/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCharacterData.h"

#include "CharacterData.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCharacterDataTableValues[] =
{
    { "data", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataData), (intptr_t)setJSCharacterDataData, NoIntrinsic },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCharacterDataTable = { 9, 7, JSCharacterDataTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCharacterDataConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCharacterDataConstructorTable = { 1, 0, JSCharacterDataConstructorTableValues, 0 };
const ClassInfo JSCharacterDataConstructor::s_info = { "CharacterDataConstructor", &Base::s_info, &JSCharacterDataConstructorTable, 0, CREATE_METHOD_TABLE(JSCharacterDataConstructor) };

JSCharacterDataConstructor::JSCharacterDataConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCharacterDataConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSCharacterDataPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSCharacterDataConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCharacterDataConstructor, JSDOMWrapper>(exec, &JSCharacterDataConstructorTable, jsCast<JSCharacterDataConstructor*>(cell), propertyName, slot);
}

bool JSCharacterDataConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCharacterDataConstructor, JSDOMWrapper>(exec, &JSCharacterDataConstructorTable, jsCast<JSCharacterDataConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCharacterDataPrototypeTableValues[] =
{
    { "substringData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionSubstringData), (intptr_t)0, NoIntrinsic },
    { "appendData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionAppendData), (intptr_t)0, NoIntrinsic },
    { "insertData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionInsertData), (intptr_t)0, NoIntrinsic },
    { "deleteData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionDeleteData), (intptr_t)0, NoIntrinsic },
    { "replaceData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionReplaceData), (intptr_t)0, NoIntrinsic },
    { "remove", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionRemove), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCharacterDataPrototypeTable = { 16, 15, JSCharacterDataPrototypeTableValues, 0 };
const ClassInfo JSCharacterDataPrototype::s_info = { "CharacterDataPrototype", &Base::s_info, &JSCharacterDataPrototypeTable, 0, CREATE_METHOD_TABLE(JSCharacterDataPrototype) };

JSObject* JSCharacterDataPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCharacterData>(exec, globalObject);
}

bool JSCharacterDataPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCharacterDataPrototype* thisObject = jsCast<JSCharacterDataPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCharacterDataPrototypeTable, thisObject, propertyName, slot);
}

bool JSCharacterDataPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCharacterDataPrototype* thisObject = jsCast<JSCharacterDataPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCharacterDataPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCharacterData::s_info = { "CharacterData", &Base::s_info, &JSCharacterDataTable, 0 , CREATE_METHOD_TABLE(JSCharacterData) };

JSCharacterData::JSCharacterData(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CharacterData> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSCharacterData::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCharacterData::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCharacterDataPrototype::create(exec->vm(), globalObject, JSCharacterDataPrototype::createStructure(exec->vm(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSCharacterData::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCharacterData* thisObject = jsCast<JSCharacterData*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCharacterData, Base>(exec, &JSCharacterDataTable, thisObject, propertyName, slot);
}

bool JSCharacterData::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCharacterData* thisObject = jsCast<JSCharacterData*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCharacterData, Base>(exec, &JSCharacterDataTable, thisObject, propertyName, descriptor);
}

JSValue jsCharacterDataData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->data());
    return result;
}


JSValue jsCharacterDataLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsCharacterDataConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCharacterData* domObject = jsCast<JSCharacterData*>(asObject(slotBase));
    return JSCharacterData::getConstructor(exec, domObject->globalObject());
}

void JSCharacterData::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCharacterData* thisObject = jsCast<JSCharacterData*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCharacterData, Base>(exec, propertyName, value, &JSCharacterDataTable, thisObject, slot);
}

void setJSCharacterDataData(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(thisObject);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setData(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSCharacterData::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCharacterDataConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionSubstringData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toUInt32(exec, exec->argument(1), NormalConversion));
    if (length < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->substringData(offset, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionAppendData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& data(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->appendData(data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionInsertData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& data(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertData(offset, data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionDeleteData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toUInt32(exec, exec->argument(1), NormalConversion));
    if (length < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteData(offset, length, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionReplaceData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toUInt32(exec, exec->argument(1), NormalConversion));
    if (length < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& data(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->replaceData(offset, length, data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCharacterData::s_info))
        return throwVMTypeError(exec);
    JSCharacterData* castedThis = jsCast<JSCharacterData*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCharacterData::s_info);
    CharacterData* impl = static_cast<CharacterData*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->remove(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
