/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_PENRYN;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_PENRYN.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_PENRYN, sbdtobf16_k_PENRYN, sbf16tos_k_PENRYN, dbf16tod_k_PENRYN,

  samax_k_PENRYN,  samin_k_PENRYN,  smax_k_PENRYN,  smin_k_PENRYN,
  isamax_k_PENRYN, isamin_k_PENRYN, ismax_k_PENRYN, ismin_k_PENRYN,
  snrm2_k_PENRYN,  sasum_k_PENRYN, ssum_k_PENRYN, scopy_k_PENRYN, sbdot_k_PENRYN,
  dsdot_k_PENRYN,
  srot_k_PENRYN,   saxpy_k_PENRYN,  sscal_k_PENRYN, sswap_k_PENRYN,
  sbgemv_n_PENRYN, sbgemv_t_PENRYN, sger_k_PENRYN,
  ssymv_L_PENRYN, ssymv_U_PENRYN,

  sbgemm_kernel_PENRYN, sbgemm_beta_PENRYN,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_PENRYN, sbgemm_itcopy_PENRYN,
#else
  sbgemm_oncopy_PENRYN, sbgemm_otcopy_PENRYN,
#endif
  sbgemm_oncopy_PENRYN, sbgemm_otcopy_PENRYN,

  strsm_kernel_LN_PENRYN, strsm_kernel_LT_PENRYN, strsm_kernel_RN_PENRYN, strsm_kernel_RT_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_PENRYN, strsm_iunncopy_PENRYN, strsm_iutucopy_PENRYN, strsm_iutncopy_PENRYN,
  strsm_ilnucopy_PENRYN, strsm_ilnncopy_PENRYN, strsm_iltucopy_PENRYN, strsm_iltncopy_PENRYN,
#else
  strsm_ounucopy_PENRYN, strsm_ounncopy_PENRYN, strsm_outucopy_PENRYN, strsm_outncopy_PENRYN,
  strsm_olnucopy_PENRYN, strsm_olnncopy_PENRYN, strsm_oltucopy_PENRYN, strsm_oltncopy_PENRYN,
#endif
  strsm_ounucopy_PENRYN, strsm_ounncopy_PENRYN, strsm_outucopy_PENRYN, strsm_outncopy_PENRYN,
  strsm_olnucopy_PENRYN, strsm_olnncopy_PENRYN, strsm_oltucopy_PENRYN, strsm_oltncopy_PENRYN,
  strmm_kernel_RN_PENRYN, strmm_kernel_RT_PENRYN, strmm_kernel_LN_PENRYN, strmm_kernel_LT_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_PENRYN, strmm_iunncopy_PENRYN, strmm_iutucopy_PENRYN, strmm_iutncopy_PENRYN,
  strmm_ilnucopy_PENRYN, strmm_ilnncopy_PENRYN, strmm_iltucopy_PENRYN, strmm_iltncopy_PENRYN,
#else
  strmm_ounucopy_PENRYN, strmm_ounncopy_PENRYN, strmm_outucopy_PENRYN, strmm_outncopy_PENRYN,
  strmm_olnucopy_PENRYN, strmm_olnncopy_PENRYN, strmm_oltucopy_PENRYN, strmm_oltncopy_PENRYN,
#endif
  strmm_ounucopy_PENRYN, strmm_ounncopy_PENRYN, strmm_outucopy_PENRYN, strmm_outncopy_PENRYN,
  strmm_olnucopy_PENRYN, strmm_olnncopy_PENRYN, strmm_oltucopy_PENRYN, strmm_oltncopy_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_PENRYN, ssymm_iltcopy_PENRYN,
#else
  ssymm_outcopy_PENRYN, ssymm_oltcopy_PENRYN,
#endif
  ssymm_outcopy_PENRYN, ssymm_oltcopy_PENRYN,

#ifndef NO_LAPACK
  sneg_tcopy_PENRYN, slaswp_ncopy_PENRYN,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_PENRYN,
  sbgemm_small_kernel_nn_PENRYN, sbgemm_small_kernel_nt_PENRYN, sbgemm_small_kernel_tn_PENRYN, sbgemm_small_kernel_tt_PENRYN,
  sbgemm_small_kernel_b0_nn_PENRYN, sbgemm_small_kernel_b0_nt_PENRYN, sbgemm_small_kernel_b0_tn_PENRYN, sbgemm_small_kernel_b0_tt_PENRYN,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_PENRYN,  samin_k_PENRYN,  smax_k_PENRYN,  smin_k_PENRYN,
  isamax_k_PENRYN, isamin_k_PENRYN, ismax_k_PENRYN, ismin_k_PENRYN,
  snrm2_k_PENRYN,  sasum_k_PENRYN,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_PENRYN,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_PENRYN, sdot_k_PENRYN,
//  dsdot_k_PENRYN,
  srot_k_PENRYN,   saxpy_k_PENRYN,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_PENRYN,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_PENRYN,
  sgemv_n_PENRYN,  sgemv_t_PENRYN,
#endif
#if BUILD_SINGLE == 1  
  sger_k_PENRYN,
  ssymv_L_PENRYN, ssymv_U_PENRYN,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_PENRYN,
  sgemm_direct_performant_PENRYN,	
#endif

  sgemm_kernel_PENRYN, sgemm_beta_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_PENRYN, sgemm_itcopy_PENRYN,
#else
  sgemm_oncopy_PENRYN, sgemm_otcopy_PENRYN,
#endif
  sgemm_oncopy_PENRYN, sgemm_otcopy_PENRYN,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_PENRYN,
  sgemm_small_kernel_nn_PENRYN, sgemm_small_kernel_nt_PENRYN, sgemm_small_kernel_tn_PENRYN, sgemm_small_kernel_tt_PENRYN,
  sgemm_small_kernel_b0_nn_PENRYN, sgemm_small_kernel_b0_nt_PENRYN, sgemm_small_kernel_b0_tn_PENRYN, sgemm_small_kernel_b0_tt_PENRYN,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_PENRYN, strsm_kernel_LT_PENRYN, strsm_kernel_RN_PENRYN, strsm_kernel_RT_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_PENRYN, strsm_iunncopy_PENRYN, strsm_iutucopy_PENRYN, strsm_iutncopy_PENRYN,
  strsm_ilnucopy_PENRYN, strsm_ilnncopy_PENRYN, strsm_iltucopy_PENRYN, strsm_iltncopy_PENRYN,
#else
  strsm_ounucopy_PENRYN, strsm_ounncopy_PENRYN, strsm_outucopy_PENRYN, strsm_outncopy_PENRYN,
  strsm_olnucopy_PENRYN, strsm_olnncopy_PENRYN, strsm_oltucopy_PENRYN, strsm_oltncopy_PENRYN,
#endif
  strsm_ounucopy_PENRYN, strsm_ounncopy_PENRYN, strsm_outucopy_PENRYN, strsm_outncopy_PENRYN,
  strsm_olnucopy_PENRYN, strsm_olnncopy_PENRYN, strsm_oltucopy_PENRYN, strsm_oltncopy_PENRYN,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_PENRYN, strmm_kernel_RT_PENRYN, strmm_kernel_LN_PENRYN, strmm_kernel_LT_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_PENRYN, strmm_iunncopy_PENRYN, strmm_iutucopy_PENRYN, strmm_iutncopy_PENRYN,
  strmm_ilnucopy_PENRYN, strmm_ilnncopy_PENRYN, strmm_iltucopy_PENRYN, strmm_iltncopy_PENRYN,
#else
  strmm_ounucopy_PENRYN, strmm_ounncopy_PENRYN, strmm_outucopy_PENRYN, strmm_outncopy_PENRYN,
  strmm_olnucopy_PENRYN, strmm_olnncopy_PENRYN, strmm_oltucopy_PENRYN, strmm_oltncopy_PENRYN,
#endif
  strmm_ounucopy_PENRYN, strmm_ounncopy_PENRYN, strmm_outucopy_PENRYN, strmm_outncopy_PENRYN,
  strmm_olnucopy_PENRYN, strmm_olnncopy_PENRYN, strmm_oltucopy_PENRYN, strmm_oltncopy_PENRYN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_PENRYN, ssymm_iltcopy_PENRYN,
#else
  ssymm_outcopy_PENRYN, ssymm_oltcopy_PENRYN,
#endif
  ssymm_outcopy_PENRYN, ssymm_oltcopy_PENRYN,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_PENRYN, slaswp_ncopy_PENRYN,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_PENRYN,  damin_k_PENRYN,  dmax_k_PENRYN,  dmin_k_PENRYN,
  idamax_k_PENRYN, idamin_k_PENRYN, idmax_k_PENRYN, idmin_k_PENRYN,
  dnrm2_k_PENRYN, dasum_k_PENRYN,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_PENRYN,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_PENRYN, ddot_k_PENRYN,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_PENRYN,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_PENRYN,
  daxpy_k_PENRYN,
  dscal_k_PENRYN, 
  dswap_k_PENRYN,
  dgemv_n_PENRYN,  dgemv_t_PENRYN,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_PENRYN,
  dsymv_L_PENRYN,  dsymv_U_PENRYN,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_PENRYN, dgemm_beta_PENRYN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_PENRYN, dgemm_itcopy_PENRYN,
#else
  dgemm_oncopy_PENRYN, dgemm_otcopy_PENRYN,
#endif
  dgemm_oncopy_PENRYN, dgemm_otcopy_PENRYN,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_PENRYN,
  dgemm_small_kernel_nn_PENRYN, dgemm_small_kernel_nt_PENRYN, dgemm_small_kernel_tn_PENRYN, dgemm_small_kernel_tt_PENRYN,
  dgemm_small_kernel_b0_nn_PENRYN, dgemm_small_kernel_b0_nt_PENRYN, dgemm_small_kernel_b0_tn_PENRYN, dgemm_small_kernel_b0_tt_PENRYN,
#endif
  dtrsm_kernel_LN_PENRYN, dtrsm_kernel_LT_PENRYN, dtrsm_kernel_RN_PENRYN, dtrsm_kernel_RT_PENRYN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_PENRYN, dtrsm_iunncopy_PENRYN, dtrsm_iutucopy_PENRYN, dtrsm_iutncopy_PENRYN,
  dtrsm_ilnucopy_PENRYN, dtrsm_ilnncopy_PENRYN, dtrsm_iltucopy_PENRYN, dtrsm_iltncopy_PENRYN,
#else
  dtrsm_ounucopy_PENRYN, dtrsm_ounncopy_PENRYN, dtrsm_outucopy_PENRYN, dtrsm_outncopy_PENRYN,
  dtrsm_olnucopy_PENRYN, dtrsm_olnncopy_PENRYN, dtrsm_oltucopy_PENRYN, dtrsm_oltncopy_PENRYN,
#endif
  dtrsm_ounucopy_PENRYN, dtrsm_ounncopy_PENRYN, dtrsm_outucopy_PENRYN, dtrsm_outncopy_PENRYN,
  dtrsm_olnucopy_PENRYN, dtrsm_olnncopy_PENRYN, dtrsm_oltucopy_PENRYN, dtrsm_oltncopy_PENRYN,
  dtrmm_kernel_RN_PENRYN, dtrmm_kernel_RT_PENRYN, dtrmm_kernel_LN_PENRYN, dtrmm_kernel_LT_PENRYN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_PENRYN, dtrmm_iunncopy_PENRYN, dtrmm_iutucopy_PENRYN, dtrmm_iutncopy_PENRYN,
  dtrmm_ilnucopy_PENRYN, dtrmm_ilnncopy_PENRYN, dtrmm_iltucopy_PENRYN, dtrmm_iltncopy_PENRYN,
#else
  dtrmm_ounucopy_PENRYN, dtrmm_ounncopy_PENRYN, dtrmm_outucopy_PENRYN, dtrmm_outncopy_PENRYN,
  dtrmm_olnucopy_PENRYN, dtrmm_olnncopy_PENRYN, dtrmm_oltucopy_PENRYN, dtrmm_oltncopy_PENRYN,
#endif
  dtrmm_ounucopy_PENRYN, dtrmm_ounncopy_PENRYN, dtrmm_outucopy_PENRYN, dtrmm_outncopy_PENRYN,
  dtrmm_olnucopy_PENRYN, dtrmm_olnncopy_PENRYN, dtrmm_oltucopy_PENRYN, dtrmm_oltncopy_PENRYN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_PENRYN, dsymm_iltcopy_PENRYN,
#else
  dsymm_outcopy_PENRYN, dsymm_oltcopy_PENRYN,
#endif
  dsymm_outcopy_PENRYN, dsymm_oltcopy_PENRYN,

#ifndef NO_LAPACK
  dneg_tcopy_PENRYN, dlaswp_ncopy_PENRYN,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_PENRYN,  qamin_k_PENRYN,  qmax_k_PENRYN,  qmin_k_PENRYN,
  iqamax_k_PENRYN, iqamin_k_PENRYN, iqmax_k_PENRYN, iqmin_k_PENRYN,
  qnrm2_k_PENRYN,  qasum_k_PENRYN,  qsum_k_PENRYN, qcopy_k_PENRYN, qdot_k_PENRYN,
  qrot_k_PENRYN,   qaxpy_k_PENRYN,  qscal_k_PENRYN, qswap_k_PENRYN,
  qgemv_n_PENRYN,  qgemv_t_PENRYN,  qger_k_PENRYN,
  qsymv_L_PENRYN,  qsymv_U_PENRYN,

  qgemm_kernel_PENRYN, qgemm_beta_PENRYN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_PENRYN, qgemm_itcopy_PENRYN,
#else
  qgemm_oncopy_PENRYN, qgemm_otcopy_PENRYN,
#endif
  qgemm_oncopy_PENRYN, qgemm_otcopy_PENRYN,
  qtrsm_kernel_LN_PENRYN, qtrsm_kernel_LT_PENRYN, qtrsm_kernel_RN_PENRYN, qtrsm_kernel_RT_PENRYN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_PENRYN, qtrsm_iunncopy_PENRYN, qtrsm_iutucopy_PENRYN, qtrsm_iutncopy_PENRYN,
  qtrsm_ilnucopy_PENRYN, qtrsm_ilnncopy_PENRYN, qtrsm_iltucopy_PENRYN, qtrsm_iltncopy_PENRYN,
#else
  qtrsm_ounucopy_PENRYN, qtrsm_ounncopy_PENRYN, qtrsm_outucopy_PENRYN, qtrsm_outncopy_PENRYN,
  qtrsm_olnucopy_PENRYN, qtrsm_olnncopy_PENRYN, qtrsm_oltucopy_PENRYN, qtrsm_oltncopy_PENRYN,
#endif
  qtrsm_ounucopy_PENRYN, qtrsm_ounncopy_PENRYN, qtrsm_outucopy_PENRYN, qtrsm_outncopy_PENRYN,
  qtrsm_olnucopy_PENRYN, qtrsm_olnncopy_PENRYN, qtrsm_oltucopy_PENRYN, qtrsm_oltncopy_PENRYN,
  qtrmm_kernel_RN_PENRYN, qtrmm_kernel_RT_PENRYN, qtrmm_kernel_LN_PENRYN, qtrmm_kernel_LT_PENRYN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_PENRYN, qtrmm_iunncopy_PENRYN, qtrmm_iutucopy_PENRYN, qtrmm_iutncopy_PENRYN,
  qtrmm_ilnucopy_PENRYN, qtrmm_ilnncopy_PENRYN, qtrmm_iltucopy_PENRYN, qtrmm_iltncopy_PENRYN,
#else
  qtrmm_ounucopy_PENRYN, qtrmm_ounncopy_PENRYN, qtrmm_outucopy_PENRYN, qtrmm_outncopy_PENRYN,
  qtrmm_olnucopy_PENRYN, qtrmm_olnncopy_PENRYN, qtrmm_oltucopy_PENRYN, qtrmm_oltncopy_PENRYN,
#endif
  qtrmm_ounucopy_PENRYN, qtrmm_ounncopy_PENRYN, qtrmm_outucopy_PENRYN, qtrmm_outncopy_PENRYN,
  qtrmm_olnucopy_PENRYN, qtrmm_olnncopy_PENRYN, qtrmm_oltucopy_PENRYN, qtrmm_oltncopy_PENRYN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_PENRYN, qsymm_iltcopy_PENRYN,
#else
  qsymm_outcopy_PENRYN, qsymm_oltcopy_PENRYN,
#endif
  qsymm_outcopy_PENRYN, qsymm_oltcopy_PENRYN,

#ifndef NO_LAPACK
  qneg_tcopy_PENRYN, qlaswp_ncopy_PENRYN,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_PENRYN, camin_k_PENRYN, icamax_k_PENRYN, icamin_k_PENRYN,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_PENRYN, casum_k_PENRYN, csum_k_PENRYN,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_PENRYN,  cdotu_k_PENRYN, cdotc_k_PENRYN,
#endif
#if (BUILD_COMPLEX)
 csrot_k_PENRYN,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_PENRYN,
  caxpyc_k_PENRYN, 
  cscal_k_PENRYN, 
  cswap_k_PENRYN,

  cgemv_n_PENRYN, cgemv_t_PENRYN, cgemv_r_PENRYN, cgemv_c_PENRYN,
  cgemv_o_PENRYN, cgemv_u_PENRYN, cgemv_s_PENRYN, cgemv_d_PENRYN,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_PENRYN, cgerc_k_PENRYN, cgerv_k_PENRYN, cgerd_k_PENRYN,
  csymv_L_PENRYN, csymv_U_PENRYN,
  chemv_L_PENRYN, chemv_U_PENRYN, chemv_M_PENRYN, chemv_V_PENRYN,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_PENRYN, cgemm_kernel_l_PENRYN, cgemm_kernel_r_PENRYN, cgemm_kernel_b_PENRYN,
  cgemm_beta_PENRYN,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_PENRYN, cgemm_itcopy_PENRYN,
#else
  cgemm_oncopy_PENRYN, cgemm_otcopy_PENRYN,
#endif
  cgemm_oncopy_PENRYN, cgemm_otcopy_PENRYN,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_PENRYN,
  cgemm_small_kernel_nn_PENRYN, cgemm_small_kernel_nt_PENRYN, cgemm_small_kernel_nr_PENRYN, cgemm_small_kernel_nc_PENRYN,
  cgemm_small_kernel_tn_PENRYN, cgemm_small_kernel_tt_PENRYN, cgemm_small_kernel_tr_PENRYN, cgemm_small_kernel_tc_PENRYN,
  cgemm_small_kernel_rn_PENRYN, cgemm_small_kernel_rt_PENRYN, cgemm_small_kernel_rr_PENRYN, cgemm_small_kernel_rc_PENRYN,
  cgemm_small_kernel_cn_PENRYN, cgemm_small_kernel_ct_PENRYN, cgemm_small_kernel_cr_PENRYN, cgemm_small_kernel_cc_PENRYN,
  cgemm_small_kernel_b0_nn_PENRYN, cgemm_small_kernel_b0_nt_PENRYN, cgemm_small_kernel_b0_nr_PENRYN, cgemm_small_kernel_b0_nc_PENRYN,
  cgemm_small_kernel_b0_tn_PENRYN, cgemm_small_kernel_b0_tt_PENRYN, cgemm_small_kernel_b0_tr_PENRYN, cgemm_small_kernel_b0_tc_PENRYN,
  cgemm_small_kernel_b0_rn_PENRYN, cgemm_small_kernel_b0_rt_PENRYN, cgemm_small_kernel_b0_rr_PENRYN, cgemm_small_kernel_b0_rc_PENRYN,
  cgemm_small_kernel_b0_cn_PENRYN, cgemm_small_kernel_b0_ct_PENRYN, cgemm_small_kernel_b0_cr_PENRYN, cgemm_small_kernel_b0_cc_PENRYN,
#endif

  ctrsm_kernel_LN_PENRYN, ctrsm_kernel_LT_PENRYN, ctrsm_kernel_LR_PENRYN, ctrsm_kernel_LC_PENRYN,
  ctrsm_kernel_RN_PENRYN, ctrsm_kernel_RT_PENRYN, ctrsm_kernel_RR_PENRYN, ctrsm_kernel_RC_PENRYN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_PENRYN,  ctrsm_iunncopy_PENRYN,  ctrsm_iutucopy_PENRYN,  ctrsm_iutncopy_PENRYN,
  ctrsm_ilnucopy_PENRYN,  ctrsm_ilnncopy_PENRYN,  ctrsm_iltucopy_PENRYN,  ctrsm_iltncopy_PENRYN,
#else
  ctrsm_ounucopy_PENRYN,  ctrsm_ounncopy_PENRYN,  ctrsm_outucopy_PENRYN,  ctrsm_outncopy_PENRYN,
  ctrsm_olnucopy_PENRYN,  ctrsm_olnncopy_PENRYN,  ctrsm_oltucopy_PENRYN,  ctrsm_oltncopy_PENRYN,
#endif
  ctrsm_ounucopy_PENRYN,  ctrsm_ounncopy_PENRYN,  ctrsm_outucopy_PENRYN,  ctrsm_outncopy_PENRYN,
  ctrsm_olnucopy_PENRYN,  ctrsm_olnncopy_PENRYN,  ctrsm_oltucopy_PENRYN,  ctrsm_oltncopy_PENRYN,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_PENRYN,  ctrmm_kernel_RT_PENRYN,  ctrmm_kernel_RR_PENRYN,  ctrmm_kernel_RC_PENRYN,
  ctrmm_kernel_LN_PENRYN,  ctrmm_kernel_LT_PENRYN,  ctrmm_kernel_LR_PENRYN,  ctrmm_kernel_LC_PENRYN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_PENRYN,  ctrmm_iunncopy_PENRYN,  ctrmm_iutucopy_PENRYN,  ctrmm_iutncopy_PENRYN,
  ctrmm_ilnucopy_PENRYN,  ctrmm_ilnncopy_PENRYN,  ctrmm_iltucopy_PENRYN,  ctrmm_iltncopy_PENRYN,
#else
  ctrmm_ounucopy_PENRYN,  ctrmm_ounncopy_PENRYN,  ctrmm_outucopy_PENRYN,  ctrmm_outncopy_PENRYN,
  ctrmm_olnucopy_PENRYN,  ctrmm_olnncopy_PENRYN,  ctrmm_oltucopy_PENRYN,  ctrmm_oltncopy_PENRYN,
#endif
  ctrmm_ounucopy_PENRYN,  ctrmm_ounncopy_PENRYN,  ctrmm_outucopy_PENRYN,  ctrmm_outncopy_PENRYN,
  ctrmm_olnucopy_PENRYN,  ctrmm_olnncopy_PENRYN,  ctrmm_oltucopy_PENRYN,  ctrmm_oltncopy_PENRYN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_PENRYN,  csymm_iltcopy_PENRYN,
#else
  csymm_outcopy_PENRYN,  csymm_oltcopy_PENRYN,
#endif
  csymm_outcopy_PENRYN,  csymm_oltcopy_PENRYN,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_PENRYN,  chemm_iltcopy_PENRYN,
#else
  chemm_outcopy_PENRYN,  chemm_oltcopy_PENRYN,
#endif
  chemm_outcopy_PENRYN,  chemm_oltcopy_PENRYN,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_PENRYN,

  cgemm3m_incopyb_PENRYN,  cgemm3m_incopyr_PENRYN,
  cgemm3m_incopyi_PENRYN,  cgemm3m_itcopyb_PENRYN,
  cgemm3m_itcopyr_PENRYN,  cgemm3m_itcopyi_PENRYN,
  cgemm3m_oncopyb_PENRYN,  cgemm3m_oncopyr_PENRYN,
  cgemm3m_oncopyi_PENRYN,  cgemm3m_otcopyb_PENRYN,
  cgemm3m_otcopyr_PENRYN,  cgemm3m_otcopyi_PENRYN,

  csymm3m_iucopyb_PENRYN,  csymm3m_ilcopyb_PENRYN,
  csymm3m_iucopyr_PENRYN,  csymm3m_ilcopyr_PENRYN,
  csymm3m_iucopyi_PENRYN,  csymm3m_ilcopyi_PENRYN,
  csymm3m_oucopyb_PENRYN,  csymm3m_olcopyb_PENRYN,
  csymm3m_oucopyr_PENRYN,  csymm3m_olcopyr_PENRYN,
  csymm3m_oucopyi_PENRYN,  csymm3m_olcopyi_PENRYN,

  chemm3m_iucopyb_PENRYN,  chemm3m_ilcopyb_PENRYN,
  chemm3m_iucopyr_PENRYN,  chemm3m_ilcopyr_PENRYN,
  chemm3m_iucopyi_PENRYN,  chemm3m_ilcopyi_PENRYN,

  chemm3m_oucopyb_PENRYN,  chemm3m_olcopyb_PENRYN,
  chemm3m_oucopyr_PENRYN,  chemm3m_olcopyr_PENRYN,
  chemm3m_oucopyi_PENRYN,  chemm3m_olcopyi_PENRYN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_PENRYN,
  
   claswp_ncopy_PENRYN,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_PENRYN, zamin_k_PENRYN, izamax_k_PENRYN, izamin_k_PENRYN,
  znrm2_k_PENRYN, zasum_k_PENRYN, zsum_k_PENRYN, zcopy_k_PENRYN,
  zdotu_k_PENRYN, zdotc_k_PENRYN, zdrot_k_PENRYN,
  zaxpy_k_PENRYN, zaxpyc_k_PENRYN, zscal_k_PENRYN, zswap_k_PENRYN,

  zgemv_n_PENRYN, zgemv_t_PENRYN, zgemv_r_PENRYN, zgemv_c_PENRYN,
  zgemv_o_PENRYN, zgemv_u_PENRYN, zgemv_s_PENRYN, zgemv_d_PENRYN,
  zgeru_k_PENRYN, zgerc_k_PENRYN, zgerv_k_PENRYN, zgerd_k_PENRYN,
  zsymv_L_PENRYN, zsymv_U_PENRYN,
  zhemv_L_PENRYN, zhemv_U_PENRYN, zhemv_M_PENRYN, zhemv_V_PENRYN,

  zgemm_kernel_n_PENRYN, zgemm_kernel_l_PENRYN, zgemm_kernel_r_PENRYN, zgemm_kernel_b_PENRYN,
  zgemm_beta_PENRYN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_PENRYN, zgemm_itcopy_PENRYN,
#else
  zgemm_oncopy_PENRYN, zgemm_otcopy_PENRYN,
#endif
  zgemm_oncopy_PENRYN, zgemm_otcopy_PENRYN,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_PENRYN,
  zgemm_small_kernel_nn_PENRYN, zgemm_small_kernel_nt_PENRYN, zgemm_small_kernel_nr_PENRYN, zgemm_small_kernel_nc_PENRYN,
  zgemm_small_kernel_tn_PENRYN, zgemm_small_kernel_tt_PENRYN, zgemm_small_kernel_tr_PENRYN, zgemm_small_kernel_tc_PENRYN,
  zgemm_small_kernel_rn_PENRYN, zgemm_small_kernel_rt_PENRYN, zgemm_small_kernel_rr_PENRYN, zgemm_small_kernel_rc_PENRYN,
  zgemm_small_kernel_cn_PENRYN, zgemm_small_kernel_ct_PENRYN, zgemm_small_kernel_cr_PENRYN, zgemm_small_kernel_cc_PENRYN,
  zgemm_small_kernel_b0_nn_PENRYN, zgemm_small_kernel_b0_nt_PENRYN, zgemm_small_kernel_b0_nr_PENRYN, zgemm_small_kernel_b0_nc_PENRYN,
  zgemm_small_kernel_b0_tn_PENRYN, zgemm_small_kernel_b0_tt_PENRYN, zgemm_small_kernel_b0_tr_PENRYN, zgemm_small_kernel_b0_tc_PENRYN,
  zgemm_small_kernel_b0_rn_PENRYN, zgemm_small_kernel_b0_rt_PENRYN, zgemm_small_kernel_b0_rr_PENRYN, zgemm_small_kernel_b0_rc_PENRYN,
  zgemm_small_kernel_b0_cn_PENRYN, zgemm_small_kernel_b0_ct_PENRYN, zgemm_small_kernel_b0_cr_PENRYN, zgemm_small_kernel_b0_cc_PENRYN,
#endif

  ztrsm_kernel_LN_PENRYN, ztrsm_kernel_LT_PENRYN, ztrsm_kernel_LR_PENRYN, ztrsm_kernel_LC_PENRYN,
  ztrsm_kernel_RN_PENRYN, ztrsm_kernel_RT_PENRYN, ztrsm_kernel_RR_PENRYN, ztrsm_kernel_RC_PENRYN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_PENRYN,  ztrsm_iunncopy_PENRYN,  ztrsm_iutucopy_PENRYN,  ztrsm_iutncopy_PENRYN,
  ztrsm_ilnucopy_PENRYN,  ztrsm_ilnncopy_PENRYN,  ztrsm_iltucopy_PENRYN,  ztrsm_iltncopy_PENRYN,
#else
  ztrsm_ounucopy_PENRYN,  ztrsm_ounncopy_PENRYN,  ztrsm_outucopy_PENRYN,  ztrsm_outncopy_PENRYN,
  ztrsm_olnucopy_PENRYN,  ztrsm_olnncopy_PENRYN,  ztrsm_oltucopy_PENRYN,  ztrsm_oltncopy_PENRYN,
#endif
  ztrsm_ounucopy_PENRYN,  ztrsm_ounncopy_PENRYN,  ztrsm_outucopy_PENRYN,  ztrsm_outncopy_PENRYN,
  ztrsm_olnucopy_PENRYN,  ztrsm_olnncopy_PENRYN,  ztrsm_oltucopy_PENRYN,  ztrsm_oltncopy_PENRYN,

  ztrmm_kernel_RN_PENRYN,  ztrmm_kernel_RT_PENRYN,  ztrmm_kernel_RR_PENRYN,  ztrmm_kernel_RC_PENRYN,
  ztrmm_kernel_LN_PENRYN,  ztrmm_kernel_LT_PENRYN,  ztrmm_kernel_LR_PENRYN,  ztrmm_kernel_LC_PENRYN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_PENRYN,  ztrmm_iunncopy_PENRYN,  ztrmm_iutucopy_PENRYN,  ztrmm_iutncopy_PENRYN,
  ztrmm_ilnucopy_PENRYN,  ztrmm_ilnncopy_PENRYN,  ztrmm_iltucopy_PENRYN,  ztrmm_iltncopy_PENRYN,
#else
  ztrmm_ounucopy_PENRYN,  ztrmm_ounncopy_PENRYN,  ztrmm_outucopy_PENRYN,  ztrmm_outncopy_PENRYN,
  ztrmm_olnucopy_PENRYN,  ztrmm_olnncopy_PENRYN,  ztrmm_oltucopy_PENRYN,  ztrmm_oltncopy_PENRYN,
#endif
  ztrmm_ounucopy_PENRYN,  ztrmm_ounncopy_PENRYN,  ztrmm_outucopy_PENRYN,  ztrmm_outncopy_PENRYN,
  ztrmm_olnucopy_PENRYN,  ztrmm_olnncopy_PENRYN,  ztrmm_oltucopy_PENRYN,  ztrmm_oltncopy_PENRYN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_PENRYN,  zsymm_iltcopy_PENRYN,
#else
  zsymm_outcopy_PENRYN,  zsymm_oltcopy_PENRYN,
#endif
  zsymm_outcopy_PENRYN,  zsymm_oltcopy_PENRYN,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_PENRYN,  zhemm_iltcopy_PENRYN,
#else
  zhemm_outcopy_PENRYN,  zhemm_oltcopy_PENRYN,
#endif
  zhemm_outcopy_PENRYN,  zhemm_oltcopy_PENRYN,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_PENRYN,

  zgemm3m_incopyb_PENRYN,  zgemm3m_incopyr_PENRYN,
  zgemm3m_incopyi_PENRYN,  zgemm3m_itcopyb_PENRYN,
  zgemm3m_itcopyr_PENRYN,  zgemm3m_itcopyi_PENRYN,
  zgemm3m_oncopyb_PENRYN,  zgemm3m_oncopyr_PENRYN,
  zgemm3m_oncopyi_PENRYN,  zgemm3m_otcopyb_PENRYN,
  zgemm3m_otcopyr_PENRYN,  zgemm3m_otcopyi_PENRYN,

  zsymm3m_iucopyb_PENRYN,  zsymm3m_ilcopyb_PENRYN,
  zsymm3m_iucopyr_PENRYN,  zsymm3m_ilcopyr_PENRYN,
  zsymm3m_iucopyi_PENRYN,  zsymm3m_ilcopyi_PENRYN,
  zsymm3m_oucopyb_PENRYN,  zsymm3m_olcopyb_PENRYN,
  zsymm3m_oucopyr_PENRYN,  zsymm3m_olcopyr_PENRYN,
  zsymm3m_oucopyi_PENRYN,  zsymm3m_olcopyi_PENRYN,

  zhemm3m_iucopyb_PENRYN,  zhemm3m_ilcopyb_PENRYN,
  zhemm3m_iucopyr_PENRYN,  zhemm3m_ilcopyr_PENRYN,
  zhemm3m_iucopyi_PENRYN,  zhemm3m_ilcopyi_PENRYN,

  zhemm3m_oucopyb_PENRYN,  zhemm3m_olcopyb_PENRYN,
  zhemm3m_oucopyr_PENRYN,  zhemm3m_olcopyr_PENRYN,
  zhemm3m_oucopyi_PENRYN,  zhemm3m_olcopyi_PENRYN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_PENRYN, zlaswp_ncopy_PENRYN,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_PENRYN, xamin_k_PENRYN, ixamax_k_PENRYN, ixamin_k_PENRYN,
  xnrm2_k_PENRYN, xasum_k_PENRYN, xsum_k_PENRYN, xcopy_k_PENRYN,
  xdotu_k_PENRYN, xdotc_k_PENRYN, xqrot_k_PENRYN,
  xaxpy_k_PENRYN, xaxpyc_k_PENRYN, xscal_k_PENRYN, xswap_k_PENRYN,

  xgemv_n_PENRYN, xgemv_t_PENRYN, xgemv_r_PENRYN, xgemv_c_PENRYN,
  xgemv_o_PENRYN, xgemv_u_PENRYN, xgemv_s_PENRYN, xgemv_d_PENRYN,
  xgeru_k_PENRYN, xgerc_k_PENRYN, xgerv_k_PENRYN, xgerd_k_PENRYN,
  xsymv_L_PENRYN, xsymv_U_PENRYN,
  xhemv_L_PENRYN, xhemv_U_PENRYN, xhemv_M_PENRYN, xhemv_V_PENRYN,

  xgemm_kernel_n_PENRYN, xgemm_kernel_l_PENRYN, xgemm_kernel_r_PENRYN, xgemm_kernel_b_PENRYN,
  xgemm_beta_PENRYN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_PENRYN, xgemm_itcopy_PENRYN,
#else
  xgemm_oncopy_PENRYN, xgemm_otcopy_PENRYN,
#endif
  xgemm_oncopy_PENRYN, xgemm_otcopy_PENRYN,

  xtrsm_kernel_LN_PENRYN, xtrsm_kernel_LT_PENRYN, xtrsm_kernel_LR_PENRYN, xtrsm_kernel_LC_PENRYN,
  xtrsm_kernel_RN_PENRYN, xtrsm_kernel_RT_PENRYN, xtrsm_kernel_RR_PENRYN, xtrsm_kernel_RC_PENRYN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_PENRYN,  xtrsm_iunncopy_PENRYN,  xtrsm_iutucopy_PENRYN,  xtrsm_iutncopy_PENRYN,
  xtrsm_ilnucopy_PENRYN,  xtrsm_ilnncopy_PENRYN,  xtrsm_iltucopy_PENRYN,  xtrsm_iltncopy_PENRYN,
#else
  xtrsm_ounucopy_PENRYN,  xtrsm_ounncopy_PENRYN,  xtrsm_outucopy_PENRYN,  xtrsm_outncopy_PENRYN,
  xtrsm_olnucopy_PENRYN,  xtrsm_olnncopy_PENRYN,  xtrsm_oltucopy_PENRYN,  xtrsm_oltncopy_PENRYN,
#endif
  xtrsm_ounucopy_PENRYN,  xtrsm_ounncopy_PENRYN,  xtrsm_outucopy_PENRYN,  xtrsm_outncopy_PENRYN,
  xtrsm_olnucopy_PENRYN,  xtrsm_olnncopy_PENRYN,  xtrsm_oltucopy_PENRYN,  xtrsm_oltncopy_PENRYN,

  xtrmm_kernel_RN_PENRYN,  xtrmm_kernel_RT_PENRYN,  xtrmm_kernel_RR_PENRYN,  xtrmm_kernel_RC_PENRYN,
  xtrmm_kernel_LN_PENRYN,  xtrmm_kernel_LT_PENRYN,  xtrmm_kernel_LR_PENRYN,  xtrmm_kernel_LC_PENRYN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_PENRYN,  xtrmm_iunncopy_PENRYN,  xtrmm_iutucopy_PENRYN,  xtrmm_iutncopy_PENRYN,
  xtrmm_ilnucopy_PENRYN,  xtrmm_ilnncopy_PENRYN,  xtrmm_iltucopy_PENRYN,  xtrmm_iltncopy_PENRYN,
#else
  xtrmm_ounucopy_PENRYN,  xtrmm_ounncopy_PENRYN,  xtrmm_outucopy_PENRYN,  xtrmm_outncopy_PENRYN,
  xtrmm_olnucopy_PENRYN,  xtrmm_olnncopy_PENRYN,  xtrmm_oltucopy_PENRYN,  xtrmm_oltncopy_PENRYN,
#endif
  xtrmm_ounucopy_PENRYN,  xtrmm_ounncopy_PENRYN,  xtrmm_outucopy_PENRYN,  xtrmm_outncopy_PENRYN,
  xtrmm_olnucopy_PENRYN,  xtrmm_olnncopy_PENRYN,  xtrmm_oltucopy_PENRYN,  xtrmm_oltncopy_PENRYN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_PENRYN,  xsymm_iltcopy_PENRYN,
#else
  xsymm_outcopy_PENRYN,  xsymm_oltcopy_PENRYN,
#endif
  xsymm_outcopy_PENRYN,  xsymm_oltcopy_PENRYN,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_PENRYN,  xhemm_iltcopy_PENRYN,
#else
  xhemm_outcopy_PENRYN,  xhemm_oltcopy_PENRYN,
#endif
  xhemm_outcopy_PENRYN,  xhemm_oltcopy_PENRYN,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_PENRYN,

  xgemm3m_incopyb_PENRYN,  xgemm3m_incopyr_PENRYN,
  xgemm3m_incopyi_PENRYN,  xgemm3m_itcopyb_PENRYN,
  xgemm3m_itcopyr_PENRYN,  xgemm3m_itcopyi_PENRYN,
  xgemm3m_oncopyb_PENRYN,  xgemm3m_oncopyr_PENRYN,
  xgemm3m_oncopyi_PENRYN,  xgemm3m_otcopyb_PENRYN,
  xgemm3m_otcopyr_PENRYN,  xgemm3m_otcopyi_PENRYN,

  xsymm3m_iucopyb_PENRYN,  xsymm3m_ilcopyb_PENRYN,
  xsymm3m_iucopyr_PENRYN,  xsymm3m_ilcopyr_PENRYN,
  xsymm3m_iucopyi_PENRYN,  xsymm3m_ilcopyi_PENRYN,
  xsymm3m_oucopyb_PENRYN,  xsymm3m_olcopyb_PENRYN,
  xsymm3m_oucopyr_PENRYN,  xsymm3m_olcopyr_PENRYN,
  xsymm3m_oucopyi_PENRYN,  xsymm3m_olcopyi_PENRYN,

  xhemm3m_iucopyb_PENRYN,  xhemm3m_ilcopyb_PENRYN,
  xhemm3m_iucopyr_PENRYN,  xhemm3m_ilcopyr_PENRYN,
  xhemm3m_iucopyi_PENRYN,  xhemm3m_ilcopyi_PENRYN,

  xhemm3m_oucopyb_PENRYN,  xhemm3m_olcopyb_PENRYN,
  xhemm3m_oucopyr_PENRYN,  xhemm3m_olcopyr_PENRYN,
  xhemm3m_oucopyi_PENRYN,  xhemm3m_olcopyi_PENRYN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_PENRYN, xlaswp_ncopy_PENRYN,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_PENRYN,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_PENRYN,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_PENRYN,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_PENRYN,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_PENRYN, somatcopy_k_ct_PENRYN, somatcopy_k_rn_PENRYN, somatcopy_k_rt_PENRYN,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_PENRYN, domatcopy_k_ct_PENRYN, domatcopy_k_rn_PENRYN, domatcopy_k_rt_PENRYN,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_PENRYN, comatcopy_k_ct_PENRYN, comatcopy_k_rn_PENRYN, comatcopy_k_rt_PENRYN,
  comatcopy_k_cnc_PENRYN, comatcopy_k_ctc_PENRYN, comatcopy_k_rnc_PENRYN, comatcopy_k_rtc_PENRYN,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_PENRYN, zomatcopy_k_ct_PENRYN, zomatcopy_k_rn_PENRYN, zomatcopy_k_rt_PENRYN,
  zomatcopy_k_cnc_PENRYN, zomatcopy_k_ctc_PENRYN, zomatcopy_k_rnc_PENRYN, zomatcopy_k_rtc_PENRYN,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_PENRYN, simatcopy_k_ct_PENRYN, simatcopy_k_rn_PENRYN, simatcopy_k_rt_PENRYN,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_PENRYN, dimatcopy_k_ct_PENRYN, dimatcopy_k_rn_PENRYN, dimatcopy_k_rt_PENRYN,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_PENRYN, cimatcopy_k_ct_PENRYN, cimatcopy_k_rn_PENRYN, cimatcopy_k_rt_PENRYN,
  cimatcopy_k_cnc_PENRYN, cimatcopy_k_ctc_PENRYN, cimatcopy_k_rnc_PENRYN, cimatcopy_k_rtc_PENRYN,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_PENRYN, zimatcopy_k_ct_PENRYN, zimatcopy_k_rn_PENRYN, zimatcopy_k_rt_PENRYN,
  zimatcopy_k_cnc_PENRYN, zimatcopy_k_ctc_PENRYN, zimatcopy_k_rnc_PENRYN, zimatcopy_k_rtc_PENRYN,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_PENRYN,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_PENRYN,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_PENRYN,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_PENRYN
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
