/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_ATOM;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_ATOM.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_ATOM, sbdtobf16_k_ATOM, sbf16tos_k_ATOM, dbf16tod_k_ATOM,

  samax_k_ATOM,  samin_k_ATOM,  smax_k_ATOM,  smin_k_ATOM,
  isamax_k_ATOM, isamin_k_ATOM, ismax_k_ATOM, ismin_k_ATOM,
  snrm2_k_ATOM,  sasum_k_ATOM, ssum_k_ATOM, scopy_k_ATOM, sbdot_k_ATOM,
  dsdot_k_ATOM,
  srot_k_ATOM,   saxpy_k_ATOM,  sscal_k_ATOM, sswap_k_ATOM,
  sbgemv_n_ATOM, sbgemv_t_ATOM, sger_k_ATOM,
  ssymv_L_ATOM, ssymv_U_ATOM,

  sbgemm_kernel_ATOM, sbgemm_beta_ATOM,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_ATOM, sbgemm_itcopy_ATOM,
#else
  sbgemm_oncopy_ATOM, sbgemm_otcopy_ATOM,
#endif
  sbgemm_oncopy_ATOM, sbgemm_otcopy_ATOM,

  strsm_kernel_LN_ATOM, strsm_kernel_LT_ATOM, strsm_kernel_RN_ATOM, strsm_kernel_RT_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ATOM, strsm_iunncopy_ATOM, strsm_iutucopy_ATOM, strsm_iutncopy_ATOM,
  strsm_ilnucopy_ATOM, strsm_ilnncopy_ATOM, strsm_iltucopy_ATOM, strsm_iltncopy_ATOM,
#else
  strsm_ounucopy_ATOM, strsm_ounncopy_ATOM, strsm_outucopy_ATOM, strsm_outncopy_ATOM,
  strsm_olnucopy_ATOM, strsm_olnncopy_ATOM, strsm_oltucopy_ATOM, strsm_oltncopy_ATOM,
#endif
  strsm_ounucopy_ATOM, strsm_ounncopy_ATOM, strsm_outucopy_ATOM, strsm_outncopy_ATOM,
  strsm_olnucopy_ATOM, strsm_olnncopy_ATOM, strsm_oltucopy_ATOM, strsm_oltncopy_ATOM,
  strmm_kernel_RN_ATOM, strmm_kernel_RT_ATOM, strmm_kernel_LN_ATOM, strmm_kernel_LT_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ATOM, strmm_iunncopy_ATOM, strmm_iutucopy_ATOM, strmm_iutncopy_ATOM,
  strmm_ilnucopy_ATOM, strmm_ilnncopy_ATOM, strmm_iltucopy_ATOM, strmm_iltncopy_ATOM,
#else
  strmm_ounucopy_ATOM, strmm_ounncopy_ATOM, strmm_outucopy_ATOM, strmm_outncopy_ATOM,
  strmm_olnucopy_ATOM, strmm_olnncopy_ATOM, strmm_oltucopy_ATOM, strmm_oltncopy_ATOM,
#endif
  strmm_ounucopy_ATOM, strmm_ounncopy_ATOM, strmm_outucopy_ATOM, strmm_outncopy_ATOM,
  strmm_olnucopy_ATOM, strmm_olnncopy_ATOM, strmm_oltucopy_ATOM, strmm_oltncopy_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ATOM, ssymm_iltcopy_ATOM,
#else
  ssymm_outcopy_ATOM, ssymm_oltcopy_ATOM,
#endif
  ssymm_outcopy_ATOM, ssymm_oltcopy_ATOM,

#ifndef NO_LAPACK
  sneg_tcopy_ATOM, slaswp_ncopy_ATOM,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_ATOM,
  sbgemm_small_kernel_nn_ATOM, sbgemm_small_kernel_nt_ATOM, sbgemm_small_kernel_tn_ATOM, sbgemm_small_kernel_tt_ATOM,
  sbgemm_small_kernel_b0_nn_ATOM, sbgemm_small_kernel_b0_nt_ATOM, sbgemm_small_kernel_b0_tn_ATOM, sbgemm_small_kernel_b0_tt_ATOM,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_ATOM,  samin_k_ATOM,  smax_k_ATOM,  smin_k_ATOM,
  isamax_k_ATOM, isamin_k_ATOM, ismax_k_ATOM, ismin_k_ATOM,
  snrm2_k_ATOM,  sasum_k_ATOM,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_ATOM,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_ATOM, sdot_k_ATOM,
//  dsdot_k_ATOM,
  srot_k_ATOM,   saxpy_k_ATOM,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_ATOM,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_ATOM,
  sgemv_n_ATOM,  sgemv_t_ATOM,
#endif
#if BUILD_SINGLE == 1  
  sger_k_ATOM,
  ssymv_L_ATOM, ssymv_U_ATOM,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_ATOM,
  sgemm_direct_performant_ATOM,	
#endif

  sgemm_kernel_ATOM, sgemm_beta_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_ATOM, sgemm_itcopy_ATOM,
#else
  sgemm_oncopy_ATOM, sgemm_otcopy_ATOM,
#endif
  sgemm_oncopy_ATOM, sgemm_otcopy_ATOM,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_ATOM,
  sgemm_small_kernel_nn_ATOM, sgemm_small_kernel_nt_ATOM, sgemm_small_kernel_tn_ATOM, sgemm_small_kernel_tt_ATOM,
  sgemm_small_kernel_b0_nn_ATOM, sgemm_small_kernel_b0_nt_ATOM, sgemm_small_kernel_b0_tn_ATOM, sgemm_small_kernel_b0_tt_ATOM,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_ATOM, strsm_kernel_LT_ATOM, strsm_kernel_RN_ATOM, strsm_kernel_RT_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ATOM, strsm_iunncopy_ATOM, strsm_iutucopy_ATOM, strsm_iutncopy_ATOM,
  strsm_ilnucopy_ATOM, strsm_ilnncopy_ATOM, strsm_iltucopy_ATOM, strsm_iltncopy_ATOM,
#else
  strsm_ounucopy_ATOM, strsm_ounncopy_ATOM, strsm_outucopy_ATOM, strsm_outncopy_ATOM,
  strsm_olnucopy_ATOM, strsm_olnncopy_ATOM, strsm_oltucopy_ATOM, strsm_oltncopy_ATOM,
#endif
  strsm_ounucopy_ATOM, strsm_ounncopy_ATOM, strsm_outucopy_ATOM, strsm_outncopy_ATOM,
  strsm_olnucopy_ATOM, strsm_olnncopy_ATOM, strsm_oltucopy_ATOM, strsm_oltncopy_ATOM,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_ATOM, strmm_kernel_RT_ATOM, strmm_kernel_LN_ATOM, strmm_kernel_LT_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ATOM, strmm_iunncopy_ATOM, strmm_iutucopy_ATOM, strmm_iutncopy_ATOM,
  strmm_ilnucopy_ATOM, strmm_ilnncopy_ATOM, strmm_iltucopy_ATOM, strmm_iltncopy_ATOM,
#else
  strmm_ounucopy_ATOM, strmm_ounncopy_ATOM, strmm_outucopy_ATOM, strmm_outncopy_ATOM,
  strmm_olnucopy_ATOM, strmm_olnncopy_ATOM, strmm_oltucopy_ATOM, strmm_oltncopy_ATOM,
#endif
  strmm_ounucopy_ATOM, strmm_ounncopy_ATOM, strmm_outucopy_ATOM, strmm_outncopy_ATOM,
  strmm_olnucopy_ATOM, strmm_olnncopy_ATOM, strmm_oltucopy_ATOM, strmm_oltncopy_ATOM,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ATOM, ssymm_iltcopy_ATOM,
#else
  ssymm_outcopy_ATOM, ssymm_oltcopy_ATOM,
#endif
  ssymm_outcopy_ATOM, ssymm_oltcopy_ATOM,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_ATOM, slaswp_ncopy_ATOM,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_ATOM,  damin_k_ATOM,  dmax_k_ATOM,  dmin_k_ATOM,
  idamax_k_ATOM, idamin_k_ATOM, idmax_k_ATOM, idmin_k_ATOM,
  dnrm2_k_ATOM, dasum_k_ATOM,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_ATOM,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_ATOM, ddot_k_ATOM,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_ATOM,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_ATOM,
  daxpy_k_ATOM,
  dscal_k_ATOM, 
  dswap_k_ATOM,
  dgemv_n_ATOM,  dgemv_t_ATOM,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_ATOM,
  dsymv_L_ATOM,  dsymv_U_ATOM,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_ATOM, dgemm_beta_ATOM,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_ATOM, dgemm_itcopy_ATOM,
#else
  dgemm_oncopy_ATOM, dgemm_otcopy_ATOM,
#endif
  dgemm_oncopy_ATOM, dgemm_otcopy_ATOM,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_ATOM,
  dgemm_small_kernel_nn_ATOM, dgemm_small_kernel_nt_ATOM, dgemm_small_kernel_tn_ATOM, dgemm_small_kernel_tt_ATOM,
  dgemm_small_kernel_b0_nn_ATOM, dgemm_small_kernel_b0_nt_ATOM, dgemm_small_kernel_b0_tn_ATOM, dgemm_small_kernel_b0_tt_ATOM,
#endif
  dtrsm_kernel_LN_ATOM, dtrsm_kernel_LT_ATOM, dtrsm_kernel_RN_ATOM, dtrsm_kernel_RT_ATOM,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_ATOM, dtrsm_iunncopy_ATOM, dtrsm_iutucopy_ATOM, dtrsm_iutncopy_ATOM,
  dtrsm_ilnucopy_ATOM, dtrsm_ilnncopy_ATOM, dtrsm_iltucopy_ATOM, dtrsm_iltncopy_ATOM,
#else
  dtrsm_ounucopy_ATOM, dtrsm_ounncopy_ATOM, dtrsm_outucopy_ATOM, dtrsm_outncopy_ATOM,
  dtrsm_olnucopy_ATOM, dtrsm_olnncopy_ATOM, dtrsm_oltucopy_ATOM, dtrsm_oltncopy_ATOM,
#endif
  dtrsm_ounucopy_ATOM, dtrsm_ounncopy_ATOM, dtrsm_outucopy_ATOM, dtrsm_outncopy_ATOM,
  dtrsm_olnucopy_ATOM, dtrsm_olnncopy_ATOM, dtrsm_oltucopy_ATOM, dtrsm_oltncopy_ATOM,
  dtrmm_kernel_RN_ATOM, dtrmm_kernel_RT_ATOM, dtrmm_kernel_LN_ATOM, dtrmm_kernel_LT_ATOM,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_ATOM, dtrmm_iunncopy_ATOM, dtrmm_iutucopy_ATOM, dtrmm_iutncopy_ATOM,
  dtrmm_ilnucopy_ATOM, dtrmm_ilnncopy_ATOM, dtrmm_iltucopy_ATOM, dtrmm_iltncopy_ATOM,
#else
  dtrmm_ounucopy_ATOM, dtrmm_ounncopy_ATOM, dtrmm_outucopy_ATOM, dtrmm_outncopy_ATOM,
  dtrmm_olnucopy_ATOM, dtrmm_olnncopy_ATOM, dtrmm_oltucopy_ATOM, dtrmm_oltncopy_ATOM,
#endif
  dtrmm_ounucopy_ATOM, dtrmm_ounncopy_ATOM, dtrmm_outucopy_ATOM, dtrmm_outncopy_ATOM,
  dtrmm_olnucopy_ATOM, dtrmm_olnncopy_ATOM, dtrmm_oltucopy_ATOM, dtrmm_oltncopy_ATOM,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_ATOM, dsymm_iltcopy_ATOM,
#else
  dsymm_outcopy_ATOM, dsymm_oltcopy_ATOM,
#endif
  dsymm_outcopy_ATOM, dsymm_oltcopy_ATOM,

#ifndef NO_LAPACK
  dneg_tcopy_ATOM, dlaswp_ncopy_ATOM,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_ATOM,  qamin_k_ATOM,  qmax_k_ATOM,  qmin_k_ATOM,
  iqamax_k_ATOM, iqamin_k_ATOM, iqmax_k_ATOM, iqmin_k_ATOM,
  qnrm2_k_ATOM,  qasum_k_ATOM,  qsum_k_ATOM, qcopy_k_ATOM, qdot_k_ATOM,
  qrot_k_ATOM,   qaxpy_k_ATOM,  qscal_k_ATOM, qswap_k_ATOM,
  qgemv_n_ATOM,  qgemv_t_ATOM,  qger_k_ATOM,
  qsymv_L_ATOM,  qsymv_U_ATOM,

  qgemm_kernel_ATOM, qgemm_beta_ATOM,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_ATOM, qgemm_itcopy_ATOM,
#else
  qgemm_oncopy_ATOM, qgemm_otcopy_ATOM,
#endif
  qgemm_oncopy_ATOM, qgemm_otcopy_ATOM,
  qtrsm_kernel_LN_ATOM, qtrsm_kernel_LT_ATOM, qtrsm_kernel_RN_ATOM, qtrsm_kernel_RT_ATOM,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_ATOM, qtrsm_iunncopy_ATOM, qtrsm_iutucopy_ATOM, qtrsm_iutncopy_ATOM,
  qtrsm_ilnucopy_ATOM, qtrsm_ilnncopy_ATOM, qtrsm_iltucopy_ATOM, qtrsm_iltncopy_ATOM,
#else
  qtrsm_ounucopy_ATOM, qtrsm_ounncopy_ATOM, qtrsm_outucopy_ATOM, qtrsm_outncopy_ATOM,
  qtrsm_olnucopy_ATOM, qtrsm_olnncopy_ATOM, qtrsm_oltucopy_ATOM, qtrsm_oltncopy_ATOM,
#endif
  qtrsm_ounucopy_ATOM, qtrsm_ounncopy_ATOM, qtrsm_outucopy_ATOM, qtrsm_outncopy_ATOM,
  qtrsm_olnucopy_ATOM, qtrsm_olnncopy_ATOM, qtrsm_oltucopy_ATOM, qtrsm_oltncopy_ATOM,
  qtrmm_kernel_RN_ATOM, qtrmm_kernel_RT_ATOM, qtrmm_kernel_LN_ATOM, qtrmm_kernel_LT_ATOM,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_ATOM, qtrmm_iunncopy_ATOM, qtrmm_iutucopy_ATOM, qtrmm_iutncopy_ATOM,
  qtrmm_ilnucopy_ATOM, qtrmm_ilnncopy_ATOM, qtrmm_iltucopy_ATOM, qtrmm_iltncopy_ATOM,
#else
  qtrmm_ounucopy_ATOM, qtrmm_ounncopy_ATOM, qtrmm_outucopy_ATOM, qtrmm_outncopy_ATOM,
  qtrmm_olnucopy_ATOM, qtrmm_olnncopy_ATOM, qtrmm_oltucopy_ATOM, qtrmm_oltncopy_ATOM,
#endif
  qtrmm_ounucopy_ATOM, qtrmm_ounncopy_ATOM, qtrmm_outucopy_ATOM, qtrmm_outncopy_ATOM,
  qtrmm_olnucopy_ATOM, qtrmm_olnncopy_ATOM, qtrmm_oltucopy_ATOM, qtrmm_oltncopy_ATOM,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_ATOM, qsymm_iltcopy_ATOM,
#else
  qsymm_outcopy_ATOM, qsymm_oltcopy_ATOM,
#endif
  qsymm_outcopy_ATOM, qsymm_oltcopy_ATOM,

#ifndef NO_LAPACK
  qneg_tcopy_ATOM, qlaswp_ncopy_ATOM,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_ATOM, camin_k_ATOM, icamax_k_ATOM, icamin_k_ATOM,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_ATOM, casum_k_ATOM, csum_k_ATOM,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_ATOM,  cdotu_k_ATOM, cdotc_k_ATOM,
#endif
#if (BUILD_COMPLEX)
 csrot_k_ATOM,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_ATOM,
  caxpyc_k_ATOM, 
  cscal_k_ATOM, 
  cswap_k_ATOM,

  cgemv_n_ATOM, cgemv_t_ATOM, cgemv_r_ATOM, cgemv_c_ATOM,
  cgemv_o_ATOM, cgemv_u_ATOM, cgemv_s_ATOM, cgemv_d_ATOM,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_ATOM, cgerc_k_ATOM, cgerv_k_ATOM, cgerd_k_ATOM,
  csymv_L_ATOM, csymv_U_ATOM,
  chemv_L_ATOM, chemv_U_ATOM, chemv_M_ATOM, chemv_V_ATOM,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_ATOM, cgemm_kernel_l_ATOM, cgemm_kernel_r_ATOM, cgemm_kernel_b_ATOM,
  cgemm_beta_ATOM,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_ATOM, cgemm_itcopy_ATOM,
#else
  cgemm_oncopy_ATOM, cgemm_otcopy_ATOM,
#endif
  cgemm_oncopy_ATOM, cgemm_otcopy_ATOM,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_ATOM,
  cgemm_small_kernel_nn_ATOM, cgemm_small_kernel_nt_ATOM, cgemm_small_kernel_nr_ATOM, cgemm_small_kernel_nc_ATOM,
  cgemm_small_kernel_tn_ATOM, cgemm_small_kernel_tt_ATOM, cgemm_small_kernel_tr_ATOM, cgemm_small_kernel_tc_ATOM,
  cgemm_small_kernel_rn_ATOM, cgemm_small_kernel_rt_ATOM, cgemm_small_kernel_rr_ATOM, cgemm_small_kernel_rc_ATOM,
  cgemm_small_kernel_cn_ATOM, cgemm_small_kernel_ct_ATOM, cgemm_small_kernel_cr_ATOM, cgemm_small_kernel_cc_ATOM,
  cgemm_small_kernel_b0_nn_ATOM, cgemm_small_kernel_b0_nt_ATOM, cgemm_small_kernel_b0_nr_ATOM, cgemm_small_kernel_b0_nc_ATOM,
  cgemm_small_kernel_b0_tn_ATOM, cgemm_small_kernel_b0_tt_ATOM, cgemm_small_kernel_b0_tr_ATOM, cgemm_small_kernel_b0_tc_ATOM,
  cgemm_small_kernel_b0_rn_ATOM, cgemm_small_kernel_b0_rt_ATOM, cgemm_small_kernel_b0_rr_ATOM, cgemm_small_kernel_b0_rc_ATOM,
  cgemm_small_kernel_b0_cn_ATOM, cgemm_small_kernel_b0_ct_ATOM, cgemm_small_kernel_b0_cr_ATOM, cgemm_small_kernel_b0_cc_ATOM,
#endif

  ctrsm_kernel_LN_ATOM, ctrsm_kernel_LT_ATOM, ctrsm_kernel_LR_ATOM, ctrsm_kernel_LC_ATOM,
  ctrsm_kernel_RN_ATOM, ctrsm_kernel_RT_ATOM, ctrsm_kernel_RR_ATOM, ctrsm_kernel_RC_ATOM,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_ATOM,  ctrsm_iunncopy_ATOM,  ctrsm_iutucopy_ATOM,  ctrsm_iutncopy_ATOM,
  ctrsm_ilnucopy_ATOM,  ctrsm_ilnncopy_ATOM,  ctrsm_iltucopy_ATOM,  ctrsm_iltncopy_ATOM,
#else
  ctrsm_ounucopy_ATOM,  ctrsm_ounncopy_ATOM,  ctrsm_outucopy_ATOM,  ctrsm_outncopy_ATOM,
  ctrsm_olnucopy_ATOM,  ctrsm_olnncopy_ATOM,  ctrsm_oltucopy_ATOM,  ctrsm_oltncopy_ATOM,
#endif
  ctrsm_ounucopy_ATOM,  ctrsm_ounncopy_ATOM,  ctrsm_outucopy_ATOM,  ctrsm_outncopy_ATOM,
  ctrsm_olnucopy_ATOM,  ctrsm_olnncopy_ATOM,  ctrsm_oltucopy_ATOM,  ctrsm_oltncopy_ATOM,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_ATOM,  ctrmm_kernel_RT_ATOM,  ctrmm_kernel_RR_ATOM,  ctrmm_kernel_RC_ATOM,
  ctrmm_kernel_LN_ATOM,  ctrmm_kernel_LT_ATOM,  ctrmm_kernel_LR_ATOM,  ctrmm_kernel_LC_ATOM,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_ATOM,  ctrmm_iunncopy_ATOM,  ctrmm_iutucopy_ATOM,  ctrmm_iutncopy_ATOM,
  ctrmm_ilnucopy_ATOM,  ctrmm_ilnncopy_ATOM,  ctrmm_iltucopy_ATOM,  ctrmm_iltncopy_ATOM,
#else
  ctrmm_ounucopy_ATOM,  ctrmm_ounncopy_ATOM,  ctrmm_outucopy_ATOM,  ctrmm_outncopy_ATOM,
  ctrmm_olnucopy_ATOM,  ctrmm_olnncopy_ATOM,  ctrmm_oltucopy_ATOM,  ctrmm_oltncopy_ATOM,
#endif
  ctrmm_ounucopy_ATOM,  ctrmm_ounncopy_ATOM,  ctrmm_outucopy_ATOM,  ctrmm_outncopy_ATOM,
  ctrmm_olnucopy_ATOM,  ctrmm_olnncopy_ATOM,  ctrmm_oltucopy_ATOM,  ctrmm_oltncopy_ATOM,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_ATOM,  csymm_iltcopy_ATOM,
#else
  csymm_outcopy_ATOM,  csymm_oltcopy_ATOM,
#endif
  csymm_outcopy_ATOM,  csymm_oltcopy_ATOM,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_ATOM,  chemm_iltcopy_ATOM,
#else
  chemm_outcopy_ATOM,  chemm_oltcopy_ATOM,
#endif
  chemm_outcopy_ATOM,  chemm_oltcopy_ATOM,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_ATOM,

  cgemm3m_incopyb_ATOM,  cgemm3m_incopyr_ATOM,
  cgemm3m_incopyi_ATOM,  cgemm3m_itcopyb_ATOM,
  cgemm3m_itcopyr_ATOM,  cgemm3m_itcopyi_ATOM,
  cgemm3m_oncopyb_ATOM,  cgemm3m_oncopyr_ATOM,
  cgemm3m_oncopyi_ATOM,  cgemm3m_otcopyb_ATOM,
  cgemm3m_otcopyr_ATOM,  cgemm3m_otcopyi_ATOM,

  csymm3m_iucopyb_ATOM,  csymm3m_ilcopyb_ATOM,
  csymm3m_iucopyr_ATOM,  csymm3m_ilcopyr_ATOM,
  csymm3m_iucopyi_ATOM,  csymm3m_ilcopyi_ATOM,
  csymm3m_oucopyb_ATOM,  csymm3m_olcopyb_ATOM,
  csymm3m_oucopyr_ATOM,  csymm3m_olcopyr_ATOM,
  csymm3m_oucopyi_ATOM,  csymm3m_olcopyi_ATOM,

  chemm3m_iucopyb_ATOM,  chemm3m_ilcopyb_ATOM,
  chemm3m_iucopyr_ATOM,  chemm3m_ilcopyr_ATOM,
  chemm3m_iucopyi_ATOM,  chemm3m_ilcopyi_ATOM,

  chemm3m_oucopyb_ATOM,  chemm3m_olcopyb_ATOM,
  chemm3m_oucopyr_ATOM,  chemm3m_olcopyr_ATOM,
  chemm3m_oucopyi_ATOM,  chemm3m_olcopyi_ATOM,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_ATOM,
  
   claswp_ncopy_ATOM,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_ATOM, zamin_k_ATOM, izamax_k_ATOM, izamin_k_ATOM,
  znrm2_k_ATOM, zasum_k_ATOM, zsum_k_ATOM, zcopy_k_ATOM,
  zdotu_k_ATOM, zdotc_k_ATOM, zdrot_k_ATOM,
  zaxpy_k_ATOM, zaxpyc_k_ATOM, zscal_k_ATOM, zswap_k_ATOM,

  zgemv_n_ATOM, zgemv_t_ATOM, zgemv_r_ATOM, zgemv_c_ATOM,
  zgemv_o_ATOM, zgemv_u_ATOM, zgemv_s_ATOM, zgemv_d_ATOM,
  zgeru_k_ATOM, zgerc_k_ATOM, zgerv_k_ATOM, zgerd_k_ATOM,
  zsymv_L_ATOM, zsymv_U_ATOM,
  zhemv_L_ATOM, zhemv_U_ATOM, zhemv_M_ATOM, zhemv_V_ATOM,

  zgemm_kernel_n_ATOM, zgemm_kernel_l_ATOM, zgemm_kernel_r_ATOM, zgemm_kernel_b_ATOM,
  zgemm_beta_ATOM,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_ATOM, zgemm_itcopy_ATOM,
#else
  zgemm_oncopy_ATOM, zgemm_otcopy_ATOM,
#endif
  zgemm_oncopy_ATOM, zgemm_otcopy_ATOM,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_ATOM,
  zgemm_small_kernel_nn_ATOM, zgemm_small_kernel_nt_ATOM, zgemm_small_kernel_nr_ATOM, zgemm_small_kernel_nc_ATOM,
  zgemm_small_kernel_tn_ATOM, zgemm_small_kernel_tt_ATOM, zgemm_small_kernel_tr_ATOM, zgemm_small_kernel_tc_ATOM,
  zgemm_small_kernel_rn_ATOM, zgemm_small_kernel_rt_ATOM, zgemm_small_kernel_rr_ATOM, zgemm_small_kernel_rc_ATOM,
  zgemm_small_kernel_cn_ATOM, zgemm_small_kernel_ct_ATOM, zgemm_small_kernel_cr_ATOM, zgemm_small_kernel_cc_ATOM,
  zgemm_small_kernel_b0_nn_ATOM, zgemm_small_kernel_b0_nt_ATOM, zgemm_small_kernel_b0_nr_ATOM, zgemm_small_kernel_b0_nc_ATOM,
  zgemm_small_kernel_b0_tn_ATOM, zgemm_small_kernel_b0_tt_ATOM, zgemm_small_kernel_b0_tr_ATOM, zgemm_small_kernel_b0_tc_ATOM,
  zgemm_small_kernel_b0_rn_ATOM, zgemm_small_kernel_b0_rt_ATOM, zgemm_small_kernel_b0_rr_ATOM, zgemm_small_kernel_b0_rc_ATOM,
  zgemm_small_kernel_b0_cn_ATOM, zgemm_small_kernel_b0_ct_ATOM, zgemm_small_kernel_b0_cr_ATOM, zgemm_small_kernel_b0_cc_ATOM,
#endif

  ztrsm_kernel_LN_ATOM, ztrsm_kernel_LT_ATOM, ztrsm_kernel_LR_ATOM, ztrsm_kernel_LC_ATOM,
  ztrsm_kernel_RN_ATOM, ztrsm_kernel_RT_ATOM, ztrsm_kernel_RR_ATOM, ztrsm_kernel_RC_ATOM,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_ATOM,  ztrsm_iunncopy_ATOM,  ztrsm_iutucopy_ATOM,  ztrsm_iutncopy_ATOM,
  ztrsm_ilnucopy_ATOM,  ztrsm_ilnncopy_ATOM,  ztrsm_iltucopy_ATOM,  ztrsm_iltncopy_ATOM,
#else
  ztrsm_ounucopy_ATOM,  ztrsm_ounncopy_ATOM,  ztrsm_outucopy_ATOM,  ztrsm_outncopy_ATOM,
  ztrsm_olnucopy_ATOM,  ztrsm_olnncopy_ATOM,  ztrsm_oltucopy_ATOM,  ztrsm_oltncopy_ATOM,
#endif
  ztrsm_ounucopy_ATOM,  ztrsm_ounncopy_ATOM,  ztrsm_outucopy_ATOM,  ztrsm_outncopy_ATOM,
  ztrsm_olnucopy_ATOM,  ztrsm_olnncopy_ATOM,  ztrsm_oltucopy_ATOM,  ztrsm_oltncopy_ATOM,

  ztrmm_kernel_RN_ATOM,  ztrmm_kernel_RT_ATOM,  ztrmm_kernel_RR_ATOM,  ztrmm_kernel_RC_ATOM,
  ztrmm_kernel_LN_ATOM,  ztrmm_kernel_LT_ATOM,  ztrmm_kernel_LR_ATOM,  ztrmm_kernel_LC_ATOM,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_ATOM,  ztrmm_iunncopy_ATOM,  ztrmm_iutucopy_ATOM,  ztrmm_iutncopy_ATOM,
  ztrmm_ilnucopy_ATOM,  ztrmm_ilnncopy_ATOM,  ztrmm_iltucopy_ATOM,  ztrmm_iltncopy_ATOM,
#else
  ztrmm_ounucopy_ATOM,  ztrmm_ounncopy_ATOM,  ztrmm_outucopy_ATOM,  ztrmm_outncopy_ATOM,
  ztrmm_olnucopy_ATOM,  ztrmm_olnncopy_ATOM,  ztrmm_oltucopy_ATOM,  ztrmm_oltncopy_ATOM,
#endif
  ztrmm_ounucopy_ATOM,  ztrmm_ounncopy_ATOM,  ztrmm_outucopy_ATOM,  ztrmm_outncopy_ATOM,
  ztrmm_olnucopy_ATOM,  ztrmm_olnncopy_ATOM,  ztrmm_oltucopy_ATOM,  ztrmm_oltncopy_ATOM,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_ATOM,  zsymm_iltcopy_ATOM,
#else
  zsymm_outcopy_ATOM,  zsymm_oltcopy_ATOM,
#endif
  zsymm_outcopy_ATOM,  zsymm_oltcopy_ATOM,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_ATOM,  zhemm_iltcopy_ATOM,
#else
  zhemm_outcopy_ATOM,  zhemm_oltcopy_ATOM,
#endif
  zhemm_outcopy_ATOM,  zhemm_oltcopy_ATOM,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_ATOM,

  zgemm3m_incopyb_ATOM,  zgemm3m_incopyr_ATOM,
  zgemm3m_incopyi_ATOM,  zgemm3m_itcopyb_ATOM,
  zgemm3m_itcopyr_ATOM,  zgemm3m_itcopyi_ATOM,
  zgemm3m_oncopyb_ATOM,  zgemm3m_oncopyr_ATOM,
  zgemm3m_oncopyi_ATOM,  zgemm3m_otcopyb_ATOM,
  zgemm3m_otcopyr_ATOM,  zgemm3m_otcopyi_ATOM,

  zsymm3m_iucopyb_ATOM,  zsymm3m_ilcopyb_ATOM,
  zsymm3m_iucopyr_ATOM,  zsymm3m_ilcopyr_ATOM,
  zsymm3m_iucopyi_ATOM,  zsymm3m_ilcopyi_ATOM,
  zsymm3m_oucopyb_ATOM,  zsymm3m_olcopyb_ATOM,
  zsymm3m_oucopyr_ATOM,  zsymm3m_olcopyr_ATOM,
  zsymm3m_oucopyi_ATOM,  zsymm3m_olcopyi_ATOM,

  zhemm3m_iucopyb_ATOM,  zhemm3m_ilcopyb_ATOM,
  zhemm3m_iucopyr_ATOM,  zhemm3m_ilcopyr_ATOM,
  zhemm3m_iucopyi_ATOM,  zhemm3m_ilcopyi_ATOM,

  zhemm3m_oucopyb_ATOM,  zhemm3m_olcopyb_ATOM,
  zhemm3m_oucopyr_ATOM,  zhemm3m_olcopyr_ATOM,
  zhemm3m_oucopyi_ATOM,  zhemm3m_olcopyi_ATOM,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_ATOM, zlaswp_ncopy_ATOM,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_ATOM, xamin_k_ATOM, ixamax_k_ATOM, ixamin_k_ATOM,
  xnrm2_k_ATOM, xasum_k_ATOM, xsum_k_ATOM, xcopy_k_ATOM,
  xdotu_k_ATOM, xdotc_k_ATOM, xqrot_k_ATOM,
  xaxpy_k_ATOM, xaxpyc_k_ATOM, xscal_k_ATOM, xswap_k_ATOM,

  xgemv_n_ATOM, xgemv_t_ATOM, xgemv_r_ATOM, xgemv_c_ATOM,
  xgemv_o_ATOM, xgemv_u_ATOM, xgemv_s_ATOM, xgemv_d_ATOM,
  xgeru_k_ATOM, xgerc_k_ATOM, xgerv_k_ATOM, xgerd_k_ATOM,
  xsymv_L_ATOM, xsymv_U_ATOM,
  xhemv_L_ATOM, xhemv_U_ATOM, xhemv_M_ATOM, xhemv_V_ATOM,

  xgemm_kernel_n_ATOM, xgemm_kernel_l_ATOM, xgemm_kernel_r_ATOM, xgemm_kernel_b_ATOM,
  xgemm_beta_ATOM,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_ATOM, xgemm_itcopy_ATOM,
#else
  xgemm_oncopy_ATOM, xgemm_otcopy_ATOM,
#endif
  xgemm_oncopy_ATOM, xgemm_otcopy_ATOM,

  xtrsm_kernel_LN_ATOM, xtrsm_kernel_LT_ATOM, xtrsm_kernel_LR_ATOM, xtrsm_kernel_LC_ATOM,
  xtrsm_kernel_RN_ATOM, xtrsm_kernel_RT_ATOM, xtrsm_kernel_RR_ATOM, xtrsm_kernel_RC_ATOM,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_ATOM,  xtrsm_iunncopy_ATOM,  xtrsm_iutucopy_ATOM,  xtrsm_iutncopy_ATOM,
  xtrsm_ilnucopy_ATOM,  xtrsm_ilnncopy_ATOM,  xtrsm_iltucopy_ATOM,  xtrsm_iltncopy_ATOM,
#else
  xtrsm_ounucopy_ATOM,  xtrsm_ounncopy_ATOM,  xtrsm_outucopy_ATOM,  xtrsm_outncopy_ATOM,
  xtrsm_olnucopy_ATOM,  xtrsm_olnncopy_ATOM,  xtrsm_oltucopy_ATOM,  xtrsm_oltncopy_ATOM,
#endif
  xtrsm_ounucopy_ATOM,  xtrsm_ounncopy_ATOM,  xtrsm_outucopy_ATOM,  xtrsm_outncopy_ATOM,
  xtrsm_olnucopy_ATOM,  xtrsm_olnncopy_ATOM,  xtrsm_oltucopy_ATOM,  xtrsm_oltncopy_ATOM,

  xtrmm_kernel_RN_ATOM,  xtrmm_kernel_RT_ATOM,  xtrmm_kernel_RR_ATOM,  xtrmm_kernel_RC_ATOM,
  xtrmm_kernel_LN_ATOM,  xtrmm_kernel_LT_ATOM,  xtrmm_kernel_LR_ATOM,  xtrmm_kernel_LC_ATOM,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_ATOM,  xtrmm_iunncopy_ATOM,  xtrmm_iutucopy_ATOM,  xtrmm_iutncopy_ATOM,
  xtrmm_ilnucopy_ATOM,  xtrmm_ilnncopy_ATOM,  xtrmm_iltucopy_ATOM,  xtrmm_iltncopy_ATOM,
#else
  xtrmm_ounucopy_ATOM,  xtrmm_ounncopy_ATOM,  xtrmm_outucopy_ATOM,  xtrmm_outncopy_ATOM,
  xtrmm_olnucopy_ATOM,  xtrmm_olnncopy_ATOM,  xtrmm_oltucopy_ATOM,  xtrmm_oltncopy_ATOM,
#endif
  xtrmm_ounucopy_ATOM,  xtrmm_ounncopy_ATOM,  xtrmm_outucopy_ATOM,  xtrmm_outncopy_ATOM,
  xtrmm_olnucopy_ATOM,  xtrmm_olnncopy_ATOM,  xtrmm_oltucopy_ATOM,  xtrmm_oltncopy_ATOM,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_ATOM,  xsymm_iltcopy_ATOM,
#else
  xsymm_outcopy_ATOM,  xsymm_oltcopy_ATOM,
#endif
  xsymm_outcopy_ATOM,  xsymm_oltcopy_ATOM,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_ATOM,  xhemm_iltcopy_ATOM,
#else
  xhemm_outcopy_ATOM,  xhemm_oltcopy_ATOM,
#endif
  xhemm_outcopy_ATOM,  xhemm_oltcopy_ATOM,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_ATOM,

  xgemm3m_incopyb_ATOM,  xgemm3m_incopyr_ATOM,
  xgemm3m_incopyi_ATOM,  xgemm3m_itcopyb_ATOM,
  xgemm3m_itcopyr_ATOM,  xgemm3m_itcopyi_ATOM,
  xgemm3m_oncopyb_ATOM,  xgemm3m_oncopyr_ATOM,
  xgemm3m_oncopyi_ATOM,  xgemm3m_otcopyb_ATOM,
  xgemm3m_otcopyr_ATOM,  xgemm3m_otcopyi_ATOM,

  xsymm3m_iucopyb_ATOM,  xsymm3m_ilcopyb_ATOM,
  xsymm3m_iucopyr_ATOM,  xsymm3m_ilcopyr_ATOM,
  xsymm3m_iucopyi_ATOM,  xsymm3m_ilcopyi_ATOM,
  xsymm3m_oucopyb_ATOM,  xsymm3m_olcopyb_ATOM,
  xsymm3m_oucopyr_ATOM,  xsymm3m_olcopyr_ATOM,
  xsymm3m_oucopyi_ATOM,  xsymm3m_olcopyi_ATOM,

  xhemm3m_iucopyb_ATOM,  xhemm3m_ilcopyb_ATOM,
  xhemm3m_iucopyr_ATOM,  xhemm3m_ilcopyr_ATOM,
  xhemm3m_iucopyi_ATOM,  xhemm3m_ilcopyi_ATOM,

  xhemm3m_oucopyb_ATOM,  xhemm3m_olcopyb_ATOM,
  xhemm3m_oucopyr_ATOM,  xhemm3m_olcopyr_ATOM,
  xhemm3m_oucopyi_ATOM,  xhemm3m_olcopyi_ATOM,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_ATOM, xlaswp_ncopy_ATOM,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_ATOM,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_ATOM,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_ATOM,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_ATOM,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_ATOM, somatcopy_k_ct_ATOM, somatcopy_k_rn_ATOM, somatcopy_k_rt_ATOM,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_ATOM, domatcopy_k_ct_ATOM, domatcopy_k_rn_ATOM, domatcopy_k_rt_ATOM,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_ATOM, comatcopy_k_ct_ATOM, comatcopy_k_rn_ATOM, comatcopy_k_rt_ATOM,
  comatcopy_k_cnc_ATOM, comatcopy_k_ctc_ATOM, comatcopy_k_rnc_ATOM, comatcopy_k_rtc_ATOM,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_ATOM, zomatcopy_k_ct_ATOM, zomatcopy_k_rn_ATOM, zomatcopy_k_rt_ATOM,
  zomatcopy_k_cnc_ATOM, zomatcopy_k_ctc_ATOM, zomatcopy_k_rnc_ATOM, zomatcopy_k_rtc_ATOM,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_ATOM, simatcopy_k_ct_ATOM, simatcopy_k_rn_ATOM, simatcopy_k_rt_ATOM,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_ATOM, dimatcopy_k_ct_ATOM, dimatcopy_k_rn_ATOM, dimatcopy_k_rt_ATOM,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_ATOM, cimatcopy_k_ct_ATOM, cimatcopy_k_rn_ATOM, cimatcopy_k_rt_ATOM,
  cimatcopy_k_cnc_ATOM, cimatcopy_k_ctc_ATOM, cimatcopy_k_rnc_ATOM, cimatcopy_k_rtc_ATOM,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_ATOM, zimatcopy_k_ct_ATOM, zimatcopy_k_rn_ATOM, zimatcopy_k_rt_ATOM,
  zimatcopy_k_cnc_ATOM, zimatcopy_k_ctc_ATOM, zimatcopy_k_rnc_ATOM, zimatcopy_k_rtc_ATOM,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_ATOM,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_ATOM,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_ATOM,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_ATOM
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
