/* $Id: funcs.c,v 1.6 2005/07/30 12:48:49 cegger Exp $
******************************************************************************

   LibGGIMisc implementation for "directx" target -- API functions.
  
   Copyright (c) 2004      Peter Ekberg         peda@lysator.liu.se
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include "directxggimisc.h"
#include <ggi/display/directx.h>

/* _All_ non-local (ie not declared 'static') functions and variables _must_
   be prefixed with the extension name, and for sublibs also with a unique
   sublib identifier. This is to keep the namespace clean on systems where
   all symbols are exported by default.
*/

/*-* API Implementation */

int GGIMISC_directx_WaitRayPos(ggi_visual *vis, int32_t *x, int32_t *y)
{
	directx_priv *priv = LIBGGI_PRIVATE(vis);
	LPDIRECTDRAW lpdd;
	HRESULT hr;

        if (*y != GGI_RP_BLANK || *x != GGI_RP_DONTCARE) {
		*x = GGI_RP_DONTCARE;
		*y = GGI_RP_BLANK;

		return 1;
	}
	
	GGI_directx_Lock(priv->cs);
	IDirectDraw_AddRef(priv->lpdd);
	lpdd = priv->lpdd;
	GGI_directx_Unlock(priv->cs);

	while(1) {
		hr = IDirectDraw_WaitForVerticalBlank(
			lpdd, DDWAITVB_BLOCKBEGIN, 0);
		if(hr != DDERR_WASSTILLDRAWING)
			break;
	}
	IDirectDraw_Release(lpdd);

	return SUCCEEDED(hr) ? 0 : -1;
}

int GGIMISC_directx_GetRayPos(ggi_visual *vis, int32_t *x, int32_t *y)
{
	directx_priv *priv = LIBGGI_PRIVATE(vis);
	LPDIRECTDRAW lpdd;
	DWORD line;
	HRESULT hr;

	GGI_directx_Lock(&priv->cs);
	IDirectDraw_AddRef(priv->lpdd);
	lpdd = priv->lpdd;
	GGI_directx_Unlock(&priv->cs);

	hr = IDirectDraw_GetScanLine(lpdd, &line);
	if(hr == DDERR_VERTICALBLANKINPROGRESS)
		*y = GGI_RP_BLANK;
	else if(SUCCEEDED(hr))
		*y = line;
	else
		*y = -1;
	*x = GGI_RP_DONTCARE;

	IDirectDraw_Release(lpdd);
	return *y < 0 ? -1 : 0;
}

/* Not implemented */
int GGIMISC_directx_SetSplitline(ggi_visual *vis, int y)
{
	return GGI_ENOFUNC;
}
