/* 
	$Id: tables.h,v 1.11 2000/01/11 06:00:31 greglee Exp $

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    tables.h
*/

#ifdef LOOKUP_SINE
extern FLOAT_T sine(int x);
#else
#include <math.h>
#ifndef PI
#  define PI M_PI
#endif
#define sine(x) (sin((2*PI/1024.0) * (x)))
#endif

#define SINE_CYCLE_LENGTH 1024
extern uint32 freq_table[];
#ifdef tplus
extern FLOAT_T *vol_table;
extern FLOAT_T def_vol_table[];
extern FLOAT_T gs_vol_table[];
extern FLOAT_T *xg_vol_table; /* == gs_vol_table */
extern float pan_delay_table[];
#else
extern FLOAT_T vol_table[];
#endif
extern FLOAT_T expr_table[];
extern FLOAT_T bend_fine[];
extern FLOAT_T bend_coarse[];
#ifdef tplus
extern FLOAT_T midi_time_table[], midi_time_table2[];
#endif

#define MAX_BW_INDEX 240
#define MAX_RESO 240

extern FLOAT_T butterworth_q0[241][4];
extern FLOAT_T butterworth_q10[241][4];
extern FLOAT_T butterworth_q20[241][4];
extern FLOAT_T butterworth_q30[241][4];
extern FLOAT_T butterworth_q40[241][4];
extern FLOAT_T butterworth_q50[241][4];
extern FLOAT_T butterworth_q60[241][4];
extern FLOAT_T butterworth_q70[241][4];
extern FLOAT_T butterworth_q80[241][4];
extern FLOAT_T butterworth_q90[241][4];
extern FLOAT_T butterworth_q100[241][4];
extern FLOAT_T butterworth_q110[241][4];
extern FLOAT_T butterworth_q120[241][4];
extern FLOAT_T butterworth_q130[241][4];
extern FLOAT_T butterworth_q140[241][4];
extern FLOAT_T butterworth_q150[241][4];
extern FLOAT_T butterworth_q160[241][4];
extern FLOAT_T butterworth_q170[241][4];
extern FLOAT_T butterworth_q180[241][4];
extern FLOAT_T butterworth_q190[241][4];
extern FLOAT_T butterworth_q200[241][4];
extern FLOAT_T butterworth_q210[241][4];
extern FLOAT_T butterworth_q220[241][4];
extern FLOAT_T butterworth_q230[241][4];
extern FLOAT_T butterworth_q240[241][4];

extern uint8 *_l2u; /* 13-bit PCM to 8-bit u-law */
extern uint8 _l2u_[]; /* used in LOOKUP_HACK */
#ifdef LOOKUP_HACK
extern int16 _u2l[];
extern int32 *mixup;
#ifdef LOOKUP_INTERPOLATION
extern int8 *iplookup;
#endif
#endif

extern void init_tables(void);

extern struct short_voice_type {
	const char *vname;
#define SOLO_MASK 1
	char flags;
} gm_voice[];


#define XMAPMAX 800
extern int xmap[XMAPMAX][5];

#define MAX_MILLI_DELAY 70
extern int xg_10th_millisecond_delay[MAX_MILLI_DELAY];

#define MAX_PARAMETER_DEFAULT 0x76
extern int xg_parameter_default[MAX_PARAMETER_DEFAULT];
extern int xg_parameter[MAX_PARAMETER_DEFAULT];

#define MAX_INSERTION_PARAMETER 0x44
extern int xg_insertion1_parameter[MAX_INSERTION_PARAMETER];
extern int xg_insertion2_parameter[MAX_INSERTION_PARAMETER];
extern int xg_insertion_parameter_default[MAX_INSERTION_PARAMETER];

