/* klotski-window.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from klotski-window.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI_WINDOW (klotski_window_get_type ())
#define KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindow))
#define KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))
#define IS_KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI_WINDOW))
#define IS_KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI_WINDOW))
#define KLOTSKI_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))

typedef struct _KlotskiWindow KlotskiWindow;
typedef struct _KlotskiWindowClass KlotskiWindowClass;
typedef struct _KlotskiWindowPrivate KlotskiWindowPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	KLOTSKI_WINDOW_DUMMY_PROPERTY,
	KLOTSKI_WINDOW_LAST_PROPERTY
};
static GParamSpec* klotski_window_properties[KLOTSKI_WINDOW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _KlotskiWindow {
	GtkApplicationWindow parent_instance;
	KlotskiWindowPrivate * priv;
};

struct _KlotskiWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _KlotskiWindowPrivate {
	GSettings* settings;
	gboolean is_tiled;
	gboolean window_is_maximized;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GtkStack* stack_packs;
	GtkStack* stack_puzzles;
	GtkPopover* puzzles_popover;
	PuzzleView* view;
	GtkTreeView* treeview_huarong;
	GtkTreeView* treeview_challenge;
	GtkTreeView* treeview_skill;
	GSimpleAction* prev_pack;
	GSimpleAction* next_pack;
	GSimpleAction* prev_puzzle;
	GSimpleAction* next_puzzle;
	GSimpleAction* start_game;
	Puzzle* puzzle;
	gint current_pack;
	gint current_level;
	GamesScoresContext* scores_context;
	GtkListStore* liststore_huarong;
	GtkListStore* liststore_challenge;
	GtkListStore* liststore_skill;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer klotski_window_parent_class = NULL;
static GeeList* klotski_window_score_categories;
static GeeList* klotski_window_score_categories = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self, LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_window_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define KLOTSKI_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI_WINDOW, KlotskiWindowPrivate))
#define KLOTSKI_WINDOW_KEY_LEVEL "level"
static void klotski_window_prev_pack_cb (KlotskiWindow* self);
static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_next_pack_cb (KlotskiWindow* self);
static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_prev_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_next_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_start_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static gchar* klotski_window_normalize_map_name (const gchar* name);
static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self, const gchar* key);
static void klotski_window_parse_old_score (KlotskiWindow* self, const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category);
KlotskiWindow* klotski_window_new (void);
KlotskiWindow* klotski_window_construct (GType object_type);
static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category, gpointer self);
static void klotski_window_level_huarong_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void klotski_window_level_challenge_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void klotski_window_level_skill_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_window_load_solved_state (KlotskiWindow* self);
static void __lambda5_ (KlotskiWindow* self);
static void klotski_window_update_popover (KlotskiWindow* self, gboolean make_current);
static void ___lambda5__gtk_widget_show (GtkWidget* _sender, gpointer self);
static void klotski_window_start_puzzle (KlotskiWindow* self);
static void klotski_window_on_size_allocate (KlotskiWindow* self, GtkAllocation* allocation);
static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean klotski_window_on_window_state_event (KlotskiWindow* self, GdkEventWindowState* event);
static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void klotski_window_on_destroy (KlotskiWindow* self);
static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self, GtkListStore* model, GtkTreeIter* iter);
static void klotski_window_update_buttons_state (KlotskiWindow* self);
static void klotski_window_level_cb (KlotskiWindow* self, GtkListStore* liststore, GtkTreePath* path, GtkTreeViewColumn* column);
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static void klotski_window_puzzle_moved_cb (KlotskiWindow* self);
static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void klotski_window_update_moves_label (KlotskiWindow* self);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_window_game_score (KlotskiWindow* self);
static gchar* klotski_window_get_level_key (KlotskiWindow* self, gint level_number);
static void klotski_window_puzzle_solved (KlotskiWindow* self, GtkTreeIter* iter, gboolean solved);
static void __lambda4_ (KlotskiWindow* self, GObject* object, GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void klotski_window_show_scores (KlotskiWindow* self);
static void klotski_window_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const LevelInfo KLOTSKI_WINDOW_levels[28] = {{N_ ("Only 18 Steps"), 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {N_ ("Daisy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Violet"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Poppy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Pansy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Snowdrop"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Red Donkey"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {N_ ("Trail"), 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {N_ ("Ambush"), 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {N_ ("Agatka"), 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {N_ ("Success"), 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {N_ ("Bone"), 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {N_ ("Fortune"), 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {N_ ("Fool"), 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {N_ ("Solomon"), 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {N_ ("Cleopatra"), 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {N_ ("Shark"), 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {N_ ("Rome"), 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {N_ ("Pennant Puzzle"), 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {N_ ("Ithaca"), 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {N_ ("Pelopones"), 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {N_ ("Transeuropa"), 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {N_ ("Lodzianka"), 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {N_ ("Polonaise"), 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {N_ ("Baltic Sea"), 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {N_ ("American Pie"), 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {N_ ("Traffic Jam"), 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {N_ ("Sunshine"), 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_WINDOW_win_actions[5] = {{"prev-pack", _klotski_window_prev_pack_cb_gsimple_action_activate_callback}, {"next-pack", _klotski_window_next_pack_cb_gsimple_action_activate_callback}, {"prev-puzzle", _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback}, {"next-puzzle", _klotski_window_next_puzzle_cb_gsimple_action_activate_callback}, {"start-game", _klotski_window_start_puzzle_cb_gsimple_action_activate_callback}};

void level_info_copy (const LevelInfo* self, LevelInfo* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = (*self).name;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*dest).name);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	(*dest).name = _tmp1_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = (*self).group;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	(*dest).group = _tmp2_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = (*self).width;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	(*dest).width = _tmp3_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = (*self).height;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	(*dest).height = _tmp4_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = (*self).data;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*dest).data);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	(*dest).data = _tmp6_;
#line 255 "klotski-window.c"
}


void level_info_destroy (LevelInfo* self) {
#line 16 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*self).name);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*self).data);
#line 264 "klotski-window.c"
}


LevelInfo* level_info_dup (const LevelInfo* self) {
	LevelInfo* dup;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	dup = g_new0 (LevelInfo, 1);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	level_info_copy (self, dup);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return dup;
#line 276 "klotski-window.c"
}


void level_info_free (LevelInfo* self) {
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	level_info_destroy (self);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_free (self);
#line 285 "klotski-window.c"
}


GType level_info_get_type (void) {
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_prev_pack_cb ((KlotskiWindow*) self);
#line 303 "klotski-window.c"
}


static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_next_pack_cb ((KlotskiWindow*) self);
#line 310 "klotski-window.c"
}


static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_prev_puzzle_cb ((KlotskiWindow*) self);
#line 317 "klotski-window.c"
}


static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_next_puzzle_cb ((KlotskiWindow*) self);
#line 324 "klotski-window.c"
}


static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle_cb ((KlotskiWindow*) self);
#line 331 "klotski-window.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1415 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1415 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1415 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 350 "klotski-window.c"
	} else {
		const gchar* _tmp2_;
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp2_ = old;
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
#line 357 "klotski-window.c"
	}
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 363 "klotski-window.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp3_ = old;
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp4_ = replacement;
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
#line 373 "klotski-window.c"
	}
#line 1416 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 377 "klotski-window.c"
		gchar* _tmp5_;
#line 1417 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp5_ = g_strdup (self);
#line 1417 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1417 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		return result;
#line 385 "klotski-window.c"
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp6_ = old;
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp9_;
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_g_free0 (_tmp8_);
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		regex = _tmp10_;
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 417 "klotski-window.c"
				goto __catch1_g_regex_error;
			}
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1420 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			return NULL;
#line 426 "klotski-window.c"
		}
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp12_ = regex;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp13_ = replacement;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp11_ = _tmp14_;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 442 "klotski-window.c"
				goto __catch1_g_regex_error;
			}
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
			return NULL;
#line 453 "klotski-window.c"
		}
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp15_ = _tmp11_;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp11_ = NULL;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		result = _tmp15_;
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_g_free0 (_tmp11_);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1421 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		return result;
#line 467 "klotski-window.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1423 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 481 "klotski-window.c"
	}
	__finally1:
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1419 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		return NULL;
#line 492 "klotski-window.c"
	}
}


static gchar* klotski_window_normalize_map_name (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 454 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = name;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = string_replace (_tmp2_, " ", "-");
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = _tmp3_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (_tmp2_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	result = _tmp4_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 522 "klotski-window.c"
}


static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 532 "klotski-window.c"
	{
		gint i = 0;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 537 "klotski-window.c"
		{
			gboolean _tmp0_ = FALSE;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp0_ = TRUE;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 544 "klotski-window.c"
				gint _tmp2_;
				const gchar* _tmp3_;
				gint _tmp4_;
				LevelInfo _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!_tmp0_) {
#line 555 "klotski-window.c"
					gint _tmp1_;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp1_ = i;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					i = _tmp1_ + 1;
#line 561 "klotski-window.c"
				}
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp0_ = FALSE;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp2_ = i;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp2_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 571 "klotski-window.c"
				}
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = key;
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = i;
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = KLOTSKI_WINDOW_levels[_tmp4_];
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = _tmp5_.name;
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = klotski_window_normalize_map_name (_tmp6_);
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = _tmp7_;
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = g_strcmp0 (_tmp3_, _tmp8_) == 0;
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_g_free0 (_tmp8_);
#line 473 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (_tmp9_) {
#line 591 "klotski-window.c"
					GeeList* _tmp10_;
					gint _tmp11_;
					gpointer _tmp12_;
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp10_ = klotski_window_score_categories;
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp11_ = i;
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					result = (GamesScoresCategory*) _tmp12_;
#line 474 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					return result;
#line 605 "klotski-window.c"
				}
			}
		}
	}
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	result = NULL;
#line 476 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 614 "klotski-window.c"
}


static void klotski_window_parse_old_score (KlotskiWindow* self, const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category) {
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint64 date = 0LL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint level = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_;
	gint moves = 0;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint64 _tmp26_;
	GamesScoresScore* _tmp27_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gpointer _tmp30_;
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (line != NULL);
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_score);
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_vala_score = NULL;
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_category);
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_vala_category = NULL;
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = line;
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	tokens = _tmp2_;
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	tokens_length1 = _vala_array_length (_tmp1_);
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tokens_size_ = tokens_length1;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = tokens;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3__length1 = tokens_length1;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp3__length1 != 3) {
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 690 "klotski-window.c"
		} else {
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 694 "klotski-window.c"
		}
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 700 "klotski-window.c"
		} else {
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 704 "klotski-window.c"
		}
#line 486 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 708 "klotski-window.c"
	}
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = tokens;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4__length1 = tokens_length1;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = _tmp4_[0];
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = games_scores_history_file_importer_parse_date (_tmp5_);
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	date = _tmp6_;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = date;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp7_ == ((gint64) 0)) {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 730 "klotski-window.c"
		} else {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 734 "klotski-window.c"
		}
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 740 "klotski-window.c"
		} else {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 744 "klotski-window.c"
		}
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 748 "klotski-window.c"
	}
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = tokens;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8__length1 = tokens_length1;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = _tmp8_[1];
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = atoi (_tmp9_);
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	level = _tmp10_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = level;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp12_ == 0) {
#line 764 "klotski-window.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp13_ = tokens;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp13__length1 = tokens_length1;
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp14_ = _tmp13_[1];
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp11_ = g_strcmp0 (_tmp14_, "0") != 0;
#line 776 "klotski-window.c"
	} else {
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp11_ = FALSE;
#line 780 "klotski-window.c"
	}
#line 493 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp11_) {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 790 "klotski-window.c"
		} else {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 794 "klotski-window.c"
		}
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 800 "klotski-window.c"
		} else {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 804 "klotski-window.c"
		}
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 808 "klotski-window.c"
	}
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = level;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp16_ < 0) {
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp15_ = TRUE;
#line 816 "klotski-window.c"
	} else {
		gint _tmp17_;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp17_ = level;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp18_ = klotski_window_score_categories;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp20_ = _tmp19_;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp15_ = _tmp17_ > _tmp20_;
#line 832 "klotski-window.c"
	}
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp15_) {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 842 "klotski-window.c"
		} else {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 846 "klotski-window.c"
		}
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 852 "klotski-window.c"
		} else {
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 856 "klotski-window.c"
		}
#line 496 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 860 "klotski-window.c"
	}
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = tokens;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp21__length1 = tokens_length1;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = _tmp21_[2];
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp23_ = atoi (_tmp22_);
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	moves = _tmp23_;
#line 499 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp24_ = moves;
#line 499 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp24_ <= 0) {
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 882 "klotski-window.c"
		} else {
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 886 "klotski-window.c"
		}
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 892 "klotski-window.c"
		} else {
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 896 "klotski-window.c"
		}
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 900 "klotski-window.c"
	}
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = moves;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = date;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = games_scores_score_new ((glong) _tmp25_, _tmp26_, NULL);
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_score);
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_vala_score = _tmp27_;
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp28_ = klotski_window_score_categories;
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp29_ = level;
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_category);
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_vala_category = (GamesScoresCategory*) _tmp30_;
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (score) {
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		*score = _vala_score;
#line 928 "klotski-window.c"
	} else {
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_object_unref0 (_vala_score);
#line 932 "klotski-window.c"
	}
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (category) {
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		*category = _vala_category;
#line 938 "klotski-window.c"
	} else {
#line 479 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_object_unref0 (_vala_category);
#line 942 "klotski-window.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 950 "klotski-window.c"
}


static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = klotski_window_category_request ((KlotskiWindow*) self, category_key);
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 959 "klotski-window.c"
}


static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore* * score, GamesScoresCategory* * category, gpointer self) {
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_parse_old_score ((KlotskiWindow*) self, line, score, category);
#line 966 "klotski-window.c"
}


static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_huarong_cb ((KlotskiWindow*) self, path, column);
#line 973 "klotski-window.c"
}


static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_challenge_cb ((KlotskiWindow*) self, path, column);
#line 980 "klotski-window.c"
}


static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_skill_cb ((KlotskiWindow*) self, path, column);
#line 987 "klotski-window.c"
}


static void __lambda5_ (KlotskiWindow* self) {
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 994 "klotski-window.c"
}


static void ___lambda5__gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	__lambda5_ ((KlotskiWindow*) self);
#line 1001 "klotski-window.c"
}


KlotskiWindow* klotski_window_construct (GType object_type) {
	KlotskiWindow * self = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gint _tmp6_;
	GSettings* _tmp7_;
	gint _tmp8_;
	GSettings* _tmp9_;
	gboolean _tmp10_;
	GAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GamesScoresHistoryFileImporter* _tmp21_;
	GamesScoresHistoryFileImporter* _tmp22_;
	GamesScoresContext* _tmp23_;
	GtkListStore* _tmp24_;
	GtkListStore* _tmp25_;
	GtkListStore* _tmp26_;
	GtkTreeIter* _tmp27_;
	GtkTreeView* _tmp70_;
	GtkListStore* _tmp71_;
	GtkTreeView* _tmp72_;
	GtkListStore* _tmp73_;
	GtkTreeView* _tmp74_;
	GtkListStore* _tmp75_;
	GtkTreeView* _tmp76_;
	GtkTreeView* _tmp77_;
	GtkTreeView* _tmp78_;
	PuzzleView* _tmp79_;
	PuzzleView* _tmp80_;
	PuzzleView* _tmp81_;
	PuzzleView* _tmp82_;
	PuzzleView* _tmp83_;
	GSettings* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	GtkPopover* _tmp87_;
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self = (KlotskiWindow*) g_object_new (object_type, NULL);
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	css_provider = _tmp0_;
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = css_provider;
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/klotski/ui/klotski.css");
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = css_provider;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_settings_new ("org.gnome.klotski");
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->settings = _tmp4_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->settings;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "window-width");
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->settings;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = g_settings_get_int (_tmp7_, "window-height");
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp6_, _tmp8_);
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = self->priv->settings;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = g_settings_get_boolean (_tmp9_, "window-is-maximized");
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp10_) {
#line 515 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 1094 "klotski-window.c"
	}
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_WINDOW_win_actions, G_N_ELEMENTS (KLOTSKI_WINDOW_win_actions), self);
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) self, "prev-pack");
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp11_) : NULL);
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_pack);
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->prev_pack = _tmp12_;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) self, "next-pack");
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp13_) : NULL);
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_pack);
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->next_pack = _tmp14_;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, "prev-puzzle");
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_puzzle);
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->prev_puzzle = _tmp16_;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "next-puzzle");
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_puzzle);
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->next_puzzle = _tmp18_;
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) self, "start-game");
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp19_) : NULL);
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->start_game);
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->start_game = _tmp20_;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = games_scores_history_file_importer_new (_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = _tmp21_;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp23_ = games_scores_context_new_with_importer ("gnome-klotski", _ ("Puzzle"), (GtkWindow*) self, _klotski_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, (GamesScoresImporter*) _tmp22_);
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->scores_context = _tmp23_;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_tmp22_);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp24_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_huarong);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_huarong = _tmp24_;
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_challenge);
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_challenge = _tmp25_;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_skill);
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_skill = _tmp26_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_WINDOW_levels));
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = _tmp27_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_WINDOW_levels);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
#line 1178 "klotski-window.c"
	{
		gint i = 0;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 1183 "klotski-window.c"
		{
			gboolean _tmp28_ = FALSE;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp28_ = TRUE;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 1190 "klotski-window.c"
				gint _tmp30_;
				gint _tmp31_;
				LevelInfo _tmp32_;
				gint _tmp33_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!_tmp28_) {
#line 1197 "klotski-window.c"
					gint _tmp29_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp29_ = i;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					i = _tmp29_ + 1;
#line 1203 "klotski-window.c"
				}
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp28_ = FALSE;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp30_ = i;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp30_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 1213 "klotski-window.c"
				}
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp31_ = i;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp32_ = KLOTSKI_WINDOW_levels[_tmp31_];
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp33_ = _tmp32_.group;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				switch (_tmp33_) {
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					case 0:
#line 1225 "klotski-window.c"
					{
						GtkListStore* _tmp34_;
						GtkTreeIter* _tmp35_;
						gint _tmp35__length1;
						gint _tmp36_;
						GtkTreeIter _tmp37_ = {0};
						GtkListStore* _tmp38_;
						GtkTreeIter* _tmp39_;
						gint _tmp39__length1;
						gint _tmp40_;
						GtkTreeIter _tmp41_;
						gint _tmp42_;
						LevelInfo _tmp43_;
						const gchar* _tmp44_;
						gint _tmp45_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp34_ = self->priv->liststore_huarong;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp35_ = self->priv->puzzles_items;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp35__length1 = self->priv->puzzles_items_length1;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp36_ = i;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp34_, &_tmp37_);
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp35_[_tmp36_] = _tmp37_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp38_ = self->priv->liststore_huarong;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp39_ = self->priv->puzzles_items;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp39__length1 = self->priv->puzzles_items_length1;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp40_ = i;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp41_ = _tmp39_[_tmp40_];
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp42_ = i;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp43_ = KLOTSKI_WINDOW_levels[_tmp42_];
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp44_ = _tmp43_.name;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp45_ = i;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp38_, &_tmp41_, 0, _ (_tmp44_), 1, FALSE, 2, _tmp45_, 3, FALSE, -1);
#line 550 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						break;
#line 1275 "klotski-window.c"
					}
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					case 1:
#line 1279 "klotski-window.c"
					{
						GtkListStore* _tmp46_;
						GtkTreeIter* _tmp47_;
						gint _tmp47__length1;
						gint _tmp48_;
						GtkTreeIter _tmp49_ = {0};
						GtkListStore* _tmp50_;
						GtkTreeIter* _tmp51_;
						gint _tmp51__length1;
						gint _tmp52_;
						GtkTreeIter _tmp53_;
						gint _tmp54_;
						LevelInfo _tmp55_;
						const gchar* _tmp56_;
						gint _tmp57_;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp46_ = self->priv->liststore_challenge;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp47_ = self->priv->puzzles_items;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp47__length1 = self->priv->puzzles_items_length1;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp48_ = i;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp46_, &_tmp49_);
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp47_[_tmp48_] = _tmp49_;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp50_ = self->priv->liststore_challenge;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp51_ = self->priv->puzzles_items;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp51__length1 = self->priv->puzzles_items_length1;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp52_ = i;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp53_ = _tmp51_[_tmp52_];
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp54_ = i;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp55_ = KLOTSKI_WINDOW_levels[_tmp54_];
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp56_ = _tmp55_.name;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp57_ = i;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp50_, &_tmp53_, 0, _ (_tmp56_), 1, FALSE, 2, _tmp57_, 3, FALSE, -1);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						break;
#line 1329 "klotski-window.c"
					}
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					case 2:
#line 1333 "klotski-window.c"
					{
						GtkListStore* _tmp58_;
						GtkTreeIter* _tmp59_;
						gint _tmp59__length1;
						gint _tmp60_;
						GtkTreeIter _tmp61_ = {0};
						GtkListStore* _tmp62_;
						GtkTreeIter* _tmp63_;
						gint _tmp63__length1;
						gint _tmp64_;
						GtkTreeIter _tmp65_;
						gint _tmp66_;
						LevelInfo _tmp67_;
						const gchar* _tmp68_;
						gint _tmp69_;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp58_ = self->priv->liststore_skill;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp59_ = self->priv->puzzles_items;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp59__length1 = self->priv->puzzles_items_length1;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp60_ = i;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp58_, &_tmp61_);
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp59_[_tmp60_] = _tmp61_;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp62_ = self->priv->liststore_skill;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp63_ = self->priv->puzzles_items;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp63__length1 = self->priv->puzzles_items_length1;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp64_ = i;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp65_ = _tmp63_[_tmp64_];
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp66_ = i;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp67_ = KLOTSKI_WINDOW_levels[_tmp66_];
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp68_ = _tmp67_.name;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp69_ = i;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp62_, &_tmp65_, 0, _ (_tmp68_), 1, FALSE, 2, _tmp69_, 3, FALSE, -1);
#line 566 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						break;
#line 1383 "klotski-window.c"
					}
					default:
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 1388 "klotski-window.c"
				}
			}
		}
	}
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp70_ = self->priv->treeview_huarong;
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp71_ = self->priv->liststore_huarong;
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp70_, (GtkTreeModel*) _tmp71_);
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp72_ = self->priv->treeview_challenge;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp73_ = self->priv->liststore_challenge;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp72_, (GtkTreeModel*) _tmp73_);
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp74_ = self->priv->treeview_skill;
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp75_ = self->priv->liststore_skill;
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp74_, (GtkTreeModel*) _tmp75_);
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp76_ = self->priv->treeview_huarong;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp76_, "row-activated", (GCallback) _klotski_window_level_huarong_cb_gtk_tree_view_row_activated, self, 0);
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp77_ = self->priv->treeview_challenge;
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp77_, "row-activated", (GCallback) _klotski_window_level_challenge_cb_gtk_tree_view_row_activated, self, 0);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp78_ = self->priv->treeview_skill;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp78_, "row-activated", (GCallback) _klotski_window_level_skill_cb_gtk_tree_view_row_activated, self, 0);
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp79_ = puzzle_view_new ();
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_object_ref_sink (_tmp79_);
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->view);
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->view = _tmp79_;
#line 579 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp80_ = self->priv->view;
#line 579 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp80_, GTK_ALIGN_FILL);
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp81_ = self->priv->view;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_object_set ((GtkWidget*) _tmp81_, "can-focus", TRUE, NULL);
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp82_ = self->priv->view;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp82_);
#line 582 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp83_ = self->priv->view;
#line 582 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp83_);
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_load_solved_state (self);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp84_ = self->priv->settings;
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp85_ = g_settings_get_int (_tmp84_, KLOTSKI_WINDOW_KEY_LEVEL);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp86_ = CLAMP (_tmp85_, 0, G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp86_;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp87_ = self->priv->puzzles_popover;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object ((GtkWidget*) _tmp87_, "show", (GCallback) ___lambda5__gtk_widget_show, self, 0);
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (css_provider);
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return self;
#line 1469 "klotski-window.c"
}


KlotskiWindow* klotski_window_new (void) {
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return klotski_window_construct (TYPE_KLOTSKI_WINDOW);
#line 1476 "klotski-window.c"
}


static void klotski_window_on_size_allocate (KlotskiWindow* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (allocation != NULL);
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->window_is_maximized;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp1_) {
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = TRUE;
#line 1495 "klotski-window.c"
	} else {
		gboolean _tmp2_;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = self->priv->is_tiled;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = _tmp2_;
#line 1502 "klotski-window.c"
	}
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp0_) {
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 1508 "klotski-window.c"
	}
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->window_width = _tmp3_;
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->window_height = _tmp4_;
#line 1516 "klotski-window.c"
}


static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_on_size_allocate ((KlotskiWindow*) self, allocation);
#line 1523 "klotski-window.c"
}


static gboolean klotski_window_on_window_state_event (KlotskiWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = event;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1543 "klotski-window.c"
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = event;
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1552 "klotski-window.c"
	}
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = event;
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1560 "klotski-window.c"
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = event;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1569 "klotski-window.c"
	}
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	result = FALSE;
#line 613 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 1575 "klotski-window.c"
}


static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = klotski_window_on_window_state_event ((KlotskiWindow*) self, event);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 1584 "klotski-window.c"
}


static void klotski_window_on_destroy (KlotskiWindow* self) {
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->settings;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp0_, KLOTSKI_WINDOW_KEY_LEVEL, _tmp1_);
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = self->priv->settings;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->window_width;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp2_, "window-width", _tmp3_);
#line 624 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = self->priv->settings;
#line 624 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->window_height;
#line 624 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp4_, "window-height", _tmp5_);
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = self->priv->settings;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->window_is_maximized;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_settings_set_boolean (_tmp6_, "window-is-maximized", _tmp7_);
#line 1623 "klotski-window.c"
}


static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_on_destroy ((KlotskiWindow*) self);
#line 1630 "klotski-window.c"
}


static void klotski_window_prev_pack_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
#line 632 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 1651 "klotski-window.c"
	}
#line 636 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 636 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = _tmp3_ - 1;
#line 637 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, FALSE);
#line 1659 "klotski-window.c"
}


static void klotski_window_next_pack_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
#line 640 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 643 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 1680 "klotski-window.c"
	}
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = _tmp3_ + 1;
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, FALSE);
#line 1688 "klotski-window.c"
}


static void klotski_window_prev_puzzle_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 651 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 1709 "klotski-window.c"
	}
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_level;
#line 652 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp3_ - 1;
#line 653 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 1719 "klotski-window.c"
}


static void klotski_window_next_puzzle_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
#line 657 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 660 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 1740 "klotski-window.c"
	}
#line 661 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_level;
#line 661 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp3_ + 1;
#line 662 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 663 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 1750 "klotski-window.c"
}


static void klotski_window_start_puzzle_cb (KlotskiWindow* self) {
	GtkTreeView* tree = NULL;
	GtkStack* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gint _tmp3_;
	gconstpointer _tmp4_;
	GtkWidget* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreeModel* _tmp10_;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_;
	GtkTreeModel* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	gboolean _tmp15_;
	GtkTreeModel* _tmp16_;
	GtkPopover* _tmp19_;
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->stack_puzzles;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_list_nth_data (_tmp2_, (guint) _tmp3_);
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp4_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_view_get_type (), GtkTreeView));
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = _tmp6_;
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp2_);
#line 668 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	tree = _tmp7_;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = tree;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = gtk_tree_view_get_model (_tmp8_);
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	model = _tmp10_;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = tree;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = gtk_tree_selection_get_selected (_tmp12_, &_tmp13_, &_tmp14_);
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (model);
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = _g_object_ref0 (_tmp13_);
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	model = _tmp16_;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	iter = _tmp14_;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp15_) {
#line 1822 "klotski-window.c"
		GtkTreeModel* _tmp17_;
		GtkTreeIter _tmp18_;
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp17_ = model;
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp18_ = iter;
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		klotski_window_start_puzzle_from_iter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_store_get_type (), GtkListStore), &_tmp18_);
#line 1831 "klotski-window.c"
	} else {
#line 675 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		klotski_window_start_puzzle (self);
#line 1835 "klotski-window.c"
	}
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = self->priv->puzzles_popover;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp19_);
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (model);
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (tree);
#line 1845 "klotski-window.c"
}


static void klotski_window_update_popover (KlotskiWindow* self, gboolean make_current) {
	gint current_level_pack = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	GtkTreeIter _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp9_;
	GtkTreeSelection* selection = NULL;
	GtkStack* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	gint _tmp14_;
	gconstpointer _tmp15_;
	GtkWidget* _tmp16_;
	GtkTreeSelection* _tmp17_;
	GtkTreeSelection* _tmp18_;
	GtkTreeSelection* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GtkStack* _tmp25_;
	GtkStack* _tmp26_;
	GList* _tmp27_;
	GList* _tmp28_;
	gint _tmp29_;
	gconstpointer _tmp30_;
	GtkStack* _tmp31_;
	GtkStack* _tmp32_;
	GList* _tmp33_;
	GList* _tmp34_;
	gint _tmp35_;
	gconstpointer _tmp36_;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_items;
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0__length1 = self->priv->puzzles_items_length1;
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	iter = _tmp2_;
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->liststore_huarong;
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = iter;
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = gtk_list_store_iter_is_valid (_tmp3_, &_tmp4_);
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp5_) {
#line 688 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		current_level_pack = 0;
#line 1906 "klotski-window.c"
	} else {
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		gboolean _tmp8_;
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = self->priv->liststore_challenge;
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = iter;
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp8_ = gtk_list_store_iter_is_valid (_tmp6_, &_tmp7_);
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (_tmp8_) {
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			current_level_pack = 1;
#line 1921 "klotski-window.c"
		} else {
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			current_level_pack = 2;
#line 1925 "klotski-window.c"
		}
	}
#line 694 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = make_current;
#line 694 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp9_) {
#line 1932 "klotski-window.c"
		gint _tmp10_;
#line 695 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp10_ = current_level_pack;
#line 695 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		self->priv->current_pack = _tmp10_;
#line 1938 "klotski-window.c"
	}
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = self->priv->stack_puzzles;
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = _tmp12_;
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = self->priv->current_pack;
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = g_list_nth_data (_tmp13_, (guint) _tmp14_);
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp15_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_tree_view_get_type (), GtkTreeView));
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp18_ = _g_object_ref0 (_tmp17_);
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = _tmp18_;
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp13_);
#line 698 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	selection = _tmp19_;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp20_ = self->priv->current_pack;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = current_level_pack;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp20_ == _tmp21_) {
#line 1968 "klotski-window.c"
		GtkTreeSelection* _tmp22_;
		GtkTreeIter _tmp23_;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp22_ = selection;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp23_ = iter;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		gtk_tree_selection_select_iter (_tmp22_, &_tmp23_);
#line 1977 "klotski-window.c"
	} else {
		GtkTreeSelection* _tmp24_;
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp24_ = selection;
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		gtk_tree_selection_unselect_all (_tmp24_);
#line 1984 "klotski-window.c"
	}
#line 704 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_buttons_state (self);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = self->priv->stack_packs;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = self->priv->stack_packs;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = gtk_container_get_children ((GtkContainer*) _tmp26_);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp28_ = _tmp27_;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp29_ = self->priv->current_pack;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp30_ = g_list_nth_data (_tmp28_, (guint) _tmp29_);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_stack_set_visible_child (_tmp25_, (GtkWidget*) _tmp30_);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp28_);
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp31_ = self->priv->stack_puzzles;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp32_ = self->priv->stack_puzzles;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp33_ = gtk_container_get_children ((GtkContainer*) _tmp32_);
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp34_ = _tmp33_;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp35_ = self->priv->current_pack;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp36_ = g_list_nth_data (_tmp34_, (guint) _tmp35_);
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_stack_set_visible_child (_tmp31_, (GtkWidget*) _tmp36_);
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp34_);
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (selection);
#line 2022 "klotski-window.c"
}


static void klotski_window_update_buttons_state (KlotskiWindow* self) {
	GSimpleAction* _tmp0_;
	gint _tmp1_;
	GSimpleAction* _tmp2_;
	gint _tmp3_;
	GSimpleAction* _tmp4_;
	gint _tmp5_;
	GSimpleAction* _tmp6_;
	gint _tmp7_;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 713 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->prev_pack;
#line 713 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_pack;
#line 713 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp0_, _tmp1_ > 0);
#line 714 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = self->priv->next_pack;
#line 714 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 714 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp2_, _tmp3_ < 2);
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = self->priv->prev_puzzle;
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->current_level;
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp4_, _tmp5_ > 0);
#line 717 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = self->priv->next_puzzle;
#line 717 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->current_level;
#line 717 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp6_, _tmp7_ < (G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1));
#line 2061 "klotski-window.c"
}


static void klotski_window_level_huarong_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
#line 724 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 724 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 724 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 726 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_huarong;
#line 726 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 726 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 726 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2083 "klotski-window.c"
}


static void klotski_window_level_challenge_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 730 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_challenge;
#line 730 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 730 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 730 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2105 "klotski-window.c"
}


static void klotski_window_level_skill_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
#line 732 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 732 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 732 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_skill;
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2127 "klotski-window.c"
}


static void klotski_window_level_cb (KlotskiWindow* self, GtkListStore* liststore, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (liststore != NULL);
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 740 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = liststore;
#line 740 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 740 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
#line 740 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	iter = _tmp2_;
#line 741 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = liststore;
#line 741 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = iter;
#line 741 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle_from_iter (self, _tmp3_, &_tmp4_);
#line 2160 "klotski-window.c"
}


static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self, GtkListStore* model, GtkTreeIter* iter) {
	GValue val = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	gint requested_level = 0;
	GValue _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 748 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 748 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (model != NULL);
#line 748 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (iter != NULL);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = model;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = *iter;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 2, &_tmp2_);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	val = _tmp2_;
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = val;
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	requested_level = g_value_get_int (&_tmp3_);
#line 754 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = requested_level;
#line 754 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp4_ < 0) {
#line 755 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 755 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 2201 "klotski-window.c"
	}
#line 757 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = requested_level;
#line 757 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp5_;
#line 758 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_buttons_state (self);
#line 759 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 748 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 2213 "klotski-window.c"
}


static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self) {
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_puzzle_moved_cb ((KlotskiWindow*) self);
#line 2220 "klotski-window.c"
}


static void klotski_window_start_puzzle (KlotskiWindow* self) {
	GtkHeaderBar* _tmp0_;
	gint _tmp1_;
	LevelInfo _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	LevelInfo _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	LevelInfo _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	LevelInfo _tmp11_;
	const gchar* _tmp12_;
	Puzzle* _tmp13_;
	Puzzle* _tmp14_;
	PuzzleView* _tmp15_;
	Puzzle* _tmp16_;
	GSimpleAction* _tmp17_;
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 764 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 764 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 764 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = KLOTSKI_WINDOW_levels[_tmp1_];
#line 764 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = _tmp2_.name;
#line 764 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_header_bar_set_title (_tmp0_, _ (_tmp3_));
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = KLOTSKI_WINDOW_levels[_tmp4_];
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = _tmp5_.width;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = KLOTSKI_WINDOW_levels[_tmp7_];
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = _tmp8_.height;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = KLOTSKI_WINDOW_levels[_tmp10_];
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = _tmp11_.data;
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = puzzle_new (_tmp6_, _tmp9_, _tmp12_);
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzle);
#line 765 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzle = _tmp13_;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = self->priv->puzzle;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp14_, "moved", (GCallback) _klotski_window_puzzle_moved_cb_puzzle_moved, self, 0);
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = self->priv->view;
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = self->priv->puzzle;
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	puzzle_view_set_puzzle (_tmp15_, _tmp16_);
#line 769 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_moves_label (self);
#line 770 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = self->priv->start_game;
#line 770 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp17_, FALSE);
#line 2295 "klotski-window.c"
}


static void klotski_window_puzzle_moved_cb (KlotskiWindow* self) {
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_moves_label (self);
#line 2304 "klotski-window.c"
}


static void klotski_window_update_moves_label (KlotskiWindow* self) {
	GSimpleAction* _tmp0_;
	GtkHeaderBar* _tmp1_;
	Puzzle* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Puzzle* _tmp6_;
	gboolean _tmp7_;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->start_game;
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp0_, TRUE);
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->headerbar;
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = self->priv->puzzle;
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = _tmp2_->moves;
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_strdup_printf (_ ("Moves: %d"), _tmp3_);
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = _tmp4_;
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_header_bar_set_subtitle (_tmp1_, _tmp5_);
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (_tmp5_);
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = self->priv->puzzle;
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = puzzle_game_over (_tmp6_);
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp7_) {
#line 2343 "klotski-window.c"
		GtkHeaderBar* _tmp8_;
#line 784 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp8_ = self->priv->headerbar;
#line 784 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		gtk_header_bar_set_title (_tmp8_, _ ("Level completed."));
#line 785 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		klotski_window_game_score (self);
#line 2351 "klotski-window.c"
	}
}


static void __lambda4_ (KlotskiWindow* self, GObject* object, GAsyncResult* _result_) {
	GError * _inner_error_ = NULL;
#line 823 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (_result_ != NULL);
#line 2360 "klotski-window.c"
	{
		GamesScoresContext* _tmp0_;
		GAsyncResult* _tmp1_;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = self->priv->scores_context;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp1_ = _result_;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2372 "klotski-window.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 830 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = e;
#line 830 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = _tmp2_->message;
#line 830 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_warning ("klotski-window.vala:830: Failed to add score: %s", _tmp3_);
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2394 "klotski-window.c"
	}
	__finally4:
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 2405 "klotski-window.c"
	}
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	__lambda4_ ((KlotskiWindow*) self, source_object, res);
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_object_unref (self);
#line 2415 "klotski-window.c"
}


static void klotski_window_game_score (KlotskiWindow* self) {
	gchar* key = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_;
	gchar* filename = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeIter* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GtkTreeIter _tmp9_;
	GamesScoresContext* _tmp10_;
	Puzzle* _tmp11_;
	gint _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	GamesScoresCategory* _tmp16_;
	GError * _inner_error_ = NULL;
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->current_level;
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = klotski_window_get_level_key (self, _tmp0_);
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	key = _tmp1_;
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = g_key_file_new ();
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	keyfile = _tmp2_;
#line 798 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = g_get_user_data_dir ();
#line 798 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
#line 798 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	filename = _tmp4_;
#line 2458 "klotski-window.c"
	{
#line 802 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
#line 802 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2464 "klotski-window.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2478 "klotski-window.c"
	}
	__finally2:
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (key);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 2495 "klotski-window.c"
	}
#line 808 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
#line 2499 "klotski-window.c"
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = _tmp5_;
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_file_set_contents (filename, _tmp6_, (gssize) -1, &_inner_error_);
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (_tmp6_);
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2513 "klotski-window.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2527 "klotski-window.c"
	}
	__finally3:
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (key);
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 810 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 2544 "klotski-window.c"
	}
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->puzzles_items;
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp7__length1 = self->priv->puzzles_items_length1;
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = self->priv->current_level;
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = _tmp7_[_tmp8_];
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_puzzle_solved (self, &_tmp9_, TRUE);
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = self->priv->scores_context;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = self->priv->puzzle;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = _tmp11_->moves;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = klotski_window_score_categories;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = self->priv->current_level;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = (GamesScoresCategory*) _tmp15_;
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	games_scores_context_add_score (_tmp10_, (glong) _tmp12_, _tmp16_, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_tmp16_);
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (filename);
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_key_file_unref0 (keyfile);
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (key);
#line 2580 "klotski-window.c"
}


void klotski_window_show_scores (KlotskiWindow* self) {
	GamesScoresContext* _tmp0_;
#line 835 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 837 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->scores_context;
#line 837 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	games_scores_context_run_dialog (_tmp0_);
#line 2592 "klotski-window.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1118 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	return result;
#line 2610 "klotski-window.c"
}


static gchar* klotski_window_get_level_key (KlotskiWindow* self, gint level_number) {
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	gint _tmp0_;
	LevelInfo _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint32 _tmp21_;
	gchar* _tmp22_;
#line 840 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 843 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_result_ = (guint32) 0xFFFFFFFFU;
#line 844 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = level_number;
#line 844 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = KLOTSKI_WINDOW_levels[_tmp0_];
#line 844 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_.data;
#line 844 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 844 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	data = _tmp3_;
#line 2638 "klotski-window.c"
	{
		gint i = 0;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 2643 "klotski-window.c"
		{
			gboolean _tmp4_ = FALSE;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp4_ = TRUE;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 2650 "klotski-window.c"
				const gchar* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				gchar octet = '\0';
				const gchar* _tmp9_;
				gint _tmp10_;
				gchar _tmp11_;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!_tmp4_) {
#line 2660 "klotski-window.c"
					gint _tmp5_;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp5_ = i;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					i = _tmp5_ + 1;
#line 2666 "klotski-window.c"
				}
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = FALSE;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = data;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = i;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = string_get (_tmp6_, (glong) _tmp7_);
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp8_ != '\0')) {
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 2680 "klotski-window.c"
				}
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = data;
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp10_ = i;
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				octet = _tmp11_;
#line 2690 "klotski-window.c"
				{
					gint j = 0;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					j = 0;
#line 2695 "klotski-window.c"
					{
						gboolean _tmp12_ = FALSE;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						_tmp12_ = TRUE;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
						while (TRUE) {
#line 2702 "klotski-window.c"
							gint _tmp14_;
							gchar _tmp15_;
							guint32 _tmp16_;
							guint32 _tmp19_;
							gchar _tmp20_;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							if (!_tmp12_) {
#line 2710 "klotski-window.c"
								gint _tmp13_;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								_tmp13_ = j;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								j = _tmp13_ + 1;
#line 2716 "klotski-window.c"
							}
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp12_ = FALSE;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp14_ = j;
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							if (!(_tmp14_ < 8)) {
#line 848 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								break;
#line 2726 "klotski-window.c"
							}
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp15_ = octet;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp16_ = _result_;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							if (((_tmp15_ >> 7) ^ (_tmp16_ >> 31)) != 0) {
#line 2734 "klotski-window.c"
								guint32 _tmp17_;
#line 851 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								_tmp17_ = _result_;
#line 851 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								_result_ = (_tmp17_ << 1) ^ 0x04c11db7;
#line 2740 "klotski-window.c"
							} else {
								guint32 _tmp18_;
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								_tmp18_ = _result_;
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
								_result_ = _tmp18_ << 1;
#line 2747 "klotski-window.c"
							}
#line 854 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp19_ = _result_;
#line 854 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_result_ = _tmp19_ & 0xFFFFFFFFLL;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							_tmp20_ = octet;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
							octet = (gchar) (_tmp20_ << 1);
#line 2757 "klotski-window.c"
						}
					}
				}
			}
		}
	}
#line 859 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = _result_;
#line 859 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = g_strdup_printf ("%08X", (guint) (~_tmp21_));
#line 859 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	result = _tmp22_;
#line 859 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (data);
#line 859 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	return result;
#line 2774 "klotski-window.c"
}


static void klotski_window_load_solved_state (KlotskiWindow* self) {
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	gchar* filename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 864 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = g_key_file_new ();
#line 864 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	keyfile = _tmp0_;
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_get_user_data_dir ();
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	filename = _tmp2_;
#line 2797 "klotski-window.c"
	{
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2803 "klotski-window.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2817 "klotski-window.c"
	}
	__finally5:
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		return;
#line 2832 "klotski-window.c"
	}
	{
		gint i = 0;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 2838 "klotski-window.c"
		{
			gboolean _tmp3_ = FALSE;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp3_ = TRUE;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 2845 "klotski-window.c"
				gint _tmp5_;
				gchar* key = NULL;
				gint _tmp6_;
				gchar* _tmp7_;
				gboolean value = FALSE;
				GtkTreeIter* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				GtkTreeIter _tmp13_;
				gboolean _tmp14_;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!_tmp3_) {
#line 2858 "klotski-window.c"
					gint _tmp4_;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp4_ = i;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					i = _tmp4_ + 1;
#line 2864 "klotski-window.c"
				}
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = FALSE;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = i;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp5_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 2874 "klotski-window.c"
				}
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = i;
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = klotski_window_get_level_key (self, _tmp6_);
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				key = _tmp7_;
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				value = FALSE;
#line 2884 "klotski-window.c"
				{
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp9_;
					gboolean _tmp10_;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp9_ = key;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp10_ = g_key_file_get_boolean (keyfile, _tmp9_, "solved", &_inner_error_);
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp8_ = _tmp10_;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2897 "klotski-window.c"
						goto __catch6_g_error;
					}
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					value = _tmp8_;
#line 2902 "klotski-window.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					e = _inner_error_;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_inner_error_ = NULL;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_g_error_free0 (e);
#line 2914 "klotski-window.c"
				}
				__finally6:
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_g_free0 (key);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_g_free0 (filename);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_g_key_file_unref0 (keyfile);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					g_clear_error (&_inner_error_);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					return;
#line 2931 "klotski-window.c"
				}
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = self->priv->puzzles_items;
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp11__length1 = self->priv->puzzles_items_length1;
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp12_ = i;
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp14_ = value;
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				klotski_window_puzzle_solved (self, &_tmp13_, _tmp14_);
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_g_free0 (key);
#line 2947 "klotski-window.c"
			}
		}
	}
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_free0 (filename);
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_key_file_unref0 (keyfile);
#line 2955 "klotski-window.c"
}


static void klotski_window_puzzle_solved (KlotskiWindow* self, GtkTreeIter* iter, gboolean solved) {
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_;
#line 890 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 890 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (iter != NULL);
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_huarong;
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = *iter;
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = gtk_list_store_iter_is_valid (_tmp0_, &_tmp1_);
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	if (_tmp2_) {
#line 2975 "klotski-window.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		gboolean _tmp5_;
#line 893 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = self->priv->liststore_huarong;
#line 893 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp4_ = *iter;
#line 893 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp5_ = solved;
#line 893 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		gtk_list_store_set (_tmp3_, &_tmp4_, 1, _tmp5_, -1);
#line 2987 "klotski-window.c"
	} else {
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		gboolean _tmp8_;
#line 894 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = self->priv->liststore_challenge;
#line 894 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = *iter;
#line 894 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		_tmp8_ = gtk_list_store_iter_is_valid (_tmp6_, &_tmp7_);
#line 894 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		if (_tmp8_) {
#line 3000 "klotski-window.c"
			GtkListStore* _tmp9_;
			GtkTreeIter _tmp10_;
			gboolean _tmp11_;
#line 895 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp9_ = self->priv->liststore_challenge;
#line 895 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp10_ = *iter;
#line 895 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp11_ = solved;
#line 895 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			gtk_list_store_set (_tmp9_, &_tmp10_, 1, _tmp11_, -1);
#line 3012 "klotski-window.c"
		} else {
			GtkListStore* _tmp12_;
			GtkTreeIter _tmp13_;
			gboolean _tmp14_;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp12_ = self->priv->liststore_skill;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp13_ = *iter;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp14_ = solved;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			gtk_list_store_set (_tmp12_, &_tmp13_, 1, _tmp14_, -1);
#line 3025 "klotski-window.c"
		}
	}
}


static void klotski_window_base_init (KlotskiWindowClass * klass) {
	GeeArrayList* _tmp0_;
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (klotski_window_score_categories);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_score_categories = (GeeList*) _tmp0_;
#line 3039 "klotski-window.c"
	{
		gint i = 0;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 3044 "klotski-window.c"
		{
			gboolean _tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			_tmp1_ = TRUE;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 3051 "klotski-window.c"
				gint _tmp3_;
				GeeList* _tmp4_;
				gint _tmp5_;
				LevelInfo _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gint _tmp10_;
				LevelInfo _tmp11_;
				const gchar* _tmp12_;
				GamesScoresCategory* _tmp13_;
				GamesScoresCategory* _tmp14_;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!_tmp1_) {
#line 3066 "klotski-window.c"
					gint _tmp2_;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					_tmp2_ = i;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					i = _tmp2_ + 1;
#line 3072 "klotski-window.c"
				}
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = i;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp3_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
					break;
#line 3082 "klotski-window.c"
				}
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = klotski_window_score_categories;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = i;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = KLOTSKI_WINDOW_levels[_tmp5_];
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = _tmp6_.name;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = klotski_window_normalize_map_name (_tmp7_);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = _tmp8_;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp10_ = i;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = KLOTSKI_WINDOW_levels[_tmp10_];
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp12_ = _tmp11_.name;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp13_ = games_scores_category_new (_tmp9_, _ (_tmp12_));
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_tmp14_ = _tmp13_;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				gee_collection_add ((GeeCollection*) _tmp4_, _tmp14_);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_g_object_unref0 (_tmp14_);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
				_g_free0 (_tmp9_);
#line 3112 "klotski-window.c"
			}
		}
	}
}


static void klotski_window_class_init (KlotskiWindowClass * klass) {
	gint KlotskiWindow_private_offset;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	klotski_window_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	g_type_class_add_private (klass, sizeof (KlotskiWindowPrivate));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	G_OBJECT_CLASS (klass)->finalize = klotski_window_finalize;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	KlotskiWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/klotski/ui/klotski.ui");
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, headerbar));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_packs", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_packs));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_puzzles", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_puzzles));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "puzzles_popover", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, puzzles_popover));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_huarong", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_huarong));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_challenge", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_challenge));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_skill", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_skill));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_klotski_window_on_size_allocate_gtk_widget_size_allocate));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_klotski_window_on_window_state_event_gtk_widget_window_state_event));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_klotski_window_on_destroy_gtk_widget_destroy));
#line 3151 "klotski-window.c"
}


static void klotski_window_instance_init (KlotskiWindow * self) {
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv = KLOTSKI_WINDOW_GET_PRIVATE (self);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = -1;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = -1;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3164 "klotski-window.c"
}


static void klotski_window_finalize (GObject * obj) {
	KlotskiWindow * self;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI_WINDOW, KlotskiWindow);
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->stack_packs);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->stack_puzzles);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzles_popover);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->view);
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_huarong);
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_challenge);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_skill);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_pack);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_pack);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_puzzle);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_puzzle);
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->start_game);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzle);
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_huarong);
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_challenge);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_skill);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/klotski-window.vala"
	G_OBJECT_CLASS (klotski_window_parent_class)->finalize (obj);
#line 3214 "klotski-window.c"
}


GType klotski_window_get_type (void) {
	static volatile gsize klotski_window_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiWindowClass), (GBaseInitFunc) klotski_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KlotskiWindow), 0, (GInstanceInitFunc) klotski_window_instance_init, NULL };
		GType klotski_window_type_id;
		klotski_window_type_id = g_type_register_static (gtk_application_window_get_type (), "KlotskiWindow", &g_define_type_info, 0);
		g_once_init_leave (&klotski_window_type_id__volatile, klotski_window_type_id);
	}
	return klotski_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



