/* stopwatch.c generated by valac 0.34.6, the Vala compiler
 * generated from stopwatch.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define CLOCKS_TYPE_ANALOG_FRAME (clocks_analog_frame_get_type ())
#define CLOCKS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrame))
#define CLOCKS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))
#define CLOCKS_IS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_IS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_ANALOG_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))

typedef struct _ClocksAnalogFrame ClocksAnalogFrame;
typedef struct _ClocksAnalogFrameClass ClocksAnalogFrameClass;
typedef struct _ClocksAnalogFramePrivate ClocksAnalogFramePrivate;

#define CLOCKS_STOPWATCH_TYPE_FRAME (clocks_stopwatch_frame_get_type ())
#define CLOCKS_STOPWATCH_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FRAME, ClocksStopwatchFrame))
#define CLOCKS_STOPWATCH_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FRAME, ClocksStopwatchFrameClass))
#define CLOCKS_STOPWATCH_IS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FRAME))
#define CLOCKS_STOPWATCH_IS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FRAME))
#define CLOCKS_STOPWATCH_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FRAME, ClocksStopwatchFrameClass))

typedef struct _ClocksStopwatchFrame ClocksStopwatchFrame;
typedef struct _ClocksStopwatchFrameClass ClocksStopwatchFrameClass;
typedef struct _ClocksStopwatchFramePrivate ClocksStopwatchFramePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_STOPWATCH_TYPE_LAPS_ROW (clocks_stopwatch_laps_row_get_type ())
#define CLOCKS_STOPWATCH_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRow))
#define CLOCKS_STOPWATCH_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_LAPS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))

typedef struct _ClocksStopwatchLapsRow ClocksStopwatchLapsRow;
typedef struct _ClocksStopwatchLapsRowClass ClocksStopwatchLapsRowClass;
typedef struct _ClocksStopwatchLapsRowPrivate ClocksStopwatchLapsRowPrivate;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_STOPWATCH_TYPE_FACE (clocks_stopwatch_face_get_type ())
#define CLOCKS_STOPWATCH_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace))
#define CLOCKS_STOPWATCH_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))
#define CLOCKS_STOPWATCH_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))

typedef struct _ClocksStopwatchFace ClocksStopwatchFace;
typedef struct _ClocksStopwatchFaceClass ClocksStopwatchFaceClass;
typedef struct _ClocksStopwatchFacePrivate ClocksStopwatchFacePrivate;

#define CLOCKS_STOPWATCH_FACE_TYPE_STATE (clocks_stopwatch_face_state_get_type ())

#define CLOCKS_STOPWATCH_FACE_TYPE_LAPS_COLUMN (clocks_stopwatch_face_laps_column_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ClocksAnalogFrame {
	GtkBin parent_instance;
	ClocksAnalogFramePrivate * priv;
};

struct _ClocksAnalogFrameClass {
	GtkBinClass parent_class;
	void (*draw_progress) (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
};

struct _ClocksStopwatchFrame {
	ClocksAnalogFrame parent_instance;
	ClocksStopwatchFramePrivate * priv;
};

struct _ClocksStopwatchFrameClass {
	ClocksAnalogFrameClass parent_class;
};

struct _ClocksStopwatchFramePrivate {
	gint seconds;
	gdouble millisecs;
};

struct _ClocksStopwatchLapsRow {
	GtkListBoxRow parent_instance;
	ClocksStopwatchLapsRowPrivate * priv;
};

struct _ClocksStopwatchLapsRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ClocksStopwatchLapsRowPrivate {
	GtkRevealer* slider;
	GtkLabel* num_label;
	GtkLabel* split_label;
	GtkLabel* tot_label;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*back) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksStopwatchFace {
	GtkBox parent_instance;
	ClocksStopwatchFacePrivate * priv;
};

struct _ClocksStopwatchFaceClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	CLOCKS_STOPWATCH_FACE_STATE_RESET,
	CLOCKS_STOPWATCH_FACE_STATE_RUNNING,
	CLOCKS_STOPWATCH_FACE_STATE_STOPPED
} ClocksStopwatchFaceState;

struct _ClocksStopwatchFacePrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	ClocksStopwatchFaceState _state;
	GTimer* timer;
	guint tick_id;
	gint current_lap;
	gdouble last_lap_time;
	ClocksStopwatchFrame* analog_frame;
	GtkLabel* time_label;
	GtkButton* left_button;
	GtkButton* right_button;
	GtkScrolledWindow* laps_scrollwin;
	GtkListBox* laps_list;
};

typedef enum  {
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP,
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT,
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL
} ClocksStopwatchFaceLapsColumn;


static gpointer clocks_stopwatch_frame_parent_class = NULL;
static gpointer clocks_stopwatch_laps_row_parent_class = NULL;
static gpointer clocks_stopwatch_face_parent_class = NULL;
static ClocksClockIface* clocks_stopwatch_face_clocks_clock_parent_iface = NULL;

GType clocks_analog_frame_get_type (void) G_GNUC_CONST;
GType clocks_stopwatch_frame_get_type (void) G_GNUC_CONST;
#define CLOCKS_STOPWATCH_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_STOPWATCH_TYPE_FRAME, ClocksStopwatchFramePrivate))
enum  {
	CLOCKS_STOPWATCH_FRAME_DUMMY_PROPERTY
};
void clocks_stopwatch_frame_update (ClocksStopwatchFrame* self, gint s, gdouble ms);
void clocks_stopwatch_frame_reset (ClocksStopwatchFrame* self);
static void clocks_stopwatch_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius);
#define CLOCKS_ANALOG_FRAME_LINE_WIDTH 6
ClocksStopwatchFrame* clocks_stopwatch_frame_new (void);
ClocksStopwatchFrame* clocks_stopwatch_frame_construct (GType object_type);
ClocksAnalogFrame* clocks_analog_frame_new (void);
ClocksAnalogFrame* clocks_analog_frame_construct (GType object_type);
static void clocks_stopwatch_frame_finalize (GObject* obj);
GType clocks_stopwatch_laps_row_get_type (void) G_GNUC_CONST;
#define CLOCKS_STOPWATCH_LAPS_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowPrivate))
enum  {
	CLOCKS_STOPWATCH_LAPS_ROW_DUMMY_PROPERTY
};
ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_new (const gchar* n, const gchar* split, const gchar* tot);
ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_construct (GType object_type, const gchar* n, const gchar* split, const gchar* tot);
void clocks_stopwatch_laps_row_slide_in (ClocksStopwatchLapsRow* self);
static void clocks_stopwatch_laps_row_finalize (GObject* obj);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_stopwatch_face_get_type (void) G_GNUC_CONST;
GType clocks_stopwatch_face_state_get_type (void) G_GNUC_CONST;
#define CLOCKS_STOPWATCH_FACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFacePrivate))
enum  {
	CLOCKS_STOPWATCH_FACE_DUMMY_PROPERTY,
	CLOCKS_STOPWATCH_FACE_LABEL,
	CLOCKS_STOPWATCH_FACE_HEADER_BAR,
	CLOCKS_STOPWATCH_FACE_PANEL_ID,
	CLOCKS_STOPWATCH_FACE_STATE
};
static GType clocks_stopwatch_face_laps_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
ClocksStopwatchFace* clocks_stopwatch_face_new (ClocksHeaderBar* header_bar);
ClocksStopwatchFace* clocks_stopwatch_face_construct (GType object_type, ClocksHeaderBar* header_bar);
static void __lambda41_ (ClocksStopwatchFace* self, GtkWidget* w);
ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self);
static gboolean clocks_stopwatch_face_update_time_label (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_add_tick (ClocksStopwatchFace* self);
static void ___lambda41__gtk_widget_map (GtkWidget* _sender, gpointer self);
static void __lambda43_ (ClocksStopwatchFace* self, GtkWidget* w);
static void clocks_stopwatch_face_remove_tick (ClocksStopwatchFace* self);
static void ___lambda43__gtk_widget_unmap (GtkWidget* _sender, gpointer self);
static void clocks_stopwatch_face_reset (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_on_left_button_clicked (ClocksStopwatchFace* self, GtkButton* button);
static void clocks_stopwatch_face_start (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_stop (ClocksStopwatchFace* self);
static void _clocks_stopwatch_face_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_stopwatch_face_on_right_button_clicked (ClocksStopwatchFace* self, GtkButton* button);
static void clocks_stopwatch_face_lap (ClocksStopwatchFace* self);
static void _clocks_stopwatch_face_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_stopwatch_face_set_state (ClocksStopwatchFace* self, ClocksStopwatchFaceState value);
void clocks_utils_time_to_hms (gdouble t, gint* h, gint* m, gint* s, gdouble* remainder);
static gboolean ___lambda42_ (ClocksStopwatchFace* self, GtkWidget* c);
static gboolean ____lambda42__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void clocks_stopwatch_face_real_grab_focus (GtkWidget* base);
static gboolean clocks_stopwatch_face_real_escape_pressed (ClocksClock* base);
static void clocks_stopwatch_face_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_stopwatch_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_stopwatch_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void clocks_stopwatch_frame_update (ClocksStopwatchFrame* self, gint s, gdouble ms) {
	gint _tmp0_ = 0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = s;
	self->priv->seconds = _tmp0_;
	_tmp1_ = ms;
	self->priv->millisecs = _tmp1_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void clocks_stopwatch_frame_reset (ClocksStopwatchFrame* self) {
	g_return_if_fail (self != NULL);
	clocks_stopwatch_frame_update (self, 0, (gdouble) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void clocks_stopwatch_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius) {
	ClocksStopwatchFrame * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkStateFlags _tmp8_ = 0;
	GdkRGBA _tmp9_ = {0};
	gdouble progress = 0.0;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	GtkStyleContext* _tmp21_ = NULL;
	GtkStyleContext* _tmp22_ = NULL;
	GtkStyleContext* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	GtkStyleContext* _tmp26_ = NULL;
	GtkStateFlags _tmp27_ = 0;
	GdkRGBA _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	GtkStyleContext* _tmp40_ = NULL;
	self = (ClocksStopwatchFrame*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gtk_style_context_save (_tmp2_);
	_tmp3_ = context;
	gtk_style_context_add_class (_tmp3_, "progress");
	_tmp4_ = cr;
	cairo_set_line_width (_tmp4_, (gdouble) CLOCKS_ANALOG_FRAME_LINE_WIDTH);
	_tmp5_ = cr;
	cairo_set_line_cap (_tmp5_, CAIRO_LINE_CAP_ROUND);
	_tmp6_ = context;
	_tmp7_ = context;
	_tmp8_ = gtk_style_context_get_state (_tmp7_);
	gtk_style_context_get_color (_tmp6_, _tmp8_, &_tmp9_);
	color = _tmp9_;
	_tmp10_ = self->priv->seconds;
	_tmp11_ = self->priv->millisecs;
	progress = (((gdouble) _tmp10_) + _tmp11_) / 60;
	_tmp12_ = progress;
	if (_tmp12_ > ((gdouble) 0)) {
		cairo_t* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gdouble _tmp17_ = 0.0;
		cairo_t* _tmp18_ = NULL;
		GdkRGBA _tmp19_ = {0};
		cairo_t* _tmp20_ = NULL;
		_tmp13_ = cr;
		_tmp14_ = center_x;
		_tmp15_ = center_y;
		_tmp16_ = radius;
		_tmp17_ = progress;
		cairo_arc (_tmp13_, (gdouble) _tmp14_, (gdouble) _tmp15_, (gdouble) (_tmp16_ - (CLOCKS_ANALOG_FRAME_LINE_WIDTH / 2)), 1.5 * G_PI, (1.5 + (_tmp17_ * 2)) * G_PI);
		_tmp18_ = cr;
		_tmp19_ = color;
		gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
		_tmp20_ = cr;
		cairo_stroke (_tmp20_);
	}
	_tmp21_ = context;
	gtk_style_context_restore (_tmp21_);
	_tmp22_ = context;
	gtk_style_context_save (_tmp22_);
	_tmp23_ = context;
	gtk_style_context_add_class (_tmp23_, "progress-fast");
	_tmp24_ = cr;
	cairo_set_line_width (_tmp24_, (gdouble) (CLOCKS_ANALOG_FRAME_LINE_WIDTH - 2));
	_tmp25_ = context;
	_tmp26_ = context;
	_tmp27_ = gtk_style_context_get_state (_tmp26_);
	gtk_style_context_get_color (_tmp25_, _tmp27_, &_tmp28_);
	color = _tmp28_;
	_tmp29_ = self->priv->millisecs;
	progress = _tmp29_;
	_tmp30_ = progress;
	if (_tmp30_ > ((gdouble) 0)) {
		cairo_t* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		cairo_t* _tmp37_ = NULL;
		GdkRGBA _tmp38_ = {0};
		cairo_t* _tmp39_ = NULL;
		_tmp31_ = cr;
		_tmp32_ = center_x;
		_tmp33_ = center_y;
		_tmp34_ = radius;
		_tmp35_ = progress;
		_tmp36_ = progress;
		cairo_arc (_tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_, (gdouble) (_tmp34_ - (CLOCKS_ANALOG_FRAME_LINE_WIDTH / 2)), ((1.5 + (_tmp35_ * 2)) * G_PI) - 0.1, ((1.5 + (_tmp36_ * 2)) * G_PI) + 0.1);
		_tmp37_ = cr;
		_tmp38_ = color;
		gdk_cairo_set_source_rgba (_tmp37_, &_tmp38_);
		_tmp39_ = cr;
		cairo_stroke (_tmp39_);
	}
	_tmp40_ = context;
	gtk_style_context_restore (_tmp40_);
	_g_object_unref0 (context);
}


ClocksStopwatchFrame* clocks_stopwatch_frame_construct (GType object_type) {
	ClocksStopwatchFrame * self = NULL;
	self = (ClocksStopwatchFrame*) clocks_analog_frame_construct (object_type);
	return self;
}


ClocksStopwatchFrame* clocks_stopwatch_frame_new (void) {
	return clocks_stopwatch_frame_construct (CLOCKS_STOPWATCH_TYPE_FRAME);
}


static void clocks_stopwatch_frame_class_init (ClocksStopwatchFrameClass * klass) {
	clocks_stopwatch_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksStopwatchFramePrivate));
	((ClocksAnalogFrameClass *) klass)->draw_progress = (void (*)(ClocksAnalogFrame*, cairo_t*, gint, gint, gint)) clocks_stopwatch_frame_real_draw_progress;
	G_OBJECT_CLASS (klass)->finalize = clocks_stopwatch_frame_finalize;
}


static void clocks_stopwatch_frame_instance_init (ClocksStopwatchFrame * self) {
	self->priv = CLOCKS_STOPWATCH_FRAME_GET_PRIVATE (self);
}


static void clocks_stopwatch_frame_finalize (GObject* obj) {
	ClocksStopwatchFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_FRAME, ClocksStopwatchFrame);
	G_OBJECT_CLASS (clocks_stopwatch_frame_parent_class)->finalize (obj);
}


GType clocks_stopwatch_frame_get_type (void) {
	static volatile gsize clocks_stopwatch_frame_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_stopwatch_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksStopwatchFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_stopwatch_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksStopwatchFrame), 0, (GInstanceInitFunc) clocks_stopwatch_frame_instance_init, NULL };
		GType clocks_stopwatch_frame_type_id;
		clocks_stopwatch_frame_type_id = g_type_register_static (CLOCKS_TYPE_ANALOG_FRAME, "ClocksStopwatchFrame", &g_define_type_info, 0);
		g_once_init_leave (&clocks_stopwatch_frame_type_id__volatile, clocks_stopwatch_frame_type_id);
	}
	return clocks_stopwatch_frame_type_id__volatile;
}


ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_construct (GType object_type, const gchar* n, const gchar* split, const gchar* tot) {
	ClocksStopwatchLapsRow * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (split != NULL, NULL);
	g_return_val_if_fail (tot != NULL, NULL);
	self = (ClocksStopwatchLapsRow*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->num_label;
	_tmp1_ = n;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->split_label;
	_tmp3_ = split;
	gtk_label_set_label (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->tot_label;
	_tmp5_ = tot;
	gtk_label_set_label (_tmp4_, _tmp5_);
	return self;
}


ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_new (const gchar* n, const gchar* split, const gchar* tot) {
	return clocks_stopwatch_laps_row_construct (CLOCKS_STOPWATCH_TYPE_LAPS_ROW, n, split, tot);
}


void clocks_stopwatch_laps_row_slide_in (ClocksStopwatchLapsRow* self) {
	GtkRevealer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->slider;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}


static void clocks_stopwatch_laps_row_class_init (ClocksStopwatchLapsRowClass * klass) {
	gint ClocksStopwatchLapsRow_private_offset;
	clocks_stopwatch_laps_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksStopwatchLapsRowPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_stopwatch_laps_row_finalize;
	ClocksStopwatchLapsRow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/stopwatchlapsrow.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "slider", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, slider));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "num_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, num_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "split_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, split_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tot_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, tot_label));
}


static void clocks_stopwatch_laps_row_instance_init (ClocksStopwatchLapsRow * self) {
	self->priv = CLOCKS_STOPWATCH_LAPS_ROW_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_stopwatch_laps_row_finalize (GObject* obj) {
	ClocksStopwatchLapsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRow);
	_g_object_unref0 (self->priv->slider);
	_g_object_unref0 (self->priv->num_label);
	_g_object_unref0 (self->priv->split_label);
	_g_object_unref0 (self->priv->tot_label);
	G_OBJECT_CLASS (clocks_stopwatch_laps_row_parent_class)->finalize (obj);
}


GType clocks_stopwatch_laps_row_get_type (void) {
	static volatile gsize clocks_stopwatch_laps_row_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_stopwatch_laps_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksStopwatchLapsRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_stopwatch_laps_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksStopwatchLapsRow), 0, (GInstanceInitFunc) clocks_stopwatch_laps_row_instance_init, NULL };
		GType clocks_stopwatch_laps_row_type_id;
		clocks_stopwatch_laps_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ClocksStopwatchLapsRow", &g_define_type_info, 0);
		g_once_init_leave (&clocks_stopwatch_laps_row_type_id__volatile, clocks_stopwatch_laps_row_type_id);
	}
	return clocks_stopwatch_laps_row_type_id__volatile;
}


GType clocks_stopwatch_face_state_get_type (void) {
	static volatile gsize clocks_stopwatch_face_state_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_STOPWATCH_FACE_STATE_RESET, "CLOCKS_STOPWATCH_FACE_STATE_RESET", "reset"}, {CLOCKS_STOPWATCH_FACE_STATE_RUNNING, "CLOCKS_STOPWATCH_FACE_STATE_RUNNING", "running"}, {CLOCKS_STOPWATCH_FACE_STATE_STOPPED, "CLOCKS_STOPWATCH_FACE_STATE_STOPPED", "stopped"}, {0, NULL, NULL}};
		GType clocks_stopwatch_face_state_type_id;
		clocks_stopwatch_face_state_type_id = g_enum_register_static ("ClocksStopwatchFaceState", values);
		g_once_init_leave (&clocks_stopwatch_face_state_type_id__volatile, clocks_stopwatch_face_state_type_id);
	}
	return clocks_stopwatch_face_state_type_id__volatile;
}


static GType clocks_stopwatch_face_laps_column_get_type (void) {
	static volatile gsize clocks_stopwatch_face_laps_column_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_laps_column_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP", "lap"}, {CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT", "split"}, {CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL", "total"}, {0, NULL, NULL}};
		GType clocks_stopwatch_face_laps_column_type_id;
		clocks_stopwatch_face_laps_column_type_id = g_enum_register_static ("ClocksStopwatchFaceLapsColumn", values);
		g_once_init_leave (&clocks_stopwatch_face_laps_column_type_id__volatile, clocks_stopwatch_face_laps_column_type_id);
	}
	return clocks_stopwatch_face_laps_column_type_id__volatile;
}


static void __lambda41_ (ClocksStopwatchFace* self, GtkWidget* w) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING) {
		clocks_stopwatch_face_update_time_label (self);
		clocks_stopwatch_face_add_tick (self);
	}
}


static void ___lambda41__gtk_widget_map (GtkWidget* _sender, gpointer self) {
	__lambda41_ ((ClocksStopwatchFace*) self, _sender);
}


static void __lambda43_ (ClocksStopwatchFace* self, GtkWidget* w) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING) {
		clocks_stopwatch_face_remove_tick (self);
	}
}


static void ___lambda43__gtk_widget_unmap (GtkWidget* _sender, gpointer self) {
	__lambda43_ ((ClocksStopwatchFace*) self, _sender);
}


ClocksStopwatchFace* clocks_stopwatch_face_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksStopwatchFace * self = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	GTimer* _tmp2_ = NULL;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_tmp0_ = _ ("Stopwatch");
	_tmp1_ = header_bar;
	self = (ClocksStopwatchFace*) g_object_new (object_type, "label", _tmp0_, "header-bar", _tmp1_, "panel-id", CLOCKS_PANEL_ID_STOPWATCH, NULL);
	_tmp2_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp2_;
	self->priv->tick_id = (guint) 0;
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) ___lambda41__gtk_widget_map, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) ___lambda43__gtk_widget_unmap, self, 0);
	clocks_stopwatch_face_reset (self);
	return self;
}


ClocksStopwatchFace* clocks_stopwatch_face_new (ClocksHeaderBar* header_bar) {
	return clocks_stopwatch_face_construct (CLOCKS_STOPWATCH_TYPE_FACE, header_bar);
}


static void clocks_stopwatch_face_on_left_button_clicked (ClocksStopwatchFace* self, GtkButton* button) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_RESET:
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			clocks_stopwatch_face_start (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_stop (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _clocks_stopwatch_face_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_stopwatch_face_on_left_button_clicked ((ClocksStopwatchFace*) self, _sender);
}


static void clocks_stopwatch_face_on_right_button_clicked (ClocksStopwatchFace* self, GtkButton* button) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			clocks_stopwatch_face_reset (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_lap (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _clocks_stopwatch_face_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_stopwatch_face_on_right_button_clicked ((ClocksStopwatchFace*) self, _sender);
}


static void clocks_stopwatch_face_start (ClocksStopwatchFace* self) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	GtkButton* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RESET) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = self->priv->timer;
		g_timer_start (_tmp1_);
	} else {
		GTimer* _tmp2_ = NULL;
		_tmp2_ = self->priv->timer;
		g_timer_continue (_tmp2_);
	}
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_RUNNING);
	clocks_stopwatch_face_add_tick (self);
	_tmp3_ = self->priv->left_button;
	_tmp4_ = _ ("Stop");
	gtk_button_set_label (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->left_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "destructive-action");
	_tmp7_ = self->priv->right_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->right_button;
	_tmp9_ = _ ("Lap");
	gtk_button_set_label (_tmp8_, _tmp9_);
}


static void clocks_stopwatch_face_stop (ClocksStopwatchFace* self) {
	GTimer* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_stop (_tmp0_);
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_STOPPED);
	clocks_stopwatch_face_remove_tick (self);
	_tmp1_ = self->priv->left_button;
	_tmp2_ = _ ("Continue");
	gtk_button_set_label (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->left_button;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_remove_class (_tmp4_, "destructive-action");
	_tmp5_ = self->priv->left_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "suggested-action");
	_tmp7_ = self->priv->right_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->right_button;
	_tmp9_ = _ ("Reset");
	gtk_button_set_label (_tmp8_, _tmp9_);
}


static void clocks_stopwatch_face_reset (ClocksStopwatchFace* self) {
	GTimer* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_reset (_tmp0_);
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_RESET);
	clocks_stopwatch_face_remove_tick (self);
	clocks_stopwatch_face_update_time_label (self);
	_tmp1_ = self->priv->left_button;
	_tmp2_ = _ ("Start");
	gtk_button_set_label (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->left_button;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "suggested-action");
	_tmp5_ = self->priv->right_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	self->priv->current_lap = 0;
	self->priv->last_lap_time = (gdouble) 0;
	_tmp6_ = self->priv->laps_list;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp7_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			GtkWidget* l = NULL;
			l = (GtkWidget*) l_it->data;
			{
				GtkListBox* _tmp8_ = NULL;
				GtkWidget* _tmp9_ = NULL;
				_tmp8_ = self->priv->laps_list;
				_tmp9_ = l;
				gtk_container_remove ((GtkContainer*) _tmp8_, _tmp9_);
			}
		}
		_g_list_free0 (l_collection);
	}
}


static void clocks_stopwatch_face_lap (ClocksStopwatchFace* self) {
	gint _tmp0_ = 0;
	gdouble e = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble split = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble r = 0.0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	gint cs = 0;
	gdouble _tmp12_ = 0.0;
	gint split_h = 0;
	gint split_m = 0;
	gint split_s = 0;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gdouble _tmp17_ = 0.0;
	gint split_cs = 0;
	gdouble _tmp18_ = 0.0;
	gchar* n_label = NULL;
	gint _tmp19_ = 0;
	gchar* _tmp20_ = NULL;
	gchar* split_label = NULL;
	gint _tmp21_ = 0;
	gchar* tot_label = NULL;
	gint _tmp31_ = 0;
	ClocksStopwatchLapsRow* row = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	ClocksStopwatchLapsRow* _tmp44_ = NULL;
	GtkListBox* _tmp45_ = NULL;
	GtkScrolledWindow* _tmp46_ = NULL;
	GtkAdjustment* _tmp47_ = NULL;
	GtkAdjustment* _tmp48_ = NULL;
	GtkScrolledWindow* _tmp49_ = NULL;
	GtkAdjustment* _tmp50_ = NULL;
	GtkAdjustment* _tmp51_ = NULL;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_lap;
	self->priv->current_lap = _tmp0_ + 1;
	_tmp1_ = self->priv->timer;
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
	e = _tmp2_;
	_tmp3_ = e;
	_tmp4_ = self->priv->last_lap_time;
	split = _tmp3_ - _tmp4_;
	_tmp5_ = e;
	_tmp6_ = floor (_tmp5_ * 100);
	self->priv->last_lap_time = _tmp6_ / 100;
	_tmp7_ = e;
	clocks_utils_time_to_hms (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	h = _tmp8_;
	m = _tmp9_;
	s = _tmp10_;
	r = _tmp11_;
	_tmp12_ = r;
	cs = (gint) (_tmp12_ * 100);
	_tmp13_ = split;
	clocks_utils_time_to_hms (_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
	split_h = _tmp14_;
	split_m = _tmp15_;
	split_s = _tmp16_;
	r = _tmp17_;
	_tmp18_ = r;
	split_cs = (gint) (_tmp18_ * 100);
	_tmp19_ = self->priv->current_lap;
	_tmp20_ = g_strdup_printf ("#%d", _tmp19_);
	n_label = _tmp20_;
	_tmp21_ = split_h;
	if (_tmp21_ > 0) {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
		_tmp22_ = split_h;
		_tmp23_ = split_m;
		_tmp24_ = split_s;
		_tmp25_ = split_cs;
		_tmp26_ = g_strdup_printf ("%i\u200E∶%02i\u200E∶%02i.%02i", _tmp22_, _tmp23_, _tmp24_, _tmp25_);
		_g_free0 (split_label);
		split_label = _tmp26_;
	} else {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gchar* _tmp30_ = NULL;
		_tmp27_ = split_m;
		_tmp28_ = split_s;
		_tmp29_ = split_cs;
		_tmp30_ = g_strdup_printf ("%02i\u200E∶%02i.%02i", _tmp27_, _tmp28_, _tmp29_);
		_g_free0 (split_label);
		split_label = _tmp30_;
	}
	_tmp31_ = h;
	if (_tmp31_ > 0) {
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gchar* _tmp36_ = NULL;
		_tmp32_ = h;
		_tmp33_ = m;
		_tmp34_ = s;
		_tmp35_ = cs;
		_tmp36_ = g_strdup_printf ("%i\u200E∶%02i\u200E∶%02i.%02i", _tmp32_, _tmp33_, _tmp34_, _tmp35_);
		_g_free0 (tot_label);
		tot_label = _tmp36_;
	} else {
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gchar* _tmp40_ = NULL;
		_tmp37_ = m;
		_tmp38_ = s;
		_tmp39_ = cs;
		_tmp40_ = g_strdup_printf ("%02i\u200E∶%02i.%02i", _tmp37_, _tmp38_, _tmp39_);
		_g_free0 (tot_label);
		tot_label = _tmp40_;
	}
	_tmp41_ = n_label;
	_tmp42_ = split_label;
	_tmp43_ = tot_label;
	_tmp44_ = clocks_stopwatch_laps_row_new (_tmp41_, _tmp42_, _tmp43_);
	g_object_ref_sink (_tmp44_);
	row = _tmp44_;
	_tmp45_ = self->priv->laps_list;
	gtk_list_box_prepend (_tmp45_, (GtkWidget*) row);
	clocks_stopwatch_laps_row_slide_in (row);
	_tmp46_ = self->priv->laps_scrollwin;
	_tmp47_ = gtk_scrolled_window_get_vadjustment (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->laps_scrollwin;
	_tmp50_ = gtk_scrolled_window_get_vadjustment (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = gtk_adjustment_get_lower (_tmp51_);
	_tmp53_ = _tmp52_;
	gtk_adjustment_set_value (_tmp48_, _tmp53_);
	_g_object_unref0 (row);
	_g_free0 (tot_label);
	_g_free0 (split_label);
	_g_free0 (n_label);
}


static gboolean ___lambda42_ (ClocksStopwatchFace* self, GtkWidget* c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = clocks_stopwatch_face_update_time_label (self);
	result = _tmp0_;
	return result;
}


static gboolean ____lambda42__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = ___lambda42_ ((ClocksStopwatchFace*) self, widget);
	return result;
}


static void clocks_stopwatch_face_add_tick (ClocksStopwatchFace* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda42__gtk_tick_callback, g_object_ref (self), g_object_unref);
		self->priv->tick_id = _tmp1_;
	}
}


static void clocks_stopwatch_face_remove_tick (ClocksStopwatchFace* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->tick_id;
		gtk_widget_remove_tick_callback ((GtkWidget*) self, _tmp1_);
		self->priv->tick_id = (guint) 0;
	}
}


static gboolean clocks_stopwatch_face_update_time_label (ClocksStopwatchFace* self) {
	gboolean result = FALSE;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble r = 0.0;
	ClocksStopwatchFaceState _tmp0_ = 0;
	gint ds = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	ClocksStopwatchFrame* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gdouble _tmp24_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	h = 0;
	m = 0;
	s = 0;
	r = (gdouble) 0;
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != CLOCKS_STOPWATCH_FACE_STATE_RESET) {
		GTimer* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gdouble _tmp6_ = 0.0;
		_tmp1_ = self->priv->timer;
		_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
		clocks_utils_time_to_hms (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
		h = _tmp3_;
		m = _tmp4_;
		s = _tmp5_;
		r = _tmp6_;
	}
	_tmp7_ = r;
	ds = (gint) (_tmp7_ * 10);
	_tmp8_ = h;
	if (_tmp8_ > 0) {
		GtkLabel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp9_ = self->priv->time_label;
		_tmp10_ = h;
		_tmp11_ = m;
		_tmp12_ = s;
		_tmp13_ = ds;
		_tmp14_ = g_strdup_printf ("%i\u200E∶%02i\u200E∶%02i.%i", _tmp10_, _tmp11_, _tmp12_, _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_label_set_text (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		GtkLabel* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp16_ = self->priv->time_label;
		_tmp17_ = m;
		_tmp18_ = s;
		_tmp19_ = ds;
		_tmp20_ = g_strdup_printf ("%02i\u200E∶%02i.%i", _tmp17_, _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp16_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = self->priv->analog_frame;
	_tmp23_ = s;
	_tmp24_ = r;
	clocks_stopwatch_frame_update (_tmp22_, _tmp23_, _tmp24_);
	result = TRUE;
	return result;
}


static void clocks_stopwatch_face_real_grab_focus (GtkWidget* base) {
	ClocksStopwatchFace * self;
	GtkButton* _tmp0_ = NULL;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->left_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


static gboolean clocks_stopwatch_face_real_escape_pressed (ClocksClock* base) {
	ClocksStopwatchFace * self;
	gboolean result = FALSE;
	ClocksStopwatchFaceState _tmp0_ = 0;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_RESET:
		{
			result = FALSE;
			return result;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			clocks_stopwatch_face_reset (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_stop (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = TRUE;
	return result;
}


static const gchar* clocks_stopwatch_face_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksStopwatchFace* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_stopwatch_face_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksStopwatchFace* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_stopwatch_face_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksStopwatchFace* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_stopwatch_face_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksStopwatchFace* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static ClocksPanelId clocks_stopwatch_face_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksStopwatchFace* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_stopwatch_face_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksStopwatchFace* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = value;
	self->priv->_panel_id = _tmp0_;
	g_object_notify ((GObject *) self, "panel-id");
}


ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self) {
	ClocksStopwatchFaceState result;
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


static void clocks_stopwatch_face_set_state (ClocksStopwatchFace* self, ClocksStopwatchFaceState value) {
	ClocksStopwatchFaceState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


static void clocks_stopwatch_face_class_init (ClocksStopwatchFaceClass * klass) {
	gint ClocksStopwatchFace_private_offset;
	clocks_stopwatch_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksStopwatchFacePrivate));
	((GtkWidgetClass *) klass)->grab_focus = (void (*)(GtkWidget*)) clocks_stopwatch_face_real_grab_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_stopwatch_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_stopwatch_face_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_stopwatch_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_PANEL_ID, g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_STATE, g_param_spec_enum ("state", "state", "state", CLOCKS_STOPWATCH_FACE_TYPE_STATE, CLOCKS_STOPWATCH_FACE_STATE_RESET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	ClocksStopwatchFace_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/stopwatch.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "analog_frame", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, analog_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_button", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, left_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_button", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, right_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "laps_scrollwin", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, laps_scrollwin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "laps_list", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, laps_list));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_left_button_clicked", G_CALLBACK(_clocks_stopwatch_face_on_left_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_right_button_clicked", G_CALLBACK(_clocks_stopwatch_face_on_right_button_clicked_gtk_button_clicked));
}


static void clocks_stopwatch_face_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_stopwatch_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->escape_pressed = (gboolean (*)(ClocksClock*)) clocks_stopwatch_face_real_escape_pressed;
	iface->get_label = clocks_stopwatch_face_real_get_label;
	iface->set_label = clocks_stopwatch_face_real_set_label;
	iface->get_header_bar = clocks_stopwatch_face_real_get_header_bar;
	iface->set_header_bar = clocks_stopwatch_face_real_set_header_bar;
	iface->get_panel_id = clocks_stopwatch_face_real_get_panel_id;
	iface->set_panel_id = clocks_stopwatch_face_real_set_panel_id;
}


static void clocks_stopwatch_face_instance_init (ClocksStopwatchFace * self) {
	self->priv = CLOCKS_STOPWATCH_FACE_GET_PRIVATE (self);
	self->priv->_state = CLOCKS_STOPWATCH_FACE_STATE_RESET;
	g_type_ensure (CLOCKS_STOPWATCH_TYPE_FRAME);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_stopwatch_face_finalize (GObject* obj) {
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->analog_frame);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->left_button);
	_g_object_unref0 (self->priv->right_button);
	_g_object_unref0 (self->priv->laps_scrollwin);
	_g_object_unref0 (self->priv->laps_list);
	G_OBJECT_CLASS (clocks_stopwatch_face_parent_class)->finalize (obj);
}


GType clocks_stopwatch_face_get_type (void) {
	static volatile gsize clocks_stopwatch_face_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksStopwatchFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_stopwatch_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksStopwatchFace), 0, (GInstanceInitFunc) clocks_stopwatch_face_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_stopwatch_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_stopwatch_face_type_id;
		clocks_stopwatch_face_type_id = g_type_register_static (gtk_box_get_type (), "ClocksStopwatchFace", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_stopwatch_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_stopwatch_face_type_id__volatile, clocks_stopwatch_face_type_id);
	}
	return clocks_stopwatch_face_type_id__volatile;
}


static void _vala_clocks_stopwatch_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	switch (property_id) {
		case CLOCKS_STOPWATCH_FACE_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_PANEL_ID:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_STATE:
		g_value_set_enum (value, clocks_stopwatch_face_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_stopwatch_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	switch (property_id) {
		case CLOCKS_STOPWATCH_FACE_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_STOPWATCH_FACE_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_STOPWATCH_FACE_PANEL_ID:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_STOPWATCH_FACE_STATE:
		clocks_stopwatch_face_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



