


#include <config.h>

#include "ephy-embed-type-builtins.h"


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-download.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-download.h"
GType
ephy_download_action_type_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_download_action_type_values[] = {
      { EPHY_DOWNLOAD_ACTION_NONE, "EPHY_DOWNLOAD_ACTION_NONE", "none" },
      { EPHY_DOWNLOAD_ACTION_AUTO, "EPHY_DOWNLOAD_ACTION_AUTO", "auto" },
      { EPHY_DOWNLOAD_ACTION_BROWSE_TO, "EPHY_DOWNLOAD_ACTION_BROWSE_TO", "browse-to" },
      { EPHY_DOWNLOAD_ACTION_OPEN, "EPHY_DOWNLOAD_ACTION_OPEN", "open" },
      { EPHY_DOWNLOAD_ACTION_DO_NOTHING, "EPHY_DOWNLOAD_ACTION_DO_NOTHING", "do-nothing" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyDownloadActionType", _ephy_download_action_type_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-embed-shell.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-embed-shell.h"
GType
ephy_embed_shell_mode_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_embed_shell_mode_values[] = {
      { EPHY_EMBED_SHELL_MODE_BROWSER, "EPHY_EMBED_SHELL_MODE_BROWSER", "browser" },
      { EPHY_EMBED_SHELL_MODE_PRIVATE, "EPHY_EMBED_SHELL_MODE_PRIVATE", "private" },
      { EPHY_EMBED_SHELL_MODE_INCOGNITO, "EPHY_EMBED_SHELL_MODE_INCOGNITO", "incognito" },
      { EPHY_EMBED_SHELL_MODE_APPLICATION, "EPHY_EMBED_SHELL_MODE_APPLICATION", "application" },
      { EPHY_EMBED_SHELL_MODE_TEST, "EPHY_EMBED_SHELL_MODE_TEST", "test" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyEmbedShellMode", _ephy_embed_shell_mode_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-web-view.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/embed/ephy-web-view.h"
GType
ephy_web_view_navigation_flags_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _ephy_web_view_navigation_flags_values[] = {
      { EPHY_WEB_VIEW_NAV_BACK, "EPHY_WEB_VIEW_NAV_BACK", "back" },
      { EPHY_WEB_VIEW_NAV_FORWARD, "EPHY_WEB_VIEW_NAV_FORWARD", "forward" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("EphyWebViewNavigationFlags", _ephy_web_view_navigation_flags_values);
  }

  return type;
}

GType
ephy_web_view_chrome_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _ephy_web_view_chrome_values[] = {
      { EPHY_WEB_VIEW_CHROME_TOOLBAR, "EPHY_WEB_VIEW_CHROME_TOOLBAR", "toolbar" },
      { EPHY_WEB_VIEW_CHROME_DOWNLOADS_BOX, "EPHY_WEB_VIEW_CHROME_DOWNLOADS_BOX", "downloads-box" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("EphyWebViewChrome", _ephy_web_view_chrome_values);
  }

  return type;
}

GType
ephy_web_view_security_level_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_web_view_security_level_values[] = {
      { EPHY_WEB_VIEW_STATE_IS_UNKNOWN, "EPHY_WEB_VIEW_STATE_IS_UNKNOWN", "unknown" },
      { EPHY_WEB_VIEW_STATE_IS_INSECURE, "EPHY_WEB_VIEW_STATE_IS_INSECURE", "insecure" },
      { EPHY_WEB_VIEW_STATE_IS_BROKEN, "EPHY_WEB_VIEW_STATE_IS_BROKEN", "broken" },
      { EPHY_WEB_VIEW_STATE_IS_SECURE_LOW, "EPHY_WEB_VIEW_STATE_IS_SECURE_LOW", "secure-low" },
      { EPHY_WEB_VIEW_STATE_IS_SECURE_MED, "EPHY_WEB_VIEW_STATE_IS_SECURE_MED", "secure-med" },
      { EPHY_WEB_VIEW_STATE_IS_SECURE_HIGH, "EPHY_WEB_VIEW_STATE_IS_SECURE_HIGH", "secure-high" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyWebViewSecurityLevel", _ephy_web_view_security_level_values);
  }

  return type;
}

GType
ephy_web_view_document_type_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_web_view_document_type_values[] = {
      { EPHY_WEB_VIEW_DOCUMENT_HTML, "EPHY_WEB_VIEW_DOCUMENT_HTML", "html" },
      { EPHY_WEB_VIEW_DOCUMENT_XML, "EPHY_WEB_VIEW_DOCUMENT_XML", "xml" },
      { EPHY_WEB_VIEW_DOCUMENT_IMAGE, "EPHY_WEB_VIEW_DOCUMENT_IMAGE", "image" },
      { EPHY_WEB_VIEW_DOCUMENT_OTHER, "EPHY_WEB_VIEW_DOCUMENT_OTHER", "other" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyWebViewDocumentType", _ephy_web_view_document_type_values);
  }

  return type;
}

GType
ephy_web_view_error_page_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_web_view_error_page_values[] = {
      { EPHY_WEB_VIEW_ERROR_PAGE_NETWORK_ERROR, "EPHY_WEB_VIEW_ERROR_PAGE_NETWORK_ERROR", "page-network-error" },
      { EPHY_WEB_VIEW_ERROR_PAGE_CRASH, "EPHY_WEB_VIEW_ERROR_PAGE_CRASH", "page-crash" },
      { EPHY_WEB_VIEW_ERROR_PROCESS_CRASH, "EPHY_WEB_VIEW_ERROR_PROCESS_CRASH", "process-crash" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyWebViewErrorPage", _ephy_web_view_error_page_values);
  }

  return type;
}




