/* Utils.c generated by valac 0.34.6, the Vala compiler
 * generated from Utils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-params.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include "CbFilter.h"
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"


#define TYPE_PAGE (page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block57Data Block57Data;
typedef struct _Block58Data Block58Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block59Data Block59Data;
typedef struct _UtilsDownloadPixbufData UtilsDownloadPixbufData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block57Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block58Data {
	int _ref_count_;
	GString* sb;
};

struct _Block59Data {
	int _ref_count_;
	GdkPixbuf* _result_;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _UtilsDownloadPixbufData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* url;
	GCancellable* cancellable;
	GdkPixbuf* result;
	Block59Data* _data59_;
	GCancellable* _tmp0_;
	SoupMessage* msg;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	GdkPixbuf* _tmp5_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


extern SoupSession* SOUP_SESSION;
SoupSession* SOUP_SESSION = NULL;

GType page_get_type (void) G_GNUC_CONST;
#define TRANSITION_DURATION (200 * 1000)
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
cairo_surface_t* load_surface (const gchar* path);
void write_surface (cairo_surface_t* surface, const gchar* path);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
gdouble ease_out_cubic (gdouble t);
gchar* rest_call_to_string (RestProxyCall* call);
GDateTime* utils_parse_date (const gchar* input);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
gchar* utils_get_file_name (const gchar* path);
gchar* utils_get_file_type (const gchar* path);
void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void __lambda48_ (Block57Data* _data57_, gint id);
static void ___lambda48__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static void ___lambda49_ (Block58Data* _data58_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda49__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void utils_download_pixbuf_data_free (gpointer _data);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static gboolean utils_download_pixbuf_co (UtilsDownloadPixbufData* _data_);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static gboolean _utils_download_pixbuf_co_gsource_func (gpointer self);
static void __lambda137_ (Block59Data* _data59_, SoupSession* _s, SoupMessage* _msg);
static guint8* _vala_array_dup7 (guint8* self, int length);
static void ___lambda137__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gchar* utils_unescape_html (const gchar* input);
void utils_load_custom_icons (void);
void utils_load_custom_css (void);
void utils_init_soup_session (void);
gchar* utils_capitalize (const gchar* s);
gint utils_get_json_array_size (JsonObject* node, const gchar* object_name);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
GSettings* settings_get (void);
GType account_get_type (void) G_GNUC_CONST;
CbFilter* utils_create_persistent_filter (const gchar* content, Account* account);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
void account_add_filter (Account* self, CbFilter* f);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GEnumValue values[] = {{PAGE_STREAM, "PAGE_STREAM", "stream"}, {PAGE_MENTIONS, "PAGE_MENTIONS", "mentions"}, {PAGE_FAVORITES, "PAGE_FAVORITES", "favorites"}, {PAGE_DM_THREADS, "PAGE_DM_THREADS", "dm-threads"}, {PAGE_LISTS, "PAGE_LISTS", "lists"}, {PAGE_FILTERS, "PAGE_FILTERS", "filters"}, {PAGE_SEARCH, "PAGE_SEARCH", "search"}, {PAGE_PROFILE, "PAGE_PROFILE", "profile"}, {PAGE_TWEET_INFO, "PAGE_TWEET_INFO", "tweet-info"}, {PAGE_DM, "PAGE_DM", "dm"}, {PAGE_LIST_STATUSES, "PAGE_LIST_STATUSES", "list-statuses"}, {PAGE_PREVIOUS, "PAGE_PREVIOUS", "previous"}, {PAGE_NEXT, "PAGE_NEXT", "next"}, {0, NULL, NULL}};
		GType page_type_id;
		page_type_id = g_enum_register_static ("Page", values);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkSeparator* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkListBoxRow* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((row_before == NULL) || GTK_IS_LIST_BOX_ROW (row_before));
	_tmp0_ = row_before;
	if (_tmp0_ == NULL) {
		GtkListBoxRow* _tmp1_ = NULL;
		_tmp1_ = row;
		gtk_list_box_row_set_header (_tmp1_, NULL);
		return;
	}
	_tmp2_ = row;
	_tmp3_ = gtk_list_box_row_get_header (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	header = _tmp4_;
	_tmp5_ = header;
	if (_tmp5_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp6_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (header);
	header = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	_tmp7_ = header;
	gtk_widget_show (_tmp7_);
	_tmp8_ = row;
	_tmp9_ = header;
	gtk_list_box_row_set_header (_tmp8_, _tmp9_);
	_g_object_unref0 (header);
}


cairo_surface_t* load_surface (const gchar* path) {
	cairo_surface_t* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		cairo_surface_t* s = NULL;
		cairo_surface_t* _tmp2_ = NULL;
		_tmp0_ = path;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		p = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch64_g_error;
		}
		_tmp2_ = gdk_cairo_surface_create_from_pixbuf (p, 1, NULL);
		s = _tmp2_;
		result = s;
		_g_object_unref0 (p);
		return result;
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Utils.vala:73: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally64:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void write_surface (cairo_surface_t* surface, const gchar* path) {
	cairo_status_t status = 0;
	cairo_surface_t* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	cairo_status_t _tmp2_ = 0;
	cairo_status_t _tmp3_ = 0;
	g_return_if_fail (surface != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = surface;
	_tmp1_ = path;
	_tmp2_ = cairo_surface_write_to_png (_tmp0_, _tmp1_);
	status = _tmp2_;
	_tmp3_ = status;
	if (_tmp3_ != CAIRO_STATUS_SUCCESS) {
		const gchar* _tmp4_ = NULL;
		cairo_status_t _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = path;
		_tmp5_ = status;
		_tmp6_ = cairo_status_to_string (_tmp5_);
		g_warning ("Utils.vala:85: Could not write surface to '%s': %s", _tmp4_, _tmp6_);
	}
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height) {
	cairo_surface_t* result = NULL;
	gint old_width = 0;
	cairo_surface_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint old_height = 0;
	cairo_surface_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	cairo_surface_t* new_surface = NULL;
	cairo_surface_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	cairo_surface_t* _tmp14_ = NULL;
	cairo_t* ct = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_surface_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_pattern_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = cairo_image_surface_get_width (_tmp0_);
	old_width = _tmp1_;
	_tmp2_ = input;
	_tmp3_ = cairo_image_surface_get_height (_tmp2_);
	old_height = _tmp3_;
	_tmp5_ = old_width;
	_tmp6_ = output_width;
	if (_tmp5_ == _tmp6_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = old_height;
		_tmp8_ = output_height;
		_tmp4_ = _tmp7_ == _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		cairo_surface_t* _tmp9_ = NULL;
		cairo_surface_t* _tmp10_ = NULL;
		_tmp9_ = input;
		_tmp10_ = _cairo_surface_reference0 (_tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = input;
	_tmp12_ = output_width;
	_tmp13_ = output_height;
	_tmp14_ = cairo_surface_create_similar_image (_tmp11_, CAIRO_FORMAT_ARGB32, _tmp12_, _tmp13_);
	new_surface = _tmp14_;
	_tmp15_ = new_surface;
	_tmp16_ = cairo_create (_tmp15_);
	ct = _tmp16_;
	_tmp17_ = ct;
	_tmp18_ = output_width;
	_tmp19_ = old_width;
	_tmp20_ = output_height;
	_tmp21_ = old_height;
	cairo_scale (_tmp17_, ((gdouble) _tmp18_) / _tmp19_, ((gdouble) _tmp20_) / _tmp21_);
	_tmp22_ = ct;
	_tmp23_ = input;
	cairo_set_source_surface (_tmp22_, _tmp23_, (gdouble) 0, (gdouble) 0);
	_tmp24_ = ct;
	_tmp25_ = cairo_get_source (_tmp24_);
	cairo_pattern_set_extend (_tmp25_, CAIRO_EXTEND_PAD);
	_tmp26_ = ct;
	cairo_set_operator (_tmp26_, CAIRO_OPERATOR_SOURCE);
	_tmp27_ = ct;
	cairo_paint (_tmp27_);
	result = new_surface;
	_cairo_destroy0 (ct);
	return result;
}


inline gdouble ease_out_cubic (gdouble t) {
	gdouble result = 0.0;
	gdouble p = 0.0;
	gdouble _tmp0_ = 0.0;
	_tmp0_ = t;
	p = _tmp0_ - 1;
	result = ((p * p) * p) + 1;
	return result;
}


gchar* rest_call_to_string (RestProxyCall* call) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	GString* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GHashTable* params = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestParams* _tmp9_ = NULL;
	GHashTable* _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	GString* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	g_return_val_if_fail (REST_IS_PROXY_CALL (call), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = call;
	_tmp3_ = rest_proxy_call_get_method (_tmp2_);
	g_string_append (_tmp1_, _tmp3_);
	_tmp4_ = builder;
	g_string_append (_tmp4_, " ");
	_tmp5_ = builder;
	_tmp6_ = call;
	_tmp7_ = rest_proxy_call_get_function (_tmp6_);
	g_string_append (_tmp5_, _tmp7_);
	_tmp8_ = call;
	_tmp9_ = rest_proxy_call_get_params (_tmp8_);
	_tmp10_ = rest_params_as_string_hash_table (_tmp9_);
	params = _tmp10_;
	_tmp11_ = params;
	_tmp12_ = g_hash_table_size (_tmp11_);
	if (_tmp12_ > ((guint) 0)) {
		GString* _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		_tmp13_ = builder;
		g_string_append (_tmp13_, "?");
		_tmp14_ = params;
		_tmp15_ = g_hash_table_get_keys (_tmp14_);
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp15_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GString* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					GString* _tmp18_ = NULL;
					GString* _tmp19_ = NULL;
					GHashTable* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gconstpointer _tmp22_ = NULL;
					GString* _tmp23_ = NULL;
					_tmp16_ = builder;
					_tmp17_ = key;
					_tmp18_ = g_string_append (_tmp16_, _tmp17_);
					_tmp19_ = g_string_append (_tmp18_, "=");
					_tmp20_ = params;
					_tmp21_ = key;
					_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
					_tmp23_ = g_string_append (_tmp19_, (const gchar*) _tmp22_);
					g_string_append (_tmp23_, "&");
				}
			}
			_g_list_free0 (key_collection);
		}
	}
	_tmp24_ = builder;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_hash_table_unref0 (params);
	_g_string_free0 (builder);
	return result;
}


/**
  * Parses a date given by Twitter in the form 'Wed Jun 20 19:01:28 +0000 2012'
  * and creates a GLib.DateTime in the local time zone to work with.
  *
  * @return The given date as GLib.DateTime in the current time zone.
  */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


GDateTime* utils_parse_date (const gchar* input) {
	GDateTime* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* month_str = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint day = 0;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint year = 0;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* timezone = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gint month = 0;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GQuark _tmp24_ = 0U;
	static GQuark _tmp23_label0 = 0;
	static GQuark _tmp23_label1 = 0;
	static GQuark _tmp23_label2 = 0;
	static GQuark _tmp23_label3 = 0;
	static GQuark _tmp23_label4 = 0;
	static GQuark _tmp23_label5 = 0;
	static GQuark _tmp23_label6 = 0;
	static GQuark _tmp23_label7 = 0;
	static GQuark _tmp23_label8 = 0;
	static GQuark _tmp23_label9 = 0;
	static GQuark _tmp23_label10 = 0;
	static GQuark _tmp23_label11 = 0;
	gint hour = 0;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint minute = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint second = 0;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	GDateTime* dt = NULL;
	const gchar* _tmp40_ = NULL;
	GTimeZone* _tmp41_ = NULL;
	GTimeZone* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	GDateTime* _tmp49_ = NULL;
	GDateTime* _tmp50_ = NULL;
	GDateTime* _tmp51_ = NULL;
	GTimeZone* _tmp52_ = NULL;
	GTimeZone* _tmp53_ = NULL;
	GDateTime* _tmp54_ = NULL;
	GDateTime* _tmp55_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		GDateTime* _tmp3_ = NULL;
		_tmp3_ = g_date_time_new_now_local ();
		result = _tmp3_;
		return result;
	}
	_tmp4_ = input;
	_tmp5_ = string_substring (_tmp4_, (glong) 4, (glong) 3);
	month_str = _tmp5_;
	_tmp6_ = input;
	_tmp7_ = string_substring (_tmp6_, (glong) 8, (glong) 2);
	_tmp8_ = _tmp7_;
	_tmp9_ = atoi (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	day = _tmp10_;
	_tmp11_ = input;
	_tmp12_ = input;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_substring (_tmp11_, (glong) (_tmp14_ - 4), (glong) -1);
	_tmp16_ = _tmp15_;
	_tmp17_ = atoi (_tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	year = _tmp18_;
	_tmp19_ = input;
	_tmp20_ = string_substring (_tmp19_, (glong) 20, (glong) 5);
	timezone = _tmp20_;
	month = -1;
	_tmp21_ = month_str;
	_tmp22_ = _tmp21_;
	_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
	if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("Jan")))) {
		switch (0) {
			default:
			{
				month = 1;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string ("Feb")))) {
		switch (0) {
			default:
			{
				month = 2;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string ("Mar")))) {
		switch (0) {
			default:
			{
				month = 3;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label3) ? _tmp23_label3 : (_tmp23_label3 = g_quark_from_static_string ("Apr")))) {
		switch (0) {
			default:
			{
				month = 4;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label4) ? _tmp23_label4 : (_tmp23_label4 = g_quark_from_static_string ("May")))) {
		switch (0) {
			default:
			{
				month = 5;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label5) ? _tmp23_label5 : (_tmp23_label5 = g_quark_from_static_string ("Jun")))) {
		switch (0) {
			default:
			{
				month = 6;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label6) ? _tmp23_label6 : (_tmp23_label6 = g_quark_from_static_string ("Jul")))) {
		switch (0) {
			default:
			{
				month = 7;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label7) ? _tmp23_label7 : (_tmp23_label7 = g_quark_from_static_string ("Aug")))) {
		switch (0) {
			default:
			{
				month = 8;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label8) ? _tmp23_label8 : (_tmp23_label8 = g_quark_from_static_string ("Sep")))) {
		switch (0) {
			default:
			{
				month = 9;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label9) ? _tmp23_label9 : (_tmp23_label9 = g_quark_from_static_string ("Oct")))) {
		switch (0) {
			default:
			{
				month = 10;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label10) ? _tmp23_label10 : (_tmp23_label10 = g_quark_from_static_string ("Nov")))) {
		switch (0) {
			default:
			{
				month = 11;
				break;
			}
		}
	} else if (_tmp24_ == ((0 != _tmp23_label11) ? _tmp23_label11 : (_tmp23_label11 = g_quark_from_static_string ("Dec")))) {
		switch (0) {
			default:
			{
				month = 12;
				break;
			}
		}
	}
	_tmp25_ = input;
	_tmp26_ = string_substring (_tmp25_, (glong) 11, (glong) 2);
	_tmp27_ = _tmp26_;
	_tmp28_ = atoi (_tmp27_);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp27_);
	hour = _tmp29_;
	_tmp30_ = input;
	_tmp31_ = string_substring (_tmp30_, (glong) 14, (glong) 2);
	_tmp32_ = _tmp31_;
	_tmp33_ = atoi (_tmp32_);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	minute = _tmp34_;
	_tmp35_ = input;
	_tmp36_ = string_substring (_tmp35_, (glong) 17, (glong) 2);
	_tmp37_ = _tmp36_;
	_tmp38_ = atoi (_tmp37_);
	_tmp39_ = _tmp38_;
	_g_free0 (_tmp37_);
	second = _tmp39_;
	_tmp40_ = timezone;
	_tmp41_ = g_time_zone_new (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = year;
	_tmp44_ = month;
	_tmp45_ = day;
	_tmp46_ = hour;
	_tmp47_ = minute;
	_tmp48_ = second;
	_tmp49_ = g_date_time_new (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, (gdouble) _tmp48_);
	_tmp50_ = _tmp49_;
	_g_time_zone_unref0 (_tmp42_);
	dt = _tmp50_;
	_tmp51_ = dt;
	_tmp52_ = g_time_zone_new_local ();
	_tmp53_ = _tmp52_;
	_tmp54_ = g_date_time_to_timezone (_tmp51_, _tmp53_);
	_tmp55_ = _tmp54_;
	_g_time_zone_unref0 (_tmp53_);
	result = _tmp55_;
	_g_date_time_unref0 (dt);
	_g_free0 (timezone);
	_g_free0 (month_str);
	return result;
}


/**
   * Calculates an easily human-readable version of the time difference between
   * time and now.
   * Example: "5m" or "3h" or "26m" or "16 Nov"
   */
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now) {
	gchar* result = NULL;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GTimeSpan _tmp2_ = 0LL;
	gint minutes = 0;
	GTimeSpan _tmp3_ = 0LL;
	gint _tmp4_ = 0;
	gint hours = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* month = NULL;
	GDateTime* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GDateTime* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GDateTime* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	g_return_val_if_fail (time != NULL, NULL);
	g_return_val_if_fail (now != NULL, NULL);
	_tmp0_ = now;
	_tmp1_ = time;
	_tmp2_ = g_date_time_difference (_tmp0_, _tmp1_);
	diff = _tmp2_;
	_tmp3_ = diff;
	minutes = (gint) (((_tmp3_ / 1000.0) / 1000.0) / 60.0);
	_tmp4_ = minutes;
	if (_tmp4_ == 0) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = _ ("Now");
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		return result;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = minutes;
		if (_tmp7_ < 60) {
			const gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gchar* _tmp10_ = NULL;
			_tmp8_ = _ ("%dm");
			_tmp9_ = minutes;
			_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
			result = _tmp10_;
			return result;
		}
	}
	_tmp11_ = minutes;
	hours = (gint) (_tmp11_ / 60.0);
	_tmp12_ = hours;
	if (_tmp12_ < 24) {
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		_tmp13_ = _ ("%dh");
		_tmp14_ = hours;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = time;
	_tmp17_ = g_date_time_format (_tmp16_, "%b");
	month = _tmp17_;
	_tmp18_ = time;
	_tmp19_ = g_date_time_get_year (_tmp18_);
	_tmp20_ = now;
	_tmp21_ = g_date_time_get_year (_tmp20_);
	if (_tmp19_ == _tmp21_) {
		GDateTime* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp22_ = time;
		_tmp23_ = g_date_time_get_day_of_month (_tmp22_);
		_tmp24_ = month;
		_tmp25_ = g_strdup_printf ("%d %s", _tmp23_, _tmp24_);
		result = _tmp25_;
		_g_free0 (month);
		return result;
	} else {
		GDateTime* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		const gchar* _tmp28_ = NULL;
		GDateTime* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gchar* _tmp31_ = NULL;
		_tmp26_ = time;
		_tmp27_ = g_date_time_get_day_of_month (_tmp26_);
		_tmp28_ = month;
		_tmp29_ = time;
		_tmp30_ = g_date_time_get_year (_tmp29_);
		_tmp31_ = g_strdup_printf ("%d %s %d", _tmp27_, _tmp28_, _tmp30_);
		result = _tmp31_;
		_g_free0 (month);
		return result;
	}
	_g_free0 (month);
}


/**
   * Extracts the actual filename out of a given path.
   * E.g. for /home/foo/bar.png, it will return "bar.png"
   *
   * @return The filename of the given path, and nothing else.
   */
static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* utils_get_file_name (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = path;
	_tmp2_ = string_last_index_of_char (_tmp1_, (gunichar) '/', 0);
	_tmp3_ = string_substring (_tmp0_, (glong) (_tmp2_ + 1), (glong) -1);
	result = _tmp3_;
	return result;
}


/**
   * Extracts the file type from the given path.
   * E.g. for http://foo.org/bar/bla.png, this will just return "png"
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* utils_get_file_type (const gchar* path) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* type = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = utils_get_file_name (_tmp0_);
	filename = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = string_index_of_char (_tmp2_, (gunichar) '.', 0);
	if (_tmp3_ == -1) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_free0 (filename);
		return result;
	}
	_tmp5_ = filename;
	_tmp6_ = filename;
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
	_tmp8_ = string_substring (_tmp5_, (glong) (_tmp7_ + 1), (glong) -1);
	type = _tmp8_;
	_tmp9_ = type;
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	_g_free0 (type);
	type = _tmp10_;
	_tmp11_ = type;
	if (g_strcmp0 (_tmp11_, "jpg") == 0) {
		gchar* _tmp12_ = NULL;
		_tmp12_ = g_strdup ("jpeg");
		result = _tmp12_;
		_g_free0 (type);
		_g_free0 (filename);
		return result;
	}
	result = type;
	_g_free0 (filename);
	return result;
}


/**
   * Shows an error dialog with the given error message
   *
   * @param message The error message to show
   */
static Block57Data* block57_data_ref (Block57Data* _data57_) {
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}


static void block57_data_unref (void * _userdata_) {
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		_g_object_unref0 (_data57_->dialog);
		g_slice_free (Block57Data, _data57_);
	}
}


static void __lambda48_ (Block57Data* _data57_, gint id) {
	gint _tmp0_ = 0;
	_tmp0_ = id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_widget_get_type (), GtkWidget));
	}
}


static void ___lambda48__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda48_ (self, response_id);
}


void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for) {
	Block57Data* _data57_;
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	g_return_if_fail (message != NULL);
	g_return_if_fail ((transient_for == NULL) || GTK_IS_WINDOW (transient_for));
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_tmp0_ = transient_for;
	_tmp1_ = message;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data57_->dialog = _tmp2_;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) ___lambda48__gtk_dialog_response, block57_data_ref (_data57_), (GClosureNotify) block57_data_unref, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_widget_get_type (), GtkWidget));
	block57_data_unref (_data57_);
	_data57_ = NULL;
}


/**
   * Shows the given json error object in an error dialog.
   * Example object data:
   * {"errors":[{"message":"Could not authenticate you","code":32}]
   *
   * @param json_data The json data to show
   * @param alternative If the given json data is not valid,
   *                    show this alternative error message.
   */
static Block58Data* block58_data_ref (Block58Data* _data58_) {
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}


static void block58_data_unref (void * _userdata_) {
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		_g_string_free0 (_data58_->sb);
		g_slice_free (Block58Data, _data58_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda49_ (Block58Data* _data58_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	GString* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GString* _tmp11_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = _data58_->sb;
	_tmp4_ = g_string_append (_tmp3_, "<li>");
	_tmp5_ = json_object_get_int_member (obj, "code");
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_string_append (_tmp4_, _tmp7_);
	_tmp9_ = g_string_append (_tmp8_, ": ");
	_tmp10_ = json_object_get_string_member (obj, "message");
	_tmp11_ = g_string_append (_tmp9_, _tmp10_);
	g_string_append (_tmp11_, "</li>");
	_g_free0 (_tmp7_);
	_json_object_unref0 (obj);
}


static void ____lambda49__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda49_ (self, array, index_, element_node);
}


void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for) {
	Block58Data* _data58_;
	gchar* error_message = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	JsonParser* _tmp13_ = NULL;
	JsonNode* _tmp14_ = NULL;
	JsonNodeType _tmp15_ = 0;
	JsonObject* root = NULL;
	JsonParser* _tmp18_ = NULL;
	JsonNode* _tmp19_ = NULL;
	JsonObject* _tmp20_ = NULL;
	JsonObject* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	JsonObject* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	JsonObject* _tmp33_ = NULL;
	JsonNode* _tmp34_ = NULL;
	JsonNodeType _tmp35_ = 0;
	JsonArray* errors = NULL;
	JsonObject* _tmp41_ = NULL;
	JsonArray* _tmp42_ = NULL;
	JsonArray* _tmp43_ = NULL;
	JsonArray* _tmp44_ = NULL;
	guint _tmp45_ = 0U;
	GString* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	const gchar* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkWindow* _tmp75_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (alternative != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail ((transient_for == NULL) || GTK_IS_WINDOW (transient_for));
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_tmp0_ = alternative;
	_tmp1_ = file;
	_tmp2_ = line;
	_tmp3_ = g_strdup_printf ("Exception: %s in %s:%d", _tmp0_, _tmp1_, _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = json_data;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		GtkWindow* _tmp6_ = NULL;
		_tmp5_ = error_message;
		_tmp6_ = transient_for;
		utils_show_error_dialog (_tmp5_, _tmp6_);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	_tmp8_ = g_string_new ("");
	_data58_->sb = _tmp8_;
	{
		JsonParser* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = parser;
		_tmp10_ = json_data;
		json_parser_load_from_data (_tmp9_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch65_g_error;
		}
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
		GtkWindow* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = error_message;
		_tmp12_ = transient_for;
		utils_show_error_dialog (_tmp11_, _tmp12_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	__finally65:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = parser;
	_tmp14_ = json_parser_get_root (_tmp13_);
	_tmp15_ = json_node_get_node_type (_tmp14_);
	if (_tmp15_ != JSON_NODE_OBJECT) {
		const gchar* _tmp16_ = NULL;
		GtkWindow* _tmp17_ = NULL;
		_tmp16_ = error_message;
		_tmp17_ = transient_for;
		utils_show_error_dialog (_tmp16_, _tmp17_);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp23_ = root;
	_tmp24_ = json_object_has_member (_tmp23_, "error");
	if (_tmp24_) {
		JsonObject* _tmp25_ = NULL;
		JsonNode* _tmp26_ = NULL;
		JsonNodeType _tmp27_ = 0;
		_tmp25_ = root;
		_tmp26_ = json_object_get_member (_tmp25_, "error");
		_tmp27_ = json_node_get_node_type (_tmp26_);
		_tmp22_ = _tmp27_ == JSON_NODE_VALUE;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp28_ = NULL;
		JsonObject* _tmp29_ = NULL;
		JsonNode* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		GtkWindow* _tmp32_ = NULL;
		_tmp28_ = json_data;
		g_message ("Utils.vala:293: %s", _tmp28_);
		_tmp29_ = root;
		_tmp30_ = json_object_get_member (_tmp29_, "error");
		_tmp31_ = json_node_get_string (_tmp30_);
		_tmp32_ = transient_for;
		utils_show_error_dialog (_tmp31_, _tmp32_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp33_ = root;
	_tmp34_ = json_object_get_member (_tmp33_, "errors");
	_tmp35_ = json_node_get_node_type (_tmp34_);
	if (_tmp35_ == JSON_NODE_VALUE) {
		const gchar* _tmp36_ = NULL;
		JsonObject* _tmp37_ = NULL;
		JsonNode* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		GtkWindow* _tmp40_ = NULL;
		_tmp36_ = json_data;
		g_message ("Utils.vala:299: %s", _tmp36_);
		_tmp37_ = root;
		_tmp38_ = json_object_get_member (_tmp37_, "errors");
		_tmp39_ = json_node_get_string (_tmp38_);
		_tmp40_ = transient_for;
		utils_show_error_dialog (_tmp39_, _tmp40_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp41_ = root;
	_tmp42_ = json_object_get_array_member (_tmp41_, "errors");
	_tmp43_ = _json_array_ref0 (_tmp42_);
	errors = _tmp43_;
	_tmp44_ = errors;
	_tmp45_ = json_array_get_length (_tmp44_);
	if (_tmp45_ == ((guint) 1)) {
		JsonObject* err = NULL;
		JsonArray* _tmp46_ = NULL;
		JsonObject* _tmp47_ = NULL;
		JsonObject* _tmp48_ = NULL;
		GString* _tmp49_ = NULL;
		JsonObject* _tmp50_ = NULL;
		gint64 _tmp51_ = 0LL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		GString* _tmp54_ = NULL;
		GString* _tmp55_ = NULL;
		JsonObject* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		GString* _tmp58_ = NULL;
		GString* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		GString* _tmp61_ = NULL;
		GString* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		GString* _tmp66_ = NULL;
		_tmp46_ = errors;
		_tmp47_ = json_array_get_object_element (_tmp46_, (guint) 0);
		_tmp48_ = _json_object_ref0 (_tmp47_);
		err = _tmp48_;
		_tmp49_ = _data58_->sb;
		_tmp50_ = err;
		_tmp51_ = json_object_get_int_member (_tmp50_, "code");
		_tmp52_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_string_append (_tmp49_, _tmp53_);
		_tmp55_ = g_string_append (_tmp54_, ": ");
		_tmp56_ = err;
		_tmp57_ = json_object_get_string_member (_tmp56_, "message");
		_tmp58_ = g_string_append (_tmp55_, _tmp57_);
		_tmp59_ = g_string_append (_tmp58_, "(");
		_tmp60_ = file;
		_tmp61_ = g_string_append (_tmp59_, _tmp60_);
		_tmp62_ = g_string_append (_tmp61_, ":");
		_tmp63_ = line;
		_tmp64_ = g_strdup_printf ("%i", _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_string_append (_tmp62_, _tmp65_);
		g_string_append (_tmp66_, ")");
		_g_free0 (_tmp65_);
		_g_free0 (_tmp53_);
		_json_object_unref0 (err);
	} else {
		GString* _tmp67_ = NULL;
		JsonArray* _tmp68_ = NULL;
		GString* _tmp69_ = NULL;
		_tmp67_ = _data58_->sb;
		g_string_append (_tmp67_, "<ul>");
		_tmp68_ = errors;
		json_array_foreach_element (_tmp68_, ____lambda49__json_array_foreach, _data58_);
		_tmp69_ = _data58_->sb;
		g_string_append (_tmp69_, "</ul>");
	}
	_tmp70_ = _data58_->sb;
	_tmp71_ = _tmp70_->str;
	_tmp72_ = g_strdup (_tmp71_);
	_g_free0 (error_message);
	error_message = _tmp72_;
	_tmp73_ = json_data;
	g_critical ("Utils.vala:322: %s", _tmp73_);
	_tmp74_ = error_message;
	_tmp75_ = transient_for;
	utils_show_error_dialog (_tmp74_, _tmp75_);
	_json_array_unref0 (errors);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	_g_free0 (error_message);
	block58_data_unref (_data58_);
	_data58_ = NULL;
}


static void utils_download_pixbuf_data_free (gpointer _data) {
	UtilsDownloadPixbufData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->result);
	g_slice_free (UtilsDownloadPixbufData, _data_);
}


void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UtilsDownloadPixbufData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	_data_ = g_slice_new0 (UtilsDownloadPixbufData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, utils_download_pixbuf);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, utils_download_pixbuf_data_free);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	utils_download_pixbuf_co (_data_);
}


GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_) {
	GdkPixbuf* result;
	UtilsDownloadPixbufData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block59Data* block59_data_ref (Block59Data* _data59_) {
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}


static void block59_data_unref (void * _userdata_) {
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		(_data59_->cb_target_destroy_notify == NULL) ? NULL : (_data59_->cb_target_destroy_notify (_data59_->cb_target), NULL);
		_data59_->cb = NULL;
		_data59_->cb_target = NULL;
		_data59_->cb_target_destroy_notify = NULL;
		_g_object_unref0 (_data59_->_result_);
		_g_object_unref0 (_data59_->cancellable);
		g_slice_free (Block59Data, _data59_);
	}
}


static gboolean _utils_download_pixbuf_co_gsource_func (gpointer self) {
	gboolean result;
	result = utils_download_pixbuf_co (self);
	return result;
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void __lambda137_ (Block59Data* _data59_, SoupSession* _s, SoupMessage* _msg) {
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data59_->cancellable;
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (_tmp1_) {
		_data59_->cb (_data59_->cb_target);
		return;
	}
	{
		GMemoryInputStream* in_stream = NULL;
		SoupMessage* _tmp2_ = NULL;
		SoupMessageBody* _tmp3_ = NULL;
		guint8* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		GDestroyNotify _tmp6_ = NULL;
		GMemoryInputStream* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		GMemoryInputStream* _tmp9_ = NULL;
		GCancellable* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		_tmp2_ = _msg;
		_tmp3_ = _tmp2_->response_body;
		_tmp4_ = _tmp3_->data;
		_tmp4__length1 = (gint) _tmp3_->length;
		_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup7 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = g_free;
		_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
		in_stream = _tmp7_;
		_tmp9_ = in_stream;
		_tmp10_ = _data59_->cancellable;
		_tmp11_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_input_stream_get_type (), GInputStream), _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (in_stream);
			goto __catch66_g_error;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (_data59_->_result_);
		_data59_->_result_ = _tmp12_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (in_stream);
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Utils.vala:343: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally66:
	{
		_data59_->cb (_data59_->cb_target);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda137__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda137_ (self, session, msg);
	block59_data_unref (self);
}


static gboolean utils_download_pixbuf_co (UtilsDownloadPixbufData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data59_ = g_slice_new0 (Block59Data);
	_data_->_data59_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data59_->cancellable);
	_data_->_data59_->cancellable = _data_->_tmp0_;
	_data_->_data59_->_async_data_ = _data_;
	_data_->_data59_->_result_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->url;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->msg = _data_->_tmp2_;
	_data_->_data59_->cb = _utils_download_pixbuf_co_gsource_func;
	_data_->_data59_->cb_target = _data_;
	_data_->_data59_->cb_target_destroy_notify = NULL;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->msg);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp4_, ___lambda137__soup_session_callback, block59_data_ref (_data_->_data59_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_data59_->_result_);
	_data_->result = _data_->_tmp5_;
	_g_object_unref0 (_data_->msg);
	block59_data_unref (_data_->_data59_);
	_data_->_data59_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->msg);
	block59_data_unref (_data_->_data59_);
	_data_->_data59_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch67_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch67_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally67;
	__catch67_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally67:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* utils_unescape_html (const gchar* input) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = string_replace (_tmp0_, "&lt;", "<");
	back = _tmp1_;
	_tmp2_ = back;
	_tmp3_ = string_replace (_tmp2_, "&gt;", ">");
	_g_free0 (back);
	back = _tmp3_;
	_tmp4_ = back;
	_tmp5_ = string_replace (_tmp4_, "&amp;", "&");
	_g_free0 (back);
	back = _tmp5_;
	result = back;
	return result;
}


void utils_load_custom_icons (void) {
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_ = NULL;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	gtk_icon_theme_add_resource_path (icon_theme, "/org/baedert/corebird/data/");
	_g_object_unref0 (icon_theme);
}


void utils_load_custom_css (void) {
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	gtk_css_provider_load_from_resource (provider, "/org/baedert/corebird/ui/style.css");
	_tmp1_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gdk_screen_get_type (), GdkScreen), G_TYPE_CHECK_INSTANCE_CAST (provider, GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}


void utils_init_soup_session (void) {
	SoupSession* _tmp0_ = NULL;
	SoupSession* _tmp1_ = NULL;
	_tmp0_ = SOUP_SESSION;
	_vala_assert (_tmp0_ == NULL, "SOUP_SESSION == null");
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (SOUP_SESSION);
	SOUP_SESSION = _tmp1_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* utils_capitalize (const gchar* s) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gunichar _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = g_strdup (_tmp0_);
	back = _tmp1_;
	_tmp2_ = s;
	_tmp3_ = string_get_char (_tmp2_, (glong) 0);
	_tmp4_ = g_unichar_islower (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gunichar _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp5_ = s;
		_tmp6_ = string_get_char (_tmp5_, (glong) 0);
		_tmp7_ = g_unichar_toupper (_tmp6_);
		_tmp8_ = g_unichar_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = s;
		_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) -1);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
		_g_free0 (back);
		back = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
	}
	result = back;
	return result;
}


gint utils_get_json_array_size (JsonObject* node, const gchar* object_name) {
	gint result = 0;
	JsonObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	g_return_val_if_fail (node != NULL, 0);
	g_return_val_if_fail (object_name != NULL, 0);
	_tmp0_ = node;
	_tmp1_ = object_name;
	_tmp2_ = json_object_has_member (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = object_name;
	_tmp5_ = json_object_get_array_member (_tmp3_, _tmp4_);
	_tmp6_ = json_array_get_length (_tmp5_);
	result = (gint) _tmp6_;
	return result;
}


/**
   * Checks if @value is existing in @node and if it is, non-null.
   *
   * Returns TRUE if the @value does both exist and is non-null.
   */
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name) {
	gboolean result = FALSE;
	JsonObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (value_name != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = value_name;
	_tmp2_ = json_object_has_member (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = value_name;
	_tmp5_ = json_object_get_null_member (_tmp3_, _tmp4_);
	result = !_tmp5_;
	return result;
}


void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name) {
	gchar** startup_accounts = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gchar** new_startup_accounts = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint new_startup_accounts_length1 = 0;
	gint _new_startup_accounts_size_ = 0;
	GSettings* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	g_return_if_fail (old_screen_name != NULL);
	g_return_if_fail (new_screen_name != NULL);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "startup-accounts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_object_unref0 (_tmp1_);
	startup_accounts = _tmp4_;
	startup_accounts_length1 = _tmp4__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp5_ = startup_accounts;
	_tmp5__length1 = startup_accounts_length1;
	_tmp6_ = g_new0 (gchar*, _tmp5__length1 + 1);
	new_startup_accounts = _tmp6_;
	new_startup_accounts_length1 = _tmp5__length1;
	_new_startup_accounts_size_ = new_startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = startup_accounts;
				_tmp10__length1 = startup_accounts_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = startup_accounts;
				_tmp11__length1 = startup_accounts_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = old_screen_name;
				if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gint _tmp16_ = 0;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp15_ = new_startup_accounts;
					_tmp15__length1 = new_startup_accounts_length1;
					_tmp16_ = i;
					_tmp17_ = startup_accounts;
					_tmp17__length1 = startup_accounts_length1;
					_tmp18_ = i;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp15_[_tmp16_]);
					_tmp15_[_tmp16_] = _tmp20_;
					_tmp21_ = _tmp15_[_tmp16_];
				} else {
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp22_ = new_startup_accounts;
					_tmp22__length1 = new_startup_accounts_length1;
					_tmp23_ = i;
					_tmp24_ = new_screen_name;
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = _tmp25_;
					_tmp26_ = _tmp22_[_tmp23_];
				}
			}
		}
	}
	_tmp27_ = settings_get ();
	_tmp28_ = _tmp27_;
	_tmp29_ = new_startup_accounts;
	_tmp29__length1 = new_startup_accounts_length1;
	g_settings_set_strv (_tmp28_, "startup-accounts", _tmp29_);
	_g_object_unref0 (_tmp28_);
	new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


CbFilter* utils_create_persistent_filter (const gchar* content, Account* account) {
	CbFilter* result = NULL;
	gint id = 0;
	Account* _tmp0_ = NULL;
	SqlDatabase* _tmp1_ = NULL;
	SqlInsertStatement* _tmp2_ = NULL;
	SqlInsertStatement* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	SqlInsertStatement* _tmp5_ = NULL;
	SqlInsertStatement* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	CbFilter* f = NULL;
	const gchar* _tmp9_ = NULL;
	CbFilter* _tmp10_ = NULL;
	Account* _tmp11_ = NULL;
	CbFilter* _tmp12_ = NULL;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = account;
	_tmp1_ = _tmp0_->db;
	_tmp2_ = sql_database_insert (_tmp1_, "filters");
	_tmp3_ = _tmp2_;
	_tmp4_ = content;
	_tmp5_ = sql_insert_statement_val (_tmp3_, "content", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sql_insert_statement_run (_tmp6_);
	_tmp8_ = (gint) _tmp7_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	id = _tmp8_;
	_tmp9_ = content;
	_tmp10_ = cb_filter_new (_tmp9_);
	f = _tmp10_;
	cb_filter_set_id (f, id);
	_tmp11_ = account;
	_tmp12_ = _g_object_ref0 (f);
	account_add_filter (_tmp11_, _tmp12_);
	result = f;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



