#ifndef CDO_ZAXIS_H
#define CDO_ZAXIS_H

#include <string>

int cdo_define_zaxis(const std::string &zaxisfile);
void define_zaxis(const char *zaxisarg);
int zaxis_from_name(const char *zaxisname);
int zaxis_from_file(FILE *zfp, const char *filename);
int zaxis_to_ltype(int zaxisID);
double cdo_zaxis_inq_level(int zaxisID, int levelID);
int cdo_zaxis_inq_levels(int zaxisID, double *levels);

void gen_layer_bounds(int nlev, double *levels, double *lbounds, double *ubounds);
int get_layer_thickness(bool useweights, bool genbounds, int index, int zaxisID, int nlev, double *thickness, double *weights);

#endif
