/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.siunitx;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.siunitx.SIPrefixCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIUnitCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIunitxSty;
import java.io.IOException;

public class SiPerPower
extends ControlSequence {
    protected SIunitxSty sty;
    private int power;

    public SiPerPower(SIunitxSty sIunitxSty, String string, int n) {
        super(string);
        this.sty = sIunitxSty;
        this.power = n;
    }

    @Override
    public Object clone() {
        return new SiPerPower(this.sty, this.getName(), this.power);
    }

    public int getPower() {
        return this.power;
    }

    protected void process(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        TeXObject teXObject3 = teXObjectList.peekStack();
        if (teXObject3 instanceof SIUnitCs) {
            teXObjectList.push(this.sty.createUnitSep(teXParser));
        }
        Group group = teXParser.getListener().createGroup();
        teXObjectList.push(group);
        if (teXParser.isMathMode()) {
            group.add(new UserNumber(-this.power));
            teXObjectList.push(teXParser.getListener().createSpChar());
        } else {
            group.add(new TeXCsRef("textminus"));
            group.add(new UserNumber(this.power));
            teXObjectList.push(new TeXCsRef("textsuperscript"));
        }
        teXObjectList.push(teXObject2);
        if (teXObject != null) {
            teXObjectList.push(teXObject);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXObject teXObject2 = null;
        if (teXObject instanceof SIPrefixCs) {
            teXObject2 = teXObject;
            teXObject = teXParser.popNextArg();
        }
        this.process(teXParser, teXParser, teXObject2, teXObject);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXObject teXObject2 = null;
        if (teXObject instanceof SIPrefixCs) {
            teXObject2 = teXObject;
            teXObject = teXObjectList.popArg(teXParser);
        }
        this.process(teXParser, teXObjectList, teXObject2, teXObject);
    }
}

