/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2014 osnola
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#include "DocumentElement.hxx"
#include "FilterInternal.hxx"
#include <string.h>

namespace librvngabw
{
void TagElement::print() const
{
	RVNGABW_DEBUG_MSG(("%s\n", m_tagName.cstr()));
}

void TagOpenElement::write(ABWDocumentHandler *pHandler) const
{
	pHandler->startElement(getTagName().cstr(), m_attributeList);
}

void TagOpenElement::print() const
{
	TagElement::print();
}

void TagOpenElement::addAttribute(const librevenge::RVNGString &szAttributeName, int value)
{
	m_attributeList.insert(szAttributeName.cstr(), librevenge::RVNGPropertyFactory::newIntProp(value));
}

void TagOpenElement::addAttribute(const librevenge::RVNGString &szAttributeName,
                                  const librevenge::RVNGString &sAttributeValue, bool forceString)
{
	if (forceString)
		m_attributeList.insert(szAttributeName.cstr(), librevenge::RVNGPropertyFactory::newStringProp(sAttributeValue));
	else
		m_attributeList.insert(szAttributeName.cstr(), sAttributeValue);
}

void TagCloseElement::write(ABWDocumentHandler *pHandler) const
{
	pHandler->endElement(getTagName().cstr());
}

void CharDataElement::write(ABWDocumentHandler *pHandler) const
{
	pHandler->characters(m_data);
}

void TextElement::write(ABWDocumentHandler *pHandler) const
{
	if (m_textBuffer.empty())
		return;
	pHandler->characters(m_textBuffer);
}

void spliceOrigDest(DocumentElementVector &orig, DocumentElementVector &dest)
{
	dest.insert(dest.end(), orig.begin(), orig.end());
	orig.clear();
}
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
