.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XCrossingEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XCrossingEvent \- EnterNotify and LeaveNotify event structure
.SH STRUCTURES
The structure for
.B EnterNotify
and
.B LeaveNotify
events contains:
.LP
.EX
typedef struct {
        int type;       /\&* EnterNotify or LeaveNotify */
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window window;  /\&* \*(lqevent\*(rq window reported relative to */
        Window root;    /\&* root window that the event occurred on */
        Window subwindow;       /\&* child window */
        Time time;      /\&* milliseconds */
        int x, y;       /\&* pointer x, y coordinates in event window */
        int x_root, y_root;     /\&* coordinates relative to root */
        int mode;       /\&* NotifyNormal, NotifyGrab, NotifyUngrab */
        int detail;
                /\&*
                * NotifyAncestor, NotifyVirtual, NotifyInferior,
                * NotifyNonlinear,NotifyNonlinearVirtual
                */
        Bool same_screen;       /\&* same screen flag */
        Bool focus;     /\&* boolean focus */
        unsigned int state;     /\&* key or button mask */
} XCrossingEvent;
typedef XCrossingEvent XEnterWindowEvent;
typedef XCrossingEvent XLeaveWindowEvent;
.EE
.LP
When you receive these events,
the structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.B GraphicsExpose
event to a client application, it sends an
.B XGraphicsExposeEvent
structure with the type member set to
.BR GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.B True
if the event came from a
.B SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The window member is set to the window on which the
.B EnterNotify
or
.B LeaveNotify
event was generated and is referred to as the event window.
This is the window used by the X server to report the event,
and is relative to the root
window on which the event occurred.
The root member is set to the root window of the screen
on which the event occurred.
.LP
For a
.B LeaveNotify
event,
if a child of the event window contains the initial position of the pointer,
the subwindow component is set to that child.
Otherwise, the X server sets the subwindow member to
.BR None .
For an
.B EnterNotify
event, if a child of the event window contains the final pointer position,
the subwindow component is set to that child or
.BR None .
.LP
The time member is set to the time when the event was generated
and is expressed in milliseconds.
The x and y members are set to the coordinates of the pointer position in
the event window.
This position is always the pointer's final position,
not its initial position.
If the event window is on the same
screen as the root window, x and y are the pointer coordinates
relative to the event window's origin.
Otherwise, x and y are set to zero.
The x_root and y_root members are set to the pointer's coordinates relative to the
root window's origin at the time of the event.
.LP
The same_screen member is set to indicate whether the event window is on the same screen
as the root window and can be either
.B True
or
.BR False .
If
.BR True ,
the event and root windows are on the same screen.
If
.BR False ,
the event and root windows are not on the same screen.
.LP
The focus member is set to indicate whether the event window is the focus window or an
inferior of the focus window.
The X server can set this member to either
.B True
or
.BR False .
If
.BR True ,
the event window is the focus window or an inferior of the focus window.
If
.BR False ,
the event window is not the focus window or an inferior of the focus window.
.LP
The state member is set to indicate the state of the pointer buttons and
modifier keys just prior to the
event.
The X server can set this member to the bitwise inclusive OR of one
or more of the button or modifier key masks:
.BR Button1Mask ,
.BR Button2Mask ,
.BR Button3Mask ,
.BR Button4Mask ,
.BR Button5Mask ,
.BR ShiftMask ,
.BR LockMask ,
.BR ControlMask ,
.BR Mod1Mask ,
.BR Mod2Mask ,
.BR Mod3Mask ,
.BR Mod4Mask ,
.BR Mod5Mask .
.LP
The mode member is set to indicate whether the events are normal events,
pseudo-motion events
when a grab activates, or pseudo-motion events when a grab deactivates.
The X server can set this member to
.BR NotifyNormal ,
.BR NotifyGrab ,
or
.BR NotifyUngrab .
.LP
The detail member is set to indicate the notify detail and can be
.BR NotifyAncestor ,
.BR NotifyVirtual ,
.BR NotifyInferior ,
.BR NotifyNonlinear ,
or
.BR NotifyNonlinearVirtual .
.SH "SEE ALSO"
.BR XAnyEvent (__libmansuffix__),
.BR XButtonEvent (__libmansuffix__),
.BR XCreateWindowEvent (__libmansuffix__),
.BR XCirculateEvent (__libmansuffix__),
.BR XCirculateRequestEvent (__libmansuffix__),
.BR XColormapEvent (__libmansuffix__),
.BR XConfigureEvent (__libmansuffix__),
.BR XConfigureRequestEvent (__libmansuffix__),
.BR XDestroyWindowEvent (__libmansuffix__),
.BR XErrorEvent (__libmansuffix__),
.BR XExposeEvent (__libmansuffix__),
.BR XFocusChangeEvent (__libmansuffix__),
.BR XGraphicsExposeEvent (__libmansuffix__),
.BR XGravityEvent (__libmansuffix__),
.BR XKeymapEvent (__libmansuffix__),
.BR XMapEvent (__libmansuffix__),
.BR XMapRequestEvent (__libmansuffix__),
.BR XPropertyEvent (__libmansuffix__),
.BR XReparentEvent (__libmansuffix__),
.BR XResizeRequestEvent (__libmansuffix__),
.BR XSelectionClearEvent (__libmansuffix__),
.BR XSelectionEvent (__libmansuffix__),
.BR XSelectionRequestEvent (__libmansuffix__),
.BR XUnmapEvent (__libmansuffix__),
.BR XVisibilityEvent (__libmansuffix__)
.br
\fI\*(xL\fP
