#ifndef SURFACEFORMAT_H
#define SURFACEFORMAT_H

#include <stdint.h>

#define SURFACEFORMAT_R32G32B32A32_FLOAT	0x000
#define SURFACEFORMAT_R32G32B32A32_SINT	0x001
#define SURFACEFORMAT_R32G32B32A32_UINT	0x002
#define SURFACEFORMAT_R32G32B32A32_UNORM	0x003
#define SURFACEFORMAT_R32G32B32A32_SNORM	0x004
#define SURFACEFORMAT_R64G64_FLOAT		0x005
#define SURFACEFORMAT_R32G32B32X32_FLOAT	0x006
#define SURFACEFORMAT_R32G32B32A32_SSCALED	0x007
#define SURFACEFORMAT_R32G32B32A32_USCALED	0x008


#define SURFACEFORMAT_R32G32B32_FLOAT	0x040
#define SURFACEFORMAT_R32G32B32_SINT	0x041
#define SURFACEFORMAT_R32G32B32_UINT	0x042
#define SURFACEFORMAT_R32G32B32_UNORM	0x043
#define SURFACEFORMAT_R32G32B32_SNORM	0x044
#define SURFACEFORMAT_R32G32B32_SSCALED	0x045
#define SURFACEFORMAT_R32G32B32_USCALED	0x046

#define SURFACEFORMAT_R16G16B16A16_UNORM		0x080
#define SURFACEFORMAT_R16G16B16A16_SNORM		0x081
#define SURFACEFORMAT_R16G16B16A16_SINT		0x082
#define SURFACEFORMAT_R16G16B16A16_UINT		0x083
#define SURFACEFORMAT_R16G16B16A16_FLOAT		0x084
#define SURFACEFORMAT_R32G32_FLOAT			0x085
#define SURFACEFORMAT_R32G32_SINT			0x086
#define SURFACEFORMAT_R32G32_UINT			0x087
#define SURFACEFORMAT_R32_FLOAT_X8X24_TYPELESS	0x088
#define SURFACEFORMAT_X32_TYPELESS_G8X24_UINT	0x089
#define SURFACEFORMAT_L32A32_FLOAT			0x08A
#define SURFACEFORMAT_R32G32_UNORM			0x08B
#define SURFACEFORMAT_R32G32_SNORM			0x08C
#define SURFACEFORMAT_R64_FLOAT			0x08D
#define SURFACEFORMAT_R16G16B16X16_UNORM		0x08E
#define SURFACEFORMAT_R16G16B16X16_FLOAT		0x08F

#define SURFACEFORMAT_A32X32_FLOAT		0x090
#define SURFACEFORMAT_L32X32_FLOAT		0x091
#define SURFACEFORMAT_I32X32_FLOAT		0x092
#define SURFACEFORMAT_R16G16B16A16_SSCALED	0x093
#define SURFACEFORMAT_R16G16B16A16_USCALED	0x094
#define SURFACEFORMAT_R32G32_SSCALED	0x095
#define SURFACEFORMAT_R32G32_USCALED	0x096

#define SURFACEFORMAT_B8G8R8A8_UNORM		0x0C0
#define SURFACEFORMAT_B8G8R8A8_UNORM_SRGB		0x0C1
#define SURFACEFORMAT_R10G10B10A2_UNORM		0x0C2
#define SURFACEFORMAT_R10G10B10A2_UNORM_SRGB	0x0C3
#define SURFACEFORMAT_R10G10B10A2_UINT		0x0C4
#define SURFACEFORMAT_R10G10B10_SNORM_A2_UNORM	0x0C5
#define SURFACEFORMAT_R8G8B8A8_UNORM		0x0C7
#define SURFACEFORMAT_R8G8B8A8_UNORM_SRGB		0x0C8
#define SURFACEFORMAT_R8G8B8A8_SNORM		0x0C9
#define SURFACEFORMAT_R8G8B8A8_SINT			0x0CA
#define SURFACEFORMAT_R8G8B8A8_UINT			0x0CB
#define SURFACEFORMAT_R16G16_UNORM			0x0CC
#define SURFACEFORMAT_R16G16_SNORM			0x0CD
#define SURFACEFORMAT_R16G16_SINT			0x0CE
#define SURFACEFORMAT_R16G16_UINT			0x0CF

#define SURFACEFORMAT_R16G16_FLOAT			0x0D0
#define SURFACEFORMAT_B10G10R10A2_UNORM		0x0D1
#define SURFACEFORMAT_B10G10R10A2_UNORM_SRGB	0x0D2
#define SURFACEFORMAT_R11G11B10_FLOAT		0x0D3
#define SURFACEFORMAT_R32_SINT			0x0D6
#define SURFACEFORMAT_R32_UINT			0x0D7
#define SURFACEFORMAT_R32_FLOAT			0x0D8
#define SURFACEFORMAT_R24_UNORM_X8_TYPELESS		0x0D9
#define SURFACEFORMAT_X24_TYPELESS_G8_UINT		0x0DA
#define SURFACEFORMAT_L16A16_UNORM			0x0DF

#define SURFACEFORMAT_I24X8_UNORM		0x0E0
#define SURFACEFORMAT_L24X8_UNORM		0x0E1
#define SURFACEFORMAT_A24X8_UNORM		0x0E2
#define SURFACEFORMAT_I32_FLOAT		0x0E3
#define SURFACEFORMAT_L32_FLOAT		0x0E4
#define SURFACEFORMAT_A32_FLOAT		0x0E5
#define SURFACEFORMAT_B8G8R8X8_UNORM	0x0E9
#define SURFACEFORMAT_B8G8R8X8_UNORM_SRGB	0x0EA
#define SURFACEFORMAT_R8G8B8X8_UNORM	0x0EB
#define SURFACEFORMAT_R8G8B8X8_UNORM_SRGB	0x0EC
#define SURFACEFORMAT_R9G9B9E5_SHAREDEXP	0x0ED
#define SURFACEFORMAT_B10G10R10X2_UNORM	0x0EE

#define SURFACEFORMAT_L16A16_FLOAT		0x0F0
#define SURFACEFORMAT_R32_UNORM		0x0F1
#define SURFACEFORMAT_R32_SNORM		0x0F2
#define SURFACEFORMAT_R10G10B10X2_USCALED	0x0F3
#define SURFACEFORMAT_R8G8B8A8_SSCALED	0x0F4
#define SURFACEFORMAT_R8G8B8A8_USCALED	0x0F5
#define SURFACEFORMAT_R16G16_SSCALED	0x0F6
#define SURFACEFORMAT_R16G16_USCALED	0x0F7
#define SURFACEFORMAT_R32_SSCALED		0x0F8
#define SURFACEFORMAT_R32_USCALED		0x0F9

#define SURFACEFORMAT_B5G6R5_UNORM		0x100
#define SURFACEFORMAT_B5G6R5_UNORM_SRGB	0x101
#define SURFACEFORMAT_B5G5R5A1_UNORM	0x102
#define SURFACEFORMAT_B5G5R5A1_UNORM_SRGB	0x103
#define SURFACEFORMAT_B4G4R4A4_UNORM	0x104
#define SURFACEFORMAT_B4G4R4A4_UNORM_SRGB	0x105
#define SURFACEFORMAT_R8G8_UNORM		0x106
#define SURFACEFORMAT_R8G8_SNORM		0x107
#define SURFACEFORMAT_R8G8_SINT		0x108
#define SURFACEFORMAT_R8G8_UINT		0x109
#define SURFACEFORMAT_R16_FLOAT		0x10E
#define SURFACEFORMAT_R16_SINT		0x10C
#define SURFACEFORMAT_R16_SNORM		0x10B
#define SURFACEFORMAT_R16_UINT		0x10D
#define SURFACEFORMAT_R16_UNORM		0x10A

#define SURFACEFORMAT_I16_UNORM		0x111
#define SURFACEFORMAT_L16_UNORM		0x112
#define SURFACEFORMAT_A16_UNORM		0x113
#define SURFACEFORMAT_L8A8_UNORM		0x114
#define SURFACEFORMAT_I16_FLOAT		0x115
#define SURFACEFORMAT_L16_FLOAT		0x116
#define SURFACEFORMAT_A16_FLOAT		0x117
#define SURFACEFORMAT_R5G5_SNORM_B6_UNORM	0x119
#define SURFACEFORMAT_B5G5R5X1_UNORM	0x11A
#define SURFACEFORMAT_B5G5R5X1_UNORM_SRGB	0x11B
#define SURFACEFORMAT_R8G8_SSCALED		0x11C
#define SURFACEFORMAT_R8G8_USCALED		0x11D
#define SURFACEFORMAT_R16_SSCALED		0x11E
#define SURFACEFORMAT_R16_USCALED		0x11F

#define SURFACEFORMAT_R8_UNORM		0x140
#define SURFACEFORMAT_R8_SNORM		0x141
#define SURFACEFORMAT_R8_SINT		0x142
#define SURFACEFORMAT_R8_UINT		0x143
#define SURFACEFORMAT_A8_UNORM		0x144
#define SURFACEFORMAT_I8_UNORM		0x145
#define SURFACEFORMAT_L8_UNORM		0x146
#define SURFACEFORMAT_P4A4_UNORM		0x147
#define SURFACEFORMAT_A4P4_UNORM		0x148
#define SURFACEFORMAT_R8_SSCALED		0x149
#define SURFACEFORMAT_R8_USCALED		0x14A

#define SURFACEFORMAT_R1_UINT		0x181
#define SURFACEFORMAT_YCRCB_NORMAL		0x182
#define SURFACEFORMAT_YCRCB_SWAPUVY		0x183
#define SURFACEFORMAT_BC1_UNORM		0x186
#define SURFACEFORMAT_BC2_UNORM		0x187
#define SURFACEFORMAT_BC3_UNORM		0x188
#define SURFACEFORMAT_BC4_UNORM		0x189
#define SURFACEFORMAT_BC5_UNORM		0x18A
#define SURFACEFORMAT_BC1_UNORM_SRGB	0x18B
#define SURFACEFORMAT_BC2_UNORM_SRGB	0x18C
#define SURFACEFORMAT_BC3_UNORM_SRGB	0x18D
#define SURFACEFORMAT_MONO8			0x18E
#define SURFACEFORMAT_YCRCB_SWAPUV		0x18F

#define SURFACEFORMAT_YCRCB_SWAPY		0x190
#define SURFACEFORMAT_DXT1_RGB		0x191
#define SURFACEFORMAT_FXT1			0x192
#define SURFACEFORMAT_R8G8B8_UNORM		0x193
#define SURFACEFORMAT_R8G8B8_SNORM		0x194
#define SURFACEFORMAT_R8G8B8_SSCALED	0x195
#define SURFACEFORMAT_R8G8B8_USCALED	0x196
#define SURFACEFORMAT_R64G64B64A64_FLOAT	0x197
#define SURFACEFORMAT_R64G64B64_FLOAT	0x198
#define SURFACEFORMAT_BC4_SNORM		0x199
#define SURFACEFORMAT_BC5_SNORM		0x19A
#define SURFACEFORMAT_R16G16B16_UNORM	0x19C
#define SURFACEFORMAT_R16G16B16_SNORM	0x19D
#define SURFACEFORMAT_R16G16B16_SSCALED	0x19E
#define SURFACEFORMAT_R16G16B16_USCALED	0x19F

#define SURFACEFORMAT_RAW	0x1FF

#define SURFACERETURNFORMAT_FLOAT32	0
#define SURFACERETURNFORMAT_S1	1

#define SURFACE_1D	0
#define SURFACE_2D	1
#define SURFACE_3D	2
#define SURFACE_CUBE	3
#define SURFACE_BUFFER	4
#define SURFACE_NULL	7

#define SURFACE_MIPMAPLAYOUT_BELOW	0
#define SURFACE_MIPMAPLAYOUT_RIGHT	1

static inline uint32_t gen4_surface_format(int bpp, int depth)
{
	switch (bpp) {
	case 8:
		return SURFACEFORMAT_R8_UNORM;
	case 16:
		return SURFACEFORMAT_R8G8_UNORM;
	case 32:
		/* only needed for proper CCS handling */
		if (depth == 30)
			return SURFACEFORMAT_B10G10R10A2_UNORM;
		else
			return SURFACEFORMAT_B8G8R8A8_UNORM;
	case 64:
		return SURFACEFORMAT_R16G16B16A16_FLOAT;
	default:
		return 0;
	}
}

#endif
