/* Generated by re2c 3.0 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API zend_result zend_lex_tstring(zval *zv, zend_lexer_ident_ref ident_ref)
{
	char *ident = (char *) SCNG(yy_start) + ident_ref.offset;
	size_t length = ident_ref.len;
	if (length == sizeof("<?=")-1 && memcmp(ident, "<?=", sizeof("<?=")-1) == 0) {
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, const char *filename) {
	zval code_zv;
	zend_bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		ZVAL_STR(&tmp, zval_get_string(filename));
		filename = &tmp;
	}
	zend_stream_init_filename(&file_handle, Z_STRVAL_P(filename));

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (UNEXPECTED(filename == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, const char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release_ex(new_compiled_filename, 0);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&tmp, filename);
	BEGIN(ST_IN_SCRIPTING);
	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(str));
		str = &tmp;
	}
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(str, str_name);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	if (UNEXPECTED(str == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static zend_bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, zend_bool using_spaces,
	zend_bool newline_at_start, zend_bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end()
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy2;
		}
		switch (yych) {
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
			case 0x08:
			case '\t':
			case '\n':
			case '\v':
			case '\f':
			case '\r':
			case 0x0E:
			case 0x0F:
			case 0x10:
			case 0x11:
			case 0x12:
			case 0x13:
			case 0x14:
			case 0x15:
			case 0x16:
			case 0x17:
			case 0x18:
			case 0x19:
			case 0x1A:
			case 0x1B:
			case 0x1C:
			case 0x1D:
			case 0x1E:
			case 0x1F:
			case 0x7F: goto yy1;
			case ' ':
			case '!': goto yy3;
			case '"': goto yy5;
			case '#': goto yy6;
			case '$': goto yy8;
			case '%': goto yy9;
			case '&': goto yy10;
			case '\'': goto yy11;
			case '(': goto yy12;
			case ')':
			case ']': goto yy14;
			case '*': goto yy15;
			case '+': goto yy16;
			case ',':
			case ';':
			case '@':
			case '~': goto yy17;
			case '-': goto yy18;
			case '.': goto yy19;
			case '/': goto yy20;
			case '0': goto yy21;
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9': goto yy23;
			case ':': goto yy25;
			case '<': goto yy26;
			case '=': goto yy27;
			case '>': goto yy28;
			case '?': goto yy29;
			case 'A':
			case 'a': goto yy30;
			case 'B':
			case 'b': goto yy32;
			case 'C':
			case 'c': goto yy33;
			case 'D':
			case 'd': goto yy34;
			case 'E':
			case 'e': goto yy35;
			case 'F':
			case 'f': goto yy36;
			case 'G':
			case 'g': goto yy37;
			case 'I':
			case 'i': goto yy40;
			case 'L':
			case 'l': goto yy41;
			case 'M':
			case 'm': goto yy42;
			case 'N':
			case 'n': goto yy43;
			case 'O':
			case 'o': goto yy44;
			case 'P':
			case 'p': goto yy45;
			case 'R':
			case 'r': goto yy46;
			case 'S':
			case 's': goto yy47;
			case 'T':
			case 't': goto yy48;
			case 'U':
			case 'u': goto yy49;
			case 'V':
			case 'v': goto yy50;
			case 'W':
			case 'w': goto yy51;
			case 'X':
			case 'x': goto yy52;
			case 'Y':
			case 'y': goto yy53;
			case '[': goto yy54;
			case '\\': goto yy55;
			case '^': goto yy57;
			case '_': goto yy58;
			case '`': goto yy59;
			case '{': goto yy60;
			case '|': goto yy61;
			case '}': goto yy62;
			default: goto yy38;
		}
yy1:
		YYDEBUG(1, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy2;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy63;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy65;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy66;
			if (yych <= '^') goto yy4;
			goto yy66;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy66;
			if (yych <= 0x7F) goto yy4;
			goto yy66;
		}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy68;
		goto yy4;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy69;
		if (yych == '=') goto yy70;
		goto yy4;
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy72;
					if (yych >= ' ') goto yy72;
				} else {
					if (yych <= '@') goto yy13;
					if (yych != 'C') goto yy72;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy72;
					if (yych >= 'I') goto yy72;
				} else {
					if (yych == 'O') goto yy72;
					if (yych >= 'R') goto yy72;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy72;
					if (yych >= 'a') goto yy72;
				} else {
					if (yych == 'd') goto yy72;
					if (yych >= 'f') goto yy72;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy72;
					if (yych >= 'o') goto yy72;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy72;
					} else {
						if (yych == 'u') goto yy72;
					}
				}
			}
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy14:
		YYDEBUG(14, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy83;
		if (yych == '=') goto yy84;
		goto yy4;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy85;
		if (yych == '=') goto yy86;
		goto yy4;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		goto yy4;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy87;
			goto yy4;
		} else {
			if (yych <= '=') goto yy88;
			if (yych <= '>') goto yy89;
			goto yy4;
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy90;
			goto yy4;
		} else {
			if (yych <= '9') goto yy91;
			if (yych == '=') goto yy94;
			goto yy4;
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy95;
			goto yy4;
		} else {
			if (yych <= '/') goto yy97;
			if (yych == '=') goto yy98;
			goto yy4;
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych == 'B') goto yy100;
			if (yych <= 'W') goto yy24;
			goto yy102;
		} else {
			if (yych <= 'b') {
				if (yych <= 'a') goto yy24;
				goto yy100;
			} else {
				if (yych == 'x') goto yy102;
				goto yy24;
			}
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	zend_bool is_octal = lnum[0] == '0';
	zend_bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy24:
		YYDEBUG(24, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy23;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy99;
			if (yych <= 'D') goto yy22;
			goto yy101;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy22;
				goto yy103;
			} else {
				if (yych == 'e') goto yy101;
				goto yy22;
			}
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy104;
		goto yy4;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy4;
		if (yych <= '<') goto yy105;
		if (yych <= '=') goto yy107;
		if (yych <= '>') goto yy108;
		goto yy4;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy4;
		if (yych <= '=') goto yy109;
		if (yych <= '>') goto yy110;
		goto yy4;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy4;
		if (yych <= '=') goto yy111;
		if (yych <= '>') goto yy112;
		goto yy4;
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy113;
			goto yy4;
		} else {
			if (yych <= '>') goto yy114;
			if (yych <= '?') goto yy116;
			goto yy4;
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy117;
				goto yy39;
			} else {
				if (yych <= 'N') goto yy118;
				if (yych <= 'Q') goto yy39;
				if (yych <= 'R') goto yy119;
				goto yy120;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy117;
				if (yych <= 'm') goto yy39;
				goto yy118;
			} else {
				if (yych <= 'q') goto yy39;
				if (yych <= 'r') goto yy119;
				if (yych <= 's') goto yy120;
				goto yy39;
			}
		}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy39;
				goto yy5;
			} else {
				if (yych == '\'') goto yy11;
				goto yy39;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy123;
				if (yych <= 'Q') goto yy39;
				goto yy124;
			} else {
				if (yych == 'r') goto yy124;
				goto yy39;
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy125;
				goto yy39;
			} else {
				if (yych <= 'L') goto yy126;
				if (yych <= 'N') goto yy39;
				goto yy127;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy125;
				goto yy39;
			} else {
				if (yych <= 'l') goto yy126;
				if (yych == 'o') goto yy127;
				goto yy39;
			}
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy128;
				goto yy39;
			} else {
				if (yych <= 'I') goto yy129;
				if (yych <= 'N') goto yy39;
				goto yy130;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy128;
				goto yy39;
			} else {
				if (yych <= 'i') goto yy129;
				if (yych == 'o') goto yy130;
				goto yy39;
			}
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'C':
			case 'c': goto yy132;
			case 'L':
			case 'l': goto yy133;
			case 'M':
			case 'm': goto yy134;
			case 'N':
			case 'n': goto yy135;
			case 'V':
			case 'v': goto yy136;
			case 'X':
			case 'x': goto yy137;
			default: goto yy39;
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy138;
				goto yy39;
			} else {
				if (yych <= 'N') goto yy139;
				if (yych <= 'O') goto yy141;
				if (yych <= 'T') goto yy39;
				goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy138;
				if (yych <= 'm') goto yy39;
				goto yy139;
			} else {
				if (yych <= 'o') goto yy141;
				if (yych == 'u') goto yy142;
				goto yy39;
			}
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy143;
			if (yych <= 'N') goto yy39;
			goto yy144;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy39;
				goto yy143;
			} else {
				if (yych == 'o') goto yy144;
				goto yy39;
			}
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy39:
		YYDEBUG(39, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
		goto yy31;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy145;
				goto yy39;
			} else {
				if (yych <= 'M') goto yy147;
				if (yych <= 'N') goto yy148;
				if (yych <= 'R') goto yy39;
				goto yy149;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy145;
				if (yych <= 'l') goto yy39;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy148;
				if (yych == 's') goto yy149;
				goto yy39;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy150;
		if (yych == 'i') goto yy150;
		goto yy39;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy151;
		if (yych == 'a') goto yy151;
		goto yy39;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy152;
			if (yych <= 'D') goto yy39;
			goto yy153;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy39;
				goto yy152;
			} else {
				if (yych == 'e') goto yy153;
				goto yy39;
			}
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy154;
		if (yych == 'r') goto yy154;
		goto yy39;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy156;
			if (yych <= 'T') goto yy39;
			goto yy157;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy39;
				goto yy156;
			} else {
				if (yych == 'u') goto yy157;
				goto yy39;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy158;
		if (yych == 'e') goto yy158;
		goto yy39;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy159;
			if (yych <= 'V') goto yy39;
			goto yy160;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy39;
				goto yy159;
			} else {
				if (yych == 'w') goto yy160;
				goto yy39;
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy161;
			if (yych <= 'Q') goto yy39;
			goto yy162;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy39;
				goto yy161;
			} else {
				if (yych == 'r') goto yy162;
				goto yy39;
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy163;
			if (yych <= 'R') goto yy39;
			goto yy164;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy39;
				goto yy163;
			} else {
				if (yych == 's') goto yy164;
				goto yy39;
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy165;
		if (yych == 'a') goto yy165;
		goto yy39;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy166;
		if (yych == 'h') goto yy166;
		goto yy39;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy167;
		if (yych == 'o') goto yy167;
		goto yy39;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy168;
		if (yych == 'i') goto yy168;
		goto yy39;
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		goto yy13;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy56;
			if (yych <= 'Z') goto yy169;
			if (yych >= '_') goto yy169;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy169;
			if (yych >= 0x80) goto yy169;
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy171;
		goto yy4;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy172;
		goto yy39;
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy173;
		if (yych == '|') goto yy174;
		goto yy4;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy175;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy66;
			} else {
				if (yych <= '@') goto yy67;
				if (yych <= 'Z') goto yy66;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy66;
			} else {
				if (yych <= 'z') goto yy66;
				if (yych >= 0x80) goto yy66;
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy72:
		YYDEBUG(72, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy71;
		}
		switch (yych) {
			case 'A':
			case 'a': goto yy74;
			case 'B':
			case 'b': goto yy75;
			case 'D':
			case 'd': goto yy76;
			case 'F':
			case 'f': goto yy77;
			case 'I':
			case 'i': goto yy78;
			case 'O':
			case 'o': goto yy79;
			case 'R':
			case 'r': goto yy80;
			case 'S':
			case 's': goto yy81;
			case 'U':
			case 'u': goto yy82;
			default: goto yy73;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 44) {
			if (yyaccept <= 22) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy13;
								} else {
									goto yy4;
								}
							} else {
								goto yy22;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy31;
								} else {
									goto yy93;
								}
							} else {
								goto yy96;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy106;
								} else {
									goto yy121;
								}
							} else {
								goto yy131;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy140;
								} else {
									goto yy146;
								}
							} else {
								goto yy155;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy170;
								} else {
									goto yy191;
								}
							} else {
								goto yy195;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy207;
								} else {
									goto yy210;
								}
							} else {
								goto yy222;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy232;
								} else {
									goto yy245;
								}
							} else {
								goto yy256;
							}
						} else {
							if (yyaccept == 21) {
								goto yy259;
							} else {
								goto yy261;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 33) {
					if (yyaccept <= 28) {
						if (yyaccept <= 25) {
							if (yyaccept <= 24) {
								if (yyaccept == 23) {
									goto yy264;
								} else {
									goto yy294;
								}
							} else {
								goto yy303;
							}
						} else {
							if (yyaccept <= 27) {
								if (yyaccept == 26) {
									goto yy305;
								} else {
									goto yy313;
								}
							} else {
								goto yy315;
							}
						}
					} else {
						if (yyaccept <= 31) {
							if (yyaccept <= 30) {
								if (yyaccept == 29) {
									goto yy322;
								} else {
									goto yy329;
								}
							} else {
								goto yy375;
							}
						} else {
							if (yyaccept == 32) {
								goto yy377;
							} else {
								goto yy380;
							}
						}
					}
				} else {
					if (yyaccept <= 39) {
						if (yyaccept <= 36) {
							if (yyaccept <= 35) {
								if (yyaccept == 34) {
									goto yy382;
								} else {
									goto yy384;
								}
							} else {
								goto yy386;
							}
						} else {
							if (yyaccept <= 38) {
								if (yyaccept == 37) {
									goto yy392;
								} else {
									goto yy396;
								}
							} else {
								goto yy401;
							}
						}
					} else {
						if (yyaccept <= 42) {
							if (yyaccept <= 41) {
								if (yyaccept == 40) {
									goto yy411;
								} else {
									goto yy413;
								}
							} else {
								goto yy416;
							}
						} else {
							if (yyaccept == 43) {
								goto yy425;
							} else {
								goto yy427;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 66) {
				if (yyaccept <= 55) {
					if (yyaccept <= 50) {
						if (yyaccept <= 47) {
							if (yyaccept <= 46) {
								if (yyaccept == 45) {
									goto yy429;
								} else {
									goto yy431;
								}
							} else {
								goto yy433;
							}
						} else {
							if (yyaccept <= 49) {
								if (yyaccept == 48) {
									goto yy462;
								} else {
									goto yy465;
								}
							} else {
								goto yy473;
							}
						}
					} else {
						if (yyaccept <= 53) {
							if (yyaccept <= 52) {
								if (yyaccept == 51) {
									goto yy483;
								} else {
									goto yy486;
								}
							} else {
								goto yy488;
							}
						} else {
							if (yyaccept == 54) {
								goto yy490;
							} else {
								goto yy512;
							}
						}
					}
				} else {
					if (yyaccept <= 61) {
						if (yyaccept <= 58) {
							if (yyaccept <= 57) {
								if (yyaccept == 56) {
									goto yy514;
								} else {
									goto yy520;
								}
							} else {
								goto yy522;
							}
						} else {
							if (yyaccept <= 60) {
								if (yyaccept == 59) {
									goto yy524;
								} else {
									goto yy528;
								}
							} else {
								goto yy534;
							}
						}
					} else {
						if (yyaccept <= 64) {
							if (yyaccept <= 63) {
								if (yyaccept == 62) {
									goto yy537;
								} else {
									goto yy541;
								}
							} else {
								goto yy552;
							}
						} else {
							if (yyaccept == 65) {
								goto yy554;
							} else {
								goto yy556;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 77) {
					if (yyaccept <= 72) {
						if (yyaccept <= 69) {
							if (yyaccept <= 68) {
								if (yyaccept == 67) {
									goto yy561;
								} else {
									goto yy563;
								}
							} else {
								goto yy575;
							}
						} else {
							if (yyaccept <= 71) {
								if (yyaccept == 70) {
									goto yy579;
								} else {
									goto yy586;
								}
							} else {
								goto yy591;
							}
						}
					} else {
						if (yyaccept <= 75) {
							if (yyaccept <= 74) {
								if (yyaccept == 73) {
									goto yy593;
								} else {
									goto yy595;
								}
							} else {
								goto yy597;
							}
						} else {
							if (yyaccept == 76) {
								goto yy601;
							} else {
								goto yy607;
							}
						}
					}
				} else {
					if (yyaccept <= 83) {
						if (yyaccept <= 80) {
							if (yyaccept <= 79) {
								if (yyaccept == 78) {
									goto yy609;
								} else {
									goto yy611;
								}
							} else {
								goto yy613;
							}
						} else {
							if (yyaccept <= 82) {
								if (yyaccept == 81) {
									goto yy616;
								} else {
									goto yy623;
								}
							} else {
								goto yy627;
							}
						}
					} else {
						if (yyaccept <= 86) {
							if (yyaccept <= 85) {
								if (yyaccept == 84) {
									goto yy634;
								} else {
									goto yy636;
								}
							} else {
								goto yy638;
							}
						} else {
							if (yyaccept == 87) {
								goto yy643;
							} else {
								goto yy646;
							}
						}
					}
				}
			}
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy176;
		if (yych == 'r') goto yy176;
		goto yy73;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy177;
			if (yych <= 'N') goto yy73;
			goto yy178;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy73;
				goto yy177;
			} else {
				if (yych == 'o') goto yy178;
				goto yy73;
			}
		}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy179;
		if (yych == 'o') goto yy179;
		goto yy73;
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy180;
		if (yych == 'l') goto yy180;
		goto yy73;
yy78:
		YYDEBUG(78, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy181;
		if (yych == 'n') goto yy181;
		goto yy73;
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy182;
		if (yych == 'b') goto yy182;
		goto yy73;
yy80:
		YYDEBUG(80, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy183;
		if (yych == 'e') goto yy183;
		goto yy73;
yy81:
		YYDEBUG(81, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy184;
		if (yych == 't') goto yy184;
		goto yy73;
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy185;
		if (yych == 'n') goto yy185;
		goto yy73;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy186;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy187;
		goto yy73;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy92:
		YYDEBUG(92, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy93;
			if (yych <= '9') goto yy91;
			if (yych >= 'E') goto yy101;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy188;
			} else {
				if (yych == 'e') goto yy101;
			}
		}
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	zend_bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy189;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
		goto yy7;
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy93;
		goto yy92;
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy190;
		}
		goto yy73;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy192;
			goto yy73;
		} else {
			if (yych <= '-') goto yy192;
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy193;
			goto yy73;
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy194;
		}
		goto yy73;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy23;
		}
		goto yy73;
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy106;
		if (yych <= '<') goto yy196;
		if (yych <= '=') goto yy197;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy198;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		goto yy64;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy199;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy200;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy201;
		goto yy73;
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy202;
		if (yych == '\r') goto yy203;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy204;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy205;
		if (yych == 's') goto yy205;
		goto yy39;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy206;
		if (yych == 'd') goto yy206;
		goto yy39;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy208;
		if (yych == 'r') goto yy208;
		goto yy39;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy73;
			if (yych <= 'Z') goto yy209;
			if (yych <= '^') goto yy73;
			goto yy209;
		} else {
			if (yych <= '`') goto yy73;
			if (yych <= 'z') goto yy209;
			if (yych <= 0x7F) goto yy73;
			goto yy209;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy211;
		goto yy73;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy212;
		if (yych == 'e') goto yy212;
		goto yy39;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy39;
				goto yy213;
			} else {
				if (yych <= 'R') goto yy39;
				if (yych <= 'S') goto yy214;
				goto yy215;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy213;
				goto yy39;
			} else {
				if (yych <= 's') goto yy214;
				if (yych <= 't') goto yy215;
				goto yy39;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy216;
			if (yych <= 'N') goto yy39;
			goto yy217;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy39;
				goto yy216;
			} else {
				if (yych == 'o') goto yy217;
				goto yy39;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy218;
		if (yych == 'n') goto yy218;
		goto yy39;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy219;
			if (yych <= 'E') goto yy39;
			goto yy220;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy39;
				goto yy219;
			} else {
				if (yych == 'f') goto yy220;
				goto yy39;
			}
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy221;
		if (yych == 'e') goto yy221;
		goto yy39;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy223;
		if (yych == 'h') goto yy223;
		goto yy39;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy224;
		if (yych == 's') goto yy224;
		goto yy39;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy225;
		if (yych == 'p') goto yy225;
		goto yy39;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy226;
		if (yych == 'd') goto yy226;
		goto yy39;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy227;
		if (yych == 'a') goto yy227;
		goto yy39;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy228;
			if (yych <= 'S') goto yy39;
			goto yy229;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy39;
				goto yy228;
			} else {
				if (yych == 't') goto yy229;
				goto yy39;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy230;
		if (yych == 'n') goto yy230;
		goto yy39;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy231;
		if (yych == 'r') goto yy231;
		goto yy39;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy233;
		if (yych == 'n') goto yy233;
		goto yy39;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy234;
		if (yych == 'o') goto yy234;
		goto yy39;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy235;
		if (yych == 't') goto yy235;
		goto yy39;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy236;
		if (yych == 'p') goto yy236;
		goto yy39;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy39;
				goto yy237;
			} else {
				if (yych <= 'R') goto yy39;
				if (yych <= 'S') goto yy238;
				goto yy239;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy237;
				goto yy39;
			} else {
				if (yych <= 's') goto yy238;
				if (yych <= 't') goto yy239;
				goto yy39;
			}
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy240;
		if (yych == 's') goto yy240;
		goto yy39;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy241;
		if (yych == 's') goto yy241;
		goto yy39;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy242;
		if (yych == 't') goto yy242;
		goto yy39;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy243;
		if (yych == 'm') goto yy243;
		goto yy39;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy244;
		if (yych == 'w') goto yy244;
		goto yy39;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy246;
			if (yych <= 'N') goto yy39;
			goto yy247;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy39;
				goto yy246;
			} else {
				if (yych == 'o') goto yy247;
				goto yy39;
			}
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy248;
		if (yych == 'b') goto yy248;
		goto yy39;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'Q') goto yy249;
			if (yych <= 'S') goto yy39;
			goto yy250;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy39;
				goto yy249;
			} else {
				if (yych == 't') goto yy250;
				goto yy39;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy251;
		if (yych == 'a') goto yy251;
		goto yy39;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy252;
		if (yych == 'i') goto yy252;
		goto yy39;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy253;
		if (yych == 'r') goto yy253;
		goto yy39;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy254;
			if (yych <= 'X') goto yy39;
			goto yy255;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy39;
				goto yy254;
			} else {
				if (yych == 'y') goto yy255;
				goto yy39;
			}
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy257;
		if (yych == 's') goto yy257;
		goto yy39;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy258;
		if (yych == 'e') goto yy258;
		goto yy39;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy260;
		if (yych == 'r') goto yy260;
		goto yy39;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy262;
		if (yych == 'i') goto yy262;
		goto yy39;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy263;
		if (yych == 'r') goto yy263;
		goto yy39;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy265;
		if (yych == 'e') goto yy265;
		goto yy39;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 12;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy170;
				if (yych <= '9') goto yy169;
			} else {
				if (yych <= 'Z') goto yy169;
				if (yych >= '\\') goto yy266;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy169;
			} else {
				if (yych <= 'z') goto yy169;
				if (yych >= 0x80) goto yy169;
			}
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'C':
			case 'c': goto yy267;
			case 'D':
			case 'd': goto yy268;
			case 'F':
			case 'f': goto yy269;
			case 'H':
			case 'h': goto yy270;
			case 'L':
			case 'l': goto yy271;
			case 'M':
			case 'm': goto yy272;
			case 'N':
			case 'n': goto yy273;
			case 'T':
			case 't': goto yy274;
			default: goto yy39;
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy275;
		if (yych == 'r') goto yy275;
		goto yy73;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy276;
		if (yych == 'n') goto yy276;
		goto yy73;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy277;
		if (yych == 'o') goto yy277;
		goto yy73;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy278;
		if (yych == 'u') goto yy278;
		goto yy73;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy279;
		if (yych == 'o') goto yy279;
		goto yy73;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy280;
		if (yych == 't') goto yy280;
		goto yy73;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy281;
		if (yych == 'j') goto yy281;
		goto yy73;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy282;
		if (yych == 'a') goto yy282;
		goto yy73;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy283;
		if (yych == 'r') goto yy283;
		goto yy73;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy284;
		if (yych == 's') goto yy284;
		goto yy73;
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy73;
		if (yych <= '9') goto yy91;
		goto yy73;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy73;
			if (yych <= '\n') goto yy285;
			goto yy73;
		} else {
			if (yych <= '\r') goto yy285;
			if (yych == ' ') goto yy285;
			goto yy73;
		}
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy190;
		}
		if (yych == '_') goto yy100;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy73;
		if (yych >= ':') goto yy73;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy93;
		if (yych <= '9') goto yy193;
		if (yych == '_') goto yy192;
		goto yy93;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy194;
		}
		if (yych == '_') goto yy102;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy196;
				if (yych <= 0x1F) goto yy73;
				goto yy196;
			} else {
				if (yych == '"') goto yy286;
				if (yych <= '&') goto yy73;
				goto yy287;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy73;
				if (yych <= 'Z') goto yy288;
				if (yych <= '^') goto yy73;
				goto yy288;
			} else {
				if (yych <= '`') goto yy73;
				if (yych <= 'z') goto yy288;
				if (yych <= 0x7F) goto yy73;
				goto yy288;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		goto yy115;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy202;
		goto yy115;
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy289;
		if (yych == 't') goto yy289;
		goto yy39;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy208:
		YYDEBUG(208, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy290;
		if (yych == 'a') goto yy290;
		goto yy39;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy210;
				if (yych <= '9') goto yy209;
			} else {
				if (yych <= 'Z') goto yy209;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy209;
			} else {
				if (yych <= 'z') goto yy209;
				if (yych >= 0x80) goto yy209;
			}
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy211:
		YYDEBUG(211, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy196;
		goto yy73;
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy291;
		if (yych == 'a') goto yy291;
		goto yy39;
yy213:
		YYDEBUG(213, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy292;
		if (yych == 'l') goto yy292;
		goto yy39;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy293;
		if (yych == 'e') goto yy293;
		goto yy39;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy295;
		if (yych == 'c') goto yy295;
		goto yy39;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy296;
		if (yych == 's') goto yy296;
		goto yy39;
yy217:
		YYDEBUG(217, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy297;
		if (yych == 'n') goto yy297;
		goto yy39;
yy218:
		YYDEBUG(218, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy39;
			if (yych <= 'S') goto yy298;
			goto yy299;
		} else {
			if (yych <= 'r') goto yy39;
			if (yych <= 's') goto yy298;
			if (yych <= 't') goto yy299;
			goto yy39;
		}
yy219:
		YYDEBUG(219, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy300;
		if (yych == 'l') goto yy300;
		goto yy39;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy301;
		if (yych == 'a') goto yy301;
		goto yy39;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy302;
		if (yych == 'o') goto yy302;
		goto yy39;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy304;
		if (yych == 'e') goto yy304;
		goto yy39;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy306;
		if (yych == 't') goto yy306;
		goto yy39;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'D':
			case 'd': goto yy307;
			case 'F':
			case 'f': goto yy308;
			case 'I':
			case 'i': goto yy309;
			case 'S':
			case 's': goto yy310;
			case 'W':
			case 'w': goto yy311;
			default: goto yy39;
		}
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy312;
		if (yych == 'l') goto yy312;
		goto yy39;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy314;
		if (yych == 't') goto yy314;
		goto yy39;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy316;
		if (yych == 'e') goto yy316;
		goto yy39;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy317;
		if (yych == 'a') goto yy317;
		goto yy39;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy232;
				if (yych <= '9') goto yy38;
				if (yych >= 'A') goto yy38;
			} else {
				if (yych <= 'E') goto yy318;
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy38;
				if (yych >= 'a') goto yy38;
			} else {
				if (yych <= 'e') goto yy318;
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy319;
		if (yych == 'c') goto yy319;
		goto yy39;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy320;
		if (yych == 'b') goto yy320;
		goto yy39;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy321;
		if (yych == 'o') goto yy321;
		goto yy39;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy323;
		if (yych == 'l') goto yy323;
		goto yy39;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy324;
		if (yych == 'l') goto yy324;
		goto yy39;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy325;
		if (yych == 't') goto yy325;
		goto yy39;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy326;
		if (yych == 'e') goto yy326;
		goto yy39;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy327;
		if (yych == 'e') goto yy327;
		goto yy39;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy328;
		if (yych == 't') goto yy328;
		goto yy39;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy330;
		if (yych == 'c') goto yy330;
		goto yy39;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy331;
		if (yych == 'e') goto yy331;
		goto yy39;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy332;
			if (yych <= 'U') goto yy39;
			goto yy333;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy39;
				goto yy332;
			} else {
				if (yych == 'v') goto yy333;
				goto yy39;
			}
		}
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy334;
		if (yych == 't') goto yy334;
		goto yy39;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy335;
		if (yych == 'l') goto yy335;
		goto yy39;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy336;
		if (yych == 'u') goto yy336;
		goto yy39;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy337;
		if (yych == 'u') goto yy337;
		goto yy39;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy338;
		if (yych == 't') goto yy338;
		goto yy39;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy339;
		if (yych == 't') goto yy339;
		goto yy39;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy340;
		if (yych == 'o') goto yy340;
		goto yy39;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy341;
		if (yych == 'i') goto yy341;
		goto yy39;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy342;
		if (yych == 'e') goto yy342;
		goto yy39;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy343;
		if (yych == 'l') goto yy343;
		goto yy39;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy344;
		if (yych == 'l') goto yy344;
		goto yy39;
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy73;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy73;
			goto yy169;
		} else {
			if (yych <= '`') goto yy73;
			if (yych <= 'z') goto yy169;
			if (yych <= 0x7F) goto yy73;
			goto yy169;
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy345;
		if (yych == 'l') goto yy345;
		goto yy39;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy346;
		if (yych == 'i') goto yy346;
		goto yy39;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy347;
			if (yych <= 'T') goto yy39;
			goto yy348;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy39;
				goto yy347;
			} else {
				if (yych == 'u') goto yy348;
				goto yy39;
			}
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy349;
		if (yych == 'a') goto yy349;
		goto yy39;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy350;
		if (yych == 'i') goto yy350;
		goto yy39;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy351;
		if (yych == 'e') goto yy351;
		goto yy39;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy352;
		if (yych == 'a') goto yy352;
		goto yy39;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy353;
		if (yych == 'r') goto yy353;
		goto yy39;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy354;
		if (yych == 'a') goto yy354;
		goto yy73;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy355;
		if (yych == 'a') goto yy355;
		goto yy73;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy356;
		if (yych == 'l') goto yy356;
		goto yy73;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy357;
		if (yych == 'b') goto yy357;
		goto yy73;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy358;
		if (yych == 'a') goto yy358;
		goto yy73;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy361;
		if (yych == 'e') goto yy361;
		goto yy360;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy362;
		if (yych == 'e') goto yy362;
		goto yy73;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy73;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy364;
		if (yych == 'i') goto yy364;
		goto yy73;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy365;
		if (yych == 'e') goto yy365;
		goto yy73;
yy285:
		YYDEBUG(285, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy96;
			if (yych <= '\n') goto yy285;
			goto yy96;
		} else {
			if (yych <= '\r') goto yy285;
			if (yych == ' ') goto yy285;
			goto yy96;
		}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy73;
		if (yych <= '/') goto yy367;
		if (yych <= '9') goto yy73;
		goto yy367;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy73;
		if (yych <= '/') goto yy369;
		if (yych <= '9') goto yy73;
		goto yy369;
yy288:
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy370;
				goto yy73;
			} else {
				if (yych <= '\r') goto yy372;
				if (yych <= '/') goto yy73;
				if (yych <= '9') goto yy288;
				goto yy73;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy288;
				if (yych <= '^') goto yy73;
				goto yy288;
			} else {
				if (yych <= '`') goto yy73;
				if (yych <= 'z') goto yy288;
				if (yych <= 0x7F) goto yy73;
				goto yy288;
			}
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy373;
		if (yych == 'r') goto yy373;
		goto yy39;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy374;
		if (yych == 'y') goto yy374;
		goto yy39;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy376;
		if (yych == 'k') goto yy376;
		goto yy39;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy378;
		if (yych == 'a') goto yy378;
		goto yy39;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy379;
		if (yych == 'h') goto yy379;
		goto yy39;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy381;
		if (yych == 's') goto yy381;
		goto yy39;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy383;
		if (yych == 'e') goto yy383;
		goto yy39;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy385;
		if (yych == 't') goto yy385;
		goto yy39;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy387;
		if (yych == 'i') goto yy387;
		goto yy39;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy388;
		if (yych == 'a') goto yy388;
		goto yy39;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy389;
		if (yych == 'u') goto yy389;
		goto yy39;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy305;
				if (yych <= '9') goto yy38;
				if (yych >= 'A') goto yy38;
			} else {
				if (yych <= 'I') goto yy390;
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy38;
				if (yych >= 'a') goto yy38;
			} else {
				if (yych <= 'i') goto yy390;
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy391;
		if (yych == 'y') goto yy391;
		goto yy39;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy393;
		if (yych == 'e') goto yy393;
		goto yy39;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy394;
		if (yych == 'o') goto yy394;
		goto yy39;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy395;
		if (yych == 'f') goto yy395;
		goto yy39;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy397;
		if (yych == 'w') goto yy397;
		goto yy39;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy398;
		if (yych == 'h') goto yy398;
		goto yy39;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy399;
		if (yych == 'n') goto yy399;
		goto yy39;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy400;
		if (yych == 'l') goto yy400;
		goto yy39;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy402;
		if (yych == 'a') goto yy402;
		goto yy39;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy403;
		if (yych == 't') goto yy403;
		goto yy39;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy404;
		if (yych == 'a') goto yy404;
		goto yy39;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy405;
		if (yych == 'e') goto yy405;
		goto yy39;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy406;
		if (yych == 'u') goto yy406;
		goto yy39;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy407;
			if (yych <= 'D') goto yy39;
			goto yy408;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy39;
				goto yy407;
			} else {
				if (yych == 'e') goto yy408;
				goto yy39;
			}
		}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy409;
		if (yych == 'r') goto yy409;
		goto yy39;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy410;
		if (yych == 't') goto yy410;
		goto yy39;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy412;
		if (yych == 'h') goto yy412;
		goto yy39;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy414;
		if (yych == 's') goto yy414;
		goto yy39;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy415;
		if (yych == 't') goto yy415;
		goto yy39;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy417;
		if (yych == 'a') goto yy417;
		goto yy39;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy418;
		if (yych == 'e') goto yy418;
		goto yy39;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy419;
		if (yych == 'i') goto yy419;
		goto yy39;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy420;
		if (yych == 'i') goto yy420;
		goto yy39;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy421;
		if (yych == 'r') goto yy421;
		goto yy39;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy422;
		if (yych == 'i') goto yy422;
		goto yy39;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy423;
		if (yych == 'c') goto yy423;
		goto yy39;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy424;
		if (yych == 'w') goto yy424;
		goto yy39;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy426;
		if (yych == 't') goto yy426;
		goto yy39;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy428;
		if (yych == 't') goto yy428;
		goto yy39;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy430;
		if (yych == 'e') goto yy430;
		goto yy39;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy432;
		if (yych == 'd') goto yy432;
		goto yy39;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy434;
		if (yych == 'a') goto yy434;
		goto yy39;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy435;
		if (yych == 'r') goto yy435;
		goto yy39;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy436;
		if (yych == 'l') goto yy436;
		goto yy39;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy437;
		if (yych == 'n') goto yy437;
		goto yy39;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy438;
		if (yych == 'l') goto yy438;
		goto yy39;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy439;
		if (yych == 'n') goto yy439;
		goto yy39;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy440;
		if (yych == 't') goto yy440;
		goto yy39;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy441;
		if (yych == 'm') goto yy441;
		goto yy39;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy442;
		if (yych == 'a') goto yy442;
		goto yy39;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy443;
		if (yych == 'y') goto yy443;
		goto yy73;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy444;
		if (yych == 'r') goto yy444;
		goto yy73;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy447;
		if (yych == 'e') goto yy447;
		goto yy446;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy448;
		if (yych == 'l') goto yy448;
		goto yy73;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy449;
		if (yych == 't') goto yy449;
		goto yy73;
yy359:
		YYDEBUG(359, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy360:
		YYDEBUG(360, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy359;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy359;
			if (yych != ')') goto yy73;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy450;
		if (yych == 'g') goto yy450;
		goto yy73;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy451;
		if (yych == 'c') goto yy451;
		goto yy73;
yy363:
		YYDEBUG(363, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy363;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy363;
			if (yych == ')') goto yy452;
			goto yy73;
		}
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy453;
		if (yych == 'n') goto yy453;
		goto yy73;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy454;
		if (yych == 't') goto yy454;
		goto yy73;
yy366:
		YYDEBUG(366, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy367:
		YYDEBUG(367, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy455;
				goto yy73;
			} else {
				if (yych <= '9') goto yy366;
				if (yych <= '@') goto yy73;
				goto yy366;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy366;
				goto yy73;
			} else {
				if (yych <= 'z') goto yy366;
				if (yych <= 0x7F) goto yy73;
				goto yy366;
			}
		}
yy368:
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy369:
		YYDEBUG(369, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy455;
				goto yy73;
			} else {
				if (yych <= '9') goto yy368;
				if (yych <= '@') goto yy73;
				goto yy368;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy368;
				goto yy73;
			} else {
				if (yych <= 'z') goto yy368;
				if (yych <= 0x7F) goto yy73;
				goto yy368;
			}
		}
yy370:
		YYDEBUG(370, *YYCURSOR);
		++YYCURSOR;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	zend_bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy370;
		goto yy371;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy456;
		if (yych == 'a') goto yy456;
		goto yy39;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy457;
		if (yych == 'b') goto yy457;
		goto yy39;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy458;
		if (yych == 'n') goto yy458;
		goto yy39;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy459;
		if (yych == 'r') goto yy459;
		goto yy39;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy460;
		if (yych == 'l') goto yy460;
		goto yy39;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy461;
		if (yych == 'f') goto yy461;
		goto yy39;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy463;
		if (yych == 'c') goto yy463;
		goto yy39;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy464;
		if (yych == 'r') goto yy464;
		goto yy39;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy466;
		if (yych == 'i') goto yy466;
		goto yy39;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy467;
		if (yych == 'i') goto yy467;
		goto yy39;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy468;
		if (yych == 'd') goto yy468;
		goto yy39;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy401;
				if (yych <= '9') goto yy38;
				if (yych >= 'A') goto yy38;
			} else {
				if (yych <= 'L') goto yy469;
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy38;
				if (yych >= 'a') goto yy38;
			} else {
				if (yych <= 'l') goto yy469;
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy470;
		if (yych == 'c') goto yy470;
		goto yy39;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy471;
		if (yych == 'i') goto yy471;
		goto yy39;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy472;
		if (yych == 'l') goto yy472;
		goto yy39;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy474;
		if (yych == 'm') goto yy474;
		goto yy39;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy475;
		if (yych == 'd') goto yy475;
		goto yy39;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy476;
		if (yych == 'n') goto yy476;
		goto yy39;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy477;
		if (yych == 'a') goto yy477;
		goto yy39;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy478;
		if (yych == 'f') goto yy478;
		goto yy39;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy479;
		if (yych == 'p') goto yy479;
		goto yy39;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy480;
		if (yych == 't') goto yy480;
		goto yy39;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy481;
		if (yych == 'c') goto yy481;
		goto yy39;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy482;
		if (yych == 'c') goto yy482;
		goto yy39;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy484;
		if (yych == 'r') goto yy484;
		goto yy39;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy485;
		if (yych == 'n') goto yy485;
		goto yy39;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy487;
		if (yych == 'c') goto yy487;
		goto yy39;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy489;
		if (yych == 'h') goto yy489;
		goto yy39;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy428:
		YYDEBUG(428, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy430:
		YYDEBUG(430, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy433;
			if (yych <= '\n') goto yy491;
			if (yych >= '\r') goto yy491;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy491;
			} else {
				if (yych == '\\') goto yy122;
			}
		}
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy434:
		YYDEBUG(434, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy492;
		if (yych == 's') goto yy492;
		goto yy39;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy493;
		goto yy39;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy494;
		if (yych == 'e') goto yy494;
		goto yy39;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy495;
		if (yych == 'c') goto yy495;
		goto yy39;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy496;
		if (yych == 't') goto yy496;
		goto yy39;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy497;
		if (yych == 'e') goto yy497;
		goto yy39;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy498;
		if (yych == 'h') goto yy498;
		goto yy39;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy499;
		if (yych == 'e') goto yy499;
		goto yy39;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy500;
		if (yych == 'i') goto yy500;
		goto yy39;
yy443:
		YYDEBUG(443, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy443;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy443;
			if (yych == ')') goto yy501;
			goto yy73;
		}
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy502;
		if (yych == 'y') goto yy502;
		goto yy73;
yy445:
		YYDEBUG(445, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy446:
		YYDEBUG(446, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy445;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy445;
			if (yych != ')') goto yy73;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy503;
		if (yych == 'a') goto yy503;
		goto yy73;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy449;
		if (yych != 'e') goto yy73;
yy449:
		YYDEBUG(449, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy449;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy449;
			if (yych == ')') goto yy504;
			goto yy73;
		}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy505;
		if (yych == 'e') goto yy505;
		goto yy73;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy506;
		if (yych == 't') goto yy506;
		goto yy73;
yy452:
		YYDEBUG(452, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy502;
		if (yych == 'g') goto yy502;
		goto yy73;
yy454:
		YYDEBUG(454, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy454;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy454;
			if (yych == ')') goto yy507;
			goto yy73;
		}
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy370;
		if (yych == '\r') goto yy372;
		goto yy73;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy508;
		if (yych == 'c') goto yy508;
		goto yy39;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy509;
		if (yych == 'l') goto yy509;
		goto yy39;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy510;
		if (yych == 'u') goto yy510;
		goto yy39;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy511;
		if (yych == 'e') goto yy511;
		goto yy39;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy513;
		if (yych == 't') goto yy513;
		goto yy39;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy515;
		if (yych == 'l') goto yy515;
		goto yy39;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy465;
				if (yych <= '9') goto yy38;
				if (yych >= 'A') goto yy38;
			} else {
				if (yych <= 'E') goto yy516;
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy38;
				if (yych >= 'a') goto yy38;
			} else {
				if (yych <= 'e') goto yy516;
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy517;
		if (yych == 't') goto yy517;
		goto yy39;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy518;
		if (yych == 'l') goto yy518;
		goto yy39;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy519;
		if (yych == 's') goto yy519;
		goto yy39;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy521;
		if (yych == 'y') goto yy521;
		goto yy39;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy523;
		if (yych == 'h') goto yy523;
		goto yy39;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy525;
		if (yych == 'o') goto yy525;
		goto yy39;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy526;
		if (yych == 'e') goto yy526;
		goto yy39;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy527;
		if (yych == 'e') goto yy527;
		goto yy39;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy529;
		if (yych == 'c') goto yy529;
		goto yy39;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy530;
		if (yych == 'd') goto yy530;
		goto yy39;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy531;
		if (yych == 'a') goto yy531;
		goto yy39;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy532;
		if (yych == 'a') goto yy532;
		goto yy39;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy533;
		if (yych == 'e') goto yy533;
		goto yy39;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy535;
		if (yych == 't') goto yy535;
		goto yy39;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy536;
		if (yych == 'e') goto yy536;
		goto yy39;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy491:
		YYDEBUG(491, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy73;
				goto yy491;
			} else {
				if (yych == '\r') goto yy491;
				goto yy73;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy491;
				if (yych <= 'E') goto yy73;
				goto yy538;
			} else {
				if (yych == 'f') goto yy538;
				goto yy73;
			}
		}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy539;
		if (yych == 's') goto yy539;
		goto yy39;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy540;
		goto yy39;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy542;
		goto yy39;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy543;
		if (yych == 't') goto yy543;
		goto yy39;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy544;
		goto yy39;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy545;
		goto yy39;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy546;
		if (yych == 'o') goto yy546;
		goto yy39;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy547;
		if (yych == 's') goto yy547;
		goto yy39;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy548;
		if (yych == 't') goto yy548;
		goto yy39;
yy501:
		YYDEBUG(501, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy502:
		YYDEBUG(502, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy502;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy502;
			if (yych == ')') goto yy549;
			goto yy73;
		}
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy445;
		if (yych == 'n') goto yy445;
		goto yy73;
yy504:
		YYDEBUG(504, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy359;
		if (yych == 'r') goto yy359;
		goto yy73;
yy506:
		YYDEBUG(506, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy506;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy506;
			if (yych == ')') goto yy550;
			goto yy73;
		}
yy507:
		YYDEBUG(507, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy551;
		if (yych == 't') goto yy551;
		goto yy39;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy553;
		if (yych == 'e') goto yy553;
		goto yy39;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy555;
		if (yych == 'e') goto yy555;
		goto yy39;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy513:
		YYDEBUG(513, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy515:
		YYDEBUG(515, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy557;
		if (yych == 'a') goto yy557;
		goto yy39;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy558;
		if (yych == 'a') goto yy558;
		goto yy39;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy559;
		if (yych == 'c') goto yy559;
		goto yy39;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy560;
		if (yych == 'e') goto yy560;
		goto yy39;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy521:
		YYDEBUG(521, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy525:
		YYDEBUG(525, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy562;
		if (yych == 'n') goto yy562;
		goto yy39;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy564;
		if (yych == 'n') goto yy564;
		goto yy39;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy528;
				if (yych <= '9') goto yy38;
			} else {
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy565;
			} else {
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy528:
		YYDEBUG(528, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy529:
		YYDEBUG(529, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy566;
		if (yych == 'e') goto yy566;
		goto yy39;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy567;
		if (yych == 'o') goto yy567;
		goto yy39;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy568;
		if (yych == 'c') goto yy568;
		goto yy39;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy569;
		if (yych == 'c') goto yy569;
		goto yy39;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy570;
		if (yych == 'e') goto yy570;
		goto yy39;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy537;
				if (yych <= '9') goto yy38;
			} else {
				if (yych <= 'Z') goto yy38;
				if (yych >= '\\') goto yy122;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy571;
			} else {
				if (yych <= 'z') goto yy38;
				if (yych >= 0x80) goto yy38;
			}
		}
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy572;
		if (yych == 'r') goto yy572;
		goto yy73;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy573;
		goto yy39;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy574;
		goto yy39;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy576;
		if (yych == 'i') goto yy576;
		goto yy39;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy577;
		if (yych == 'c') goto yy577;
		goto yy39;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy578;
		goto yy39;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy580;
		if (yych == 'd') goto yy580;
		goto yy39;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy581;
		if (yych == 'p') goto yy581;
		goto yy39;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy582;
		goto yy39;
yy549:
		YYDEBUG(549, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy550:
		YYDEBUG(550, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy583;
		if (yych == 'r') goto yy583;
		goto yy39;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy584;
		if (yych == 'c') goto yy584;
		goto yy39;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy585;
		if (yych == 'h') goto yy585;
		goto yy39;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy587;
		if (yych == 't') goto yy587;
		goto yy39;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy588;
		if (yych == 'o') goto yy588;
		goto yy39;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy589;
		if (yych == 'o') goto yy589;
		goto yy39;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy590;
		if (yych == 'f') goto yy590;
		goto yy39;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy592;
		if (yych == 'e') goto yy592;
		goto yy39;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy594;
		if (yych == 'e') goto yy594;
		goto yy39;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy596;
		if (yych == 'd') goto yy596;
		goto yy39;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy598;
		if (yych == 'o') goto yy598;
		goto yy39;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy599;
		if (yych == 'o') goto yy599;
		goto yy73;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy600;
		goto yy39;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy602;
		if (yych == 'o') goto yy602;
		goto yy39;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy603;
		if (yych == 'o') goto yy603;
		goto yy39;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy604;
		goto yy39;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy605;
		if (yych == 'a') goto yy605;
		goto yy39;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy606;
		goto yy39;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy608;
		if (yych == 'e') goto yy608;
		goto yy39;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy610;
		if (yych == 'h') goto yy610;
		goto yy39;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy587:
		YYDEBUG(587, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy612;
		if (yych == 's') goto yy612;
		goto yy39;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy614;
		if (yych == 'n') goto yy614;
		goto yy39;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy615;
		if (yych == 'f') goto yy615;
		goto yy39;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy617;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy618;
		if (yych == 'n') goto yy618;
		goto yy39;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy619;
		if (yych == 'm') goto yy619;
		goto yy73;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy620;
		if (yych == 'n') goto yy620;
		goto yy39;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy621;
		if (yych == 'm') goto yy621;
		goto yy39;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy622;
		goto yy39;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy624;
		if (yych == 'c') goto yy624;
		goto yy39;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy625;
		if (yych == 'c') goto yy625;
		goto yy39;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy617:
		YYDEBUG(617, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy73;
			if (yych <= 'Z') goto yy626;
			if (yych <= '^') goto yy73;
			goto yy626;
		} else {
			if (yych <= '`') goto yy73;
			if (yych <= 'z') goto yy626;
			if (yych <= 0x7F) goto yy73;
			goto yy626;
		}
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy628;
		if (yych == 'c') goto yy628;
		goto yy39;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy629;
				goto yy73;
			} else {
				if (yych <= '@') goto yy629;
				if (yych <= 'Z') goto yy73;
				goto yy629;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy73;
				goto yy629;
			} else {
				if (yych <= 'z') goto yy73;
				if (yych <= 0x7F) goto yy629;
				goto yy73;
			}
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy630;
		goto yy39;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy631;
		if (yych == 'p') goto yy631;
		goto yy39;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy632;
		if (yych == 'e') goto yy632;
		goto yy39;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy633;
		if (yych == 'e') goto yy633;
		goto yy39;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 83;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy627;
				if (yych <= '9') goto yy626;
			} else {
				if (yych <= 'Z') goto yy626;
				if (yych >= '\\') goto yy617;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy626;
			} else {
				if (yych <= 'z') goto yy626;
				if (yych >= 0x80) goto yy626;
			}
		}
yy627:
		YYDEBUG(627, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy635;
		if (yych == 'e') goto yy635;
		goto yy39;
yy629:
		YYDEBUG(629, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy637;
		goto yy39;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy639;
		if (yych == 'i') goto yy639;
		goto yy39;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy640;
		goto yy39;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy641;
		if (yych == 'l') goto yy641;
		goto yy39;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy642;
		goto yy39;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy644;
		if (yych == 'e') goto yy644;
		goto yy39;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy645;
		if (yych != 'r') goto yy39;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yyaccept = 88;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy38;
		}
		if (yych == '\\') goto yy122;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(647, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy649;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy650;
			} else {
				if (yych <= '?') goto yy651;
				if (yych >= 'A') goto yy652;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy652;
			} else {
				if (yych <= 'z') goto yy652;
				if (yych >= 0x80) goto yy652;
			}
		}
		++YYCURSOR;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy649:
		YYDEBUG(649, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy649;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy653;
		goto yy648;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy654;
		goto yy648;
yy652:
		YYDEBUG(652, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy652;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy653:
		YYDEBUG(653, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy655;
		YYCURSOR = YYMARKER;
		goto yy648;
yy655:
		YYDEBUG(655, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(656, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy658;
		} else {
			if (yych <= '`') goto yy659;
			if (yych == '{') goto yy660;
		}
		++YYCURSOR;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy657;
			if (yych <= 'Z') goto yy661;
			if (yych <= '^') goto yy657;
			goto yy661;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy657;
				goto yy661;
			} else {
				if (yych <= '{') goto yy663;
				if (yych <= 0x7F) goto yy657;
				goto yy661;
			}
		}
yy659:
		YYDEBUG(659, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy664;
		goto yy657;
yy661:
		YYDEBUG(661, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy661;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy665;
		} else {
			if (yych <= '?') goto yy667;
			if (yych <= '@') goto yy662;
			if (yych <= '[') goto yy668;
		}
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy664:
		YYDEBUG(664, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy669;
yy666:
		YYDEBUG(666, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy662;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy670;
		goto yy666;
yy668:
		YYDEBUG(668, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy666;
			if (yych <= 'Z') goto yy671;
			if (yych <= '^') goto yy666;
			goto yy671;
		} else {
			if (yych <= '`') goto yy666;
			if (yych <= 'z') goto yy671;
			if (yych <= 0x7F) goto yy666;
			goto yy671;
		}
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy672;
		goto yy666;
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy666;
			if (yych <= 'Z') goto yy673;
			if (yych <= '^') goto yy666;
		} else {
			if (yych <= '`') goto yy666;
			if (yych <= 'z') goto yy673;
			if (yych <= 0x7F) goto yy666;
		}
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(674, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy676;
		} else {
			if (yych <= '$') goto yy677;
			if (yych == '{') goto yy678;
		}
		++YYCURSOR;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy675;
			if (yych <= 'Z') goto yy679;
			if (yych <= '^') goto yy675;
			goto yy679;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy675;
				goto yy679;
			} else {
				if (yych <= '{') goto yy681;
				if (yych <= 0x7F) goto yy675;
				goto yy679;
			}
		}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy682;
		goto yy675;
yy679:
		YYDEBUG(679, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy679;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy683;
		} else {
			if (yych <= '?') goto yy685;
			if (yych <= '@') goto yy680;
			if (yych <= '[') goto yy686;
		}
yy680:
		YYDEBUG(680, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy687;
yy684:
		YYDEBUG(684, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy680;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy688;
		goto yy684;
yy686:
		YYDEBUG(686, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy684;
			if (yych <= 'Z') goto yy689;
			if (yych <= '^') goto yy684;
			goto yy689;
		} else {
			if (yych <= '`') goto yy684;
			if (yych <= 'z') goto yy689;
			if (yych <= 0x7F) goto yy684;
			goto yy689;
		}
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy690;
		goto yy684;
yy689:
		YYDEBUG(689, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy684;
			if (yych <= 'Z') goto yy691;
			if (yych <= '^') goto yy684;
		} else {
			if (yych <= '`') goto yy684;
			if (yych <= 'z') goto yy691;
			if (yych <= 0x7F) goto yy684;
		}
yy691:
		YYDEBUG(691, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(692, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy694;
		if (yych == '{') goto yy695;
		++YYCURSOR;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy693;
			if (yych <= 'Z') goto yy696;
			if (yych <= '^') goto yy693;
			goto yy696;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy693;
				goto yy696;
			} else {
				if (yych <= '{') goto yy698;
				if (yych <= 0x7F) goto yy693;
				goto yy696;
			}
		}
yy695:
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy699;
		goto yy693;
yy696:
		YYDEBUG(696, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy696;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy700;
		} else {
			if (yych <= '?') goto yy702;
			if (yych <= '@') goto yy697;
			if (yych <= '[') goto yy703;
		}
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy698:
		YYDEBUG(698, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy704;
yy701:
		YYDEBUG(701, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy697;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy705;
		goto yy701;
yy703:
		YYDEBUG(703, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy701;
			if (yych <= 'Z') goto yy706;
			if (yych <= '^') goto yy701;
			goto yy706;
		} else {
			if (yych <= '`') goto yy701;
			if (yych <= 'z') goto yy706;
			if (yych <= 0x7F) goto yy701;
			goto yy706;
		}
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy707;
		goto yy701;
yy706:
		YYDEBUG(706, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy701;
			if (yych <= 'Z') goto yy708;
			if (yych <= '^') goto yy701;
		} else {
			if (yych <= '`') goto yy701;
			if (yych <= 'z') goto yy708;
			if (yych <= 0x7F) goto yy701;
		}
yy708:
		YYDEBUG(708, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(709, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy710;
			if (yych <= 'Z') goto yy712;
			if (yych >= '_') goto yy712;
		} else {
			if (yych <= '`') goto yy710;
			if (yych <= 'z') goto yy712;
			if (yych >= 0x80) goto yy712;
		}
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy711;
				if (yych <= '9') goto yy714;
				goto yy711;
			} else {
				if (yych <= '[') goto yy714;
				if (yych <= '^') goto yy711;
				goto yy714;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy711;
				if (yych <= 'z') goto yy714;
				goto yy711;
			} else {
				if (yych <= '}') goto yy714;
				if (yych <= 0x7F) goto yy711;
				goto yy714;
			}
		}
yy713:
		YYDEBUG(713, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy714:
		YYDEBUG(714, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy713;
		}
		if (yych <= '@') goto yy715;
		if (yych <= '[') goto yy716;
		if (yych == '}') goto yy716;
yy715:
		YYDEBUG(715, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy711;
yy716:
		YYDEBUG(716, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,   0, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(717, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy718;
					if (yych <= '\n') goto yy719;
				} else {
					if (yych <= '\r') goto yy719;
					if (yych >= ' ') goto yy719;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy720;
					if (yych <= '#') goto yy719;
					goto yy722;
				} else {
					if (yych == '\'') goto yy719;
					if (yych <= '/') goto yy720;
					goto yy723;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy725;
					if (yych <= '@') goto yy720;
					goto yy726;
				} else {
					if (yych <= '[') goto yy720;
					if (yych <= '\\') goto yy719;
					goto yy727;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy726;
					goto yy720;
				} else {
					if (yych <= 'z') goto yy726;
					if (yych <= '~') goto yy720;
					if (yych >= 0x80) goto yy726;
				}
			}
		}
yy718:
		YYDEBUG(718, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy721;
			if (yych <= 'Z') goto yy728;
			if (yych <= '^') goto yy721;
			goto yy728;
		} else {
			if (yych <= '`') goto yy721;
			if (yych <= 'z') goto yy728;
			if (yych <= 0x7F) goto yy721;
			goto yy728;
		}
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'A') {
				if (yych <= '/') goto yy724;
				if (yych <= '9') goto yy730;
			} else {
				if (yych <= 'B') goto yy732;
				if (yych >= 'X') goto yy734;
			}
		} else {
			if (yych <= 'a') {
				if (yych == '_') goto yy735;
			} else {
				if (yych <= 'b') goto yy732;
				if (yych == 'x') goto yy734;
			}
		}
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy725;
		}
		if (yych == '_') goto yy735;
		goto yy724;
yy726:
		YYDEBUG(726, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy726;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy728;
			} else {
				if (yych <= '@') goto yy729;
				if (yych <= 'Z') goto yy728;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy728;
			} else {
				if (yych <= 'z') goto yy728;
				if (yych >= 0x80) goto yy728;
			}
		}
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy730:
		YYDEBUG(730, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy731;
		if (yych <= '9') goto yy730;
		if (yych == '_') goto yy735;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy732:
		YYDEBUG(732, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy736;
		}
yy733:
		YYDEBUG(733, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy724;
		} else {
			goto yy731;
		}
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy737;
		}
		goto yy733;
yy735:
		YYDEBUG(735, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy733;
		if (yych <= '9') goto yy730;
		goto yy733;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy736;
		}
		if (yych == '_') goto yy732;
		goto yy731;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy737;
		}
		if (yych == '_') goto yy734;
		goto yy731;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(738, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy740;
		++YYCURSOR;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy739;
yy741:
		YYDEBUG(741, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy741;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(742, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy744;
	++YYCURSOR;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy743;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy746;
	} else {
		if (yych <= 'P') goto yy747;
		if (yych == 'p') goto yy747;
	}
yy745:
	YYDEBUG(745, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy746:
	YYDEBUG(746, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy749;
	if (yych == 'h') goto yy749;
yy748:
	YYDEBUG(748, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy745;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy750;
	if (yych != 'p') goto yy748;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy751;
		if (yych <= '\n') goto yy752;
	} else {
		if (yych <= '\r') goto yy754;
		if (yych == ' ') goto yy752;
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy752:
	YYDEBUG(752, *YYCURSOR);
	++YYCURSOR;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy752;
	goto yy753;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(755, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(756, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident.offset = SCNG(yy_text) - SCNG(yy_start);
		elem->ident.len = SCNG(yy_leng);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
