.\" zip_get_file_extra.mdoc \-- get extra field for file in zip
.\" Copyright (C) 2006-2011 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_GET_FILE_EXTRA 3 "February 13, 2011" NiH
.SH "NAME"
zip_get_file_extra \- get extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
const char *
zip_get_file_extra(struct zip *archive, zip_uint64_t index); \
"int *lenp" "int flags"
.SH "DESCRIPTION"
The
zip_get_file_extra
function returns the extra field for the file at position
\fBindex\fR
in the zip archive.
This pointer should not be modified or
free(3)
Ap d.
If
\fBlenp\fR
is not
\fBNULL,\fR
the integer to which it points will be set to the length of the
extra.
If
\fBflags\fR
is set to
\fBZIP_FL_UNCHANGED,\fR
the original unchanged extra field is returned.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the extra field is returned,
or
\fBNULL\fR
if there is no extra field.
In case of an error,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_get_file_extra
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
\fBindex\fR
is not a valid file index in
\fBarchive.\fR
.RE
.SH "SEE ALSO"
libzip(3),
zip_set_file_extra(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
