.\" $XTermId: koi8rxterm.man,v 1.4 2011/08/16 09:44:32 tom Exp $
.\"
.\" Copyright 2004 Branden Robinson
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" SOFTWARE IN THE PUBLIC INTEREST, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.TH koi8rxterm 1 "2004-12-19" "Debian Project"
.SH NAME
koi8rxterm \- X terminal emulator for KOI8-R environments
.SH SYNOPSIS
.B koi8rxterm
[
.I xterm-options
]
.SH DESCRIPTION
.B koi8rxterm
is a wrapper around the
.BR xterm(1)
program that invokes the latter program with the \(oqKOI8R__default_class__\(cq X
resource class set.
All arguments to
.B koi8rxterm
are passed to
.B xterm
without processing; the
.B \-class
and
.B \-k8
options should not be specified because they are used by the wrapper.
See the
.BR xterm
manual page for more information on
.IR xterm-options .
.PP
The environment's locale settings (see \(lqENVIRONMENT\(rq below) are
used to discern the locale's character set.
If no current locale can be determined, the locale \(oqru_RU.KOI8-R\(cq
(the Russian language as used in the territory of Russia, with the KOI8-R
character set) is assumed.
The
.BR locale(1)
utility is used to determine whether the system supports the selected
locale.
If it does not,
.B koi8rxterm
will exit with an error and report the output of
.BR locale .
.PP
.B Note: koi8rxterm
may produce unexpected results if the current locale is set to one in which
the KOI8-R character encoding is not supported, or if fonts using that
encoding are not available.
In the Debian system, the \(oqxfonts\-cyrillic\(cq package provides the
fonts that
.B koi8rxterm
uses by default.
To change the fonts
.B koi8rxterm
uses, edit the
.I __apploaddir__/KOI8R__default_class__
file.
.PP
A similar wrapper,
.BR uxterm(1),
is available for Unicode UTF-8 environments.
.SH ENVIRONMENT
.TP
.B LC_ALL\fR, \fBLC_CTYPE\fR, \fBLANG
The values of these variables are checked, in order, to determine the
character set used by the current locale.
.SH AUTHOR
.B koi8rxterm
was written by Branden Robinson and is very heavily based on
.BR uxterm ,
by Thomas Dickey.
The assistance of Jurij Smakov was invaluable in sanity-checking its
operation.
.SH "SEE ALSO"
.BR locale(1),
.BR locale(7),
.BR uxterm(1),
.BR xterm(1)
