/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_samr.h"

static bool api_samr_Connect(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Connect *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CONNECT];

	r = talloc(talloc_tos(), struct samr_Connect);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect, r);
	}

	ZERO_STRUCT(r->out);
	r->out.connect_handle = talloc_zero(r, struct policy_handle);
	if (r->out.connect_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_Connect(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Close(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Close *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CLOSE];

	r = talloc(talloc_tos(), struct samr_Close);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Close, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _samr_Close(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Close, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetSecurity(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetSecurity *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETSECURITY];

	r = talloc(talloc_tos(), struct samr_SetSecurity);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetSecurity, r);
	}

	r->out.result = _samr_SetSecurity(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetSecurity, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QuerySecurity(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QuerySecurity *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYSECURITY];

	r = talloc(talloc_tos(), struct samr_QuerySecurity);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QuerySecurity, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sdbuf = talloc_zero(r, struct sec_desc_buf *);
	if (r->out.sdbuf == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QuerySecurity(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QuerySecurity, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Shutdown(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Shutdown *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SHUTDOWN];

	r = talloc(talloc_tos(), struct samr_Shutdown);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Shutdown, r);
	}

	r->out.result = _samr_Shutdown(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Shutdown, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_LookupDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_LookupDomain *r;

	call = &ndr_table_samr.calls[NDR_SAMR_LOOKUPDOMAIN];

	r = talloc(talloc_tos(), struct samr_LookupDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupDomain, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid2 *);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_LookupDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_EnumDomains(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_EnumDomains *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ENUMDOMAINS];

	r = talloc(talloc_tos(), struct samr_EnumDomains);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomains, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.sam = talloc_zero(r, struct samr_SamArray *);
	if (r->out.sam == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_entries = talloc_zero(r, uint32_t);
	if (r->out.num_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_EnumDomains(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomains, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_OpenDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_OpenDomain *r;

	call = &ndr_table_samr.calls[NDR_SAMR_OPENDOMAIN];

	r = talloc(talloc_tos(), struct samr_OpenDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenDomain, r);
	}

	ZERO_STRUCT(r->out);
	r->out.domain_handle = talloc_zero(r, struct policy_handle);
	if (r->out.domain_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_OpenDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryDomainInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryDomainInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYDOMAININFO];

	r = talloc(talloc_tos(), struct samr_QueryDomainInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDomainInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_DomainInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryDomainInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDomainInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetDomainInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetDomainInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETDOMAININFO];

	r = talloc(talloc_tos(), struct samr_SetDomainInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetDomainInfo, r);
	}

	r->out.result = _samr_SetDomainInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetDomainInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_CreateDomainGroup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_CreateDomainGroup *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CREATEDOMAINGROUP];

	r = talloc(talloc_tos(), struct samr_CreateDomainGroup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateDomainGroup, r);
	}

	ZERO_STRUCT(r->out);
	r->out.group_handle = talloc_zero(r, struct policy_handle);
	if (r->out.group_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_CreateDomainGroup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateDomainGroup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_EnumDomainGroups(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_EnumDomainGroups *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ENUMDOMAINGROUPS];

	r = talloc(talloc_tos(), struct samr_EnumDomainGroups);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainGroups, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.sam = talloc_zero(r, struct samr_SamArray *);
	if (r->out.sam == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_entries = talloc_zero(r, uint32_t);
	if (r->out.num_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_EnumDomainGroups(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainGroups, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_CreateUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_CreateUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CREATEUSER];

	r = talloc(talloc_tos(), struct samr_CreateUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateUser, r);
	}

	ZERO_STRUCT(r->out);
	r->out.user_handle = talloc_zero(r, struct policy_handle);
	if (r->out.user_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_CreateUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_EnumDomainUsers(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_EnumDomainUsers *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ENUMDOMAINUSERS];

	r = talloc(talloc_tos(), struct samr_EnumDomainUsers);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainUsers, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.sam = talloc_zero(r, struct samr_SamArray *);
	if (r->out.sam == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_entries = talloc_zero(r, uint32_t);
	if (r->out.num_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_EnumDomainUsers(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainUsers, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_CreateDomAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_CreateDomAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CREATEDOMALIAS];

	r = talloc(talloc_tos(), struct samr_CreateDomAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateDomAlias, r);
	}

	ZERO_STRUCT(r->out);
	r->out.alias_handle = talloc_zero(r, struct policy_handle);
	if (r->out.alias_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_CreateDomAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateDomAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_EnumDomainAliases(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_EnumDomainAliases *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ENUMDOMAINALIASES];

	r = talloc(talloc_tos(), struct samr_EnumDomainAliases);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainAliases, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.sam = talloc_zero(r, struct samr_SamArray *);
	if (r->out.sam == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_entries = talloc_zero(r, uint32_t);
	if (r->out.num_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_EnumDomainAliases(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainAliases, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetAliasMembership(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetAliasMembership *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETALIASMEMBERSHIP];

	r = talloc(talloc_tos(), struct samr_GetAliasMembership);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetAliasMembership, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rids = talloc_zero(r, struct samr_Ids);
	if (r->out.rids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetAliasMembership(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetAliasMembership, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_LookupNames(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_LookupNames *r;

	call = &ndr_table_samr.calls[NDR_SAMR_LOOKUPNAMES];

	r = talloc(talloc_tos(), struct samr_LookupNames);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupNames, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rids = talloc_zero(r, struct samr_Ids);
	if (r->out.rids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.types = talloc_zero(r, struct samr_Ids);
	if (r->out.types == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_LookupNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupNames, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_LookupRids(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_LookupRids *r;

	call = &ndr_table_samr.calls[NDR_SAMR_LOOKUPRIDS];

	r = talloc(talloc_tos(), struct samr_LookupRids);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupRids, r);
	}

	ZERO_STRUCT(r->out);
	r->out.names = talloc_zero(r, struct lsa_Strings);
	if (r->out.names == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.types = talloc_zero(r, struct samr_Ids);
	if (r->out.types == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_LookupRids(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupRids, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_OpenGroup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_OpenGroup *r;

	call = &ndr_table_samr.calls[NDR_SAMR_OPENGROUP];

	r = talloc(talloc_tos(), struct samr_OpenGroup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenGroup, r);
	}

	ZERO_STRUCT(r->out);
	r->out.group_handle = talloc_zero(r, struct policy_handle);
	if (r->out.group_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_OpenGroup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenGroup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryGroupInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryGroupInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYGROUPINFO];

	r = talloc(talloc_tos(), struct samr_QueryGroupInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryGroupInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_GroupInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryGroupInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryGroupInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetGroupInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetGroupInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETGROUPINFO];

	r = talloc(talloc_tos(), struct samr_SetGroupInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetGroupInfo, r);
	}

	r->out.result = _samr_SetGroupInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetGroupInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_AddGroupMember(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_AddGroupMember *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ADDGROUPMEMBER];

	r = talloc(talloc_tos(), struct samr_AddGroupMember);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddGroupMember, r);
	}

	r->out.result = _samr_AddGroupMember(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddGroupMember, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_DeleteDomainGroup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_DeleteDomainGroup *r;

	call = &ndr_table_samr.calls[NDR_SAMR_DELETEDOMAINGROUP];

	r = talloc(talloc_tos(), struct samr_DeleteDomainGroup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteDomainGroup, r);
	}

	ZERO_STRUCT(r->out);
	r->out.group_handle = r->in.group_handle;
	r->out.result = _samr_DeleteDomainGroup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteDomainGroup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_DeleteGroupMember(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_DeleteGroupMember *r;

	call = &ndr_table_samr.calls[NDR_SAMR_DELETEGROUPMEMBER];

	r = talloc(talloc_tos(), struct samr_DeleteGroupMember);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteGroupMember, r);
	}

	r->out.result = _samr_DeleteGroupMember(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteGroupMember, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryGroupMember(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryGroupMember *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYGROUPMEMBER];

	r = talloc(talloc_tos(), struct samr_QueryGroupMember);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryGroupMember, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rids = talloc_zero(r, struct samr_RidTypeArray *);
	if (r->out.rids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryGroupMember(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryGroupMember, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetMemberAttributesOfGroup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetMemberAttributesOfGroup *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP];

	r = talloc(talloc_tos(), struct samr_SetMemberAttributesOfGroup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetMemberAttributesOfGroup, r);
	}

	r->out.result = _samr_SetMemberAttributesOfGroup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetMemberAttributesOfGroup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_OpenAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_OpenAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_OPENALIAS];

	r = talloc(talloc_tos(), struct samr_OpenAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenAlias, r);
	}

	ZERO_STRUCT(r->out);
	r->out.alias_handle = talloc_zero(r, struct policy_handle);
	if (r->out.alias_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_OpenAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryAliasInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryAliasInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYALIASINFO];

	r = talloc(talloc_tos(), struct samr_QueryAliasInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryAliasInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_AliasInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryAliasInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryAliasInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetAliasInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetAliasInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETALIASINFO];

	r = talloc(talloc_tos(), struct samr_SetAliasInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetAliasInfo, r);
	}

	r->out.result = _samr_SetAliasInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetAliasInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_DeleteDomAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_DeleteDomAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_DELETEDOMALIAS];

	r = talloc(talloc_tos(), struct samr_DeleteDomAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteDomAlias, r);
	}

	ZERO_STRUCT(r->out);
	r->out.alias_handle = r->in.alias_handle;
	r->out.result = _samr_DeleteDomAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteDomAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_AddAliasMember(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_AddAliasMember *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ADDALIASMEMBER];

	r = talloc(talloc_tos(), struct samr_AddAliasMember);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddAliasMember, r);
	}

	r->out.result = _samr_AddAliasMember(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddAliasMember, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_DeleteAliasMember(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_DeleteAliasMember *r;

	call = &ndr_table_samr.calls[NDR_SAMR_DELETEALIASMEMBER];

	r = talloc(talloc_tos(), struct samr_DeleteAliasMember);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteAliasMember, r);
	}

	r->out.result = _samr_DeleteAliasMember(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteAliasMember, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetMembersInAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetMembersInAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETMEMBERSINALIAS];

	r = talloc(talloc_tos(), struct samr_GetMembersInAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetMembersInAlias, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = talloc_zero(r, struct lsa_SidArray);
	if (r->out.sids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetMembersInAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetMembersInAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_OpenUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_OpenUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_OPENUSER];

	r = talloc(talloc_tos(), struct samr_OpenUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenUser, r);
	}

	ZERO_STRUCT(r->out);
	r->out.user_handle = talloc_zero(r, struct policy_handle);
	if (r->out.user_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_OpenUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_DeleteUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_DeleteUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_DELETEUSER];

	r = talloc(talloc_tos(), struct samr_DeleteUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteUser, r);
	}

	ZERO_STRUCT(r->out);
	r->out.user_handle = r->in.user_handle;
	r->out.result = _samr_DeleteUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryUserInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryUserInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYUSERINFO];

	r = talloc(talloc_tos(), struct samr_QueryUserInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryUserInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_UserInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryUserInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryUserInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetUserInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetUserInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETUSERINFO];

	r = talloc(talloc_tos(), struct samr_SetUserInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetUserInfo, r);
	}

	r->out.result = _samr_SetUserInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetUserInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_ChangePasswordUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_ChangePasswordUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CHANGEPASSWORDUSER];

	r = talloc(talloc_tos(), struct samr_ChangePasswordUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser, r);
	}

	r->out.result = _samr_ChangePasswordUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetGroupsForUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetGroupsForUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETGROUPSFORUSER];

	r = talloc(talloc_tos(), struct samr_GetGroupsForUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetGroupsForUser, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rids = talloc_zero(r, struct samr_RidWithAttributeArray *);
	if (r->out.rids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetGroupsForUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetGroupsForUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryDisplayInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryDisplayInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYDISPLAYINFO];

	r = talloc(talloc_tos(), struct samr_QueryDisplayInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.total_size = talloc_zero(r, uint32_t);
	if (r->out.total_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.returned_size = talloc_zero(r, uint32_t);
	if (r->out.returned_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info = talloc_zero(r, union samr_DispInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryDisplayInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetDisplayEnumerationIndex(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetDisplayEnumerationIndex *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETDISPLAYENUMERATIONINDEX];

	r = talloc(talloc_tos(), struct samr_GetDisplayEnumerationIndex);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDisplayEnumerationIndex, r);
	}

	ZERO_STRUCT(r->out);
	r->out.idx = talloc_zero(r, uint32_t);
	if (r->out.idx == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetDisplayEnumerationIndex(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDisplayEnumerationIndex, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_TestPrivateFunctionsDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_TestPrivateFunctionsDomain *r;

	call = &ndr_table_samr.calls[NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN];

	r = talloc(talloc_tos(), struct samr_TestPrivateFunctionsDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_TestPrivateFunctionsDomain, r);
	}

	r->out.result = _samr_TestPrivateFunctionsDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_TestPrivateFunctionsDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_TestPrivateFunctionsUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_TestPrivateFunctionsUser *r;

	call = &ndr_table_samr.calls[NDR_SAMR_TESTPRIVATEFUNCTIONSUSER];

	r = talloc(talloc_tos(), struct samr_TestPrivateFunctionsUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_TestPrivateFunctionsUser, r);
	}

	r->out.result = _samr_TestPrivateFunctionsUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_TestPrivateFunctionsUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetUserPwInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetUserPwInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETUSERPWINFO];

	r = talloc(talloc_tos(), struct samr_GetUserPwInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetUserPwInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct samr_PwInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetUserPwInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetUserPwInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_RemoveMemberFromForeignDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_RemoveMemberFromForeignDomain *r;

	call = &ndr_table_samr.calls[NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN];

	r = talloc(talloc_tos(), struct samr_RemoveMemberFromForeignDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RemoveMemberFromForeignDomain, r);
	}

	r->out.result = _samr_RemoveMemberFromForeignDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RemoveMemberFromForeignDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryDomainInfo2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryDomainInfo2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYDOMAININFO2];

	r = talloc(talloc_tos(), struct samr_QueryDomainInfo2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDomainInfo2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_DomainInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryDomainInfo2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDomainInfo2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryUserInfo2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryUserInfo2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYUSERINFO2];

	r = talloc(talloc_tos(), struct samr_QueryUserInfo2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryUserInfo2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union samr_UserInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryUserInfo2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryUserInfo2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryDisplayInfo2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryDisplayInfo2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYDISPLAYINFO2];

	r = talloc(talloc_tos(), struct samr_QueryDisplayInfo2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.total_size = talloc_zero(r, uint32_t);
	if (r->out.total_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.returned_size = talloc_zero(r, uint32_t);
	if (r->out.returned_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info = talloc_zero(r, union samr_DispInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryDisplayInfo2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetDisplayEnumerationIndex2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetDisplayEnumerationIndex2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETDISPLAYENUMERATIONINDEX2];

	r = talloc(talloc_tos(), struct samr_GetDisplayEnumerationIndex2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDisplayEnumerationIndex2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.idx = talloc_zero(r, uint32_t);
	if (r->out.idx == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetDisplayEnumerationIndex2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDisplayEnumerationIndex2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_CreateUser2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_CreateUser2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CREATEUSER2];

	r = talloc(talloc_tos(), struct samr_CreateUser2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateUser2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.user_handle = talloc_zero(r, struct policy_handle);
	if (r->out.user_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.access_granted = talloc_zero(r, uint32_t);
	if (r->out.access_granted == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_CreateUser2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateUser2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_QueryDisplayInfo3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_QueryDisplayInfo3 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_QUERYDISPLAYINFO3];

	r = talloc(talloc_tos(), struct samr_QueryDisplayInfo3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.total_size = talloc_zero(r, uint32_t);
	if (r->out.total_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.returned_size = talloc_zero(r, uint32_t);
	if (r->out.returned_size == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info = talloc_zero(r, union samr_DispInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_QueryDisplayInfo3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo3, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_AddMultipleMembersToAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_AddMultipleMembersToAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS];

	r = talloc(talloc_tos(), struct samr_AddMultipleMembersToAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddMultipleMembersToAlias, r);
	}

	r->out.result = _samr_AddMultipleMembersToAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddMultipleMembersToAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_RemoveMultipleMembersFromAlias(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_RemoveMultipleMembersFromAlias *r;

	call = &ndr_table_samr.calls[NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS];

	r = talloc(talloc_tos(), struct samr_RemoveMultipleMembersFromAlias);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RemoveMultipleMembersFromAlias, r);
	}

	r->out.result = _samr_RemoveMultipleMembersFromAlias(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RemoveMultipleMembersFromAlias, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_OemChangePasswordUser2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_OemChangePasswordUser2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_OEMCHANGEPASSWORDUSER2];

	r = talloc(talloc_tos(), struct samr_OemChangePasswordUser2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OemChangePasswordUser2, r);
	}

	r->out.result = _samr_OemChangePasswordUser2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OemChangePasswordUser2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_ChangePasswordUser2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_ChangePasswordUser2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CHANGEPASSWORDUSER2];

	r = talloc(talloc_tos(), struct samr_ChangePasswordUser2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser2, r);
	}

	r->out.result = _samr_ChangePasswordUser2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetDomPwInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetDomPwInfo *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETDOMPWINFO];

	r = talloc(talloc_tos(), struct samr_GetDomPwInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDomPwInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct samr_PwInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetDomPwInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDomPwInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Connect2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Connect2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CONNECT2];

	r = talloc(talloc_tos(), struct samr_Connect2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.connect_handle = talloc_zero(r, struct policy_handle);
	if (r->out.connect_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_Connect2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetUserInfo2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetUserInfo2 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETUSERINFO2];

	r = talloc(talloc_tos(), struct samr_SetUserInfo2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetUserInfo2, r);
	}

	r->out.result = _samr_SetUserInfo2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetUserInfo2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetBootKeyInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetBootKeyInformation *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETBOOTKEYINFORMATION];

	r = talloc(talloc_tos(), struct samr_SetBootKeyInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetBootKeyInformation, r);
	}

	r->out.result = _samr_SetBootKeyInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetBootKeyInformation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_GetBootKeyInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_GetBootKeyInformation *r;

	call = &ndr_table_samr.calls[NDR_SAMR_GETBOOTKEYINFORMATION];

	r = talloc(talloc_tos(), struct samr_GetBootKeyInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetBootKeyInformation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.unknown = talloc_zero(r, uint32_t);
	if (r->out.unknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_GetBootKeyInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetBootKeyInformation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Connect3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Connect3 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CONNECT3];

	r = talloc(talloc_tos(), struct samr_Connect3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.connect_handle = talloc_zero(r, struct policy_handle);
	if (r->out.connect_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_Connect3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect3, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Connect4(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Connect4 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CONNECT4];

	r = talloc(talloc_tos(), struct samr_Connect4);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect4, r);
	}

	ZERO_STRUCT(r->out);
	r->out.connect_handle = talloc_zero(r, struct policy_handle);
	if (r->out.connect_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_Connect4(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect4, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_ChangePasswordUser3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_ChangePasswordUser3 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CHANGEPASSWORDUSER3];

	r = talloc(talloc_tos(), struct samr_ChangePasswordUser3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.dominfo = talloc_zero(r, struct samr_DomInfo1 *);
	if (r->out.dominfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.reject = talloc_zero(r, struct samr_ChangeReject *);
	if (r->out.reject == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_ChangePasswordUser3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser3, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_Connect5(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_Connect5 *r;

	call = &ndr_table_samr.calls[NDR_SAMR_CONNECT5];

	r = talloc(talloc_tos(), struct samr_Connect5);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect5, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info_out = talloc_zero(r, union samr_ConnectInfo);
	if (r->out.info_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.connect_handle = talloc_zero(r, struct policy_handle);
	if (r->out.connect_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_Connect5(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect5, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_RidToSid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_RidToSid *r;

	call = &ndr_table_samr.calls[NDR_SAMR_RIDTOSID];

	r = talloc(talloc_tos(), struct samr_RidToSid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RidToSid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid2 *);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_RidToSid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RidToSid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_SetDsrmPassword(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_SetDsrmPassword *r;

	call = &ndr_table_samr.calls[NDR_SAMR_SETDSRMPASSWORD];

	r = talloc(talloc_tos(), struct samr_SetDsrmPassword);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetDsrmPassword, r);
	}

	r->out.result = _samr_SetDsrmPassword(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetDsrmPassword, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_samr_ValidatePassword(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct samr_ValidatePassword *r;

	call = &ndr_table_samr.calls[NDR_SAMR_VALIDATEPASSWORD];

	r = talloc(talloc_tos(), struct samr_ValidatePassword);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ValidatePassword, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rep = talloc_zero(r, union samr_ValidatePasswordRep *);
	if (r->out.rep == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _samr_ValidatePassword(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ValidatePassword, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_samr_cmds[] = 
{
	{"SAMR_CONNECT", NDR_SAMR_CONNECT, api_samr_Connect},
	{"SAMR_CLOSE", NDR_SAMR_CLOSE, api_samr_Close},
	{"SAMR_SETSECURITY", NDR_SAMR_SETSECURITY, api_samr_SetSecurity},
	{"SAMR_QUERYSECURITY", NDR_SAMR_QUERYSECURITY, api_samr_QuerySecurity},
	{"SAMR_SHUTDOWN", NDR_SAMR_SHUTDOWN, api_samr_Shutdown},
	{"SAMR_LOOKUPDOMAIN", NDR_SAMR_LOOKUPDOMAIN, api_samr_LookupDomain},
	{"SAMR_ENUMDOMAINS", NDR_SAMR_ENUMDOMAINS, api_samr_EnumDomains},
	{"SAMR_OPENDOMAIN", NDR_SAMR_OPENDOMAIN, api_samr_OpenDomain},
	{"SAMR_QUERYDOMAININFO", NDR_SAMR_QUERYDOMAININFO, api_samr_QueryDomainInfo},
	{"SAMR_SETDOMAININFO", NDR_SAMR_SETDOMAININFO, api_samr_SetDomainInfo},
	{"SAMR_CREATEDOMAINGROUP", NDR_SAMR_CREATEDOMAINGROUP, api_samr_CreateDomainGroup},
	{"SAMR_ENUMDOMAINGROUPS", NDR_SAMR_ENUMDOMAINGROUPS, api_samr_EnumDomainGroups},
	{"SAMR_CREATEUSER", NDR_SAMR_CREATEUSER, api_samr_CreateUser},
	{"SAMR_ENUMDOMAINUSERS", NDR_SAMR_ENUMDOMAINUSERS, api_samr_EnumDomainUsers},
	{"SAMR_CREATEDOMALIAS", NDR_SAMR_CREATEDOMALIAS, api_samr_CreateDomAlias},
	{"SAMR_ENUMDOMAINALIASES", NDR_SAMR_ENUMDOMAINALIASES, api_samr_EnumDomainAliases},
	{"SAMR_GETALIASMEMBERSHIP", NDR_SAMR_GETALIASMEMBERSHIP, api_samr_GetAliasMembership},
	{"SAMR_LOOKUPNAMES", NDR_SAMR_LOOKUPNAMES, api_samr_LookupNames},
	{"SAMR_LOOKUPRIDS", NDR_SAMR_LOOKUPRIDS, api_samr_LookupRids},
	{"SAMR_OPENGROUP", NDR_SAMR_OPENGROUP, api_samr_OpenGroup},
	{"SAMR_QUERYGROUPINFO", NDR_SAMR_QUERYGROUPINFO, api_samr_QueryGroupInfo},
	{"SAMR_SETGROUPINFO", NDR_SAMR_SETGROUPINFO, api_samr_SetGroupInfo},
	{"SAMR_ADDGROUPMEMBER", NDR_SAMR_ADDGROUPMEMBER, api_samr_AddGroupMember},
	{"SAMR_DELETEDOMAINGROUP", NDR_SAMR_DELETEDOMAINGROUP, api_samr_DeleteDomainGroup},
	{"SAMR_DELETEGROUPMEMBER", NDR_SAMR_DELETEGROUPMEMBER, api_samr_DeleteGroupMember},
	{"SAMR_QUERYGROUPMEMBER", NDR_SAMR_QUERYGROUPMEMBER, api_samr_QueryGroupMember},
	{"SAMR_SETMEMBERATTRIBUTESOFGROUP", NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP, api_samr_SetMemberAttributesOfGroup},
	{"SAMR_OPENALIAS", NDR_SAMR_OPENALIAS, api_samr_OpenAlias},
	{"SAMR_QUERYALIASINFO", NDR_SAMR_QUERYALIASINFO, api_samr_QueryAliasInfo},
	{"SAMR_SETALIASINFO", NDR_SAMR_SETALIASINFO, api_samr_SetAliasInfo},
	{"SAMR_DELETEDOMALIAS", NDR_SAMR_DELETEDOMALIAS, api_samr_DeleteDomAlias},
	{"SAMR_ADDALIASMEMBER", NDR_SAMR_ADDALIASMEMBER, api_samr_AddAliasMember},
	{"SAMR_DELETEALIASMEMBER", NDR_SAMR_DELETEALIASMEMBER, api_samr_DeleteAliasMember},
	{"SAMR_GETMEMBERSINALIAS", NDR_SAMR_GETMEMBERSINALIAS, api_samr_GetMembersInAlias},
	{"SAMR_OPENUSER", NDR_SAMR_OPENUSER, api_samr_OpenUser},
	{"SAMR_DELETEUSER", NDR_SAMR_DELETEUSER, api_samr_DeleteUser},
	{"SAMR_QUERYUSERINFO", NDR_SAMR_QUERYUSERINFO, api_samr_QueryUserInfo},
	{"SAMR_SETUSERINFO", NDR_SAMR_SETUSERINFO, api_samr_SetUserInfo},
	{"SAMR_CHANGEPASSWORDUSER", NDR_SAMR_CHANGEPASSWORDUSER, api_samr_ChangePasswordUser},
	{"SAMR_GETGROUPSFORUSER", NDR_SAMR_GETGROUPSFORUSER, api_samr_GetGroupsForUser},
	{"SAMR_QUERYDISPLAYINFO", NDR_SAMR_QUERYDISPLAYINFO, api_samr_QueryDisplayInfo},
	{"SAMR_GETDISPLAYENUMERATIONINDEX", NDR_SAMR_GETDISPLAYENUMERATIONINDEX, api_samr_GetDisplayEnumerationIndex},
	{"SAMR_TESTPRIVATEFUNCTIONSDOMAIN", NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN, api_samr_TestPrivateFunctionsDomain},
	{"SAMR_TESTPRIVATEFUNCTIONSUSER", NDR_SAMR_TESTPRIVATEFUNCTIONSUSER, api_samr_TestPrivateFunctionsUser},
	{"SAMR_GETUSERPWINFO", NDR_SAMR_GETUSERPWINFO, api_samr_GetUserPwInfo},
	{"SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN", NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN, api_samr_RemoveMemberFromForeignDomain},
	{"SAMR_QUERYDOMAININFO2", NDR_SAMR_QUERYDOMAININFO2, api_samr_QueryDomainInfo2},
	{"SAMR_QUERYUSERINFO2", NDR_SAMR_QUERYUSERINFO2, api_samr_QueryUserInfo2},
	{"SAMR_QUERYDISPLAYINFO2", NDR_SAMR_QUERYDISPLAYINFO2, api_samr_QueryDisplayInfo2},
	{"SAMR_GETDISPLAYENUMERATIONINDEX2", NDR_SAMR_GETDISPLAYENUMERATIONINDEX2, api_samr_GetDisplayEnumerationIndex2},
	{"SAMR_CREATEUSER2", NDR_SAMR_CREATEUSER2, api_samr_CreateUser2},
	{"SAMR_QUERYDISPLAYINFO3", NDR_SAMR_QUERYDISPLAYINFO3, api_samr_QueryDisplayInfo3},
	{"SAMR_ADDMULTIPLEMEMBERSTOALIAS", NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS, api_samr_AddMultipleMembersToAlias},
	{"SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS", NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS, api_samr_RemoveMultipleMembersFromAlias},
	{"SAMR_OEMCHANGEPASSWORDUSER2", NDR_SAMR_OEMCHANGEPASSWORDUSER2, api_samr_OemChangePasswordUser2},
	{"SAMR_CHANGEPASSWORDUSER2", NDR_SAMR_CHANGEPASSWORDUSER2, api_samr_ChangePasswordUser2},
	{"SAMR_GETDOMPWINFO", NDR_SAMR_GETDOMPWINFO, api_samr_GetDomPwInfo},
	{"SAMR_CONNECT2", NDR_SAMR_CONNECT2, api_samr_Connect2},
	{"SAMR_SETUSERINFO2", NDR_SAMR_SETUSERINFO2, api_samr_SetUserInfo2},
	{"SAMR_SETBOOTKEYINFORMATION", NDR_SAMR_SETBOOTKEYINFORMATION, api_samr_SetBootKeyInformation},
	{"SAMR_GETBOOTKEYINFORMATION", NDR_SAMR_GETBOOTKEYINFORMATION, api_samr_GetBootKeyInformation},
	{"SAMR_CONNECT3", NDR_SAMR_CONNECT3, api_samr_Connect3},
	{"SAMR_CONNECT4", NDR_SAMR_CONNECT4, api_samr_Connect4},
	{"SAMR_CHANGEPASSWORDUSER3", NDR_SAMR_CHANGEPASSWORDUSER3, api_samr_ChangePasswordUser3},
	{"SAMR_CONNECT5", NDR_SAMR_CONNECT5, api_samr_Connect5},
	{"SAMR_RIDTOSID", NDR_SAMR_RIDTOSID, api_samr_RidToSid},
	{"SAMR_SETDSRMPASSWORD", NDR_SAMR_SETDSRMPASSWORD, api_samr_SetDsrmPassword},
	{"SAMR_VALIDATEPASSWORD", NDR_SAMR_VALIDATEPASSWORD, api_samr_ValidatePassword},
};

void samr_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_samr_cmds;
	*n_fns = sizeof(api_samr_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_samr_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_SAMR_CONNECT: {
			struct samr_Connect *r = (struct samr_Connect *)_r;
			ZERO_STRUCT(r->out);
			r->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.connect_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_Connect(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CLOSE: {
			struct samr_Close *r = (struct samr_Close *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = r->in.handle;
			r->out.result = _samr_Close(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETSECURITY: {
			struct samr_SetSecurity *r = (struct samr_SetSecurity *)_r;
			r->out.result = _samr_SetSecurity(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYSECURITY: {
			struct samr_QuerySecurity *r = (struct samr_QuerySecurity *)_r;
			ZERO_STRUCT(r->out);
			r->out.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf *);
			if (r->out.sdbuf == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QuerySecurity(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SHUTDOWN: {
			struct samr_Shutdown *r = (struct samr_Shutdown *)_r;
			r->out.result = _samr_Shutdown(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_LOOKUPDOMAIN: {
			struct samr_LookupDomain *r = (struct samr_LookupDomain *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid2 *);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_LookupDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ENUMDOMAINS: {
			struct samr_EnumDomains *r = (struct samr_EnumDomains *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
			if (r->out.sam == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.num_entries = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_EnumDomains(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_OPENDOMAIN: {
			struct samr_OpenDomain *r = (struct samr_OpenDomain *)_r;
			ZERO_STRUCT(r->out);
			r->out.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.domain_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_OpenDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYDOMAININFO: {
			struct samr_QueryDomainInfo *r = (struct samr_QueryDomainInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_DomainInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryDomainInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETDOMAININFO: {
			struct samr_SetDomainInfo *r = (struct samr_SetDomainInfo *)_r;
			r->out.result = _samr_SetDomainInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CREATEDOMAINGROUP: {
			struct samr_CreateDomainGroup *r = (struct samr_CreateDomainGroup *)_r;
			ZERO_STRUCT(r->out);
			r->out.group_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.group_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.rid = talloc_zero(mem_ctx, uint32_t);
			if (r->out.rid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_CreateDomainGroup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ENUMDOMAINGROUPS: {
			struct samr_EnumDomainGroups *r = (struct samr_EnumDomainGroups *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
			if (r->out.sam == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.num_entries = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_EnumDomainGroups(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CREATEUSER: {
			struct samr_CreateUser *r = (struct samr_CreateUser *)_r;
			ZERO_STRUCT(r->out);
			r->out.user_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.user_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.rid = talloc_zero(mem_ctx, uint32_t);
			if (r->out.rid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_CreateUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ENUMDOMAINUSERS: {
			struct samr_EnumDomainUsers *r = (struct samr_EnumDomainUsers *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
			if (r->out.sam == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.num_entries = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_EnumDomainUsers(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CREATEDOMALIAS: {
			struct samr_CreateDomAlias *r = (struct samr_CreateDomAlias *)_r;
			ZERO_STRUCT(r->out);
			r->out.alias_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.alias_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.rid = talloc_zero(mem_ctx, uint32_t);
			if (r->out.rid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_CreateDomAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ENUMDOMAINALIASES: {
			struct samr_EnumDomainAliases *r = (struct samr_EnumDomainAliases *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
			if (r->out.sam == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.num_entries = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_EnumDomainAliases(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETALIASMEMBERSHIP: {
			struct samr_GetAliasMembership *r = (struct samr_GetAliasMembership *)_r;
			ZERO_STRUCT(r->out);
			r->out.rids = talloc_zero(mem_ctx, struct samr_Ids);
			if (r->out.rids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetAliasMembership(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_LOOKUPNAMES: {
			struct samr_LookupNames *r = (struct samr_LookupNames *)_r;
			ZERO_STRUCT(r->out);
			r->out.rids = talloc_zero(mem_ctx, struct samr_Ids);
			if (r->out.rids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.types = talloc_zero(mem_ctx, struct samr_Ids);
			if (r->out.types == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_LookupNames(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_LOOKUPRIDS: {
			struct samr_LookupRids *r = (struct samr_LookupRids *)_r;
			ZERO_STRUCT(r->out);
			r->out.names = talloc_zero(mem_ctx, struct lsa_Strings);
			if (r->out.names == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.types = talloc_zero(mem_ctx, struct samr_Ids);
			if (r->out.types == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_LookupRids(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_OPENGROUP: {
			struct samr_OpenGroup *r = (struct samr_OpenGroup *)_r;
			ZERO_STRUCT(r->out);
			r->out.group_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.group_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_OpenGroup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYGROUPINFO: {
			struct samr_QueryGroupInfo *r = (struct samr_QueryGroupInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_GroupInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryGroupInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETGROUPINFO: {
			struct samr_SetGroupInfo *r = (struct samr_SetGroupInfo *)_r;
			r->out.result = _samr_SetGroupInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ADDGROUPMEMBER: {
			struct samr_AddGroupMember *r = (struct samr_AddGroupMember *)_r;
			r->out.result = _samr_AddGroupMember(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_DELETEDOMAINGROUP: {
			struct samr_DeleteDomainGroup *r = (struct samr_DeleteDomainGroup *)_r;
			ZERO_STRUCT(r->out);
			r->out.group_handle = r->in.group_handle;
			r->out.result = _samr_DeleteDomainGroup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_DELETEGROUPMEMBER: {
			struct samr_DeleteGroupMember *r = (struct samr_DeleteGroupMember *)_r;
			r->out.result = _samr_DeleteGroupMember(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYGROUPMEMBER: {
			struct samr_QueryGroupMember *r = (struct samr_QueryGroupMember *)_r;
			ZERO_STRUCT(r->out);
			r->out.rids = talloc_zero(mem_ctx, struct samr_RidTypeArray *);
			if (r->out.rids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryGroupMember(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP: {
			struct samr_SetMemberAttributesOfGroup *r = (struct samr_SetMemberAttributesOfGroup *)_r;
			r->out.result = _samr_SetMemberAttributesOfGroup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_OPENALIAS: {
			struct samr_OpenAlias *r = (struct samr_OpenAlias *)_r;
			ZERO_STRUCT(r->out);
			r->out.alias_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.alias_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_OpenAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYALIASINFO: {
			struct samr_QueryAliasInfo *r = (struct samr_QueryAliasInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_AliasInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryAliasInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETALIASINFO: {
			struct samr_SetAliasInfo *r = (struct samr_SetAliasInfo *)_r;
			r->out.result = _samr_SetAliasInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_DELETEDOMALIAS: {
			struct samr_DeleteDomAlias *r = (struct samr_DeleteDomAlias *)_r;
			ZERO_STRUCT(r->out);
			r->out.alias_handle = r->in.alias_handle;
			r->out.result = _samr_DeleteDomAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ADDALIASMEMBER: {
			struct samr_AddAliasMember *r = (struct samr_AddAliasMember *)_r;
			r->out.result = _samr_AddAliasMember(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_DELETEALIASMEMBER: {
			struct samr_DeleteAliasMember *r = (struct samr_DeleteAliasMember *)_r;
			r->out.result = _samr_DeleteAliasMember(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETMEMBERSINALIAS: {
			struct samr_GetMembersInAlias *r = (struct samr_GetMembersInAlias *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
			if (r->out.sids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetMembersInAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_OPENUSER: {
			struct samr_OpenUser *r = (struct samr_OpenUser *)_r;
			ZERO_STRUCT(r->out);
			r->out.user_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.user_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_OpenUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_DELETEUSER: {
			struct samr_DeleteUser *r = (struct samr_DeleteUser *)_r;
			ZERO_STRUCT(r->out);
			r->out.user_handle = r->in.user_handle;
			r->out.result = _samr_DeleteUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYUSERINFO: {
			struct samr_QueryUserInfo *r = (struct samr_QueryUserInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_UserInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryUserInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETUSERINFO: {
			struct samr_SetUserInfo *r = (struct samr_SetUserInfo *)_r;
			r->out.result = _samr_SetUserInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CHANGEPASSWORDUSER: {
			struct samr_ChangePasswordUser *r = (struct samr_ChangePasswordUser *)_r;
			r->out.result = _samr_ChangePasswordUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETGROUPSFORUSER: {
			struct samr_GetGroupsForUser *r = (struct samr_GetGroupsForUser *)_r;
			ZERO_STRUCT(r->out);
			r->out.rids = talloc_zero(mem_ctx, struct samr_RidWithAttributeArray *);
			if (r->out.rids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetGroupsForUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYDISPLAYINFO: {
			struct samr_QueryDisplayInfo *r = (struct samr_QueryDisplayInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.total_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.total_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.returned_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.returned_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.info = talloc_zero(mem_ctx, union samr_DispInfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryDisplayInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETDISPLAYENUMERATIONINDEX: {
			struct samr_GetDisplayEnumerationIndex *r = (struct samr_GetDisplayEnumerationIndex *)_r;
			ZERO_STRUCT(r->out);
			r->out.idx = talloc_zero(mem_ctx, uint32_t);
			if (r->out.idx == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetDisplayEnumerationIndex(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN: {
			struct samr_TestPrivateFunctionsDomain *r = (struct samr_TestPrivateFunctionsDomain *)_r;
			r->out.result = _samr_TestPrivateFunctionsDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_TESTPRIVATEFUNCTIONSUSER: {
			struct samr_TestPrivateFunctionsUser *r = (struct samr_TestPrivateFunctionsUser *)_r;
			r->out.result = _samr_TestPrivateFunctionsUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETUSERPWINFO: {
			struct samr_GetUserPwInfo *r = (struct samr_GetUserPwInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, struct samr_PwInfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetUserPwInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN: {
			struct samr_RemoveMemberFromForeignDomain *r = (struct samr_RemoveMemberFromForeignDomain *)_r;
			r->out.result = _samr_RemoveMemberFromForeignDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYDOMAININFO2: {
			struct samr_QueryDomainInfo2 *r = (struct samr_QueryDomainInfo2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_DomainInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryDomainInfo2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYUSERINFO2: {
			struct samr_QueryUserInfo2 *r = (struct samr_QueryUserInfo2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union samr_UserInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryUserInfo2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYDISPLAYINFO2: {
			struct samr_QueryDisplayInfo2 *r = (struct samr_QueryDisplayInfo2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.total_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.total_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.returned_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.returned_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.info = talloc_zero(mem_ctx, union samr_DispInfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryDisplayInfo2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETDISPLAYENUMERATIONINDEX2: {
			struct samr_GetDisplayEnumerationIndex2 *r = (struct samr_GetDisplayEnumerationIndex2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.idx = talloc_zero(mem_ctx, uint32_t);
			if (r->out.idx == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetDisplayEnumerationIndex2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CREATEUSER2: {
			struct samr_CreateUser2 *r = (struct samr_CreateUser2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.user_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.user_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.access_granted = talloc_zero(mem_ctx, uint32_t);
			if (r->out.access_granted == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.rid = talloc_zero(mem_ctx, uint32_t);
			if (r->out.rid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_CreateUser2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_QUERYDISPLAYINFO3: {
			struct samr_QueryDisplayInfo3 *r = (struct samr_QueryDisplayInfo3 *)_r;
			ZERO_STRUCT(r->out);
			r->out.total_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.total_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.returned_size = talloc_zero(mem_ctx, uint32_t);
			if (r->out.returned_size == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.info = talloc_zero(mem_ctx, union samr_DispInfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_QueryDisplayInfo3(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS: {
			struct samr_AddMultipleMembersToAlias *r = (struct samr_AddMultipleMembersToAlias *)_r;
			r->out.result = _samr_AddMultipleMembersToAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS: {
			struct samr_RemoveMultipleMembersFromAlias *r = (struct samr_RemoveMultipleMembersFromAlias *)_r;
			r->out.result = _samr_RemoveMultipleMembersFromAlias(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_OEMCHANGEPASSWORDUSER2: {
			struct samr_OemChangePasswordUser2 *r = (struct samr_OemChangePasswordUser2 *)_r;
			r->out.result = _samr_OemChangePasswordUser2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CHANGEPASSWORDUSER2: {
			struct samr_ChangePasswordUser2 *r = (struct samr_ChangePasswordUser2 *)_r;
			r->out.result = _samr_ChangePasswordUser2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETDOMPWINFO: {
			struct samr_GetDomPwInfo *r = (struct samr_GetDomPwInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, struct samr_PwInfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetDomPwInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CONNECT2: {
			struct samr_Connect2 *r = (struct samr_Connect2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.connect_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_Connect2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETUSERINFO2: {
			struct samr_SetUserInfo2 *r = (struct samr_SetUserInfo2 *)_r;
			r->out.result = _samr_SetUserInfo2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETBOOTKEYINFORMATION: {
			struct samr_SetBootKeyInformation *r = (struct samr_SetBootKeyInformation *)_r;
			r->out.result = _samr_SetBootKeyInformation(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_GETBOOTKEYINFORMATION: {
			struct samr_GetBootKeyInformation *r = (struct samr_GetBootKeyInformation *)_r;
			ZERO_STRUCT(r->out);
			r->out.unknown = talloc_zero(mem_ctx, uint32_t);
			if (r->out.unknown == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_GetBootKeyInformation(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CONNECT3: {
			struct samr_Connect3 *r = (struct samr_Connect3 *)_r;
			ZERO_STRUCT(r->out);
			r->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.connect_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_Connect3(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CONNECT4: {
			struct samr_Connect4 *r = (struct samr_Connect4 *)_r;
			ZERO_STRUCT(r->out);
			r->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.connect_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_Connect4(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CHANGEPASSWORDUSER3: {
			struct samr_ChangePasswordUser3 *r = (struct samr_ChangePasswordUser3 *)_r;
			ZERO_STRUCT(r->out);
			r->out.dominfo = talloc_zero(mem_ctx, struct samr_DomInfo1 *);
			if (r->out.dominfo == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.reject = talloc_zero(mem_ctx, struct samr_ChangeReject *);
			if (r->out.reject == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_ChangePasswordUser3(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_CONNECT5: {
			struct samr_Connect5 *r = (struct samr_Connect5 *)_r;
			ZERO_STRUCT(r->out);
			r->out.level_out = talloc_zero(mem_ctx, uint32_t);
			if (r->out.level_out == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.info_out = talloc_zero(mem_ctx, union samr_ConnectInfo);
			if (r->out.info_out == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.connect_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_Connect5(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_RIDTOSID: {
			struct samr_RidToSid *r = (struct samr_RidToSid *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid2 *);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_RidToSid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_SETDSRMPASSWORD: {
			struct samr_SetDsrmPassword *r = (struct samr_SetDsrmPassword *)_r;
			r->out.result = _samr_SetDsrmPassword(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SAMR_VALIDATEPASSWORD: {
			struct samr_ValidatePassword *r = (struct samr_ValidatePassword *)_r;
			ZERO_STRUCT(r->out);
			r->out.rep = talloc_zero(mem_ctx, union samr_ValidatePasswordRep *);
			if (r->out.rep == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _samr_ValidatePassword(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_samr_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "samr", "samr", &ndr_table_samr, api_samr_cmds, sizeof(api_samr_cmds) / sizeof(struct api_struct));
}
