
#include <QtTest/QtTest>
#include <QPaintEvent>
#include <QSlider>
#include <iostream>

#include "phpqt_internals.h"
#include "unittests.h"

#include <zend.h>
#include "smokephp.h"


extern Smoke* qt_Smoke;

TestPHPQt::TestPHPQt( SmokeBinding* binding, zval* z )
  : _binding(binding), _z(z), _smoke( qt_Smoke )
{
  std::cout << "setting up unittests" << std::endl;
}

TestPHPQt::~TestPHPQt()
{
}

/*
 * test case for invoking virtual methods
 * QWidget::paintEvent( QPaintEvent* x1 );
 * 
 * smoke code:
 * virtual void paintEvent(QPaintEvent* x1) 
 * {
 *       Smoke::StackItem x[2];
 *       x[1].s_class = (void*)x1;
 *       if(this->_binding->callMethod(18732, (void*)this, x)) return;
 *       this->QWidget::paintEvent(x1);
 * }
 */

void TestPHPQt::InvokeVirtualMethod()
{
  QPaintEvent x1( QRect( 0,0,10,10 ) );
  void* p = PHPQt::getQtObjectFromZval( _z );

  // QWidget paintEvent
  Smoke::ModuleIndex method = _smoke->findMethod( "QWidget", "paintEvent#" );
  Smoke::Index index = _smoke->methodMaps[ method.index ].method;

  Smoke::StackItem x[2];
  x[1].s_class = (void*) &x1;
  for(int i = 0; i < 80; i++){
    _binding->callMethod( index, p, x );
  }
  std::cout << std::endl;
}

void TestPHPQt::InvokeSlot()
{
  QSlider* slider = static_cast< QSlider* > ( PHPQt::getQtObjectFromZval( _z ) );

  zval* arg;
  MAKE_STD_ZVAL( arg );
  ZVAL_LONG( arg, 7 );
  zval** args = (zval**) safe_emalloc( sizeof( zval* ), 1, 0 );
  args[0] = arg;

  // last argument is just a dummy here
  PHPQt::callPHPMethod( _z, QString("setupConnections").toLatin1().constData(), 0, args );

  for(int i = 0; i < 80; i++ )
    {
      PHPQt::callPHPMethod( _z, QString("invokeSetValue").toLatin1().constData(), 1, args );
    }
  std::cout << std::endl;
  FREE_ZVAL( arg );
  efree( args );
}
