//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  When a KXmlGuiWindow is passed to the constructor, the XMLGUI
    ///  defined context menu <code>akonadi_collectionview_contextmenu</code> is
    ///  used if available.
    ///  Example:
    ///  @code
    ///  class MyWindow : public KXmlGuiWindow
    ///  {
    ///    public     MyWindow()
    ///     {
    ///       Akonadi.CollectionView view = new Akonadi.CollectionView( this, this );
    ///       setCentralWidget( view );
    ///       Akonadi.CollectionModel model = new Akonadi.CollectionModel( this );
    ///       view.SetModel( model );
    ///     }
    ///  }
    ///  @endcode
    ///  See <see cref="ICollectionViewSignals"></see> for signals emitted by CollectionView
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> A view to show a collection tree provided by a CollectionModel. </short>
    [SmokeClass("Akonadi::CollectionView")]
    public class CollectionView : QTreeView, IDisposable {
        protected CollectionView(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CollectionView), this);
        }
        /// <remarks>
        ///  Creates a new collection view.
        /// <param> name="parent" The parent widget.
        ///      </param></remarks>        <short>    Creates a new collection view.</short>
        public CollectionView(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionView#", "CollectionView(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public CollectionView() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionView", "CollectionView()", typeof(void));
        }
        /// <remarks>
        ///  Creates a new collection view.
        /// <param> name="xmlGuiWindow" The KXmlGuiWindow the view is used in.
        ///                      This is needed for the XMLGUI based context menu.
        ///                      Passing 0 is ok and will disable the builtin context menu.
        /// </param><param> name="parent" The parent widget.
        ///      </param></remarks>        <short>    Creates a new collection view.</short>
        public CollectionView(KXmlGuiWindow xmlGuiWindow, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionView##", "CollectionView(KXmlGuiWindow*, QWidget*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow, typeof(QWidget), parent);
        }
        public CollectionView(KXmlGuiWindow xmlGuiWindow) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionView#", "CollectionView(KXmlGuiWindow*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow);
        }
        /// <remarks>
        ///  Sets the KXmlGuiWindow which the view is used in.
        ///  This is needed if you want to use the built-in context menu.
        /// <param> name="xmlGuiWindow" The KXmlGuiWindow the view is used in.
        ///      </param></remarks>        <short>    Sets the KXmlGuiWindow which the view is used in.</short>
        public void SetXmlGuiWindow(KXmlGuiWindow xmlGuiWindow) {
            interceptor.Invoke("setXmlGuiWindow#", "setXmlGuiWindow(KXmlGuiWindow*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow);
        }
        [SmokeMethod("setModel(QAbstractItemModel*)")]
        public override void SetModel(QAbstractItemModel model) {
            interceptor.Invoke("setModel#", "setModel(QAbstractItemModel*)", typeof(void), typeof(QAbstractItemModel), model);
        }
        [SmokeMethod("dragMoveEvent(QDragMoveEvent*)")]
        protected override void DragMoveEvent(QDragMoveEvent arg1) {
            interceptor.Invoke("dragMoveEvent#", "dragMoveEvent(QDragMoveEvent*)", typeof(void), typeof(QDragMoveEvent), arg1);
        }
        [SmokeMethod("dragLeaveEvent(QDragLeaveEvent*)")]
        protected override void DragLeaveEvent(QDragLeaveEvent arg1) {
            interceptor.Invoke("dragLeaveEvent#", "dragLeaveEvent(QDragLeaveEvent*)", typeof(void), typeof(QDragLeaveEvent), arg1);
        }
        [SmokeMethod("dropEvent(QDropEvent*)")]
        protected override void DropEvent(QDropEvent arg1) {
            interceptor.Invoke("dropEvent#", "dropEvent(QDropEvent*)", typeof(void), typeof(QDropEvent), arg1);
        }
        [SmokeMethod("contextMenuEvent(QContextMenuEvent*)")]
        protected override void ContextMenuEvent(QContextMenuEvent arg1) {
            interceptor.Invoke("contextMenuEvent#", "contextMenuEvent(QContextMenuEvent*)", typeof(void), typeof(QContextMenuEvent), arg1);
        }
        ~CollectionView() {
            interceptor.Invoke("~CollectionView", "~CollectionView()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~CollectionView", "~CollectionView()", typeof(void));
        }
        protected new ICollectionViewSignals Emit {
            get { return (ICollectionViewSignals) Q_EMIT; }
        }
    }

    public interface ICollectionViewSignals : IQTreeViewSignals {
        /// <remarks>
        ///  This signal is emitted whenever the user has clicked
        ///  a collection in the view.
        /// <param> name="collection" The clicked collection.
        ///      </param></remarks>        <short>    This signal is emitted whenever the user has clicked  a collection in the view.</short>
        [Q_SIGNAL("void clicked(Akonadi::Collection)")]
        void Clicked(Akonadi.Collection collection);
        /// <remarks>
        ///  This signal is emitted whenever the current collection
        ///  in the view has changed.
        /// <param> name="collection" The new current collection.
        ///      </param></remarks>        <short>    This signal is emitted whenever the current collection  in the view has changed.</short>
        [Q_SIGNAL("void currentChanged(Akonadi::Collection)")]
        void CurrentChanged(Akonadi.Collection collection);
    }
}
