#ifndef CRYPTSETUP_NLS_H
#define CRYPTSETUP_NLS_H

#ifndef LOCALEDIR
#define LOCALEDIR "/usr/share/locale"
#endif

#if HAVE_LOCALE_H
# include <locale.h>
#else
# undef setlocale
# define setlocale(Category, Locale) /* empty */
#endif

#if ENABLE_NLS
# include <libintl.h>
# define _(Text) gettext (Text)
# ifdef gettext_noop
#  define N_(String) gettext_noop (String)
# else
#  define N_(String) (String)
# endif
#else
# undef bindtextdomain
# define bindtextdomain(Domain, Directory) /* empty */
# undef textdomain
# define textdomain(Domain) /* empty */
# define _(Text) (Text)
# define N_(Text) (Text)
# define ngettext(Singular, Plural, Count) \
    ( (Count) == 1 ? (Singular) : (Plural) )
#endif

#endif /* CRYPTSETUP_NLS_H */
