/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer
implements Serializable {
    private static final long serialVersionUID = 8996673345831063337L;
    protected DragSource dragSource;
    protected Component component;
    protected transient DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList events;

    private /* synthetic */ void finit$() {
        this.events = new ArrayList();
    }

    protected DragGestureRecognizer(DragSource ds, Component c, int sa, DragGestureListener dgl) {
        this.finit$();
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = ds;
        this.component = c;
        this.sourceActions = sa;
        this.dragGestureListener = dgl;
    }

    protected DragGestureRecognizer(DragSource ds, Component c, int sa) {
        this(ds, c, sa, null);
    }

    protected DragGestureRecognizer(DragSource ds, Component c) {
        this(ds, c, 0, null);
    }

    protected DragGestureRecognizer(DragSource ds) {
        this(ds, null, 0, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component c) {
        this.component = c;
    }

    public int getSourceActions() {
        return this.sourceActions;
    }

    public void setSourceActions(int sa) {
        this.sourceActions = sa;
    }

    public InputEvent getTriggerEvent() {
        if (this.events.size() > 0) {
            return (InputEvent)this.events.get(0);
        }
        return null;
    }

    public void resetRecognizer() {
        throw new Error("not implemented");
    }

    public void addDragGestureListener(DragGestureListener dgl) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dgl;
    }

    public void removeDragGestureListener(DragGestureListener dgl) {
        if (this.dragGestureListener != dgl) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
    }

    protected void fireDragGestureRecognized(int dragAction, Point p) {
        throw new Error("not implemented");
    }

    protected void appendEvent(InputEvent e) {
        if (e == null) {
            return;
        }
        this.events.add(e);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.dragGestureListener = (DragGestureListener)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.dragGestureListener instanceof Serializable ? this.dragGestureListener : null);
    }
}

