/*#define DEBUG*/
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <glob.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "icons.h"
#include "input.h"
#include "menu.h"
#include "misc.h"
#include "refresh.h"
#include "reg.h"
#include "widgets.h"
#include "xfstab.h"
#include "bookmarks.h"

extern gchar *bookfile;

/* autotype entries will appear in file-menu and popup depending on
 * extension of selected item (if any). Notes:
 * -leave a blank at end of command if using arguments (to be safe) 
 * -keep entries with same extension together (so they all will appear)
 * -using NULL for input_query_text means that no input will be required
 * -using TRUE in the queued field will place it into the single queued, 
 *        where processes are run one at a time, sequentially.
 * 
 *  {char *extension,char *command,
 *  char *menu_label,char *input_query_text, gboolean queued} 
 * */
#if 1
/* here the extension is appendend to "$command $filename$extension $filename". if NULL, 
 * then  "$command $filename" is used */
autotype_t autotype_dir[]= {
	/* archive file extractions (queued) */
	{".tar.gz","tar -czf ",N_("Create tarball"),N_("Output dir"),1},
	{".iso","mkisofs -dDlLJNRTUP Created_by_XFce4_desktop -o ",N_("Create isofs"),N_("Output dir"),1},
	{NULL,NULL}
};
#endif

autotype_t autotype[]= {
	/* archive file extractions (queued) */
	{".tar.gz","tar -xzf ",N_("Extract files from"),N_("Extract into"),1},
	{".tar.gz","tar -tzf ","Tarball contents",NULL,1}, /* XXX remove when tarball expansion enabled */
	{".gz","gunzip",N_("Uncompress"),NULL,1},
	{".tar","tar -tf ","Tarball contents",NULL,1},/* XXX remove when tarball expansion enabled */
	{".tar","tar -xf ",N_("Extract files from"),N_("Extract into"),1},
	{".tar.bz2","tar --use-compress-program bunzip2 -xf",N_("Extract files from"),N_("Extract into"),1},
	{".bz2","bunzip2",N_("Uncompress"),NULL,1},
	{".Z","uncompress",N_("Uncompress"),NULL,1},
	{".ZIP","unzip",N_("Uncompress"),NULL,1},
	{".zip","unzip",N_("Uncompress"),NULL,1},
	
	{".tgz","tar -xzf ",N_("Extract files from"),N_("Extract into"),1},
	{".tgz","tar -tzf ","Tarball contents",NULL,1}, /* XXX remove when tarball expansion enabled */
#if 1
	{".iso","burncd -f /dev/acd0c -s max data ","burncd",NULL,1},
	{".iso","cdrecord -v speed=24 dev=0,0 ","cdrecord",NULL,1},
#endif
	
	/* FreeBSD package management (queued) */
#ifndef __linux__
#ifdef	__FreeBSD__
	{".tgz","pkg_info -dV ",N_("Package information"),NULL,1},
	{".tbz","pkg_info -dV ",N_("Package information"),NULL,1},
#else
	{".tgz","pkg_info -d ",N_("Package information"),NULL,1},
	{".tbz","pkg_info -d ",N_("Package information"),NULL,1},
#endif	/* !__FreeBSD__ */
	{".tgz","pkg_info -r ",N_("Package requirements"),NULL,1},
	{".tgz","pkg_info -L ",N_("Package contents"),NULL,1},
	{".tgz","pkg_update ",N_("Update package"),NULL,1},
	{".tgz","pkg_add ",N_("Install package"),NULL,1},
	{".tgz","pkg_add -f ",N_("Install package (force)"),NULL,1},
	
	{".tbz","pkg_info -r ",N_("Package requirements"),NULL,1},
	{".tbz","pkg_info -L ",N_("Package contents"),NULL,1},
	{".tbz","pkg_update ",N_("Update package"),NULL,1},
	{".tbz","pkg_add ",N_("Install package"),NULL,1},
	{".tbz","pkg_add -f ",N_("Install package (force)"),NULL,1},
#endif
#ifdef __linux__
	/* RedHat package management (queued) */
	{".rpm","rpm -q -i -p ",N_("Package information"),NULL,1},
	{".rpm","rpm -qR -p ",N_("Package requirements"),NULL,1},
	{".rpm","rpm -ql -p ",N_("Package contents"),NULL,1},
	{".rpm","rpm -U --percent ",N_("Update package"),NULL,1},
	{".rpm","rpm -U --percent --nodeps ",N_("Update package (nodeps)"),NULL,1},
	{".rpm","rpm -U --percent --force ",N_("Update package (force)"),NULL,1},
	{".rpm","rpm -i --percent ",N_("Install package"),NULL,1},
	{".rpm","rpm -i --percent --nodeps ",N_("Install package (nodeps)"),NULL,1},
	{".rpm","rpm -i --percent --force ",N_("Install package (force)"),NULL,1},
	/* Debian package management (queued) */
	{".deb","dpkg -i ",N_("Install package"),NULL,1},
#endif
	/* assorted packages (not queued) */
	{".lyx","lyx","lyx",NULL,0},
	{".ps","gv","gv",NULL,0},
	{".pdf","gv","gv",NULL,0},
	{".abw","abiword","abiword",NULL,0},
	{".rtf","abiword","abiword",NULL,0},
	{".rtf","oowriter","oowriter",NULL,0},
	{".rtf","swriter","swriter",NULL,0},
	{".dvi","xdvi","xdvi",NULL,0},
	{".html","mozilla","mozilla",NULL,0},
	{".html","dillo","dillo",NULL,0},
	{".html","netscape","netscape",NULL,0},
	{".sdw","oowriter","oowriter",NULL,0},
	{".sdw","swriter","swriter",NULL,0},
	{".doc","abiword","abiword",NULL,0},
	{".doc","oowriter","oowriter",NULL,0},
	{".doc","swriter","swriter",NULL,0},
	{".log","gvim","gvim",NULL,0},
	{".tex","gvim","gvim",NULL,0},
	{".txt","abiword","abiword",NULL,0},
	{".txt","oowriter","oowriter",NULL,0},
	{".txt","swriter","swriter",NULL,0},
	{".txt","emacs","emacs",NULL,0},
	{".txt","gvim","gvim",NULL,0},
	{".sdc","oocalc","oocalc",NULL,0},
	{".sxc","oocalc","oocalc",NULL,0},
	{".sdc","scalc","scalc",NULL,0},
	{".sxc","scalc","scalc",NULL,0},
	{".sh","gvim","gvim",NULL,0},
	{".py","gvim","gvim",NULL,0},
	{".bash","gvim","gvim",NULL,0},
	{".csh","gvim","gvim",NULL,0},
	{".pl","gvim","gvim",NULL,0},
	{".wav","soxplay","soxplay",NULL,0},

	{".bmp","display","display",NULL,0},
	{".eps","display","display",NULL,0},
	{".gif","display","display",NULL,0},
	{".tiff","display","display",NULL,0},
	{".tif","display","display",NULL,0},
	{".jpg","display","display",NULL,0},
	{".jpeg","display","display",NULL,0},
	{".png","display","display",NULL,0},
	{".xpm","display","display",NULL,0},

	{".gif","gimp","gimp",NULL,0},
	{".tiff","gimp","gimp",NULL,0},
	{".tif","gimp","gimp",NULL,0},
	{".jpg","gimp","gimp",NULL,0},
	{".jpeg","gimp","gimp",NULL,0},
	{".png","gimp","gimp",NULL,0},
	{".xpm","gimp","gimp",NULL,0},
	/*{"","","",NULL},*/
	{NULL,NULL}
};

/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
char *auto_C_name[]={
   "autotype_C1",
   "autotype_C2",
   "autotype_C3",
   "autotype_C4",
   "autotype_C5",
   "autotype_C6",
   "autotype_C7",
   "autotype_C8",
   "autotype_C9",
   "autotype_C10",
   NULL
};
/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
char *auto_CC_name[]={
   "autotype_CC1",
   "autotype_CC2",
   "autotype_CC3",
   "autotype_CC4",
   "autotype_CC5",
   "autotype_CC6",
   "autotype_CC7",
   "autotype_CC8",
   "autotype_CC9",
   "autotype_CC10",
   NULL
};
char *auto_D_name[]={
   "autotype_D1",
   "autotype_D2",
   "autotype_D3",
   "autotype_D4",
   "autotype_D5",
   "autotype_D6",
   "autotype_D7",
   "autotype_D8",
   "autotype_D9",
   "autotype_D10",
   NULL
};
/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
char *auto_DD_name[]={
   "autotype_DD1",
   "autotype_DD2",
   "autotype_DD3",
   "autotype_DD4",
   "autotype_DD5",
   "autotype_DD6",
   "autotype_DD7",
   "autotype_DD8",
   "autotype_DD9",
   "autotype_DD10",
   NULL
};

static gboolean invalid_input;
static gboolean local_stuff;
static gboolean remote_stuff;
static gchar *remote_pass=NULL;
static gchar *remote_location=NULL;
static GList *unselect_list=NULL;
static unsigned which_branch;

static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = get_tree_details(treeview);
/*    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);*/
    tree_entry_t *en = get_entry(treeview, iter);
/*    GtkTreeRowReference *reference;*/

    if(!en || IS_DUMMY_TYPE(en->type)){		    
         GtkTreeRowReference *reference=
		 gtk_tree_row_reference_new(model,path);
	 unselect_list = g_list_append(unselect_list, reference);    
	 return;
    }	    
    if (IS_PATH(en->type)) local_stuff=TRUE;
    if(IS_NETTHING(en->subtype)||IS_NETWORK_TYPE(en->type)){
	remote_stuff=TRUE;
	if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)||
			IS_XF_NETSHARE(en->subtype)){
	   gchar *server_pass=g_strdup(en->tag);
	   gchar *location=g_strdup(en->path);
	   if (local_stuff){
		   invalid_input=TRUE;
		   return;
	   }
	   if (!strchr(location+2,'/')) g_assert_not_reached();
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("DBG:location=%s\n",location);*/
	   if (!location || !strlen(location)) g_assert_not_reached();
   	   if (!remote_location)remote_location=location;
	   else {
	     if (strcmp(remote_location,location)!=0)invalid_input=TRUE;
	     g_free(location);location=NULL;
	   }
   	   if (!remote_pass)remote_pass=server_pass;
	   else {
	     if (strcmp(remote_pass,server_pass)!=0)invalid_input=TRUE;
	     g_free(server_pass);server_pass=NULL;
	   }
	}
    }
    if (local_stuff&&remote_stuff){
	   invalid_input=TRUE;
	   return;
    }
    tree_details->selectionOK++;
    return;
}



void do_select_popup(GtkTreeView * treeview, GtkTreePath *selectpath,gint32 t)
{
    GtkWidget *widget, *popup;
    GtkTreeIter iter;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);


    if(tree_details->loading)
	return;			/* there's a stop button, you know */
    invalid_input=FALSE;
    local_stuff=FALSE;
    remote_stuff=FALSE;
    remote_pass=NULL;
    remote_location=NULL;    
    tree_details->selectionOK=0;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    while (unselect_list){
	    GtkTreeRowReference *ref=(GtkTreeRowReference *)unselect_list->data;
	    GtkTreePath *tpath=gtk_tree_row_reference_get_path(ref);
	    gtk_tree_selection_unselect_path(selection,tpath);
    	    unselect_list = g_list_remove(unselect_list, ref);
	    gtk_tree_path_free(tpath);
	    gtk_tree_row_reference_free(ref);	    
    }
    if (invalid_input || tree_details->selectionOK==0) return;
    
    popup = lookup_widget(tree_details->window, "item22_menu");
    gtk_widget_hide_all(popup);

    if (tree_details->selectionOK>1){
	  showit(popup, "cut1");
	  showit(popup, "copy1");
	  showit(popup, "remove1");
 	  gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
   }
    
    else {
	    /* single item selected */
	    
	gtk_tree_selection_unselect_all(selection);
	gtk_tree_selection_select_path(selection, selectpath);
	gtk_tree_model_get_iter(treemodel, &iter, selectpath);
	gtk_tree_selection_select_iter(selection, &iter);
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    
	/* this instead will make the popup more volatile: */
	/*en = get_selected_entry(treeview, &iter);*/

	if(!en){
	     printf("DBG: no entry!\n");
	     return;
	}
	
	/*printf("DBG: toggle disabled\n");*/

	
    	enable_refresh_by_toggle(FALSE);

	/* FIXME: the following has to be simplified for maintanance */
		
	print_status_tmp(treeview, resolve_icon_small(en),  FILENAME(en), NULL);
	if(IS_PATH(en->type)){
	  turn_on(treeview);
          if (!(tree_details->preferences & SHOW_DOT)) showit(popup, "show_hidden1");
	  showit(popup, "tools1");	
	  showit(popup, "separator25");
	  showit(popup, "separator13");
	  showit(popup, "select_all2");	
	}
	if(IS_ROOT_TYPE(en->type)) {
		which_branch=0;
		if (IS_LOCAL_TYPE(en->type)) which_branch |= ACTIVATE_LOCAL;
		if (IS_APP_TYPE(en->type)) which_branch |= ACTIVATE_APPS;
		if (IS_BOOKMARK_TYPE(en->type)) which_branch |= ACTIVATE_BOOK;
		if (IS_FSTAB_TYPE(en->type)) which_branch |= ACTIVATE_FSTAB;
		if (IS_FIND_TYPE(en->type)) which_branch |= ACTIVATE_FIND;
		if (IS_NETWORK_TYPE(en->type)) which_branch |= ACTIVATE_SMB;
		if (IS_TRASH_TYPE(en->type)) which_branch |= ACTIVATE_TRASH;
		if (which_branch) showit(popup, "hide_branch");
	}

	if ((IS_APP_TYPE(en->type)||IS_FSTAB_TYPE(en->type))
		       	&& IS_ROOT_TYPE(en->type)){
	  showit(popup, "refresh3");	
	}
	if (IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type))
	{
	  int i=is_mounted(en->path);
	  showit(popup, "refresh3");	
	  if (i>=0){
	      if (i) showit(popup, "unmountP");
	      else showit(popup, "mountP");
	  } else {
	      if (IS_MOUNTED(en->type)) showit(popup, "unmountP");
	      else showit(popup, "mountP");
	  }
	}
	
	if (IS_NETWORK_TYPE(en->type)){
	    showit(popup, "refresh3");	
	}

	if (IS_BOOKMARK_TYPE(en->type)){
	   GtkTreeIter parent;
	   tree_entry_t *p_en;
	   /*get parent */
	   if(gtk_tree_model_iter_parent(treemodel, &parent, &iter)){
	     gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
	     if(IS_ROOT_TYPE(p_en->type))
		showit(popup, "remove_from_bookmarks");	 
	   }
	}
    
	if(IS_ROOT_TYPE(en->type) || IS_PATH(en->type) || IS_XF_FND(en->type)
			|| IS_NETTHING(en->subtype))
	{
		    /*printf("DBG:ROOT type\n");*/
	    if (IS_NETTHING(en->subtype)){
		showit(popup, "refresh3"); /* for netthings in bookmarks */
		showit(popup, "copy1");
		if (IS_NETDIR(en->subtype)||IS_XF_NETSHARE(en->subtype)) {
		    if (!(tree_details->preferences & SHOW_DOT)) showit(popup, "show_hidden1");
		    showit(popup, "separator25");
		    showit(popup, "separator13");
		    showit(popup, "select_all2");
		    showit(popup, "paste1");
		}
		showit(popup, "remove1");
		    
	    }
	    if(IS_PATH(en->type))
	    {
        	gchar *cmd=NULL;
      		reg_t *prg = reg_prog_by_file (en->path);
		showit(popup, "file1");
		showit(popup, "remove1");
		showit(popup, "refresh3");
		if (strrchr(en->path,'/') && IS_IMAGE(strrchr(en->path,'/')))
			showit(popup,"preview_this_image");
		if(!IS_BROKEN_LNK(en->type)) {
			int i;
			showit(popup, "open1");
			for (i=0;auto_C_name[i];i++)
				hideit(popup,auto_C_name[i]);
			for (i=0;auto_D_name[i];i++)
				hideit(popup,auto_D_name[i]);
			hideit(popup, "autotype_Prun");
			hideit(popup, "autotype_D");/* FIXME: these should be removed from glade gui*/
			hideit(popup, "autotype_R");
			showit(popup, "open_with_1");
		}
		if (IS_EXE(en->type) && !IS_DIR(en->type)) {
		  GtkWidget *label,*a=lookup_widget(popup,"autotype_Prun");
    		  label = gtk_bin_get_child(GTK_BIN(a));
		  cmd=g_strconcat(_("Execute")," ",
					  FILENAME(en),NULL);
		  gtk_label_set_text((GtkLabel *)label,my_utf_string(cmd));
		  g_free(cmd);cmd=NULL;
 		  showit(popup,"autotype_Prun");
		}
		showit(popup, "separator25");
		showit(popup, "separator13");
		showit(popup, "cut1");
		showit(popup, "cut1");
		showit(popup, "copy1");
		showit(popup, "paste1");
		hideit(popup, "scramble1");
		hideit(popup, "unscramble1");
      		if (prg && strlen(prg->app)) {
			/* look in registered programs first */
			/* FIXME: should check whether prg->app can be run
			 * before generating the menu entry... */
		  gchar *text;
		  GtkWidget *label,*a=lookup_widget(popup,"autotype_R");
    		  label = gtk_bin_get_child(GTK_BIN(a));
		  if (prg->arg) {
			  cmd=g_strconcat(prg->app," ",prg->arg,NULL);
					  /*" ", FILENAME(en),NULL);*/
		  }
		  else {
			  cmd=g_strconcat(prg->app, NULL);
					  /*" ",FILENAME(en),NULL);*/
		  }
		  text=g_strconcat(cmd," ",FILENAME(en),NULL);
		  gtk_label_set_text((GtkLabel *)label,my_utf_string(text));
		  g_free(text);text=NULL;
		  showit(popup, "autotype_R");
      	  	} 
		{/* autotypes */	      
      		   char *loc;
		   int i,j;
		   GtkWidget *label;
		   for (j=i=0;auto_C_name[j]&&autotype[i].extension;i++){
		       GtkWidget *a=lookup_widget(popup,auto_C_name[j]);
		       loc=strstr(en->path,autotype[i].extension);
		       if ((loc)&&(strcmp(loc,autotype[i].extension)==0)){
		           gchar *text,*prog;
    		  	   label = gtk_bin_get_child(GTK_BIN(a));
		           text=g_strconcat(_(autotype[i].label),
					   " ", FILENAME(en),
					   NULL);
			   gtk_label_set_text((GtkLabel *)label,
					   my_utf_string(text));
			   g_free(text); text=NULL;
			   prog=g_strdup(autotype[i].command);
			   if (strstr(prog," ")) prog=strtok(prog," ");
			   text=g_find_program_in_path(prog);
		  	   if (text && !(cmd && strcmp(prog,cmd)==0)) {
				   showit(popup, auto_C_name[j]);
			   }
			   g_free(text);text=NULL;
			   g_free(prog);prog=NULL;
			   g_free(cmd);cmd=NULL;
			   j++;
		       }
		   }
		}

		if(IS_TRASH_TYPE(en->type))
		{
		    showit(popup, "uncollect_from_trash");
		}

		if(IS_DIR(en->type))
		{
		    if (!(tree_details->preferences & IMAGE_PREVIEW)) 
			    showit(popup, "preview_images1");
		    if (IS_NETTHING(en->subtype) || HAS_HIDDEN(en->type)
			&& !(tree_details->preferences & SHOW_DOT)) 
			    showit(popup, "show_hidden1");
		    showit(popup, "sort2");
		    showit(popup, "collect_trash1");
		    showit(popup, "open_in_xffm1");
		    showit(popup, "open_in_terminal1");
		    /*showit(popup, "autotype_D");*/
		    hideit(popup, "print3");
		    hideit(popup, "touch2");
		    hideit(popup, "separador10");
		    hideit(popup, "salir2");
#if 1
		{/* autotypes_D */	      
      		   char *loc;
		   int i,j;
		   GtkWidget *label;
		   for (j=i=0;auto_D_name[j]&&autotype_dir[i].label;i++){
		       GtkWidget *a=lookup_widget(popup,auto_D_name[j]);
		       {
		           gchar *text,*prg;
    		  	   label = gtk_bin_get_child(GTK_BIN(a));
		           text=g_strconcat(_(autotype_dir[i].label),
					   " ", FILENAME(en),
					   NULL);
			   gtk_label_set_text((GtkLabel *)label,
					   my_utf_string(text));
			   g_free(text); text=NULL;
			   prg=g_strdup(autotype_dir[i].command);
			   if (strstr(prg," ")) prg=strtok(prg," ");
			   text=g_find_program_in_path(prg);
		  	   if (text) showit(popup, auto_D_name[j]);
			   g_free(text);text=NULL;
			   g_free(prg);prg=NULL;
			   j++;
		       }
		   }
		}
#endif
#if 0
		    {
        		GtkWidget *label;
        		gchar *text=NULL;
			GtkWidget *a=lookup_widget(popup,"autotype_D");
    			label = gtk_bin_get_child(GTK_BIN(a));
			//label=(GtkLabel *)(((GtkBin *)(a))->child);
			g_free(text);	    
		        text=g_strconcat(_("Create")," ",
					FILENAME(en),".tar.gz",NULL);
			gtk_label_set_text(GTK_LABEL(label),my_utf_string(text));
			g_free(text);
		    }		
#endif
		}
		else if (IS_FILE(en->type))
		{
		    char *p = strrchr(en->path, '.');

		    if(!IS_BROKEN_LNK(en->type))
		    {
			if(p && strcmp(p, ".cyt") == 0)
			    showit(popup, "unscramble1");
			else
			    showit(popup, "scramble1");
		    }
		    else
		    {
			hideit(popup, "print3");
			hideit(popup, "duplicate2");
			hideit(popup, "symlink2");
		    }
		    hideit(popup, "new2");
		    hideit(popup, "open_in_xffm1");
		    hideit(popup, "open_in_terminal1");
		    hideit(popup, "paste1");
		    hideit(popup, "separador10");
		    hideit(popup, "salir2");
		}
	    }
	    else if(IS_TRASH_TYPE(en->type))
	    {
		if(IS_ERASED_SPACE(en->type))
		{
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, "purge_trash"), TRUE);
		}
		else
		{
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, "purge_trash"), FALSE);
		}
		showit(popup, "sort2");
		showit(popup, "refresh3");
		showit(popup, "purge_trash");
		showit(popup, "uncollect_trash1");
		showit(popup, "separador12");
		showit(popup, "delete_all_trash1");
		/*showit(popup,"schred_all_trash1"); */
	    }
	    else if(IS_FIND_TYPE(en->type))
	    {
		if(IS_XF_FND(en->type))
		    showit(popup, "remove_from_results");
		else
		    showit(popup, "clear_all_results");
	    }
	    else if(IS_BOOKMARK_TYPE(en->type)&&IS_ROOT_TYPE(en->type))
	    {
		if(IS_ERASED_SPACE(en->type))
		{
		    /*printf("DBG:has erased space\n"); */
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, "purge_bookmarks1"), TRUE);
		}
		else
		{
		    /*printf("DBG:has not erased space\n"); */
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, "purge_bookmarks1"), FALSE);
		}		    
		    	
		showit(popup, "separator25");
		showit(popup, "separator13");
		showit(popup, "paste1");
		showit(popup, "refresh3");
		showit(popup, "sort2");
		showit(popup, "purge_bookmarks1");
		showit(popup, "clear_all_bookmarks");
		showit(popup, "save_book2");
		showit(popup, "open_book2");
	    }



	    
	    if(IS_DIR(en->type) || 
			    IS_TRASH_TYPE(en->type) || 
			    IS_BOOKMARK_TYPE(en->type))	{
		    char *n = "name1";
		    if(IS_SORT_SIZE(en->type))
			n = "size1";
		    else if(IS_SORT_TIME(en->type))
			n = "date1";
		    else if(IS_SORT_UID(en->type))
			n = "owner1";
		    else if(IS_SORT_GID(en->type))
			n = "group1";
		    widget = lookup_widget(tree_details->window, n);
		    gtk_check_menu_item_set_active(
				    GTK_CHECK_MENU_ITEM(widget), TRUE);				
	    }
	}

	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
			/*event->time);*/
	
	widget = lookup_widget(tree_details->window, "preview_images1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_IMAGES(en->type));
	widget = lookup_widget(tree_details->window, "subsort_by_file_type1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			IS_TYPE_SUBSORT(en->type));
	widget = lookup_widget(tree_details->window, "show_hidden1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_HIDDEN(en->type));
	widget = lookup_widget(tree_details->window, "ascending1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			IS_ASCENDING(en->type));
        /*printf("DBG: toggle enabled\n");*/
	enable_refresh_by_toggle(TRUE);
    }
    return;
}

void do_popup(GtkTreeView * treeview, GdkEventButton * event)
{
    GtkTreePath *selectpath;
    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
			    &selectpath, NULL, NULL, NULL))
	    do_select_popup(treeview, selectpath,event->time);
}

void
hide_branch_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
    switch (which_branch){
	   case ACTIVATE_BOOK:
		   erase_bookmark_root(treeview);
		   break;
	   case ACTIVATE_LOCAL:
		   erase_local_root(treeview);
		   break;
	   case ACTIVATE_SMB:
		   erase_network_root(treeview);
		   break;
	   case ACTIVATE_APPS:
		   erase_apps_root(treeview);
		   break;
	   case ACTIVATE_TRASH:
		   erase_trash_root(treeview);
		   break;
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	   case ACTIVATE_FSTAB:
		   erase_fstab_root(treeview);
		   break;
#endif
	   case ACTIVATE_FIND:
		   erase_find_root(treeview);
		   break;
	   default: return;

   }
}

void
on_tools_menu                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
    gboolean trash=find_root(treeview,ROOT_TRASH);
    gboolean book=find_root(treeview,ROOT_BOOKMARKS);
    gboolean find=find_root(treeview,ROOT_FIND);
    if (trash){
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"collect_trash2"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"uncollect_all_trash1"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"delete_all_trash2"), 
			TRUE);
    } else {
 	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"collect_trash2"), 
			FALSE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"uncollect_all_trash1"), 
			FALSE);
			
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"delete_all_trash2"), 
			FALSE);
    }
    if (book) {
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"clear_book1"), 
			TRUE);
    } else {
		gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"clear_book1"), 
			FALSE);
    }
    if (find) {
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"clear_find_results1"), 
			TRUE);
    } else {
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				menuitem, 
				"clear_find_results1"), 
			FALSE);
    }
}

void
on_defaultbook_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
	
    g_free(bookfile);bookfile=NULL;
    bookfile=NULL;
    reload_book(treeview);
}


void
on_newbook_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
    
    show_input(treeview, NEW_BOOK_INPUT);
}


void
on_rememberbook_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
  	glob_t dirlist;
	int i;
    	char bm_dir[_POSIX_PATH_MAX];
	gchar *globstring;
        xfce_get_userfile_r(bm_dir, _POSIX_PATH_MAX-1, "xffm");
	globstring = g_strconcat(bm_dir,"/*.bm.dbh",NULL);

	print_diagnostics(treeview,"xf_INFO_ICON",_("Book"),":\n",NULL);

	
	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0) {
	   print_diagnostics(treeview,"xf_WARNING_ICON","Nothing found",NULL);
#ifdef DEBUG
           printf ("DBG:%s: no match\n", globstring);
#endif
	   
	} else {
	   print_diagnostics(treeview,NULL,_("Files found=")," ",NULL);
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")) continue;
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      print_diagnostics(treeview,NULL,g,(i == dirlist.gl_pathc-1)?
			      "\n":", ",NULL);
#ifdef DEBUG
              /*printf ("DBG:glob match: %s\n", dirlist.gl_pathv[i]);*/
              printf ("DBG:glob match: %s\n", g);
	      
#endif
	      g_free(g);g=NULL;
	   }
	}
  	globfree (&dirlist);

}


void
on_open_book_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
    
    show_input(treeview, OPEN_BOOK_INPUT);

}

