; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;    3dTruchet  - a script to create Truchet patterns 
;                 by Adrian Likins <aklikins@eos.ncsu.edu>
;                 http://www4.ncsu.edu/~aklikins/
;    version about .8 give or take
;
;  Lots of thanks to Quartic for his help.
;
;
;         The utility of this script is left as an exercise for the reader.

(define (center-ellipse img
			cx
			cy
			rx
			ry
			op
			aa
			feather
			frad)
  (gimp-ellipse-select img (- cx rx) (- cy ry) (+ rx rx) (+ ry ry)
		       op aa feather frad))

(define (use-tile img
		  drawable
		  height
		  width
		  img2
		  drawable2
		  xoffset
		  yoffset)
  (gimp-edit-copy drawable2)
  (let ((floating-sel (car (gimp-edit-paste drawable FALSE))))
    (gimp-layer-set-offsets floating-sel xoffset yoffset)
    (gimp-floating-sel-anchor floating-sel)
    )
  )


(define (create-tile img
		     drawable1
		     drawable2
		     size
		     thickness
		     backcolor
		     begincolor
		     endcolor
		     supersample)
  (let* (
	 (half-thickness (/ thickness 2))
	 (outer-radius (+ (/ size 2) half-thickness))
	 (inner-radius (- (/ size 2) half-thickness))
	 )

    (gimp-selection-all img)
    (gimp-palette-set-background backcolor)
    (gimp-edit-fill drawable1 BG-IMAGE-FILL)

    (let* (
	   (tempSize (* size 3))
	   (temp-img (car (gimp-image-new tempSize tempSize RGB)))
	   (temp-draw (car (gimp-layer-new temp-img tempSize tempSize
					   RGB_IMAGE "Jabar" 100 NORMAL)))
      	   (temp-draw2 (car (gimp-layer-new temp-img tempSize tempSize
					    RGB_IMAGE "Jabar" 100 NORMAL))))

      (gimp-image-undo-disable temp-img)
      (gimp-image-add-layer temp-img temp-draw 0)
      (gimp-image-add-layer temp-img temp-draw2 0)
      (gimp-palette-set-background backcolor)
      (gimp-edit-fill temp-draw BG-IMAGE-FILL)
      (gimp-edit-fill temp-draw2 BG-IMAGE-FILL)

      ;weird aint it
      (gimp-palette-set-background begincolor)
      (gimp-palette-set-foreground endcolor)

      (center-ellipse temp-img size size outer-radius outer-radius
		      REPLACE TRUE FALSE 0)
      (center-ellipse temp-img size size inner-radius inner-radius
		      SUB TRUE FALSE 0)
      
      (center-ellipse temp-img (* size 2) (*  size 2)  outer-radius outer-radius
		      ADD TRUE FALSE 0)
      (center-ellipse temp-img (* size 2) (*  size 2)  inner-radius inner-radius
		      SUB TRUE FALSE 0)

      (gimp-blend temp-draw FG-BG-RGB NORMAL
		  GRADIENT-SHAPEBURST-ANGULAR 100 0 REPEAT-NONE FALSE
		  supersample 3 .2 TRUE
		  size size (* size 2) (/ size 2))

      (center-ellipse temp-img size (* size 2)  outer-radius outer-radius
		      REPLACE TRUE FALSE 0)
      (center-ellipse temp-img size (* size 2) inner-radius inner-radius
		      SUB TRUE FALSE 0)

      (center-ellipse temp-img (* size 2) size  outer-radius outer-radius
		      ADD TRUE FALSE 0)
      (center-ellipse temp-img (* size 2) size  inner-radius inner-radius
		      SUB TRUE FALSE 0)

      ;(gimp-edit-fill temp-img temp-draw2 BG-IMAGE-FILL)

      (gimp-blend temp-draw2 FG-BG-RGB NORMAL
		  GRADIENT-SHAPEBURST-ANGULAR 100 0 REPEAT-NONE FALSE
		  supersample 3 .2 TRUE
		  size size (* size 2) (* size 2))

      (gimp-selection-none temp-img)

      (gimp-image-resize temp-img size size (- size) (- size))
      ; woo hoo it works....finally...


      (gimp-selection-all temp-img)
      (gimp-edit-copy temp-draw)
      (let ((floating-sel (car (gimp-edit-paste drawable2 FALSE))))
	(gimp-floating-sel-anchor floating-sel))

      (gimp-edit-copy temp-draw2)
      (let ((floating-sel (car (gimp-edit-paste drawable1 FALSE))))
	(gimp-floating-sel-anchor floating-sel))

      ;(let ((drawble (car (gimp-flip img drawable1 0)))))
	

      ;(gimp-display-new temp-img)
      (gimp-image-delete temp-img)
      )
    )
  )


(define (script-fu-3dtruchet size
			     thickness
			     backcolor
			     begincolor
			     endcolor
			     supersample
			     xtiles
			     ytiles)
  (let* (
	 (width (* size xtiles))
	 (height (* size ytiles))
	 (img (car (gimp-image-new width height RGB)))
	 (tile (car (gimp-image-new size size RGB)))
	 (layer-one (car (gimp-layer-new img width height RGB "Rambis" 100 NORMAL)))
	 (tiledraw1 (car (gimp-layer-new tile size size RGB "Johnson" 100 NORMAL)))
	 (tiledraw2 (car (gimp-layer-new tile size size RGB "Cooper" 100 NORMAL)))
	 (Xindex 0)
	 (Yindex 0)
	 (old-bg (car (gimp-palette-get-background)))
	 (old-fg (car (gimp-palette-get-foreground)))
	 )

    (gimp-image-undo-disable img)
    (gimp-image-undo-disable tile)

    (gimp-image-add-layer img layer-one 0)
    (gimp-image-add-layer tile tiledraw1 0)
    (gimp-image-add-layer tile tiledraw2 0)
 
    ;just to look a little better
    (gimp-selection-all img)
    (gimp-palette-set-background backcolor)
    (gimp-edit-fill layer-one BG-IMAGE-FILL)
    (gimp-selection-none img)

    (create-tile tile tiledraw1 tiledraw2 size thickness
		 backcolor begincolor endcolor supersample)
    

    (while (<= Xindex xtiles)
	   (while (<= Yindex ytiles)
		  (if (= (rand 2) 0)
		      (use-tile img layer-one height width tile
				tiledraw1 (* Xindex size) (* Yindex size))
		      (use-tile img layer-one height width tile
				tiledraw2 (* Xindex size) (* Yindex size))
		      )
		  (set! Yindex (+ Yindex 1))
		  )
	   (set! Yindex 0)
	   (set! Xindex (+ Xindex 1))
	   )
 
    (gimp-image-delete tile)
    (gimp-palette-set-background old-bg)
    (gimp-palette-set-foreground old-fg)
    (gimp-image-undo-enable img)
    (gimp-display-new img)
    )
  )

(script-fu-register "script-fu-3dtruchet"
		    _"<Toolbox>/Xtns/Script-Fu/Patterns/3_D Truchet..."
		    "3D Truchet pattern"
		    "Adrian Likins <aklikins@eos.ncsu.edu>"
		    "Adrian Likins"
		    "1997"
		    ""
		    SF-ADJUSTMENT _"Block Size"        '(64 5 1000 1 10 0 1)
		    SF-ADJUSTMENT _"Thickness"         '(12 2 100 1 10 0 1)
		    SF-COLOR      _"Background Color"  '(255 255 255)
		    SF-COLOR      _"Start Blend"       '(0 0 0)
		    SF-COLOR      _"End Blend"         '(255 255 255)
		    SF-TOGGLE     _"Supersample"       TRUE
		    SF-ADJUSTMENT _"Number of X Tiles" '(5 1 1000 1 10 0 1)
		    SF-ADJUSTMENT _"Number of Y Tiles" '(5 1 1000 1 10 0 1))
