/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "kviewconfmodules.h"
#include "kview.h"

#include <qlayout.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>

#include "kpluginselector.h"
#include <klocale.h>
#include <kdialog.h>
#include <kglobal.h>
#include <kconfig.h>

KViewGeneralConfig::KViewGeneralConfig( QObject * parent )
	: KPreferencesModule( 0, i18n( "General KView Configuration" ), "kview", parent, "KView General Config Module" )
{
	setGroupName( i18n( "Application" ) );
}

KViewGeneralConfig::~KViewGeneralConfig()
{
}

void KViewGeneralConfig::applyChanges()
{
	KConfigGroup cfgGroup( KGlobal::instance()->config(), "KView General" );
	cfgGroup.writeEntry( "Resize Mode", m_pResizeGroup->id( m_pResizeGroup->selected() ) );
	emit configChanged();
}

void KViewGeneralConfig::reset()
{
	KConfigGroup cfgGroup( KGlobal::instance()->config(), "KView General" );
	int n = cfgGroup.readNumEntry( "Resize Mode", 2 );
	if( n < 0 || n > 2 )
		n = 2;
	m_pResizeGroup->setButton( n );
}

void KViewGeneralConfig::createPage( QFrame * page )
{
	QBoxLayout * layout = new QVBoxLayout( page, KDialog::marginHint(), KDialog::spacingHint() );
	layout->setAutoAdd( true );

	m_pResizeGroup = new QVButtonGroup( i18n( "Resizing" ), page );
	m_pResizeGroup->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed ) );

	( void )new QRadioButton( i18n( "Only resize window" ), m_pResizeGroup );
	( void )new QRadioButton( i18n( "Resize image to fit window" ), m_pResizeGroup );
	( void )new QRadioButton( i18n( "Don't resize anything" ), m_pResizeGroup );

	reset();
}

// ########### KViewPluginConfig #############

KViewPluginConfig::KViewPluginConfig( KView * parent )
	: KPreferencesModule( i18n( "Plugins" ), i18n( "Select Which Plugins to Use" ), "input_devices_settings", parent, "KView Plugin Config Module" )
	, m_instance( parent->instance() )
	, m_pPluginSelector( 0 )
{
}

KViewPluginConfig::~KViewPluginConfig()
{
}

void KViewPluginConfig::applyChanges()
{
	m_pPluginSelector->save();
	emit configChanged();
}

void KViewPluginConfig::reset()
{
}

void KViewPluginConfig::createPage( QFrame * page )
{
	QBoxLayout * layout = new QVBoxLayout( page );
	layout->setAutoAdd( true );
	m_pPluginSelector = new KPluginSelector( m_instance, page );
}

// vim:sw=4:ts=4

#include "kviewconfmodules.moc"
