/***************************************************************************
                          pointofconc.cpp  -  description
                             -------------------
    begin                : Wed May 10 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pointofconc.h"

PointOfConc::PointOfConc(): GeoPoint()
{
	identificator = "PointOfConc";
	ID = ID_pointOfConc;

	int temp[] = { ID_geoLine, 2, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

PointOfConc::~PointOfConc()
{
}

void PointOfConc::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

  Coordinates coord1, coord2, coord3, coord4;
	coord1 = parents.first()->getStartCoordinates();
	coord2 = parents.current()->getEndCoordinates();
	coord3 = parents.next()->getStartCoordinates();
	coord4 = parents.current()->getEndCoordinates();

	MetricsCenter::pointOfConc( coords, coord1, coord2, coord3, coord4 );

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	//	Calculate new rectangle around point.
	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x ,y ,size ,size );
}

