// QString.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

	using Qt;
	using System;
	using System.Runtime.InteropServices;

	public class QString : QtSupport, IDisposable {

		public enum SectionFlags {
			SectionDefault = 0,
			SectionSkipEmpty = 1,
			SectionIncludeLeadingSep = 2,
			SectionIncludeTrailingSep = 4,
			SectionCaseInsensitiveSeps = 8
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString ();
		public QString () : this (QNull.Instance)
		{
			rawObject = qt_new_QString ();
			RegisterObject (this);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString1 (IntPtr arg1);
		public QString (QChar arg1) : this (QNull.Instance)
		{
			rawObject = qt_new_QString1 (arg1.RawObject);
			RegisterObject (this);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString2 (IntPtr arg1);
		public QString (QString arg1) : this (QNull.Instance)
		{
			rawObject = qt_new_QString2 (arg1.RawObject);
			RegisterObject (this);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString3 (IntPtr arg1);
		public QString (QByteArray arg1) : this (QNull.Instance)
		{
			rawObject = qt_new_QString3 (arg1.RawObject);
			RegisterObject (this);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString4 (IntPtr unicode, uint length);
		public QString (QChar unicode, uint length) : this (QNull.Instance)
		{
			rawObject = qt_new_QString4 (unicode.RawObject, length);
			RegisterObject (this);
		}

		
// 		public string ToString()
// 		{
// 			
// 		}
		
		
		public static QString FromString( string s )
		{
			QString dest = new QString();
			dest.rawObject = qt_QString_setUnicodeCodes(
				dest.rawObject, s.ToCharArray(), (uint) s.Length );
			return dest;
		}
	
		
		
		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QString5 (string str);
		public QString (string str) : this (QNull.Instance)
		{
			rawObject = qt_new_QString5 (str);
			RegisterObject (this);
		}

		internal QString (IntPtr ptr) : this (QNull.Instance)
		{
			rawObject = ptr;
			RegisterObject(this);
		}

		internal QString (QNull dummy) : base (QNull.Instance) {}

		~QString ()
		{
			Dispose (false);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QString (IntPtr raw);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QString (rawObject);
			deleted = true;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_isNull (IntPtr raw);
		public bool IsNull ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_isNull (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_isEmpty (IntPtr raw);
		public bool IsEmpty ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_isEmpty (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern uint qt_QString_length (IntPtr raw);
		public uint Length ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_length (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QString_truncate (IntPtr raw, uint pos);
		public void Truncate (uint pos)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QString_truncate (rawObject, pos);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_fill (IntPtr raw, IntPtr c, int len);
		public string Fill (QChar c, int len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_fill (rawObject, c.RawObject, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_copy (IntPtr raw);
		public string Copy ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_copy (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg (IntPtr raw, long a, int fieldwidth, int Q_base);
		public string Arg (long a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg1 (IntPtr raw, ulong a, int fieldwidth, int Q_base);
		public string Arg (ulong a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg1 (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg2 (IntPtr raw, int a, int fieldwidth, int Q_base);
		public string Arg (int a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg2 (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg3 (IntPtr raw, uint a, int fieldwidth, int Q_base);
		public string Arg (uint a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg3 (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg4 (IntPtr raw, short a, int fieldwidth, int Q_base);
		public string Arg (short a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg4 (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg5 (IntPtr raw, ushort a, int fieldwidth, int Q_base);
		public string Arg (ushort a, int fieldwidth, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg5 (rawObject, a, fieldwidth, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg6 (IntPtr raw, char a, int fieldwidth);
		public string Arg (char a, int fieldwidth)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg6 (rawObject, a, fieldwidth));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg7 (IntPtr raw, IntPtr a, int fieldwidth);
		public string Arg (QChar a, int fieldwidth)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg7 (rawObject, a.RawObject, fieldwidth));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg8 (IntPtr raw, IntPtr a, int fieldwidth);
		public string Arg (QString a, int fieldwidth)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg8 (rawObject, a.RawObject, fieldwidth));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_arg9 (IntPtr raw, double a, int fieldwidth, char fmt, int prec);
		public string Arg (double a, int fieldwidth, char fmt, int prec)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_arg9 (rawObject, a, fieldwidth, fmt, prec));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_find (IntPtr raw, IntPtr c, int index, bool cs);
		public int Find (QChar c, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_find (rawObject, c.RawObject, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_find1 (IntPtr raw, char c, int index, bool cs);
		public int Find (char c, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_find1 (rawObject, c, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_find2 (IntPtr raw, IntPtr str, int index, bool cs);
		public int Find (QString str, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_find2 (rawObject, str.RawObject, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_find3 (IntPtr raw, IntPtr arg1, int index);
		public int Find (QRegExp arg1, int index)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_find3 (rawObject, arg1.RawObject, index);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_find4 (IntPtr raw, string str, int index);
		public int Find (string str, int index)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_find4 (rawObject, str, index);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_findRev (IntPtr raw, IntPtr c, int index, bool cs);
		public int FindRev (QChar c, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_findRev (rawObject, c.RawObject, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_findRev1 (IntPtr raw, char c, int index, bool cs);
		public int FindRev (char c, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_findRev1 (rawObject, c, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_findRev2 (IntPtr raw, IntPtr str, int index, bool cs);
		public int FindRev (QString str, int index, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_findRev2 (rawObject, str.RawObject, index, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_findRev3 (IntPtr raw, IntPtr arg1, int index);
		public int FindRev (QRegExp arg1, int index)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_findRev3 (rawObject, arg1.RawObject, index);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_findRev4 (IntPtr raw, string str, int index);
		public int FindRev (string str, int index)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_findRev4 (rawObject, str, index);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_contains (IntPtr raw, IntPtr c, bool cs);
		public int Contains (QChar c, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_contains (rawObject, c.RawObject, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_contains1 (IntPtr raw, char c, bool cs);
		public int Contains (char c, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_contains1 (rawObject, c, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_contains2 (IntPtr raw, string str, bool cs);
		public int Contains (string str, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_contains2 (rawObject, str, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_contains3 (IntPtr raw, IntPtr str, bool cs);
		public int Contains (QString str, bool cs)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_contains3 (rawObject, str.RawObject, cs);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_contains4 (IntPtr raw, IntPtr arg1);
		public int Contains (QRegExp arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_contains4 (rawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_section (IntPtr raw, IntPtr sep, int start, int end, QString.SectionFlags SectionFlags);
		public string Section (QChar sep, int start, int end, QString.SectionFlags SectionFlags)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_section (rawObject, sep.RawObject, start, end, SectionFlags));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_section1 (IntPtr raw, char sep, int start, int end, QString.SectionFlags SectionFlags);
		public string Section (char sep, int start, int end, QString.SectionFlags SectionFlags)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_section1 (rawObject, sep, start, end, SectionFlags));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_section2 (IntPtr raw, string in_sep, int start, int end, QString.SectionFlags SectionFlags);
		public string Section (string in_sep, int start, int end, QString.SectionFlags SectionFlags)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_section2 (rawObject, in_sep, start, end, SectionFlags));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_section3 (IntPtr raw, IntPtr in_sep, int start, int end, QString.SectionFlags SectionFlags);
		public string Section (QString in_sep, int start, int end, QString.SectionFlags SectionFlags)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_section3 (rawObject, in_sep.RawObject, start, end, SectionFlags));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_section4 (IntPtr raw, IntPtr reg, int start, int end, QString.SectionFlags SectionFlags);
		public string Section (QRegExp reg, int start, int end, QString.SectionFlags SectionFlags)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_section4 (rawObject, reg.RawObject, start, end, SectionFlags));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_left (IntPtr raw, uint len);
		public string Left (uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_left (rawObject, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_right (IntPtr raw, uint len);
		public string Right (uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_right (rawObject, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_mid (IntPtr raw, uint index, uint len);
		public string Mid (uint index, uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_mid (rawObject, index, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_leftJustify (IntPtr raw, uint width, IntPtr fill, bool trunc);
		public string LeftJustify (uint width, QChar fill, bool trunc)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_leftJustify (rawObject, width, fill.RawObject, trunc));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_rightJustify (IntPtr raw, uint width, IntPtr fill, bool trunc);
		public string RightJustify (uint width, QChar fill, bool trunc)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_rightJustify (rawObject, width, fill.RawObject, trunc));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_lower (IntPtr raw);
		public string Lower ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_lower (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_upper (IntPtr raw);
		public string Upper ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_upper (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_stripWhiteSpace (IntPtr raw);
		public string StripWhiteSpace ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_stripWhiteSpace (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_simplifyWhiteSpace (IntPtr raw);
		public string SimplifyWhiteSpace ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_simplifyWhiteSpace (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_insert (IntPtr raw, uint index, IntPtr arg1);
		public string Insert (uint index, QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_insert (rawObject, index, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_insert1 (IntPtr raw, uint index, IntPtr arg1, uint len);
		public string Insert (uint index, QChar arg1, uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_insert1 (rawObject, index, arg1.RawObject, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_insert2 (IntPtr raw, uint index, IntPtr arg1);
		public string Insert (uint index, QChar arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_insert2 (rawObject, index, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_insert3 (IntPtr raw, uint index, char c);
		public string Insert (uint index, char c)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_insert3 (rawObject, index, c));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_append (IntPtr raw, char arg1);
		public string Append (char arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_append (rawObject, arg1));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_append1 (IntPtr raw, IntPtr arg1);
		public string Append (QChar arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_append1 (rawObject, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_append2 (IntPtr raw, IntPtr arg1);
		public string Append (QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_append2 (rawObject, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_prepend (IntPtr raw, char arg1);
		public string Prepend (char arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_prepend (rawObject, arg1));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_prepend1 (IntPtr raw, IntPtr arg1);
		public string Prepend (QChar arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_prepend1 (rawObject, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_prepend2 (IntPtr raw, IntPtr arg1);
		public string Prepend (QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_prepend2 (rawObject, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_remove (IntPtr raw, uint index, uint len);
		public string Remove (uint index, uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_remove (rawObject, index, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_replace (IntPtr raw, uint index, uint len, IntPtr arg1);
		public string Replace (uint index, uint len, QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_replace (rawObject, index, len, arg1.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_replace1 (IntPtr raw, uint index, uint len, IntPtr arg1, uint clen);
		public string Replace (uint index, uint len, QChar arg1, uint clen)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_replace1 (rawObject, index, len, arg1.RawObject, clen));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_replace2 (IntPtr raw, IntPtr arg1, IntPtr arg2);
		public string Replace (QRegExp arg1, QString arg2)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_replace2 (rawObject, arg1.RawObject, arg2.RawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern short qt_QString_toShort (IntPtr raw, bool ok, int Q_base);
		public short ToShort (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toShort (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern ushort qt_QString_toUShort (IntPtr raw, bool ok, int Q_base);
		public ushort ToUShort (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toUShort (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_toInt (IntPtr raw, bool ok, int Q_base);
		public int ToInt (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toInt (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern uint qt_QString_toUInt (IntPtr raw, bool ok, int Q_base);
		public uint ToUInt (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toUInt (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern long qt_QString_toLong (IntPtr raw, bool ok, int Q_base);
		public long ToLong (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toLong (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern ulong qt_QString_toULong (IntPtr raw, bool ok, int Q_base);
		public ulong ToULong (bool ok, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toULong (rawObject, ok, Q_base);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern float qt_QString_toFloat (IntPtr raw, bool ok);
		public float ToFloat (bool ok)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toFloat (rawObject, ok);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern double qt_QString_toDouble (IntPtr raw, bool ok);
		public double ToDouble (bool ok)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_toDouble (rawObject, ok);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum (IntPtr raw, short arg1, int Q_base);
		public string SetNum (short arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum1 (IntPtr raw, ushort arg1, int Q_base);
		public string SetNum (ushort arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum1 (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum2 (IntPtr raw, int arg1, int Q_base);
		public string SetNum (int arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum2 (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum3 (IntPtr raw, uint arg1, int Q_base);
		public string SetNum (uint arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum3 (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum4 (IntPtr raw, long arg1, int Q_base);
		public string SetNum (long arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum4 (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum5 (IntPtr raw, ulong arg1, int Q_base);
		public string SetNum (ulong arg1, int Q_base)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum5 (rawObject, arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum6 (IntPtr raw, float arg1, char f, int prec);
		public string SetNum (float arg1, char f, int prec)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum6 (rawObject, arg1, f, prec));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setNum7 (IntPtr raw, double arg1, char f, int prec);
		public string SetNum (double arg1, char f, int prec)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setNum7 (rawObject, arg1, f, prec));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QString_setExpand (IntPtr raw, uint index, IntPtr c);
		public void SetExpand (uint index, QChar c)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QString_setExpand (rawObject, index, c.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_at (IntPtr raw, uint i);
		public QChar At (uint i)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_at (rawObject, i), typeof (QChar)) as QChar;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_constref (IntPtr raw, uint i);
		public QChar Constref (uint i)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_constref (rawObject, i), typeof (QChar)) as QChar;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_ref (IntPtr raw, uint i);
		public QChar Q_ref (uint i)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_ref (rawObject, i), typeof (QChar)) as QChar;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_unicode (IntPtr raw);
		public QChar Unicode ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_unicode (rawObject), typeof (QChar)) as QChar;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern string qt_QString_ascii (IntPtr raw);
		public string Ascii ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_ascii (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern string qt_QString_latin1 (IntPtr raw);
		public string Latin1 ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_latin1 (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_utf8 (IntPtr raw);
		public QCString Utf8 ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_utf8 (rawObject), typeof (QCString)) as QCString;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_local8Bit (IntPtr raw);
		public QCString Local8Bit ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return LookupObject (qt_QString_local8Bit (rawObject), typeof (QCString)) as QCString;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setUnicode (IntPtr raw, IntPtr unicode, uint len);
		public string SetUnicode (QChar unicode, uint len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setUnicode (rawObject, unicode.RawObject, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setUnicodeCodes(
			IntPtr raw,
			[MarshalAs(UnmanagedType.LPArray, SizeParamIndex=1)] char[] charArray,
			uint len);
			
		// Temporarily disabled this... It won't work as-is anyway!	
// 		public string SetUnicodeCodes (ushort unicode_as_ushorts, uint len)
// 		{
// 			if (disposed)
// 				throw new ObjectDisposedException (this+": Attempted use of disposed object");
// 
// 			QString qstr = new QString (qt_QString_setUnicodeCodes (rawObject, unicode_as_ushorts, len));
// 			string str = qstr.Latin1 ();
// 			qstr.Dispose ();
// 			return str;
// 		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_setLatin1 (IntPtr raw, string arg1, int len);
		public string SetLatin1 (string arg1, int len)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			QString qstr = new QString (qt_QString_setLatin1 (rawObject, arg1, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_compare (IntPtr raw, IntPtr s);
		public int Compare (QString s)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_compare (rawObject, s.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_localeAwareCompare (IntPtr raw, IntPtr s);
		public int LocaleAwareCompare (QString s)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_localeAwareCompare (rawObject, s.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QString_compose (IntPtr raw);
		public void Compose ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QString_compose (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern string qt_QString_data (IntPtr raw);
		public string Data ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_data (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_startsWith (IntPtr raw, IntPtr arg1);
		public bool StartsWith (QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_startsWith (rawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_endsWith (IntPtr raw, IntPtr arg1);
		public bool EndsWith (QString arg1)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_endsWith (rawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QString_setLength (IntPtr raw, uint newLength);
		public void SetLength (uint newLength)
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			qt_QString_setLength (rawObject, newLength);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_simpleText (IntPtr raw);
		public bool SimpleText ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_simpleText (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern bool qt_QString_isRightToLeft (IntPtr raw);
		public bool IsRightToLeft ()
		{
			if (disposed)
				throw new ObjectDisposedException (this+": Attempted use of disposed object");

			return qt_QString_isRightToLeft (rawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_number (long arg1, int Q_base);
		public static string Number (long arg1, int Q_base)
		{
			QString qstr = new QString (qt_QString_number (arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_number1 (ulong arg1, int Q_base);
		public static string Number (ulong arg1, int Q_base)
		{
			QString qstr = new QString (qt_QString_number1 (arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_number2 (int arg1, int Q_base);
		public static string Number (int arg1, int Q_base)
		{
			QString qstr = new QString (qt_QString_number2 (arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_number3 (uint arg1, int Q_base);
		public static string Number (uint arg1, int Q_base)
		{
			QString qstr = new QString (qt_QString_number3 (arg1, Q_base));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_number4 (double arg1, char f, int prec);
		public static string Number (double arg1, char f, int prec)
		{
			QString qstr = new QString (qt_QString_number4 (arg1, f, prec));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_fromLatin1 (string arg1, int len);
		public static string FromLatin1 (string arg1, int len)
		{
			QString qstr = new QString (qt_QString_fromLatin1 (arg1, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_fromUtf8 (string arg1, int len);
		public static string FromUtf8 (string arg1, int len)
		{
			QString qstr = new QString (qt_QString_fromUtf8 (arg1, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QString_fromLocal8Bit (string arg1, int len);
		public static string FromLocal8Bit (string arg1, int len)
		{
			QString qstr = new QString (qt_QString_fromLocal8Bit (arg1, len));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_compare1 (IntPtr s1, IntPtr s2);
		public static int Compare (QString s1, QString s2)
		{
			return qt_QString_compare1 (s1.RawObject, s2.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QString_localeAwareCompare1 (IntPtr s1, IntPtr s2);
		public static int LocaleAwareCompare (QString s1, QString s2)
		{
			return qt_QString_localeAwareCompare1 (s1.RawObject, s2.RawObject);
		}

		public string Fill (QChar c)
		{
			return Fill(c, (int) -1);
		}

		public string Arg (long a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (long a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (ulong a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (ulong a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (int a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (int a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (uint a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (uint a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (short a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (short a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (ushort a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (ushort a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (int) 10);
		}

		public string Arg (char a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (QChar a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (QString a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (double a)
		{
			return Arg(a, (int) 0);
		}

		public string Arg (double a, int fieldwidth)
		{
			return Arg(a, fieldwidth, (char) 'g');
		}

		public string Arg (double a, int fieldwidth, char fmt)
		{
			return Arg(a, fieldwidth, fmt, (int) -1);
		}

		public int Find (QChar c)
		{
			return Find(c, (int) 0);
		}

		public int Find (QChar c, int index)
		{
			return Find(c, index, true);
		}

		public int Find (char c)
		{
			return Find(c, (int) 0);
		}

		public int Find (char c, int index)
		{
			return Find(c, index, true);
		}

		public int Find (QString str)
		{
			return Find(str, (int) 0);
		}

		public int Find (QString str, int index)
		{
			return Find(str, index, true);
		}

		public int Find (QRegExp arg1)
		{
			return Find(arg1, (int) 0);
		}

		public int Find (string str)
		{
			return Find(str, (int) 0);
		}

		public int FindRev (QChar c)
		{
			return FindRev(c, (int) -1);
		}

		public int FindRev (QChar c, int index)
		{
			return FindRev(c, index, true);
		}

		public int FindRev (char c)
		{
			return FindRev(c, (int) -1);
		}

		public int FindRev (char c, int index)
		{
			return FindRev(c, index, true);
		}

		public int FindRev (QString str)
		{
			return FindRev(str, (int) -1);
		}

		public int FindRev (QString str, int index)
		{
			return FindRev(str, index, true);
		}

		public int FindRev (QRegExp arg1)
		{
			return FindRev(arg1, (int) -1);
		}

		public int FindRev (string str)
		{
			return FindRev(str, (int) -1);
		}

		public int Contains (QChar c)
		{
			return Contains(c, true);
		}

		public int Contains (char c)
		{
			return Contains(c, true);
		}

		public int Contains (string str)
		{
			return Contains(str, true);
		}

		public int Contains (QString str)
		{
			return Contains(str, true);
		}

		public string Section (QChar sep, int start)
		{
			return Section(sep, start, (int) 1);
		}

		public string Section (QChar sep, int start, int end)
		{
			return Section(sep, start, end, QString.SectionFlags.SectionDefault);
		}

		public string Section (char sep, int start)
		{
			return Section(sep, start, (int) 1);
		}

		public string Section (char sep, int start, int end)
		{
			return Section(sep, start, end, QString.SectionFlags.SectionDefault);
		}

		public string Section (string in_sep, int start)
		{
			return Section(in_sep, start, (int) 1);
		}

		public string Section (string in_sep, int start, int end)
		{
			return Section(in_sep, start, end, QString.SectionFlags.SectionDefault);
		}

		public string Section (QString in_sep, int start)
		{
			return Section(in_sep, start, (int) 1);
		}

		public string Section (QString in_sep, int start, int end)
		{
			return Section(in_sep, start, end, QString.SectionFlags.SectionDefault);
		}

		public string Section (QRegExp reg, int start)
		{
			return Section(reg, start, (int) 1);
		}

		public string Section (QRegExp reg, int start, int end)
		{
			return Section(reg, start, end, QString.SectionFlags.SectionDefault);
		}

		public string Mid (uint index)
		{
			return Mid(index, (uint) 1);
		}

		public string LeftJustify (uint width)
		{
			return LeftJustify(width, new QChar ());
		}

		public string LeftJustify (uint width, QChar fill)
		{
			return LeftJustify(width, fill, false);
		}

		public string RightJustify (uint width)
		{
			return RightJustify(width, new QChar ());
		}

		public string RightJustify (uint width, QChar fill)
		{
			return RightJustify(width, fill, false);
		}

		public short ToShort ()
		{
			return ToShort(false);
		}

		public short ToShort (bool ok)
		{
			return ToShort(ok, (int) 10);
		}

		public ushort ToUShort ()
		{
			return ToUShort(false);
		}

		public ushort ToUShort (bool ok)
		{
			return ToUShort(ok, (int) 10);
		}

		public int ToInt ()
		{
			return ToInt(false);
		}

		public int ToInt (bool ok)
		{
			return ToInt(ok, (int) 10);
		}

		public uint ToUInt ()
		{
			return ToUInt(false);
		}

		public uint ToUInt (bool ok)
		{
			return ToUInt(ok, (int) 10);
		}

		public long ToLong ()
		{
			return ToLong(false);
		}

		public long ToLong (bool ok)
		{
			return ToLong(ok, (int) 10);
		}

		public ulong ToULong ()
		{
			return ToULong(false);
		}

		public ulong ToULong (bool ok)
		{
			return ToULong(ok, (int) 10);
		}

		public float ToFloat ()
		{
			return ToFloat(false);
		}

		public double ToDouble ()
		{
			return ToDouble(false);
		}

		public string SetNum (short arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (ushort arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (int arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (uint arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (long arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (ulong arg1)
		{
			return SetNum(arg1, (int) 10);
		}

		public string SetNum (float arg1)
		{
			return SetNum(arg1, (char) 'g');
		}

		public string SetNum (float arg1, char f)
		{
			return SetNum(arg1, f, (int) 6);
		}

		public string SetNum (double arg1)
		{
			return SetNum(arg1, (char) 'g');
		}

		public string SetNum (double arg1, char f)
		{
			return SetNum(arg1, f, (int) 6);
		}

		public string SetLatin1 (string arg1)
		{
			return SetLatin1(arg1, (int) -1);
		}

		public static string Number (long arg1)
		{
			return Number(arg1, (int) 10);
		}

		public static string Number (ulong arg1)
		{
			return Number(arg1, (int) 10);
		}

		public static string Number (int arg1)
		{
			return Number(arg1, (int) 10);
		}

		public static string Number (uint arg1)
		{
			return Number(arg1, (int) 10);
		}

		public static string Number (double arg1)
		{
			return Number(arg1, (char) 'g');
		}

		public static string Number (double arg1, char f)
		{
			return Number(arg1, f, (int) 6);
		}

		public static string FromLatin1 (string arg1)
		{
			return FromLatin1(arg1, (int) -1);
		}

		public static string FromUtf8 (string arg1)
		{
			return FromUtf8(arg1, (int) -1);
		}

		public static string FromLocal8Bit (string arg1)
		{
			return FromLocal8Bit(arg1, (int) -1);
		}
	}
}
