/***************************************************************************
                            DCOPRef.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPREF_H
#define DCOPREF_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.
*/
@class DCOPObject; 

@interface  DCOPRef : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a null reference.
     
*/
- init;

/** 
 Copy constructor.
     
*/
- copyWithZone: (NSZone *) zone;

/** 
 Creates a reference to a certain object in a
 certain application.

*/
- initWithText: (NSString *)app obj: (NSString *)obj;

/** 
 Creates a reference to a certain object in a
 certain application.

*/
- initWithDCOPObject: (DCOPObject*)object;

/** 
 Creates a reference to a certain object in a
 certain application.

*/
- initWithText: (NSString *)app obj: (NSString *)obj type: (NSString *)type;

/** 
 Tests wether it is a null reference.
     
*/
- (BOOL) isNull;

/** 
 Name of the application in which the object resides.
     
*/
- (NSString *) app;

/** 
 Object ID of the referenced object.
     
*/
- (NSString *) object;

/** 
 type of the referenced object. May be null (i.e. unknown).
     
*/
- (NSString *) type;

/** 
 Changes the referenced object. Resets the type to unknown (null).
     
*/
- setRef: (NSString *)app obj: (NSString *)obj;

/** 
 Changes the referenced object
     
*/
- setRef: (NSString *)app obj: (NSString *)obj type: (NSString *)type;

/** 
 Makes this a null reference.
     
*/
- clear;
@end

#endif
