#include <qimage.h>

static PyQt_Enum pyqt_qimage_Endian[] = {
    { (int)QImage::IgnoreEndian, "IgnoreEndian" },
    { (int)QImage::BigEndian, "BigEndian" },
    { (int)QImage::LittleEndian, "LittleEndian" },
    { 0, 0 }
};


static void pyqt_qimage_free( void* ptr )
{
    delete (QImage*)ptr;
}

static QImage* pyqt_qimage_toCpp( PyObject* obj )
{
    return (QImage*)getPointer( obj, Image );
}

static PyObject* pyqt_qimage_toPython( const QImage& ptr )
{
    return qobjectToPython( new QImage( ptr ), Image );
}

static PyObject* pyqt_qimage_constructor( void* /* ptr */, PyObject* obj, PyObject* arg_tuple )
{
    if ( !obj )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         void* ptr = new QImage;
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    int _0param;
    int _1param;
    int _2param;
    int _3param=0;
    char* _4enum = 0;
    int   _4param=QImage::IgnoreEndian;
    if ( PyArg_ParseTuple( arg_tuple, "iii|is", &_0param, &_1param, &_2param, &_3param, &_4enum )  && ( !_4enum || enumToCpp( pyqt_qimage_Endian, _4enum, &_4param ) ) )
    {
         PyErr_Clear();
        void* ptr = new QImage( _0param, _1param, _2param, _3param, (QImage::Endian)_4param );
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _5param = 0;
    int _6param;
    int _7param=0;
    char* _8enum = 0;
    int   _8param=QImage::IgnoreEndian;
    if ( PyArg_ParseTuple( arg_tuple, "Oi|is", &_5param, &_6param, &_7param, &_8enum )  && inherits( _5param, Size ) && ( !_8enum || enumToCpp( pyqt_qimage_Endian, _8enum, &_8param ) ) )
    {
         PyErr_Clear();
        void* ptr = new QImage( *pyqt_qsize_toCpp( _5param ), _6param, _7param, (QImage::Endian)_8param );
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    char* _9param = 0;
    char* _10param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "ss", &_9param, &_10param )  )
    {
         PyErr_Clear();
        void* ptr = new QImage( _9param, _10param );
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    char* _12data;
    int   _12len;
    if ( PyArg_ParseTuple( arg_tuple, "s#", &_12data, &_12len )  )
    {
        PyQt_ByteArray _12param( _12data, _12len );
        PyErr_Clear();
        void* ptr = new QImage( _12param );
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _13param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_13param )  && inherits( _13param, Image ) )
    {
         PyErr_Clear();
        void* ptr = new QImage( *pyqt_qimage_toCpp( _13param ) );
        mapObject( obj, ptr, pyqt_qimage_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_textLanguages( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qstringlist_toPython( ((QImage*)ptr)->textLanguages() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_pixelIndex( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
         return PyInt_FromLong( ((QImage*)ptr)->pixelIndex(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_imageFormat( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    char* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "s", &_0param )  )
    {
         return Py_BuildValue("s", QImage::imageFormat(_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_depth( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->depth() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_isNull( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->isNull() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_allGray( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->allGray() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setText( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0param = 0;
    char* _1param = 0;
    char* _2param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "sss", &_0param, &_1param, &_2param )  )
    {
         ((QImage*)ptr)->setText(_0param, _1param, _2param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_loadFromData( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0data;
    int   _0len;
    char* _1param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "s#|s", &_0data, &_0len, &_1param )  )
    {
        PyQt_ByteArray _0param( _0data, _0len );
        return Py_BuildValue("b", (char)((QImage*)ptr)->loadFromData(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setColor( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    uint _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
         ((QImage*)ptr)->setColor(_0param, _1param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_setAlphaBuffer( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    bool _0param;
    if ( PyArg_ParseTuple( arg_tuple, "b", &_0param )  )
    {
         ((QImage*)ptr)->setAlphaBuffer(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_setNumColors( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         ((QImage*)ptr)->setNumColors(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_systemBitOrder( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return enumToPython( pyqt_qimage_Endian, (int)QImage::systemBitOrder() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setDotsPerMeterY( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         ((QImage*)ptr)->setDotsPerMeterY(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_reset( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         ((QImage*)ptr)->reset();
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_rect( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qrect_toPython( ((QImage*)ptr)->rect() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_dotsPerMeterX( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->dotsPerMeterX() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_hasAlphaBuffer( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->hasAlphaBuffer() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_copy( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->copy() );
    }
    int _0param;
    int _1param;
    int _2param;
    int _3param;
    int _4param=0;
    if ( PyArg_ParseTuple( arg_tuple, "iiii|i", &_0param, &_1param, &_2param, &_3param, &_4param )  )
    {
         PyErr_Clear();
        return pyqt_qimage_toPython( ((QImage*)ptr)->copy(_0param, _1param, _2param, _3param, _4param) );
    }
    PyObject* _5param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_5param )  && inherits( _5param, Rect ) )
    {
         PyErr_Clear();
        return pyqt_qimage_toPython( ((QImage*)ptr)->copy(*pyqt_qrect_toCpp( _5param )) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_inputFormatList( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qstringlist_toPython( QImage::inputFormatList() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_createHeuristicMask( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    bool _0param=TRUE;
    if ( PyArg_ParseTuple( arg_tuple, "|b", &_0param )  )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->createHeuristicMask(_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_isGrayscale( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->isGrayscale() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_numBytes( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->numBytes() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_smoothScale( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->smoothScale(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_numColors( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->numColors() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_detach( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         ((QImage*)ptr)->detach();
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_offset( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qpoint_toPython( ((QImage*)ptr)->offset() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_swapRGB( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->swapRGB() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_createAlphaMask( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param=0;
    if ( PyArg_ParseTuple( arg_tuple, "|i", &_0param )  )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->createAlphaMask(_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_pixel( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
         return PyLong_FromUnsignedLong( ((QImage*)ptr)->pixel(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_save( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0param = 0;
    char* _1param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "ss", &_0param, &_1param )  )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->save(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setOffset( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, Point ) )
    {
         ((QImage*)ptr)->setOffset(*pyqt_qpoint_toCpp( _0param ));
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_textKeys( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qstringlist_toPython( ((QImage*)ptr)->textKeys() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_valid( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->valid(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_width( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->width() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setPixel( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    uint _2param;
    if ( PyArg_ParseTuple( arg_tuple, "iii", &_0param, &_1param, &_2param )  )
    {
         ((QImage*)ptr)->setPixel(_0param, _1param, _2param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_create( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    int _2param;
    int _3param=0;
    char* _4enum = 0;
    int   _4param=QImage::IgnoreEndian;
    if ( PyArg_ParseTuple( arg_tuple, "iii|is", &_0param, &_1param, &_2param, &_3param, &_4enum )  && ( !_4enum || enumToCpp( pyqt_qimage_Endian, _4enum, &_4param ) ) )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->create(_0param, _1param, _2param, _3param, (QImage::Endian)_4param) );
    }
    PyObject* _5param = 0;
    int _6param;
    int _7param=0;
    char* _8enum = 0;
    int   _8param=QImage::IgnoreEndian;
    if ( PyArg_ParseTuple( arg_tuple, "Oi|is", &_5param, &_6param, &_7param, &_8enum )  && inherits( _5param, Size ) && ( !_8enum || enumToCpp( pyqt_qimage_Endian, _8enum, &_8param ) ) )
    {
         PyErr_Clear();
        return Py_BuildValue("b", (char)((QImage*)ptr)->create(*pyqt_qsize_toCpp( _5param ), _6param, _7param, (QImage::Endian)_8param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_setDotsPerMeterX( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         ((QImage*)ptr)->setDotsPerMeterX(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_bytesPerLine( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->bytesPerLine() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_size( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qsize_toPython( ((QImage*)ptr)->size() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_outputFormatList( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qstringlist_toPython( QImage::outputFormatList() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_fill( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    uint _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         ((QImage*)ptr)->fill(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_convertBitOrder( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0enum = 0;
    int   _0param;
    if ( PyArg_ParseTuple( arg_tuple, "s", &_0enum )  && ( !_0enum || enumToCpp( pyqt_qimage_Endian, _0enum, &_0param ) ) )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->convertBitOrder((QImage::Endian)_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_mirror( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->mirror() );
    }
    bool _0param;
    bool _1param;
    if ( PyArg_ParseTuple( arg_tuple, "bb", &_0param, &_1param )  )
    {
         PyErr_Clear();
        return pyqt_qimage_toPython( ((QImage*)ptr)->mirror(_0param, _1param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_systemByteOrder( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return enumToPython( pyqt_qimage_Endian, (int)QImage::systemByteOrder() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_height( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->height() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_invertPixels( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    bool _0param= TRUE;
    if ( PyArg_ParseTuple( arg_tuple, "|b", &_0param )  )
    {
         ((QImage*)ptr)->invertPixels(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qimage_text( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0param = 0;
    char* _1param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "ss", &_0param, &_1param )  )
    {
         return PyString_FromString( ((QImage*)ptr)->text(_0param, _1param).latin1() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_color( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         return PyLong_FromUnsignedLong( ((QImage*)ptr)->color(_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_bitOrder( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return enumToPython( pyqt_qimage_Endian, (int)((QImage*)ptr)->bitOrder() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_dotsPerMeterY( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyInt_FromLong( ((QImage*)ptr)->dotsPerMeterY() );
    }
    return NULL;
}

static PyObject* pyqt_qimage_convertDepth( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         return pyqt_qimage_toPython( ((QImage*)ptr)->convertDepth(_0param) );
    }
    int _1param;
    int _2param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_1param, &_2param )  )
    {
         PyErr_Clear();
        return pyqt_qimage_toPython( ((QImage*)ptr)->convertDepth(_1param, _2param) );
    }
    return NULL;
}

static PyObject* pyqt_qimage_load( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0param = 0;
    char* _1param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "ss", &_0param, &_1param )  )
    {
         return Py_BuildValue("b", (char)((QImage*)ptr)->load(_0param, _1param) );
    }
    return NULL;
}

static PyQt_Method pyqt_qimage_methods[] = {
    pyqt_qimage_constructor,
    pyqt_qimage_textLanguages,
    pyqt_qimage_pixelIndex,
    pyqt_qimage_imageFormat,
    pyqt_qimage_depth,
    pyqt_qimage_isNull,
    pyqt_qimage_allGray,
    pyqt_qimage_setText,
    pyqt_qimage_loadFromData,
    pyqt_qimage_setColor,
    pyqt_qimage_setAlphaBuffer,
    pyqt_qimage_setNumColors,
    pyqt_qimage_systemBitOrder,
    pyqt_qimage_setDotsPerMeterY,
    pyqt_qimage_reset,
    pyqt_qimage_rect,
    pyqt_qimage_dotsPerMeterX,
    pyqt_qimage_hasAlphaBuffer,
    pyqt_qimage_copy,
    pyqt_qimage_inputFormatList,
    pyqt_qimage_createHeuristicMask,
    pyqt_qimage_isGrayscale,
    pyqt_qimage_numBytes,
    pyqt_qimage_smoothScale,
    pyqt_qimage_numColors,
    pyqt_qimage_detach,
    pyqt_qimage_offset,
    pyqt_qimage_swapRGB,
    pyqt_qimage_createAlphaMask,
    pyqt_qimage_pixel,
    pyqt_qimage_save,
    pyqt_qimage_setOffset,
    pyqt_qimage_textKeys,
    pyqt_qimage_valid,
    pyqt_qimage_width,
    pyqt_qimage_setPixel,
    pyqt_qimage_create,
    pyqt_qimage_setDotsPerMeterX,
    pyqt_qimage_bytesPerLine,
    pyqt_qimage_size,
    pyqt_qimage_outputFormatList,
    pyqt_qimage_fill,
    pyqt_qimage_convertBitOrder,
    pyqt_qimage_mirror,
    pyqt_qimage_systemByteOrder,
    pyqt_qimage_height,
    pyqt_qimage_invertPixels,
    pyqt_qimage_text,
    pyqt_qimage_color,
    pyqt_qimage_bitOrder,
    pyqt_qimage_dotsPerMeterY,
    pyqt_qimage_convertDepth,
    pyqt_qimage_load,
    0
};

static void pyqt_qimage_init()
{
    if ( pyqt_qimage_class )
        return;

    pyqt_qimage_class = new PyQt_ClassInfo;
    pyqt_qimage_class->freeQt = pyqt_qimage_free;
    pyqt_qimage_class->methods = pyqt_qimage_methods;
    pyqt_qimage_class->methodCount = methodCount( pyqt_qimage_methods );
    pyqt_qimage_class->next = 0;
    pyqt_qimage_class->classid = Image;
    pyqt_qimage_class->classObject = PyDict_GetItemString( pyqt_qt_dict, "QImage" );
    pyqt_qimage_class->className = "QImage";
    ASSERT( pyqt_qimage_class->classObject );
}
