#include "kcontrol.moc"
#include <mainwidget.h>
#include <ui.h>
#include <kglobal.h>
#include <klocale.h>
#include <qlayout.h>
#include <kaboutdata.h>
#include <unistd.h>

KControl::KControl(QWidget *parent, const char *name)
  : KCModule(parent, name)
{
	QVBoxLayout *layout=new QVBoxLayout(this);
	m=new MainWidget(this, name);
	layout->addWidget(m);
	connect(m, SIGNAL(configChanged()), SLOT(configChanged()));
        if (getuid() != 0) {
            m->makeReadOnly();
        }
}

void KControl::load()
{
	m->load();
}

void KControl::save()
{
	m->save();
}

void KControl::defaults()
{
	m->defaults();
}

void KControl::reset()
{
	m->reset();
}

void KControl::configChanged() // SLOT
{
	emit changed(true);
}

const KAboutData* KControl::aboutData() const
{
	KAboutData *about = new KAboutData(I18N_NOOP("kcmlilo"), I18N_NOOP("LILO Configuration"),
	0, 0, KAboutData::License_GPL,
	I18N_NOOP("(c) 2000, Bernhard Rosenkraenzer"));
	about->addAuthor("Bernhard \"Bero\" Rosenkraenzer", 0, "bero@redhat.com");
	return about;
}

extern "C"
{
  KCModule *create_lilo(QWidget *parent, const char *name)
  {
    return new KControl(parent, "kcmlilo");
  };
}

