/*
 *   Copyright (c) International Business Machines Corp., 2000-2002
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
/*
 *   FUNCTIONS: no-frills substitutes for fsck routines
 *              used by logredo modules outside of fsck
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "jfs_types.h"
#include "fsckmsgc.h"
#include "fsckmsge.h"

#define STDOUT_HANDLE  1
#define STDERR_HANDLE  2

extern short MsgProtocol[][2];

extern char *Vol_Label;

extern char *verbose_msg_ptr;

extern char *msgprms[];
extern short msgprmidx[];

extern unsigned long msgs_txt_maxlen;

/****************************************************************************
 * NAME: alloc_wrksp
 *
 * FUNCTION:  Allocates and initializes (to guarantee the storage is backed)
 *            dynamic storage for the caller.
 *
 * PARAMETERS:
 *      length         - input - the number of bytes of storage which are needed
 *      dynstg_object  - input - a constant (see xfsck.h) identifying the purpose
 *                               for which the storage is needed (Used in error
 *                               message if the request cannot be satisfied.
 *      addr_wrksp_ptr - input - the address of a variable in which this routine
 *                               will return the address of the dynamic storage
 *                               allocated for the caller
 *
 * RETURNS:
 *      success: 0
 *      failure: something else
 */
int alloc_wrksp(unsigned length, int dynstg_object, int for_logredo, void **addr_wrksp_ptr)
{
	int awsp_rc = 0;
	unsigned min_length;

	*addr_wrksp_ptr = NULL;	/* initialize return value */
	min_length = ((length + 7) / 4) * 4;	/* round up to an 4 byte boundary */

	*addr_wrksp_ptr = (char *) malloc(min_length);

	return (awsp_rc);
}

/*****************************************************************************
 * NAME: fsck_send_msg
 *
 * FUNCTION: Issue an fsck message, depending on the message's protocol
 *           according to the fsck message arrays.
 *
 * PARAMETERS:
 *      ?                 - input -
 *      ?                 - returned -
 *
 * RETURNS:
 * 	nothing
 */
void fsck_send_msg(int msg_num, int num_inserts)
{
	int prmidx;

	memset((void *) verbose_msg_ptr, '\0', msgs_txt_maxlen);

	prmidx = 0;
	while (prmidx < num_inserts) {
		if (msgprmidx[prmidx] != 0) {	/* variable text insert */
			msgprms[prmidx] = MsgText[msgprmidx[prmidx]];
		}
		prmidx += 1;
	}

	sprintf(verbose_msg_ptr, MsgText[msg_num],
		msgprms[0], msgprms[1], msgprms[2], msgprms[3], msgprms[4],
		msgprms[5], msgprms[6], msgprms[7], msgprms[8], msgprms[9]);

	printf("%s", verbose_msg_ptr);

	return;
}
