/*********************************************************************
 *      rec_select.c - exercises input interface of an OSS sound driver
 *			using select()
 *      Copyright (C) 1999-2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <stdlib.h>
#include "common.h"

int main()
{
	int audio_fd;
	__u8 devbuf[BUF_SIZE];
	int val, ret;
	mode_t mode;
	fd_set set;

	mode = O_RDONLY | O_NONBLOCK;
	audio_fd = setup("/dev/dsp", mode);

	FD_ZERO(&set);
	FD_SET(audio_fd, &set);

	while (1) {

		if (DEBUG)
			print_info(audio_fd, mode);

		val = BUF_SIZE;

		select(FD_SETSIZE, &set, NULL, NULL, NULL);

		if ((ret = read(audio_fd, devbuf, val)) == -1)
			perror("audio read");

		if (WRITE_FILE)
                        output_devbuf(devbuf);

		if (DEBUG)
			printf("(read)\ncount: %d ret: %d\n\n", val, ret);
	}

	return 0;
}
