#include "Config.h"
void ConfigFile::set(String const &key, String const &value, bool const &quote, bool const &removeIfEmpty, String const &prefix)
{
	String re="[ \t]*" + key + "[ \t]*=";
	String s=grep(re);
	if(value.empty() && removeIfEmpty) {
		if(!s.empty())
			remove(s);
	} else if(s.empty()) {
		if(quote)
			insert(end(), prefix + key + "=\"" + value + "\"");
		else
			insert(end(), prefix + key + "=" + value);
	} else {
		for(iterator it=begin(); it!=end(); it++)
			if(!(*it).regex(re).empty()) {
				if(quote)
					(*it)=prefix + key + "=\"" + value +"\"";
				else
					(*it)=prefix + key + "=" + value;
				break;
			}
	}
}
String const ConfigFile::get(String const &key, String const &dflt, bool const &unquote)
{
	String s=grep("[ \t]*" + key + "[ \t]*=").simplifyWhiteSpace();
	if(s.empty())
		return dflt;
	s=s.mid(s.locate("=")+2).simplifyWhiteSpace();
	if(unquote) {
		if(s.chr(0)=='"')
			s=s.mid(2);
		if(s.chr(s.size()-1)=='"')
			s=s.left(s.size()-1);
	}
	return s.simplifyWhiteSpace();
}
