/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "videocardpageimpl.h"
#include "kxdata.h"

#include <qheader.h>
#include <qlabel.h>

#include <klocale.h>
#include <klistview.h>

#include <assert.h>

VideoCardPage::VideoCardPage( QWidget *parent, const char *name )
    : VideoCardPageBase( parent, name )
{
    m_videoCards->header()->hide();
    m_vendors->header()->hide();
    m_selectedCard->setText( QString::null );

    connect( m_videoCards, SIGNAL( currentChanged( QListViewItem * ) ),
             this, SLOT( videoCardSelected( QListViewItem * ) ) );

    connect( m_videoCards, SIGNAL( currentChanged( QListViewItem * ) ),
             this, SIGNAL( changed() ) );

    connect( m_vendors, SIGNAL( currentChanged( QListViewItem * ) ),
             this, SIGNAL( changed() ) );

    connect( m_vendors, SIGNAL( currentChanged( QListViewItem * ) ),
             this, SLOT( vendorSelected( QListViewItem * ) ) );
}

VideoCardPage::~VideoCardPage()
{
}

void VideoCardPage::load()
{
    m_videoCards->clear();
    m_vendors->clear();

    m_current = m_data->currentVideoCards()[ 0 ];

    KXVideoCardDataMap videoCards = m_data->videoCards();
    KXVideoCardDataMap::ConstIterator vendorIt = videoCards.begin();
    KXVideoCardDataMap::ConstIterator vendorEnd = videoCards.end();
    for (; vendorIt != vendorEnd; ++vendorIt )
    {
        QListViewItem *vendorItem = new QListViewItem( m_vendors, 0 );
        vendorItem->setText( 0, vendorIt.key() );

        if ( vendorIt.key() == m_current.vendor() )
        {
            m_vendors->setCurrentItem( vendorItem );
            m_vendors->ensureItemVisible( vendorItem );
            vendorSelected( vendorItem );
        }

        /*
        KXVideoCardDataList cards = *vendorIt;
        KXVideoCardDataList::ConstIterator it = cards.begin();
        KXVideoCardDataList::ConstIterator end = cards.end();
        for (; it != end; ++it )
        {
            QListViewItem *item = new QListViewItem( vendorItem, 0 );
            item->setText( 0, (*it).name() );

            if ( *it == vcard ) // current card?
            {
                item->setSelected( true );
                vendorItem->setOpen( true );
                m_videoCards->ensureItemVisible( item );

                slotVideoCardSelected( item );
            }
        }
        */
    }

    emit enableForward( false );

    QListViewItem *cardItem = m_videoCards->firstChild();
    for (; cardItem; cardItem = cardItem->nextSibling() )
        if ( cardItem->text( 0 ) == m_current.model() )
        {
            m_videoCards->setCurrentItem( cardItem );
            m_videoCards->ensureItemVisible( cardItem );

            m_selectedCard->setText( m_current.model() );
            emit enableForward( true );

            break;
        }
}

void VideoCardPage::save()
{
    m_data->currentVideoCards()[ 0 ] = m_current;
}

void VideoCardPage::vendorSelected( QListViewItem *item )
{
    if ( !item )
        return;

    QString vendor = item->text( 0 );

    KXVideoCardDataList cardList = m_data->videoCards()[ vendor ];

    m_videoCards->clear();

    KXVideoCardDataList::ConstIterator it = cardList.begin();
    KXVideoCardDataList::ConstIterator end = cardList.end();
    for (; it != end; ++it )
    {
        QListViewItem *item = new QListViewItem( m_videoCards );
        item->setText( 0, (*it).model() );

        m_selectedCard->setText( QString::null );
        emit enableForward( false );
    }
}

void VideoCardPage::videoCardSelected( QListViewItem *item )
{
    assert( item );

    QListViewItem *vendorItem = m_vendors->currentItem();

    assert( vendorItem );
    assert( vendorItem->isSelected() );

    // find vendor
    KXVideoCardDataList vendorList = m_data->videoCards()[ vendorItem->text( 0 ) ];

    KXVideoCardDataList::ConstIterator it = vendorList.begin();
    KXVideoCardDataList::ConstIterator end = vendorList.end();
    for (; it != end; ++it )
        if ( item->text( 0 ) == (*it).model() )
        {
            m_selectedCard->setText( (*it).model() );

            m_current = *it;

            emit enableForward( true );
            break;
        }
}

QString VideoCardPage::quickHelp() const
{
    return i18n("<h1>Select Video Card</h1>"
                "<p>Please choose the video card built into your system from the list "
                "of card vendors and models on the left.</p>");
}

#include "videocardpageimpl.moc"
