#include "Messages.moc"
#include "AddMessage.h"
#include <klocale.h>
#include <kapplication.h>
#include <kurlrequester.h>

#include <qcheckbox.h>
#include <qlineedit.h>
#include <qwhatsthis.h>

Messages::Messages(QWidget *parent, const char *name)
 : MessagesBase(parent, name)
{
	banner->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);

	QWhatsThis::add(banner,i18n("The file selected here will be displayed to\nFTP users before login.\nMay break compatibility with truly ancient clients."));
	QWhatsThis::add(hostname,i18n("The hostname given here will be shown at login and for\nthe %L cookie in message files.\nIf this is blank, the canonical hostname of your system will be used."));
	QWhatsThis::add(adminmail,i18n("Email address returned with the %E cookie in message files."));
	QWhatsThis::add(msgShowEverytime,i18n("If this is not checked, message files at CWD will be displayed only once."));
	QWhatsThis::add(rdmShowEverytime,i18n("If this is not checked, hints on README files will be displayed only once."));

	QWhatsThis::add(messages, i18n("Messages are files that are automatically displayed to the user after logging in or after entering a directory. Use the <b>Add Message</b> and <b>Remove Message</b> buttons to modify the messages."));
	QWhatsThis::add(addMsg, i18n("Messages are files that are automatically displayed to the user after logging in or after entering a directory. Use the <b>Add Message</b> and <b>Remove Message</b> buttons to modify the messages."));
	QWhatsThis::add(rmMsg, i18n("Messages are files that are automatically displayed to the user after logging in or after entering a directory. Use the <b>Add Message</b> and <b>Remove Message</b> buttons to modify the messages."));

	QWhatsThis::add(readmes, i18n("When you've defined README files, users changing to a directory containing files matching the glob listed here will be pointed to these files with a <i>Please read the file README, last modified x days ago</i> message.<br>Use the <b>Add Readme</b> and <b>Remove Readme</b> buttons to modify the list of README files."));
	QWhatsThis::add(addRdm, i18n("When you've defined README files, users changing to a directory containing files matching the glob listed here will be pointed to these files with a <i>Please read the file README, last modified x days ago</i> message.<br>Use the <b>Add Readme</b> and <b>Remove Readme</b> buttons to modify the list of README files."));
	QWhatsThis::add(rmRdm, i18n("When you've defined README files, users changing to a directory containing files matching the glob listed here will be pointed to these files with a <i>Please read the file README, last modified x days ago</i> message.<br>Use the <b>Add Readme</b> and <b>Remove Readme</b> buttons to modify the list of README files."));

	connect(addMsg,SIGNAL(clicked()),SLOT(addMsgPressed()));
	connect(rmMsg,SIGNAL(clicked()),SLOT(rmMsgPressed()));
	connect(addRdm,SIGNAL(clicked()),SLOT(addRdmPressed()));
	connect(rmRdm,SIGNAL(clicked()),SLOT(rmRdmPressed()));
}

Messages::~Messages()
{
}
void Messages::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	banner->setURL(xs->getBanner());
	hostname->setText(xs->getHostname());
	adminmail->setText(xs->getAdminMail());
	msgShowEverytime->setChecked(xs->getMsgShowEverytime());
	rdmShowEverytime->setChecked(xs->getRdmShowEverytime());
	redrawLBs();
}
void Messages::redrawLBs()
{
	messages->clear();
	ftpmessage *m=ftpxs->getFirstMessage();
	while(m) {
		messages->insertItem(m->getId());
		m=ftpxs->getNextMessage(m);
	}
	messages->update();	
	readmes->clear();
	ftpmessage *r=ftpxs->getFirstReadme();
	while(r) {
		readmes->insertItem(r->getId());
		r=ftpxs->getNextReadme(r);
	}
	readmes->update();	
}
void Messages::update()
{
	ftpxs->setBanner(banner->url());
	ftpxs->setHostname(hostname->text());
	ftpxs->setAdminMail(adminmail->text());
	ftpxs->setMsgShowEverytime(msgShowEverytime->isChecked());
	ftpxs->setRdmShowEverytime(rdmShowEverytime->isChecked());
}
void Messages::addMsgPressed()
{
	addDlg(false);
}
void Messages::rmMsgPressed()
{
	for(int i=0;i<ftpxs->getNumMessages();i++) 
		if(messages->isSelected(i))
			ftpxs->deleteMessage(i);
	redrawLBs();
}
void Messages::addRdmPressed()
{
	addDlg(true);
}
void Messages::rmRdmPressed()
{
	for(int i=0;i<ftpxs->getNumReadmes();i++) 
		if(readmes->isSelected(i))
			ftpxs->deleteReadme(i);
	redrawLBs();
}
void Messages::addDlg(bool readme)
{
	AddMessage am(ftpxs,readme,0);
	connect(&am,SIGNAL(MessageAdded(bool, ftpmessage *)),SLOT(MessageAdded(bool, ftpmessage *)));
	am.exec();
}
void Messages::MessageAdded(bool readme, ftpmessage *m)
{
	if(readme)
		ftpxs->addReadme(m);
	else
		ftpxs->addMessage(m);
	redrawLBs();
}
