/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSFLOW_H
#define ARTSFLOW_H

#include "common.h"

namespace Arts {
enum AutoSuspendState {asNoSuspend = 0, asSuspend = 1, asSuspendStop = 2};
enum AudioManagerDirection {amPlay = 0, amRecord = 1};
}
namespace Arts {
class AudioManagerInfo : public Arts::Type {
public:
	AudioManagerInfo();
	AudioManagerInfo(long _a_ID, const std::string& _a_destination, Arts::AudioManagerDirection _a_direction, const std::string& _a_title, const std::string& _a_autoRestoreID);
	AudioManagerInfo(Arts::Buffer& stream);
	AudioManagerInfo(const AudioManagerInfo& copyType);
	AudioManagerInfo& operator=(const AudioManagerInfo& assignType);
	long ID;
	std::string destination;
	Arts::AudioManagerDirection direction;
	std::string title;
	std::string autoRestoreID;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

}
namespace Arts {
class SynthModule;
class Synth_PLAY;
class Synth_RECORD;
class Synth_FREQUENCY;
class Synth_WAVE_SIN;
class Synth_MULTI_ADD;
class Synth_ADD;
class Synth_MUL;
class Synth_PLAY_WAV;
class Synth_BUS_UPLINK;
class Synth_BUS_DOWNLINK;
class ByteStreamToAudio;
class AudioToByteStream;
class StereoEffect;
class StereoVolumeControl;
class StereoFFTScope;
class StereoEffectStack;
class AudioManagerClient;
class AudioManager;
class Synth_AMAN_PLAY;
class Synth_AMAN_RECORD;
class DataHandle;
class ReversedDataHandle;
class CroppedDataHandle;
class CutDataHandle;
class DataHandlePlay;
class WaveDataHandle;

class SynthModule_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static SynthModule_base *_create(const std::string& subClass = "Arts::SynthModule");
	static SynthModule_base *_fromString(const std::string& objectref);
	static SynthModule_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SynthModule_base *_fromDynamicCast(const Arts::Object& object);
	inline SynthModule_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::AutoSuspendState autoSuspend() = 0;
	virtual void start() = 0;
	virtual void stop() = 0;
	virtual void streamInit() = 0;
	virtual void streamStart() = 0;
	virtual void streamEnd() = 0;
};

class SynthModule_stub : virtual public SynthModule_base, virtual public Arts::Object_stub {
protected:
	SynthModule_stub();

public:
	SynthModule_stub(Arts::Connection *connection, long objectID);

	Arts::AutoSuspendState autoSuspend();
	void start();
	void stop();
	void streamInit();
	void streamStart();
	void streamEnd();
};

class SynthModule_skel : virtual public SynthModule_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void autoSuspend_changed(Arts::AutoSuspendState newValue) {
		_emit_changed("autoSuspend_changed",newValue);
	}

public:
	SynthModule_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class SynthModule : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SynthModule_base *_cache;
	inline SynthModule_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SynthModule_base *)_pool->base->_cast(SynthModule_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SynthModule(SynthModule_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SynthModule_base _base_class;

	inline SynthModule() : Arts::Object(_Creator), _cache(0) {}
	inline SynthModule(const Arts::SubClass& s) :
		Arts::Object(SynthModule_base::_create(s.string())), _cache(0) {}
	inline SynthModule(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SynthModule_base::_fromString(r.string())):(SynthModule_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SynthModule(const Arts::DynamicCast& c) : Arts::Object(SynthModule_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SynthModule(const SynthModule& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SynthModule(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SynthModule null() {return SynthModule((SynthModule_base*)0);}
	inline static SynthModule _from_base(SynthModule_base* b) {return SynthModule(b);}
	inline SynthModule& operator=(const SynthModule& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline SynthModule_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_PLAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_base *_create(const std::string& subClass = "Arts::Synth_PLAY");
	static Synth_PLAY_base *_fromString(const std::string& objectref);
	static Synth_PLAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_PLAY_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_PLAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_PLAY_stub : virtual public Synth_PLAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PLAY_stub();

public:
	Synth_PLAY_stub(Arts::Connection *connection, long objectID);

};

class Synth_PLAY_skel : virtual public Synth_PLAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue_left;                      // incoming stream
	float *invalue_right;                     // incoming stream

public:
	Synth_PLAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_PLAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PLAY_base *_cache;
	inline Synth_PLAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_base *)_pool->base->_cast(Synth_PLAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PLAY(Synth_PLAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PLAY_base _base_class;

	inline Synth_PLAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PLAY(const Arts::SubClass& s) :
		Arts::Object(Synth_PLAY_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PLAY_base::_fromString(r.string())):(Synth_PLAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY(const Arts::DynamicCast& c) : Arts::Object(Synth_PLAY_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_PLAY(const Synth_PLAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PLAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PLAY null() {return Synth_PLAY((Synth_PLAY_base*)0);}
	inline static Synth_PLAY _from_base(Synth_PLAY_base* b) {return Synth_PLAY(b);}
	inline Synth_PLAY& operator=(const Synth_PLAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PLAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_RECORD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_RECORD_base *_create(const std::string& subClass = "Arts::Synth_RECORD");
	static Synth_RECORD_base *_fromString(const std::string& objectref);
	static Synth_RECORD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_RECORD_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_RECORD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_RECORD_stub : virtual public Synth_RECORD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_RECORD_stub();

public:
	Synth_RECORD_stub(Arts::Connection *connection, long objectID);

};

class Synth_RECORD_skel : virtual public Synth_RECORD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	Synth_RECORD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_RECORD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_RECORD_base *_cache;
	inline Synth_RECORD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_RECORD_base *)_pool->base->_cast(Synth_RECORD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_RECORD(Synth_RECORD_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_RECORD_base _base_class;

	inline Synth_RECORD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_RECORD(const Arts::SubClass& s) :
		Arts::Object(Synth_RECORD_base::_create(s.string())), _cache(0) {}
	inline Synth_RECORD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_RECORD_base::_fromString(r.string())):(Synth_RECORD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_RECORD(const Arts::DynamicCast& c) : Arts::Object(Synth_RECORD_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_RECORD(const Synth_RECORD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_RECORD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_RECORD null() {return Synth_RECORD((Synth_RECORD_base*)0);}
	inline static Synth_RECORD _from_base(Synth_RECORD_base* b) {return Synth_RECORD(b);}
	inline Synth_RECORD& operator=(const Synth_RECORD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_RECORD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_FREQUENCY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FREQUENCY_base *_create(const std::string& subClass = "Arts::Synth_FREQUENCY");
	static Synth_FREQUENCY_base *_fromString(const std::string& objectref);
	static Synth_FREQUENCY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_FREQUENCY_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_FREQUENCY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_FREQUENCY_stub : virtual public Synth_FREQUENCY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FREQUENCY_stub();

public:
	Synth_FREQUENCY_stub(Arts::Connection *connection, long objectID);

};

class Synth_FREQUENCY_skel : virtual public Synth_FREQUENCY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *pos;                               // outgoing stream

public:
	Synth_FREQUENCY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_FREQUENCY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FREQUENCY_base *_cache;
	inline Synth_FREQUENCY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FREQUENCY_base *)_pool->base->_cast(Synth_FREQUENCY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FREQUENCY(Synth_FREQUENCY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FREQUENCY_base _base_class;

	inline Synth_FREQUENCY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::SubClass& s) :
		Arts::Object(Synth_FREQUENCY_base::_create(s.string())), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FREQUENCY_base::_fromString(r.string())):(Synth_FREQUENCY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FREQUENCY(const Arts::DynamicCast& c) : Arts::Object(Synth_FREQUENCY_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_FREQUENCY(const Synth_FREQUENCY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FREQUENCY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FREQUENCY null() {return Synth_FREQUENCY((Synth_FREQUENCY_base*)0);}
	inline static Synth_FREQUENCY _from_base(Synth_FREQUENCY_base* b) {return Synth_FREQUENCY(b);}
	inline Synth_FREQUENCY& operator=(const Synth_FREQUENCY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FREQUENCY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_SIN_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SIN_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SIN");
	static Synth_WAVE_SIN_base *_fromString(const std::string& objectref);
	static Synth_WAVE_SIN_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_WAVE_SIN_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_WAVE_SIN_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SIN_stub : virtual public Synth_WAVE_SIN_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SIN_stub();

public:
	Synth_WAVE_SIN_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SIN_skel : virtual public Synth_WAVE_SIN_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SIN_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_WAVE_SIN : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SIN_base *_cache;
	inline Synth_WAVE_SIN_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SIN_base *)_pool->base->_cast(Synth_WAVE_SIN_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SIN(Synth_WAVE_SIN_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SIN_base _base_class;

	inline Synth_WAVE_SIN() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SIN_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SIN_base::_fromString(r.string())):(Synth_WAVE_SIN_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SIN(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SIN_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_WAVE_SIN(const Synth_WAVE_SIN& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SIN(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SIN null() {return Synth_WAVE_SIN((Synth_WAVE_SIN_base*)0);}
	inline static Synth_WAVE_SIN _from_base(Synth_WAVE_SIN_base* b) {return Synth_WAVE_SIN(b);}
	inline Synth_WAVE_SIN& operator=(const Synth_WAVE_SIN& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SIN_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MULTI_ADD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MULTI_ADD_base *_create(const std::string& subClass = "Arts::Synth_MULTI_ADD");
	static Synth_MULTI_ADD_base *_fromString(const std::string& objectref);
	static Synth_MULTI_ADD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_MULTI_ADD_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_MULTI_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MULTI_ADD_stub : virtual public Synth_MULTI_ADD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MULTI_ADD_stub();

public:
	Synth_MULTI_ADD_stub(Arts::Connection *connection, long objectID);

};

class Synth_MULTI_ADD_skel : virtual public Synth_MULTI_ADD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float **invalue;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MULTI_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_MULTI_ADD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MULTI_ADD_base *_cache;
	inline Synth_MULTI_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MULTI_ADD_base *)_pool->base->_cast(Synth_MULTI_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MULTI_ADD(Synth_MULTI_ADD_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MULTI_ADD_base _base_class;

	inline Synth_MULTI_ADD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::SubClass& s) :
		Arts::Object(Synth_MULTI_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MULTI_ADD_base::_fromString(r.string())):(Synth_MULTI_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MULTI_ADD(const Arts::DynamicCast& c) : Arts::Object(Synth_MULTI_ADD_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_MULTI_ADD(const Synth_MULTI_ADD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MULTI_ADD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MULTI_ADD null() {return Synth_MULTI_ADD((Synth_MULTI_ADD_base*)0);}
	inline static Synth_MULTI_ADD _from_base(Synth_MULTI_ADD_base* b) {return Synth_MULTI_ADD(b);}
	inline Synth_MULTI_ADD& operator=(const Synth_MULTI_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MULTI_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_ADD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ADD_base *_create(const std::string& subClass = "Arts::Synth_ADD");
	static Synth_ADD_base *_fromString(const std::string& objectref);
	static Synth_ADD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_ADD_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_ADD_stub : virtual public Synth_ADD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ADD_stub();

public:
	Synth_ADD_stub(Arts::Connection *connection, long objectID);

};

class Synth_ADD_skel : virtual public Synth_ADD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_ADD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ADD_base *_cache;
	inline Synth_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ADD_base *)_pool->base->_cast(Synth_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ADD(Synth_ADD_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_ADD_base _base_class;

	inline Synth_ADD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ADD(const Arts::SubClass& s) :
		Arts::Object(Synth_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_ADD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ADD_base::_fromString(r.string())):(Synth_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ADD(const Arts::DynamicCast& c) : Arts::Object(Synth_ADD_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_ADD(const Synth_ADD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ADD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ADD null() {return Synth_ADD((Synth_ADD_base*)0);}
	inline static Synth_ADD _from_base(Synth_ADD_base* b) {return Synth_ADD(b);}
	inline Synth_ADD& operator=(const Synth_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MUL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MUL_base *_create(const std::string& subClass = "Arts::Synth_MUL");
	static Synth_MUL_base *_fromString(const std::string& objectref);
	static Synth_MUL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_MUL_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_MUL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MUL_stub : virtual public Synth_MUL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MUL_stub();

public:
	Synth_MUL_stub(Arts::Connection *connection, long objectID);

};

class Synth_MUL_skel : virtual public Synth_MUL_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MUL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_MUL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MUL_base *_cache;
	inline Synth_MUL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MUL_base *)_pool->base->_cast(Synth_MUL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MUL(Synth_MUL_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MUL_base _base_class;

	inline Synth_MUL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MUL(const Arts::SubClass& s) :
		Arts::Object(Synth_MUL_base::_create(s.string())), _cache(0) {}
	inline Synth_MUL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MUL_base::_fromString(r.string())):(Synth_MUL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MUL(const Arts::DynamicCast& c) : Arts::Object(Synth_MUL_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_MUL(const Synth_MUL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MUL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MUL null() {return Synth_MUL((Synth_MUL_base*)0);}
	inline static Synth_MUL _from_base(Synth_MUL_base* b) {return Synth_MUL(b);}
	inline Synth_MUL& operator=(const Synth_MUL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MUL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_PLAY_WAV_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_WAV_base *_create(const std::string& subClass = "Arts::Synth_PLAY_WAV");
	static Synth_PLAY_WAV_base *_fromString(const std::string& objectref);
	static Synth_PLAY_WAV_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_PLAY_WAV_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_PLAY_WAV_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual bool finished() = 0;
};

class Synth_PLAY_WAV_stub : virtual public Synth_PLAY_WAV_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PLAY_WAV_stub();

public:
	Synth_PLAY_WAV_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	std::string filename();
	void filename(const std::string& newValue);
	bool finished();
};

class Synth_PLAY_WAV_skel : virtual public Synth_PLAY_WAV_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}
	inline void finished_changed(bool newValue) {
		_emit_changed("finished_changed",newValue);
	}

public:
	Synth_PLAY_WAV_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_PLAY_WAV : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PLAY_WAV_base *_cache;
	inline Synth_PLAY_WAV_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_WAV_base *)_pool->base->_cast(Synth_PLAY_WAV_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PLAY_WAV(Synth_PLAY_WAV_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PLAY_WAV_base _base_class;

	inline Synth_PLAY_WAV() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::SubClass& s) :
		Arts::Object(Synth_PLAY_WAV_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PLAY_WAV_base::_fromString(r.string())):(Synth_PLAY_WAV_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY_WAV(const Arts::DynamicCast& c) : Arts::Object(Synth_PLAY_WAV_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_PLAY_WAV(const Synth_PLAY_WAV& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PLAY_WAV(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PLAY_WAV null() {return Synth_PLAY_WAV((Synth_PLAY_WAV_base*)0);}
	inline static Synth_PLAY_WAV _from_base(Synth_PLAY_WAV_base* b) {return Synth_PLAY_WAV(b);}
	inline Synth_PLAY_WAV& operator=(const Synth_PLAY_WAV& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PLAY_WAV_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline bool finished();
};

class Synth_BUS_UPLINK_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_BUS_UPLINK_base *_create(const std::string& subClass = "Arts::Synth_BUS_UPLINK");
	static Synth_BUS_UPLINK_base *_fromString(const std::string& objectref);
	static Synth_BUS_UPLINK_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_BUS_UPLINK_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_BUS_UPLINK_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string busname() = 0;
	virtual void busname(const std::string& newValue) = 0;
};

class Synth_BUS_UPLINK_stub : virtual public Synth_BUS_UPLINK_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_BUS_UPLINK_stub();

public:
	Synth_BUS_UPLINK_stub(Arts::Connection *connection, long objectID);

	std::string busname();
	void busname(const std::string& newValue);
};

class Synth_BUS_UPLINK_skel : virtual public Synth_BUS_UPLINK_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // incoming stream
	float *right;                             // incoming stream

protected:
	// emitters for change notifications
	inline void busname_changed(const std::string& newValue) {
		_emit_changed("busname_changed",newValue);
	}

public:
	Synth_BUS_UPLINK_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_BUS_UPLINK : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_BUS_UPLINK_base *_cache;
	inline Synth_BUS_UPLINK_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_BUS_UPLINK_base *)_pool->base->_cast(Synth_BUS_UPLINK_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_BUS_UPLINK(Synth_BUS_UPLINK_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_BUS_UPLINK_base _base_class;

	inline Synth_BUS_UPLINK() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_BUS_UPLINK(const Arts::SubClass& s) :
		Arts::Object(Synth_BUS_UPLINK_base::_create(s.string())), _cache(0) {}
	inline Synth_BUS_UPLINK(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_BUS_UPLINK_base::_fromString(r.string())):(Synth_BUS_UPLINK_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_BUS_UPLINK(const Arts::DynamicCast& c) : Arts::Object(Synth_BUS_UPLINK_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_BUS_UPLINK(const Synth_BUS_UPLINK& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_BUS_UPLINK(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_BUS_UPLINK null() {return Synth_BUS_UPLINK((Synth_BUS_UPLINK_base*)0);}
	inline static Synth_BUS_UPLINK _from_base(Synth_BUS_UPLINK_base* b) {return Synth_BUS_UPLINK(b);}
	inline Synth_BUS_UPLINK& operator=(const Synth_BUS_UPLINK& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_BUS_UPLINK_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string busname();
	inline void busname(const std::string& _newValue);
};

class Synth_BUS_DOWNLINK_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_BUS_DOWNLINK_base *_create(const std::string& subClass = "Arts::Synth_BUS_DOWNLINK");
	static Synth_BUS_DOWNLINK_base *_fromString(const std::string& objectref);
	static Synth_BUS_DOWNLINK_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_BUS_DOWNLINK_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_BUS_DOWNLINK_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string busname() = 0;
	virtual void busname(const std::string& newValue) = 0;
};

class Synth_BUS_DOWNLINK_stub : virtual public Synth_BUS_DOWNLINK_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_BUS_DOWNLINK_stub();

public:
	Synth_BUS_DOWNLINK_stub(Arts::Connection *connection, long objectID);

	std::string busname();
	void busname(const std::string& newValue);
};

class Synth_BUS_DOWNLINK_skel : virtual public Synth_BUS_DOWNLINK_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

protected:
	// emitters for change notifications
	inline void busname_changed(const std::string& newValue) {
		_emit_changed("busname_changed",newValue);
	}

public:
	Synth_BUS_DOWNLINK_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_BUS_DOWNLINK : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_BUS_DOWNLINK_base *_cache;
	inline Synth_BUS_DOWNLINK_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_BUS_DOWNLINK_base *)_pool->base->_cast(Synth_BUS_DOWNLINK_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_BUS_DOWNLINK(Synth_BUS_DOWNLINK_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_BUS_DOWNLINK_base _base_class;

	inline Synth_BUS_DOWNLINK() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_BUS_DOWNLINK(const Arts::SubClass& s) :
		Arts::Object(Synth_BUS_DOWNLINK_base::_create(s.string())), _cache(0) {}
	inline Synth_BUS_DOWNLINK(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_BUS_DOWNLINK_base::_fromString(r.string())):(Synth_BUS_DOWNLINK_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_BUS_DOWNLINK(const Arts::DynamicCast& c) : Arts::Object(Synth_BUS_DOWNLINK_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_BUS_DOWNLINK(const Synth_BUS_DOWNLINK& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_BUS_DOWNLINK(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_BUS_DOWNLINK null() {return Synth_BUS_DOWNLINK((Synth_BUS_DOWNLINK_base*)0);}
	inline static Synth_BUS_DOWNLINK _from_base(Synth_BUS_DOWNLINK_base* b) {return Synth_BUS_DOWNLINK(b);}
	inline Synth_BUS_DOWNLINK& operator=(const Synth_BUS_DOWNLINK& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_BUS_DOWNLINK_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string busname();
	inline void busname(const std::string& _newValue);
};

class ByteStreamToAudio_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteStreamToAudio_base *_create(const std::string& subClass = "Arts::ByteStreamToAudio");
	static ByteStreamToAudio_base *_fromString(const std::string& objectref);
	static ByteStreamToAudio_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ByteStreamToAudio_base *_fromDynamicCast(const Arts::Object& object);
	inline ByteStreamToAudio_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual void samplingRate(long newValue) = 0;
	virtual long channels() = 0;
	virtual void channels(long newValue) = 0;
	virtual long bits() = 0;
	virtual void bits(long newValue) = 0;
	virtual bool running() = 0;
};

class ByteStreamToAudio_stub : virtual public ByteStreamToAudio_base, virtual public Arts::SynthModule_stub {
protected:
	ByteStreamToAudio_stub();

public:
	ByteStreamToAudio_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	void samplingRate(long newValue);
	long channels();
	void channels(long newValue);
	long bits();
	void bits(long newValue);
	bool running();
};

class ByteStreamToAudio_skel : virtual public ByteStreamToAudio_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream indata;             // incoming stream
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

	// handler for asynchronous streams
	virtual void process_indata(Arts::DataPacket<Arts::mcopbyte> *) = 0;

protected:
	// emitters for change notifications
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}
	inline void running_changed(bool newValue) {
		_emit_changed("running_changed",newValue);
	}

public:
	ByteStreamToAudio_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

}
#include "reference.h"
namespace Arts {
class ByteStreamToAudio : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ByteStreamToAudio_base *_cache;
	inline ByteStreamToAudio_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteStreamToAudio_base *)_pool->base->_cast(ByteStreamToAudio_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ByteStreamToAudio(ByteStreamToAudio_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ByteStreamToAudio_base _base_class;

	inline ByteStreamToAudio() : Arts::Object(_Creator), _cache(0) {}
	inline ByteStreamToAudio(const Arts::SubClass& s) :
		Arts::Object(ByteStreamToAudio_base::_create(s.string())), _cache(0) {}
	inline ByteStreamToAudio(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ByteStreamToAudio_base::_fromString(r.string())):(ByteStreamToAudio_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteStreamToAudio(const Arts::DynamicCast& c) : Arts::Object(ByteStreamToAudio_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ByteStreamToAudio(const ByteStreamToAudio& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ByteStreamToAudio(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ByteStreamToAudio null() {return ByteStreamToAudio((ByteStreamToAudio_base*)0);}
	inline static ByteStreamToAudio _from_base(ByteStreamToAudio_base* b) {return ByteStreamToAudio(b);}
	inline ByteStreamToAudio& operator=(const ByteStreamToAudio& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline ByteStreamToAudio_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline void samplingRate(long _newValue);
	inline long channels();
	inline void channels(long _newValue);
	inline long bits();
	inline void bits(long _newValue);
	inline bool running();
};

class AudioToByteStream_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static AudioToByteStream_base *_create(const std::string& subClass = "Arts::AudioToByteStream");
	static AudioToByteStream_base *_fromString(const std::string& objectref);
	static AudioToByteStream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AudioToByteStream_base *_fromDynamicCast(const Arts::Object& object);
	inline AudioToByteStream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual void samplingRate(long newValue) = 0;
	virtual long channels() = 0;
	virtual void channels(long newValue) = 0;
	virtual long bits() = 0;
	virtual void bits(long newValue) = 0;
};

class AudioToByteStream_stub : virtual public AudioToByteStream_base, virtual public Arts::SynthModule_stub {
protected:
	AudioToByteStream_stub();

public:
	AudioToByteStream_stub(Arts::Connection *connection, long objectID);

	long samplingRate();
	void samplingRate(long newValue);
	long channels();
	void channels(long newValue);
	long bits();
	void bits(long newValue);
};

class AudioToByteStream_skel : virtual public AudioToByteStream_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	Arts::ByteAsyncStream outdata;            // outgoing stream
	float *left;                              // incoming stream
	float *right;                             // incoming stream

	// handler for asynchronous streams
	virtual void request_outdata(Arts::DataPacket<Arts::mcopbyte> *);

protected:
	// emitters for change notifications
	inline void samplingRate_changed(long newValue) {
		_emit_changed("samplingRate_changed",newValue);
	}
	inline void channels_changed(long newValue) {
		_emit_changed("channels_changed",newValue);
	}
	inline void bits_changed(long newValue) {
		_emit_changed("bits_changed",newValue);
	}

public:
	AudioToByteStream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
	void notify(const Arts::Notification& notification);
};

}
#include "reference.h"
namespace Arts {
class AudioToByteStream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AudioToByteStream_base *_cache;
	inline AudioToByteStream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AudioToByteStream_base *)_pool->base->_cast(AudioToByteStream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AudioToByteStream(AudioToByteStream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AudioToByteStream_base _base_class;

	inline AudioToByteStream() : Arts::Object(_Creator), _cache(0) {}
	inline AudioToByteStream(const Arts::SubClass& s) :
		Arts::Object(AudioToByteStream_base::_create(s.string())), _cache(0) {}
	inline AudioToByteStream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AudioToByteStream_base::_fromString(r.string())):(AudioToByteStream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AudioToByteStream(const Arts::DynamicCast& c) : Arts::Object(AudioToByteStream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AudioToByteStream(const AudioToByteStream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AudioToByteStream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AudioToByteStream null() {return AudioToByteStream((AudioToByteStream_base*)0);}
	inline static AudioToByteStream _from_base(AudioToByteStream_base* b) {return AudioToByteStream(b);}
	inline AudioToByteStream& operator=(const AudioToByteStream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline AudioToByteStream_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long samplingRate();
	inline void samplingRate(long _newValue);
	inline long channels();
	inline void channels(long _newValue);
	inline long bits();
	inline void bits(long _newValue);
};

class StereoEffect_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffect_base *_create(const std::string& subClass = "Arts::StereoEffect");
	static StereoEffect_base *_fromString(const std::string& objectref);
	static StereoEffect_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoEffect_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoEffect_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class StereoEffect_stub : virtual public StereoEffect_base, virtual public Arts::SynthModule_stub {
protected:
	StereoEffect_stub();

public:
	StereoEffect_stub(Arts::Connection *connection, long objectID);

};

class StereoEffect_skel : virtual public StereoEffect_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *inleft;                            // incoming stream
	float *inright;                           // incoming stream
	float *outleft;                           // outgoing stream
	float *outright;                          // outgoing stream

public:
	StereoEffect_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StereoEffect : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffect_base *_cache;
	inline StereoEffect_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffect_base *)_pool->base->_cast(StereoEffect_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffect(StereoEffect_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoEffect_base _base_class;

	inline StereoEffect() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffect(const Arts::SubClass& s) :
		Arts::Object(StereoEffect_base::_create(s.string())), _cache(0) {}
	inline StereoEffect(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffect_base::_fromString(r.string())):(StereoEffect_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffect(const Arts::DynamicCast& c) : Arts::Object(StereoEffect_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoEffect(const StereoEffect& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffect(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffect null() {return StereoEffect((StereoEffect_base*)0);}
	inline static StereoEffect _from_base(StereoEffect_base* b) {return StereoEffect(b);}
	inline StereoEffect& operator=(const StereoEffect& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoEffect_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class StereoVolumeControl_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoVolumeControl_base *_create(const std::string& subClass = "Arts::StereoVolumeControl");
	static StereoVolumeControl_base *_fromString(const std::string& objectref);
	static StereoVolumeControl_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoVolumeControl_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoVolumeControl_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float scaleFactor() = 0;
	virtual void scaleFactor(float newValue) = 0;
	virtual float currentVolumeLeft() = 0;
	virtual float currentVolumeRight() = 0;
};

class StereoVolumeControl_stub : virtual public StereoVolumeControl_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoVolumeControl_stub();

public:
	StereoVolumeControl_stub(Arts::Connection *connection, long objectID);

	float scaleFactor();
	void scaleFactor(float newValue);
	float currentVolumeLeft();
	float currentVolumeRight();
};

class StereoVolumeControl_skel : virtual public StereoVolumeControl_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void scaleFactor_changed(float newValue) {
		_emit_changed("scaleFactor_changed",newValue);
	}
	inline void currentVolumeLeft_changed(float newValue) {
		_emit_changed("currentVolumeLeft_changed",newValue);
	}
	inline void currentVolumeRight_changed(float newValue) {
		_emit_changed("currentVolumeRight_changed",newValue);
	}

public:
	StereoVolumeControl_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StereoVolumeControl : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoVolumeControl_base *_cache;
	inline StereoVolumeControl_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoVolumeControl_base *)_pool->base->_cast(StereoVolumeControl_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoVolumeControl(StereoVolumeControl_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoVolumeControl_base _base_class;

	inline StereoVolumeControl() : Arts::Object(_Creator), _cache(0) {}
	inline StereoVolumeControl(const Arts::SubClass& s) :
		Arts::Object(StereoVolumeControl_base::_create(s.string())), _cache(0) {}
	inline StereoVolumeControl(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoVolumeControl_base::_fromString(r.string())):(StereoVolumeControl_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoVolumeControl(const Arts::DynamicCast& c) : Arts::Object(StereoVolumeControl_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoVolumeControl(const StereoVolumeControl& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoVolumeControl(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoVolumeControl null() {return StereoVolumeControl((StereoVolumeControl_base*)0);}
	inline static StereoVolumeControl _from_base(StereoVolumeControl_base* b) {return StereoVolumeControl(b);}
	inline StereoVolumeControl& operator=(const StereoVolumeControl& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoVolumeControl_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float scaleFactor();
	inline void scaleFactor(float _newValue);
	inline float currentVolumeLeft();
	inline float currentVolumeRight();
};

class StereoFFTScope_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoFFTScope_base *_create(const std::string& subClass = "Arts::StereoFFTScope");
	static StereoFFTScope_base *_fromString(const std::string& objectref);
	static StereoFFTScope_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoFFTScope_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoFFTScope_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<float> * scope() = 0;
};

class StereoFFTScope_stub : virtual public StereoFFTScope_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoFFTScope_stub();

public:
	StereoFFTScope_stub(Arts::Connection *connection, long objectID);

	std::vector<float> * scope();
};

class StereoFFTScope_skel : virtual public StereoFFTScope_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void scope_changed(const std::vector<float>& newValue) {
		_emit_changed("scope_changed",newValue);
	}

public:
	StereoFFTScope_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StereoFFTScope : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoFFTScope_base *_cache;
	inline StereoFFTScope_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoFFTScope_base *)_pool->base->_cast(StereoFFTScope_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoFFTScope(StereoFFTScope_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoFFTScope_base _base_class;

	inline StereoFFTScope() : Arts::Object(_Creator), _cache(0) {}
	inline StereoFFTScope(const Arts::SubClass& s) :
		Arts::Object(StereoFFTScope_base::_create(s.string())), _cache(0) {}
	inline StereoFFTScope(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoFFTScope_base::_fromString(r.string())):(StereoFFTScope_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoFFTScope(const Arts::DynamicCast& c) : Arts::Object(StereoFFTScope_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoFFTScope(const StereoFFTScope& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoFFTScope(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoFFTScope null() {return StereoFFTScope((StereoFFTScope_base*)0);}
	inline static StereoFFTScope _from_base(StereoFFTScope_base* b) {return StereoFFTScope(b);}
	inline StereoFFTScope& operator=(const StereoFFTScope& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoFFTScope_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::vector<float> * scope();
};

class StereoEffectStack_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffectStack_base *_create(const std::string& subClass = "Arts::StereoEffectStack");
	static StereoEffectStack_base *_fromString(const std::string& objectref);
	static StereoEffectStack_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoEffectStack_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoEffectStack_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long insertTop(Arts::StereoEffect effect, const std::string& name) = 0;
	virtual long insertBottom(Arts::StereoEffect effect, const std::string& name) = 0;
	virtual void remove(long ID) = 0;
};

class StereoEffectStack_stub : virtual public StereoEffectStack_base, virtual public Arts::StereoEffect_stub {
protected:
	StereoEffectStack_stub();

public:
	StereoEffectStack_stub(Arts::Connection *connection, long objectID);

	long insertTop(Arts::StereoEffect effect, const std::string& name);
	long insertBottom(Arts::StereoEffect effect, const std::string& name);
	void remove(long ID);
};

class StereoEffectStack_skel : virtual public StereoEffectStack_base, virtual public Arts::StereoEffect_skel {
public:
	StereoEffectStack_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class StereoEffectStack : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffectStack_base *_cache;
	inline StereoEffectStack_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffectStack_base *)_pool->base->_cast(StereoEffectStack_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffectStack(StereoEffectStack_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoEffectStack_base _base_class;

	inline StereoEffectStack() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffectStack(const Arts::SubClass& s) :
		Arts::Object(StereoEffectStack_base::_create(s.string())), _cache(0) {}
	inline StereoEffectStack(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffectStack_base::_fromString(r.string())):(StereoEffectStack_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffectStack(const Arts::DynamicCast& c) : Arts::Object(StereoEffectStack_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoEffectStack(const StereoEffectStack& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffectStack(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffectStack null() {return StereoEffectStack((StereoEffectStack_base*)0);}
	inline static StereoEffectStack _from_base(StereoEffectStack_base* b) {return StereoEffectStack(b);}
	inline StereoEffectStack& operator=(const StereoEffectStack& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline StereoEffectStack_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long insertTop(Arts::StereoEffect effect, const std::string& name);
	inline long insertBottom(Arts::StereoEffect effect, const std::string& name);
	inline void remove(long ID);
};

class AudioManagerClient_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static AudioManagerClient_base *_create(const std::string& subClass = "Arts::AudioManagerClient");
	static AudioManagerClient_base *_fromString(const std::string& objectref);
	static AudioManagerClient_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AudioManagerClient_base *_fromDynamicCast(const Arts::Object& object);
	inline AudioManagerClient_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long ID() = 0;
	virtual Arts::AudioManagerDirection direction() = 0;
	virtual void direction(Arts::AudioManagerDirection newValue) = 0;
	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual std::string autoRestoreID() = 0;
	virtual void autoRestoreID(const std::string& newValue) = 0;
	virtual void constructor(Arts::AudioManagerDirection direction, const std::string& title, const std::string& autoRestoreID) = 0;
};

class AudioManagerClient_stub : virtual public AudioManagerClient_base, virtual public Arts::Object_stub {
protected:
	AudioManagerClient_stub();

public:
	AudioManagerClient_stub(Arts::Connection *connection, long objectID);

	long ID();
	Arts::AudioManagerDirection direction();
	void direction(Arts::AudioManagerDirection newValue);
	std::string title();
	void title(const std::string& newValue);
	std::string autoRestoreID();
	void autoRestoreID(const std::string& newValue);
	void constructor(Arts::AudioManagerDirection direction, const std::string& title, const std::string& autoRestoreID);
};

class AudioManagerClient_skel : virtual public AudioManagerClient_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void ID_changed(long newValue) {
		_emit_changed("ID_changed",newValue);
	}
	inline void direction_changed(Arts::AudioManagerDirection newValue) {
		_emit_changed("direction_changed",newValue);
	}
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}
	inline void autoRestoreID_changed(const std::string& newValue) {
		_emit_changed("autoRestoreID_changed",newValue);
	}

public:
	AudioManagerClient_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class AudioManagerClient : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AudioManagerClient_base *_cache;
	inline AudioManagerClient_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AudioManagerClient_base *)_pool->base->_cast(AudioManagerClient_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AudioManagerClient(AudioManagerClient_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AudioManagerClient_base _base_class;

	inline AudioManagerClient() : Arts::Object(_Creator), _cache(0) {}
	inline AudioManagerClient(const Arts::SubClass& s) :
		Arts::Object(AudioManagerClient_base::_create(s.string())), _cache(0) {}
	inline AudioManagerClient(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AudioManagerClient_base::_fromString(r.string())):(AudioManagerClient_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AudioManagerClient(const Arts::DynamicCast& c) : Arts::Object(AudioManagerClient_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AudioManagerClient(const AudioManagerClient& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AudioManagerClient(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AudioManagerClient null() {return AudioManagerClient((AudioManagerClient_base*)0);}
	inline static AudioManagerClient _from_base(AudioManagerClient_base* b) {return AudioManagerClient(b);}
	inline AudioManagerClient& operator=(const AudioManagerClient& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline AudioManagerClient_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline Arts::AudioManagerDirection direction();
	inline void direction(Arts::AudioManagerDirection _newValue);
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline std::string autoRestoreID();
	inline void autoRestoreID(const std::string& _newValue);
	inline AudioManagerClient(Arts::AudioManagerDirection direction, const std::string& title, const std::string& autoRestoreID);
};

class AudioManager_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static AudioManager_base *_create(const std::string& subClass = "Arts::AudioManager");
	static AudioManager_base *_fromString(const std::string& objectref);
	static AudioManager_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AudioManager_base *_fromDynamicCast(const Arts::Object& object);
	inline AudioManager_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<std::string> * destinations() = 0;
	virtual std::vector<Arts::AudioManagerInfo> * clients() = 0;
	virtual long changes() = 0;
	virtual void setDestination(long ID, const std::string& destination) = 0;
};

class AudioManager_stub : virtual public AudioManager_base, virtual public Arts::Object_stub {
protected:
	AudioManager_stub();

public:
	AudioManager_stub(Arts::Connection *connection, long objectID);

	std::vector<std::string> * destinations();
	std::vector<Arts::AudioManagerInfo> * clients();
	long changes();
	void setDestination(long ID, const std::string& destination);
};

class AudioManager_skel : virtual public AudioManager_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void destinations_changed(const std::vector<std::string>& newValue) {
		_emit_changed("destinations_changed",newValue);
	}
	inline void changes_changed(long newValue) {
		_emit_changed("changes_changed",newValue);
	}

public:
	AudioManager_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class AudioManager : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AudioManager_base *_cache;
	inline AudioManager_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AudioManager_base *)_pool->base->_cast(AudioManager_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AudioManager(AudioManager_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AudioManager_base _base_class;

	inline AudioManager() : Arts::Object(_Creator), _cache(0) {}
	inline AudioManager(const Arts::SubClass& s) :
		Arts::Object(AudioManager_base::_create(s.string())), _cache(0) {}
	inline AudioManager(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AudioManager_base::_fromString(r.string())):(AudioManager_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AudioManager(const Arts::DynamicCast& c) : Arts::Object(AudioManager_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AudioManager(const AudioManager& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AudioManager(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AudioManager null() {return AudioManager((AudioManager_base*)0);}
	inline static AudioManager _from_base(AudioManager_base* b) {return AudioManager(b);}
	inline AudioManager& operator=(const AudioManager& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline AudioManager_base* _base() {return _cache?_cache:_method_call();}

	inline std::vector<std::string> * destinations();
	inline std::vector<Arts::AudioManagerInfo> * clients();
	inline long changes();
	inline void setDestination(long ID, const std::string& destination);
};

class Synth_AMAN_PLAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_AMAN_PLAY_base *_create(const std::string& subClass = "Arts::Synth_AMAN_PLAY");
	static Synth_AMAN_PLAY_base *_fromString(const std::string& objectref);
	static Synth_AMAN_PLAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_AMAN_PLAY_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_AMAN_PLAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual std::string autoRestoreID() = 0;
	virtual void autoRestoreID(const std::string& newValue) = 0;
	virtual void constructor(Arts::AudioManagerClient client) = 0;
};

class Synth_AMAN_PLAY_stub : virtual public Synth_AMAN_PLAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_AMAN_PLAY_stub();

public:
	Synth_AMAN_PLAY_stub(Arts::Connection *connection, long objectID);

	std::string title();
	void title(const std::string& newValue);
	std::string autoRestoreID();
	void autoRestoreID(const std::string& newValue);
	void constructor(Arts::AudioManagerClient client);
};

class Synth_AMAN_PLAY_skel : virtual public Synth_AMAN_PLAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // incoming stream
	float *right;                             // incoming stream

protected:
	// emitters for change notifications
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}
	inline void autoRestoreID_changed(const std::string& newValue) {
		_emit_changed("autoRestoreID_changed",newValue);
	}

public:
	Synth_AMAN_PLAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_AMAN_PLAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_AMAN_PLAY_base *_cache;
	inline Synth_AMAN_PLAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_AMAN_PLAY_base *)_pool->base->_cast(Synth_AMAN_PLAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_AMAN_PLAY(Synth_AMAN_PLAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_AMAN_PLAY_base _base_class;

	inline Synth_AMAN_PLAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_AMAN_PLAY(const Arts::SubClass& s) :
		Arts::Object(Synth_AMAN_PLAY_base::_create(s.string())), _cache(0) {}
	inline Synth_AMAN_PLAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_AMAN_PLAY_base::_fromString(r.string())):(Synth_AMAN_PLAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_AMAN_PLAY(const Arts::DynamicCast& c) : Arts::Object(Synth_AMAN_PLAY_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_AMAN_PLAY(const Synth_AMAN_PLAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_AMAN_PLAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_AMAN_PLAY null() {return Synth_AMAN_PLAY((Synth_AMAN_PLAY_base*)0);}
	inline static Synth_AMAN_PLAY _from_base(Synth_AMAN_PLAY_base* b) {return Synth_AMAN_PLAY(b);}
	inline Synth_AMAN_PLAY& operator=(const Synth_AMAN_PLAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_AMAN_PLAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline std::string autoRestoreID();
	inline void autoRestoreID(const std::string& _newValue);
	inline Synth_AMAN_PLAY(Arts::AudioManagerClient client);
};

class Synth_AMAN_RECORD_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_AMAN_RECORD_base *_create(const std::string& subClass = "Arts::Synth_AMAN_RECORD");
	static Synth_AMAN_RECORD_base *_fromString(const std::string& objectref);
	static Synth_AMAN_RECORD_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Synth_AMAN_RECORD_base *_fromDynamicCast(const Arts::Object& object);
	inline Synth_AMAN_RECORD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual std::string autoRestoreID() = 0;
	virtual void autoRestoreID(const std::string& newValue) = 0;
	virtual void constructor(Arts::AudioManagerClient client) = 0;
};

class Synth_AMAN_RECORD_stub : virtual public Synth_AMAN_RECORD_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_AMAN_RECORD_stub();

public:
	Synth_AMAN_RECORD_stub(Arts::Connection *connection, long objectID);

	std::string title();
	void title(const std::string& newValue);
	std::string autoRestoreID();
	void autoRestoreID(const std::string& newValue);
	void constructor(Arts::AudioManagerClient client);
};

class Synth_AMAN_RECORD_skel : virtual public Synth_AMAN_RECORD_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

protected:
	// emitters for change notifications
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}
	inline void autoRestoreID_changed(const std::string& newValue) {
		_emit_changed("autoRestoreID_changed",newValue);
	}

public:
	Synth_AMAN_RECORD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class Synth_AMAN_RECORD : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_AMAN_RECORD_base *_cache;
	inline Synth_AMAN_RECORD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_AMAN_RECORD_base *)_pool->base->_cast(Synth_AMAN_RECORD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_AMAN_RECORD(Synth_AMAN_RECORD_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_AMAN_RECORD_base _base_class;

	inline Synth_AMAN_RECORD() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_AMAN_RECORD(const Arts::SubClass& s) :
		Arts::Object(Synth_AMAN_RECORD_base::_create(s.string())), _cache(0) {}
	inline Synth_AMAN_RECORD(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_AMAN_RECORD_base::_fromString(r.string())):(Synth_AMAN_RECORD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_AMAN_RECORD(const Arts::DynamicCast& c) : Arts::Object(Synth_AMAN_RECORD_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Synth_AMAN_RECORD(const Synth_AMAN_RECORD& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_AMAN_RECORD(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_AMAN_RECORD null() {return Synth_AMAN_RECORD((Synth_AMAN_RECORD_base*)0);}
	inline static Synth_AMAN_RECORD _from_base(Synth_AMAN_RECORD_base* b) {return Synth_AMAN_RECORD(b);}
	inline Synth_AMAN_RECORD& operator=(const Synth_AMAN_RECORD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_AMAN_RECORD_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline std::string autoRestoreID();
	inline void autoRestoreID(const std::string& _newValue);
	inline Synth_AMAN_RECORD(Arts::AudioManagerClient client);
};

class DataHandle_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static DataHandle_base *_create(const std::string& subClass = "Arts::DataHandle");
	static DataHandle_base *_fromString(const std::string& objectref);
	static DataHandle_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static DataHandle_base *_fromDynamicCast(const Arts::Object& object);
	inline DataHandle_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long bitDepth() = 0;
	virtual long channelCount() = 0;
	virtual long valueCount() = 0;
	virtual long errorNo() = 0;
};

class DataHandle_stub : virtual public DataHandle_base, virtual public Arts::Object_stub {
protected:
	DataHandle_stub();

public:
	DataHandle_stub(Arts::Connection *connection, long objectID);

	long bitDepth();
	long channelCount();
	long valueCount();
	long errorNo();
};

class DataHandle_skel : virtual public DataHandle_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void bitDepth_changed(long newValue) {
		_emit_changed("bitDepth_changed",newValue);
	}
	inline void channelCount_changed(long newValue) {
		_emit_changed("channelCount_changed",newValue);
	}
	inline void valueCount_changed(long newValue) {
		_emit_changed("valueCount_changed",newValue);
	}
	inline void errorNo_changed(long newValue) {
		_emit_changed("errorNo_changed",newValue);
	}

public:
	DataHandle_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class DataHandle : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	DataHandle_base *_cache;
	inline DataHandle_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(DataHandle_base *)_pool->base->_cast(DataHandle_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline DataHandle(DataHandle_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef DataHandle_base _base_class;

	inline DataHandle() : Arts::Object(_Creator), _cache(0) {}
	inline DataHandle(const Arts::SubClass& s) :
		Arts::Object(DataHandle_base::_create(s.string())), _cache(0) {}
	inline DataHandle(const Arts::Reference &r) :
		Arts::Object(r.isString()?(DataHandle_base::_fromString(r.string())):(DataHandle_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline DataHandle(const Arts::DynamicCast& c) : Arts::Object(DataHandle_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline DataHandle(const DataHandle& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline DataHandle(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static DataHandle null() {return DataHandle((DataHandle_base*)0);}
	inline static DataHandle _from_base(DataHandle_base* b) {return DataHandle(b);}
	inline DataHandle& operator=(const DataHandle& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline DataHandle_base* _base() {return _cache?_cache:_method_call();}

	inline long bitDepth();
	inline long channelCount();
	inline long valueCount();
	inline long errorNo();
};

class ReversedDataHandle_base : virtual public Arts::DataHandle_base {
public:
	static unsigned long _IID; // interface ID

	static ReversedDataHandle_base *_create(const std::string& subClass = "Arts::ReversedDataHandle");
	static ReversedDataHandle_base *_fromString(const std::string& objectref);
	static ReversedDataHandle_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ReversedDataHandle_base *_fromDynamicCast(const Arts::Object& object);
	inline ReversedDataHandle_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void init(Arts::DataHandle sourceHandle) = 0;
};

class ReversedDataHandle_stub : virtual public ReversedDataHandle_base, virtual public Arts::DataHandle_stub {
protected:
	ReversedDataHandle_stub();

public:
	ReversedDataHandle_stub(Arts::Connection *connection, long objectID);

	void init(Arts::DataHandle sourceHandle);
};

class ReversedDataHandle_skel : virtual public ReversedDataHandle_base, virtual public Arts::DataHandle_skel {
public:
	ReversedDataHandle_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ReversedDataHandle : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ReversedDataHandle_base *_cache;
	inline ReversedDataHandle_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ReversedDataHandle_base *)_pool->base->_cast(ReversedDataHandle_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ReversedDataHandle(ReversedDataHandle_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ReversedDataHandle_base _base_class;

	inline ReversedDataHandle() : Arts::Object(_Creator), _cache(0) {}
	inline ReversedDataHandle(const Arts::SubClass& s) :
		Arts::Object(ReversedDataHandle_base::_create(s.string())), _cache(0) {}
	inline ReversedDataHandle(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ReversedDataHandle_base::_fromString(r.string())):(ReversedDataHandle_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ReversedDataHandle(const Arts::DynamicCast& c) : Arts::Object(ReversedDataHandle_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ReversedDataHandle(const ReversedDataHandle& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ReversedDataHandle(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ReversedDataHandle null() {return ReversedDataHandle((ReversedDataHandle_base*)0);}
	inline static ReversedDataHandle _from_base(ReversedDataHandle_base* b) {return ReversedDataHandle(b);}
	inline ReversedDataHandle& operator=(const ReversedDataHandle& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::DataHandle() const { return Arts::DataHandle(*_pool); }
	inline ReversedDataHandle_base* _base() {return _cache?_cache:_method_call();}

	inline long bitDepth();
	inline long channelCount();
	inline long valueCount();
	inline long errorNo();
	inline void init(Arts::DataHandle sourceHandle);
};

class CroppedDataHandle_base : virtual public Arts::DataHandle_base {
public:
	static unsigned long _IID; // interface ID

	static CroppedDataHandle_base *_create(const std::string& subClass = "Arts::CroppedDataHandle");
	static CroppedDataHandle_base *_fromString(const std::string& objectref);
	static CroppedDataHandle_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static CroppedDataHandle_base *_fromDynamicCast(const Arts::Object& object);
	inline CroppedDataHandle_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void init(Arts::DataHandle sourceHandle, long headCutValueCount, long tailCutValueCount) = 0;
};

class CroppedDataHandle_stub : virtual public CroppedDataHandle_base, virtual public Arts::DataHandle_stub {
protected:
	CroppedDataHandle_stub();

public:
	CroppedDataHandle_stub(Arts::Connection *connection, long objectID);

	void init(Arts::DataHandle sourceHandle, long headCutValueCount, long tailCutValueCount);
};

class CroppedDataHandle_skel : virtual public CroppedDataHandle_base, virtual public Arts::DataHandle_skel {
public:
	CroppedDataHandle_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class CroppedDataHandle : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	CroppedDataHandle_base *_cache;
	inline CroppedDataHandle_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(CroppedDataHandle_base *)_pool->base->_cast(CroppedDataHandle_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline CroppedDataHandle(CroppedDataHandle_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef CroppedDataHandle_base _base_class;

	inline CroppedDataHandle() : Arts::Object(_Creator), _cache(0) {}
	inline CroppedDataHandle(const Arts::SubClass& s) :
		Arts::Object(CroppedDataHandle_base::_create(s.string())), _cache(0) {}
	inline CroppedDataHandle(const Arts::Reference &r) :
		Arts::Object(r.isString()?(CroppedDataHandle_base::_fromString(r.string())):(CroppedDataHandle_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline CroppedDataHandle(const Arts::DynamicCast& c) : Arts::Object(CroppedDataHandle_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline CroppedDataHandle(const CroppedDataHandle& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline CroppedDataHandle(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static CroppedDataHandle null() {return CroppedDataHandle((CroppedDataHandle_base*)0);}
	inline static CroppedDataHandle _from_base(CroppedDataHandle_base* b) {return CroppedDataHandle(b);}
	inline CroppedDataHandle& operator=(const CroppedDataHandle& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::DataHandle() const { return Arts::DataHandle(*_pool); }
	inline CroppedDataHandle_base* _base() {return _cache?_cache:_method_call();}

	inline long bitDepth();
	inline long channelCount();
	inline long valueCount();
	inline long errorNo();
	inline void init(Arts::DataHandle sourceHandle, long headCutValueCount, long tailCutValueCount);
};

class CutDataHandle_base : virtual public Arts::DataHandle_base {
public:
	static unsigned long _IID; // interface ID

	static CutDataHandle_base *_create(const std::string& subClass = "Arts::CutDataHandle");
	static CutDataHandle_base *_fromString(const std::string& objectref);
	static CutDataHandle_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static CutDataHandle_base *_fromDynamicCast(const Arts::Object& object);
	inline CutDataHandle_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void init(Arts::DataHandle sourceHandle, long cutOffset, long cutValueCount) = 0;
};

class CutDataHandle_stub : virtual public CutDataHandle_base, virtual public Arts::DataHandle_stub {
protected:
	CutDataHandle_stub();

public:
	CutDataHandle_stub(Arts::Connection *connection, long objectID);

	void init(Arts::DataHandle sourceHandle, long cutOffset, long cutValueCount);
};

class CutDataHandle_skel : virtual public CutDataHandle_base, virtual public Arts::DataHandle_skel {
public:
	CutDataHandle_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class CutDataHandle : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	CutDataHandle_base *_cache;
	inline CutDataHandle_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(CutDataHandle_base *)_pool->base->_cast(CutDataHandle_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline CutDataHandle(CutDataHandle_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef CutDataHandle_base _base_class;

	inline CutDataHandle() : Arts::Object(_Creator), _cache(0) {}
	inline CutDataHandle(const Arts::SubClass& s) :
		Arts::Object(CutDataHandle_base::_create(s.string())), _cache(0) {}
	inline CutDataHandle(const Arts::Reference &r) :
		Arts::Object(r.isString()?(CutDataHandle_base::_fromString(r.string())):(CutDataHandle_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline CutDataHandle(const Arts::DynamicCast& c) : Arts::Object(CutDataHandle_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline CutDataHandle(const CutDataHandle& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline CutDataHandle(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static CutDataHandle null() {return CutDataHandle((CutDataHandle_base*)0);}
	inline static CutDataHandle _from_base(CutDataHandle_base* b) {return CutDataHandle(b);}
	inline CutDataHandle& operator=(const CutDataHandle& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::DataHandle() const { return Arts::DataHandle(*_pool); }
	inline CutDataHandle_base* _base() {return _cache?_cache:_method_call();}

	inline long bitDepth();
	inline long channelCount();
	inline long valueCount();
	inline long errorNo();
	inline void init(Arts::DataHandle sourceHandle, long cutOffset, long cutValueCount);
};

class DataHandlePlay_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static DataHandlePlay_base *_create(const std::string& subClass = "Arts::DataHandlePlay");
	static DataHandlePlay_base *_fromString(const std::string& objectref);
	static DataHandlePlay_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static DataHandlePlay_base *_fromDynamicCast(const Arts::Object& object);
	inline DataHandlePlay_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::DataHandle handle() = 0;
	virtual void handle(Arts::DataHandle newValue) = 0;
	virtual float mixerFrequency() = 0;
	virtual void mixerFrequency(float newValue) = 0;
	virtual long channelIndex() = 0;
	virtual void channelIndex(long newValue) = 0;
	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual long pos() = 0;
	virtual void pos(long newValue) = 0;
	virtual bool finished() = 0;
	virtual bool paused() = 0;
	virtual void paused(bool newValue) = 0;
	virtual Arts::DataHandlePlay clone() = 0;
};

class DataHandlePlay_stub : virtual public DataHandlePlay_base, virtual public Arts::SynthModule_stub {
protected:
	DataHandlePlay_stub();

public:
	DataHandlePlay_stub(Arts::Connection *connection, long objectID);

	Arts::DataHandle handle();
	void handle(Arts::DataHandle newValue);
	float mixerFrequency();
	void mixerFrequency(float newValue);
	long channelIndex();
	void channelIndex(long newValue);
	float speed();
	void speed(float newValue);
	long pos();
	void pos(long newValue);
	bool finished();
	bool paused();
	void paused(bool newValue);
	Arts::DataHandlePlay clone();
};

class DataHandlePlay_skel : virtual public DataHandlePlay_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void mixerFrequency_changed(float newValue) {
		_emit_changed("mixerFrequency_changed",newValue);
	}
	inline void channelIndex_changed(long newValue) {
		_emit_changed("channelIndex_changed",newValue);
	}
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void pos_changed(long newValue) {
		_emit_changed("pos_changed",newValue);
	}
	inline void finished_changed(bool newValue) {
		_emit_changed("finished_changed",newValue);
	}
	inline void paused_changed(bool newValue) {
		_emit_changed("paused_changed",newValue);
	}

public:
	DataHandlePlay_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class DataHandlePlay : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	DataHandlePlay_base *_cache;
	inline DataHandlePlay_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(DataHandlePlay_base *)_pool->base->_cast(DataHandlePlay_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline DataHandlePlay(DataHandlePlay_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef DataHandlePlay_base _base_class;

	inline DataHandlePlay() : Arts::Object(_Creator), _cache(0) {}
	inline DataHandlePlay(const Arts::SubClass& s) :
		Arts::Object(DataHandlePlay_base::_create(s.string())), _cache(0) {}
	inline DataHandlePlay(const Arts::Reference &r) :
		Arts::Object(r.isString()?(DataHandlePlay_base::_fromString(r.string())):(DataHandlePlay_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline DataHandlePlay(const Arts::DynamicCast& c) : Arts::Object(DataHandlePlay_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline DataHandlePlay(const DataHandlePlay& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline DataHandlePlay(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static DataHandlePlay null() {return DataHandlePlay((DataHandlePlay_base*)0);}
	inline static DataHandlePlay _from_base(DataHandlePlay_base* b) {return DataHandlePlay(b);}
	inline DataHandlePlay& operator=(const DataHandlePlay& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline DataHandlePlay_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::DataHandle handle();
	inline void handle(Arts::DataHandle _newValue);
	inline float mixerFrequency();
	inline void mixerFrequency(float _newValue);
	inline long channelIndex();
	inline void channelIndex(long _newValue);
	inline float speed();
	inline void speed(float _newValue);
	inline long pos();
	inline void pos(long _newValue);
	inline bool finished();
	inline bool paused();
	inline void paused(bool _newValue);
	inline Arts::DataHandlePlay clone();
};

class WaveDataHandle_base : virtual public Arts::DataHandle_base {
public:
	static unsigned long _IID; // interface ID

	static WaveDataHandle_base *_create(const std::string& subClass = "Arts::WaveDataHandle");
	static WaveDataHandle_base *_fromString(const std::string& objectref);
	static WaveDataHandle_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static WaveDataHandle_base *_fromDynamicCast(const Arts::Object& object);
	inline WaveDataHandle_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float mixerFrequency() = 0;
	virtual float oscillatorFrequency() = 0;
	virtual bool isLoaded() = 0;
	virtual bool load(const std::string& filename) = 0;
	virtual bool load(const std::string& filename, long waveIndex, long chunkIndex) = 0;
	virtual Arts::DataHandlePlay createPlayer() = 0;
};

class WaveDataHandle_stub : virtual public WaveDataHandle_base, virtual public Arts::DataHandle_stub {
protected:
	WaveDataHandle_stub();

public:
	WaveDataHandle_stub(Arts::Connection *connection, long objectID);

	float mixerFrequency();
	float oscillatorFrequency();
	bool isLoaded();
	bool load(const std::string& filename);
	bool load(const std::string& filename, long waveIndex, long chunkIndex);
	Arts::DataHandlePlay createPlayer();
};

class WaveDataHandle_skel : virtual public WaveDataHandle_base, virtual public Arts::DataHandle_skel {
protected:
	// emitters for change notifications
	inline void mixerFrequency_changed(float newValue) {
		_emit_changed("mixerFrequency_changed",newValue);
	}
	inline void oscillatorFrequency_changed(float newValue) {
		_emit_changed("oscillatorFrequency_changed",newValue);
	}
	inline void isLoaded_changed(bool newValue) {
		_emit_changed("isLoaded_changed",newValue);
	}

public:
	WaveDataHandle_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class WaveDataHandle : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	WaveDataHandle_base *_cache;
	inline WaveDataHandle_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(WaveDataHandle_base *)_pool->base->_cast(WaveDataHandle_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline WaveDataHandle(WaveDataHandle_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef WaveDataHandle_base _base_class;

	inline WaveDataHandle() : Arts::Object(_Creator), _cache(0) {}
	inline WaveDataHandle(const Arts::SubClass& s) :
		Arts::Object(WaveDataHandle_base::_create(s.string())), _cache(0) {}
	inline WaveDataHandle(const Arts::Reference &r) :
		Arts::Object(r.isString()?(WaveDataHandle_base::_fromString(r.string())):(WaveDataHandle_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline WaveDataHandle(const Arts::DynamicCast& c) : Arts::Object(WaveDataHandle_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline WaveDataHandle(const WaveDataHandle& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline WaveDataHandle(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static WaveDataHandle null() {return WaveDataHandle((WaveDataHandle_base*)0);}
	inline static WaveDataHandle _from_base(WaveDataHandle_base* b) {return WaveDataHandle(b);}
	inline WaveDataHandle& operator=(const WaveDataHandle& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::DataHandle() const { return Arts::DataHandle(*_pool); }
	inline WaveDataHandle_base* _base() {return _cache?_cache:_method_call();}

	inline long bitDepth();
	inline long channelCount();
	inline long valueCount();
	inline long errorNo();
	inline float mixerFrequency();
	inline float oscillatorFrequency();
	inline bool isLoaded();
	inline bool load(const std::string& filename);
	inline bool load(const std::string& filename, long waveIndex, long chunkIndex);
	inline Arts::DataHandlePlay createPlayer();
};

}
// Forward wrapper calls to _base classes:

inline Arts::AutoSuspendState Arts::SynthModule::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::SynthModule::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::SynthModule::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::SynthModule::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::SynthModule::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::SynthModule::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_PLAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PLAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PLAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PLAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PLAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PLAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_RECORD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_RECORD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_RECORD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_RECORD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_RECORD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_RECORD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_FREQUENCY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FREQUENCY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FREQUENCY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FREQUENCY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FREQUENCY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FREQUENCY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SIN::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SIN::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SIN::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SIN::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SIN::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SIN::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MULTI_ADD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MULTI_ADD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MULTI_ADD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MULTI_ADD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MULTI_ADD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MULTI_ADD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_ADD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ADD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ADD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ADD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ADD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ADD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MUL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MUL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MUL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MUL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MUL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MUL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_PLAY_WAV::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PLAY_WAV::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PLAY_WAV::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PLAY_WAV::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PLAY_WAV::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PLAY_WAV::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PLAY_WAV::speed()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->speed():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->speed();
}

inline void Arts::Synth_PLAY_WAV::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->speed(_newValue);
}

inline std::string Arts::Synth_PLAY_WAV::filename()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->filename():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->filename();
}

inline void Arts::Synth_PLAY_WAV::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->filename(_newValue);
}

inline bool Arts::Synth_PLAY_WAV::finished()
{
	return _cache?static_cast<Arts::Synth_PLAY_WAV_base*>(_cache)->finished():static_cast<Arts::Synth_PLAY_WAV_base*>(_method_call())->finished();
}

inline Arts::AutoSuspendState Arts::Synth_BUS_UPLINK::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_BUS_UPLINK::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_BUS_UPLINK::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_BUS_UPLINK::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_BUS_UPLINK::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_BUS_UPLINK::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_BUS_UPLINK::busname()
{
	return _cache?static_cast<Arts::Synth_BUS_UPLINK_base*>(_cache)->busname():static_cast<Arts::Synth_BUS_UPLINK_base*>(_method_call())->busname();
}

inline void Arts::Synth_BUS_UPLINK::busname(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_BUS_UPLINK_base*>(_cache)->busname(_newValue):static_cast<Arts::Synth_BUS_UPLINK_base*>(_method_call())->busname(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_BUS_DOWNLINK::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_BUS_DOWNLINK::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_BUS_DOWNLINK::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_BUS_DOWNLINK::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_BUS_DOWNLINK::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_BUS_DOWNLINK::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_BUS_DOWNLINK::busname()
{
	return _cache?static_cast<Arts::Synth_BUS_DOWNLINK_base*>(_cache)->busname():static_cast<Arts::Synth_BUS_DOWNLINK_base*>(_method_call())->busname();
}

inline void Arts::Synth_BUS_DOWNLINK::busname(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_BUS_DOWNLINK_base*>(_cache)->busname(_newValue):static_cast<Arts::Synth_BUS_DOWNLINK_base*>(_method_call())->busname(_newValue);
}

inline Arts::AutoSuspendState Arts::ByteStreamToAudio::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::ByteStreamToAudio::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::ByteStreamToAudio::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::ByteStreamToAudio::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::ByteStreamToAudio::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::ByteStreamToAudio::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::ByteStreamToAudio::samplingRate()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->samplingRate():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->samplingRate();
}

inline void Arts::ByteStreamToAudio::samplingRate(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->samplingRate(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->samplingRate(_newValue);
}

inline long Arts::ByteStreamToAudio::channels()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->channels():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->channels();
}

inline void Arts::ByteStreamToAudio::channels(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->channels(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->channels(_newValue);
}

inline long Arts::ByteStreamToAudio::bits()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->bits():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->bits();
}

inline void Arts::ByteStreamToAudio::bits(long _newValue)
{
	 _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->bits(_newValue):static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->bits(_newValue);
}

inline bool Arts::ByteStreamToAudio::running()
{
	return _cache?static_cast<Arts::ByteStreamToAudio_base*>(_cache)->running():static_cast<Arts::ByteStreamToAudio_base*>(_method_call())->running();
}

inline Arts::AutoSuspendState Arts::AudioToByteStream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::AudioToByteStream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::AudioToByteStream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::AudioToByteStream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::AudioToByteStream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::AudioToByteStream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::AudioToByteStream::samplingRate()
{
	return _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->samplingRate():static_cast<Arts::AudioToByteStream_base*>(_method_call())->samplingRate();
}

inline void Arts::AudioToByteStream::samplingRate(long _newValue)
{
	 _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->samplingRate(_newValue):static_cast<Arts::AudioToByteStream_base*>(_method_call())->samplingRate(_newValue);
}

inline long Arts::AudioToByteStream::channels()
{
	return _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->channels():static_cast<Arts::AudioToByteStream_base*>(_method_call())->channels();
}

inline void Arts::AudioToByteStream::channels(long _newValue)
{
	 _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->channels(_newValue):static_cast<Arts::AudioToByteStream_base*>(_method_call())->channels(_newValue);
}

inline long Arts::AudioToByteStream::bits()
{
	return _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->bits():static_cast<Arts::AudioToByteStream_base*>(_method_call())->bits();
}

inline void Arts::AudioToByteStream::bits(long _newValue)
{
	 _cache?static_cast<Arts::AudioToByteStream_base*>(_cache)->bits(_newValue):static_cast<Arts::AudioToByteStream_base*>(_method_call())->bits(_newValue);
}

inline Arts::AutoSuspendState Arts::StereoEffect::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoEffect::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoEffect::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoEffect::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoEffect::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoEffect::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::StereoVolumeControl::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoVolumeControl::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoVolumeControl::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoVolumeControl::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoVolumeControl::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoVolumeControl::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::StereoVolumeControl::scaleFactor()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->scaleFactor():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->scaleFactor();
}

inline void Arts::StereoVolumeControl::scaleFactor(float _newValue)
{
	 _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->scaleFactor(_newValue):static_cast<Arts::StereoVolumeControl_base*>(_method_call())->scaleFactor(_newValue);
}

inline float Arts::StereoVolumeControl::currentVolumeLeft()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->currentVolumeLeft():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->currentVolumeLeft();
}

inline float Arts::StereoVolumeControl::currentVolumeRight()
{
	return _cache?static_cast<Arts::StereoVolumeControl_base*>(_cache)->currentVolumeRight():static_cast<Arts::StereoVolumeControl_base*>(_method_call())->currentVolumeRight();
}

inline Arts::AutoSuspendState Arts::StereoFFTScope::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoFFTScope::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoFFTScope::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoFFTScope::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoFFTScope::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoFFTScope::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::vector<float> * Arts::StereoFFTScope::scope()
{
	return _cache?static_cast<Arts::StereoFFTScope_base*>(_cache)->scope():static_cast<Arts::StereoFFTScope_base*>(_method_call())->scope();
}

inline Arts::AutoSuspendState Arts::StereoEffectStack::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::StereoEffectStack::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::StereoEffectStack::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::StereoEffectStack::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::StereoEffectStack::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::StereoEffectStack::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long Arts::StereoEffectStack::insertTop(Arts::StereoEffect effect, const std::string& name)
{
	return _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->insertTop(effect, name):static_cast<Arts::StereoEffectStack_base*>(_method_call())->insertTop(effect, name);
}

inline long Arts::StereoEffectStack::insertBottom(Arts::StereoEffect effect, const std::string& name)
{
	return _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->insertBottom(effect, name):static_cast<Arts::StereoEffectStack_base*>(_method_call())->insertBottom(effect, name);
}

inline void Arts::StereoEffectStack::remove(long ID)
{
	 _cache?static_cast<Arts::StereoEffectStack_base*>(_cache)->remove(ID):static_cast<Arts::StereoEffectStack_base*>(_method_call())->remove(ID);
}

inline long Arts::AudioManagerClient::ID()
{
	return _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->ID():static_cast<Arts::AudioManagerClient_base*>(_method_call())->ID();
}

inline Arts::AudioManagerDirection Arts::AudioManagerClient::direction()
{
	return _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->direction():static_cast<Arts::AudioManagerClient_base*>(_method_call())->direction();
}

inline void Arts::AudioManagerClient::direction(Arts::AudioManagerDirection _newValue)
{
	 _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->direction(_newValue):static_cast<Arts::AudioManagerClient_base*>(_method_call())->direction(_newValue);
}

inline std::string Arts::AudioManagerClient::title()
{
	return _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->title():static_cast<Arts::AudioManagerClient_base*>(_method_call())->title();
}

inline void Arts::AudioManagerClient::title(const std::string& _newValue)
{
	 _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->title(_newValue):static_cast<Arts::AudioManagerClient_base*>(_method_call())->title(_newValue);
}

inline std::string Arts::AudioManagerClient::autoRestoreID()
{
	return _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->autoRestoreID():static_cast<Arts::AudioManagerClient_base*>(_method_call())->autoRestoreID();
}

inline void Arts::AudioManagerClient::autoRestoreID(const std::string& _newValue)
{
	 _cache?static_cast<Arts::AudioManagerClient_base*>(_cache)->autoRestoreID(_newValue):static_cast<Arts::AudioManagerClient_base*>(_method_call())->autoRestoreID(_newValue);
}

inline Arts::AudioManagerClient::AudioManagerClient(Arts::AudioManagerDirection direction, const std::string& title, const std::string& autoRestoreID)
		: Arts::Object(AudioManagerClient_base::_create())
{
	static_cast<Arts::AudioManagerClient_base*>(_method_call())->constructor(direction, title, autoRestoreID);
}

inline std::vector<std::string> * Arts::AudioManager::destinations()
{
	return _cache?static_cast<Arts::AudioManager_base*>(_cache)->destinations():static_cast<Arts::AudioManager_base*>(_method_call())->destinations();
}

inline std::vector<Arts::AudioManagerInfo> * Arts::AudioManager::clients()
{
	return _cache?static_cast<Arts::AudioManager_base*>(_cache)->clients():static_cast<Arts::AudioManager_base*>(_method_call())->clients();
}

inline long Arts::AudioManager::changes()
{
	return _cache?static_cast<Arts::AudioManager_base*>(_cache)->changes():static_cast<Arts::AudioManager_base*>(_method_call())->changes();
}

inline void Arts::AudioManager::setDestination(long ID, const std::string& destination)
{
	 _cache?static_cast<Arts::AudioManager_base*>(_cache)->setDestination(ID, destination):static_cast<Arts::AudioManager_base*>(_method_call())->setDestination(ID, destination);
}

inline Arts::AutoSuspendState Arts::Synth_AMAN_PLAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_AMAN_PLAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_AMAN_PLAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_AMAN_PLAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_AMAN_PLAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_AMAN_PLAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_AMAN_PLAY::title()
{
	return _cache?static_cast<Arts::Synth_AMAN_PLAY_base*>(_cache)->title():static_cast<Arts::Synth_AMAN_PLAY_base*>(_method_call())->title();
}

inline void Arts::Synth_AMAN_PLAY::title(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_AMAN_PLAY_base*>(_cache)->title(_newValue):static_cast<Arts::Synth_AMAN_PLAY_base*>(_method_call())->title(_newValue);
}

inline std::string Arts::Synth_AMAN_PLAY::autoRestoreID()
{
	return _cache?static_cast<Arts::Synth_AMAN_PLAY_base*>(_cache)->autoRestoreID():static_cast<Arts::Synth_AMAN_PLAY_base*>(_method_call())->autoRestoreID();
}

inline void Arts::Synth_AMAN_PLAY::autoRestoreID(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_AMAN_PLAY_base*>(_cache)->autoRestoreID(_newValue):static_cast<Arts::Synth_AMAN_PLAY_base*>(_method_call())->autoRestoreID(_newValue);
}

inline Arts::Synth_AMAN_PLAY::Synth_AMAN_PLAY(Arts::AudioManagerClient client)
		: Arts::Object(Synth_AMAN_PLAY_base::_create())
{
	static_cast<Arts::Synth_AMAN_PLAY_base*>(_method_call())->constructor(client);
}

inline Arts::AutoSuspendState Arts::Synth_AMAN_RECORD::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_AMAN_RECORD::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_AMAN_RECORD::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_AMAN_RECORD::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_AMAN_RECORD::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_AMAN_RECORD::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_AMAN_RECORD::title()
{
	return _cache?static_cast<Arts::Synth_AMAN_RECORD_base*>(_cache)->title():static_cast<Arts::Synth_AMAN_RECORD_base*>(_method_call())->title();
}

inline void Arts::Synth_AMAN_RECORD::title(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_AMAN_RECORD_base*>(_cache)->title(_newValue):static_cast<Arts::Synth_AMAN_RECORD_base*>(_method_call())->title(_newValue);
}

inline std::string Arts::Synth_AMAN_RECORD::autoRestoreID()
{
	return _cache?static_cast<Arts::Synth_AMAN_RECORD_base*>(_cache)->autoRestoreID():static_cast<Arts::Synth_AMAN_RECORD_base*>(_method_call())->autoRestoreID();
}

inline void Arts::Synth_AMAN_RECORD::autoRestoreID(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_AMAN_RECORD_base*>(_cache)->autoRestoreID(_newValue):static_cast<Arts::Synth_AMAN_RECORD_base*>(_method_call())->autoRestoreID(_newValue);
}

inline Arts::Synth_AMAN_RECORD::Synth_AMAN_RECORD(Arts::AudioManagerClient client)
		: Arts::Object(Synth_AMAN_RECORD_base::_create())
{
	static_cast<Arts::Synth_AMAN_RECORD_base*>(_method_call())->constructor(client);
}

inline long Arts::DataHandle::bitDepth()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->bitDepth():static_cast<Arts::DataHandle_base*>(_method_call())->bitDepth();
}

inline long Arts::DataHandle::channelCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->channelCount():static_cast<Arts::DataHandle_base*>(_method_call())->channelCount();
}

inline long Arts::DataHandle::valueCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->valueCount():static_cast<Arts::DataHandle_base*>(_method_call())->valueCount();
}

inline long Arts::DataHandle::errorNo()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->errorNo():static_cast<Arts::DataHandle_base*>(_method_call())->errorNo();
}

inline long Arts::ReversedDataHandle::bitDepth()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->bitDepth():static_cast<Arts::DataHandle_base*>(_method_call())->bitDepth();
}

inline long Arts::ReversedDataHandle::channelCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->channelCount():static_cast<Arts::DataHandle_base*>(_method_call())->channelCount();
}

inline long Arts::ReversedDataHandle::valueCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->valueCount():static_cast<Arts::DataHandle_base*>(_method_call())->valueCount();
}

inline long Arts::ReversedDataHandle::errorNo()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->errorNo():static_cast<Arts::DataHandle_base*>(_method_call())->errorNo();
}

inline void Arts::ReversedDataHandle::init(Arts::DataHandle sourceHandle)
{
	 _cache?static_cast<Arts::ReversedDataHandle_base*>(_cache)->init(sourceHandle):static_cast<Arts::ReversedDataHandle_base*>(_method_call())->init(sourceHandle);
}

inline long Arts::CroppedDataHandle::bitDepth()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->bitDepth():static_cast<Arts::DataHandle_base*>(_method_call())->bitDepth();
}

inline long Arts::CroppedDataHandle::channelCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->channelCount():static_cast<Arts::DataHandle_base*>(_method_call())->channelCount();
}

inline long Arts::CroppedDataHandle::valueCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->valueCount():static_cast<Arts::DataHandle_base*>(_method_call())->valueCount();
}

inline long Arts::CroppedDataHandle::errorNo()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->errorNo():static_cast<Arts::DataHandle_base*>(_method_call())->errorNo();
}

inline void Arts::CroppedDataHandle::init(Arts::DataHandle sourceHandle, long headCutValueCount, long tailCutValueCount)
{
	 _cache?static_cast<Arts::CroppedDataHandle_base*>(_cache)->init(sourceHandle, headCutValueCount, tailCutValueCount):static_cast<Arts::CroppedDataHandle_base*>(_method_call())->init(sourceHandle, headCutValueCount, tailCutValueCount);
}

inline long Arts::CutDataHandle::bitDepth()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->bitDepth():static_cast<Arts::DataHandle_base*>(_method_call())->bitDepth();
}

inline long Arts::CutDataHandle::channelCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->channelCount():static_cast<Arts::DataHandle_base*>(_method_call())->channelCount();
}

inline long Arts::CutDataHandle::valueCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->valueCount():static_cast<Arts::DataHandle_base*>(_method_call())->valueCount();
}

inline long Arts::CutDataHandle::errorNo()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->errorNo():static_cast<Arts::DataHandle_base*>(_method_call())->errorNo();
}

inline void Arts::CutDataHandle::init(Arts::DataHandle sourceHandle, long cutOffset, long cutValueCount)
{
	 _cache?static_cast<Arts::CutDataHandle_base*>(_cache)->init(sourceHandle, cutOffset, cutValueCount):static_cast<Arts::CutDataHandle_base*>(_method_call())->init(sourceHandle, cutOffset, cutValueCount);
}

inline Arts::AutoSuspendState Arts::DataHandlePlay::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::DataHandlePlay::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::DataHandlePlay::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::DataHandlePlay::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::DataHandlePlay::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::DataHandlePlay::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::DataHandle Arts::DataHandlePlay::handle()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->handle():static_cast<Arts::DataHandlePlay_base*>(_method_call())->handle();
}

inline void Arts::DataHandlePlay::handle(Arts::DataHandle _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->handle(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->handle(_newValue);
}

inline float Arts::DataHandlePlay::mixerFrequency()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->mixerFrequency():static_cast<Arts::DataHandlePlay_base*>(_method_call())->mixerFrequency();
}

inline void Arts::DataHandlePlay::mixerFrequency(float _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->mixerFrequency(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->mixerFrequency(_newValue);
}

inline long Arts::DataHandlePlay::channelIndex()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->channelIndex():static_cast<Arts::DataHandlePlay_base*>(_method_call())->channelIndex();
}

inline void Arts::DataHandlePlay::channelIndex(long _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->channelIndex(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->channelIndex(_newValue);
}

inline float Arts::DataHandlePlay::speed()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->speed():static_cast<Arts::DataHandlePlay_base*>(_method_call())->speed();
}

inline void Arts::DataHandlePlay::speed(float _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->speed(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->speed(_newValue);
}

inline long Arts::DataHandlePlay::pos()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->pos():static_cast<Arts::DataHandlePlay_base*>(_method_call())->pos();
}

inline void Arts::DataHandlePlay::pos(long _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->pos(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->pos(_newValue);
}

inline bool Arts::DataHandlePlay::finished()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->finished():static_cast<Arts::DataHandlePlay_base*>(_method_call())->finished();
}

inline bool Arts::DataHandlePlay::paused()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->paused():static_cast<Arts::DataHandlePlay_base*>(_method_call())->paused();
}

inline void Arts::DataHandlePlay::paused(bool _newValue)
{
	 _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->paused(_newValue):static_cast<Arts::DataHandlePlay_base*>(_method_call())->paused(_newValue);
}

inline Arts::DataHandlePlay Arts::DataHandlePlay::clone()
{
	return _cache?static_cast<Arts::DataHandlePlay_base*>(_cache)->clone():static_cast<Arts::DataHandlePlay_base*>(_method_call())->clone();
}

inline long Arts::WaveDataHandle::bitDepth()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->bitDepth():static_cast<Arts::DataHandle_base*>(_method_call())->bitDepth();
}

inline long Arts::WaveDataHandle::channelCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->channelCount():static_cast<Arts::DataHandle_base*>(_method_call())->channelCount();
}

inline long Arts::WaveDataHandle::valueCount()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->valueCount():static_cast<Arts::DataHandle_base*>(_method_call())->valueCount();
}

inline long Arts::WaveDataHandle::errorNo()
{
	return _cache?static_cast<Arts::DataHandle_base*>(_cache)->errorNo():static_cast<Arts::DataHandle_base*>(_method_call())->errorNo();
}

inline float Arts::WaveDataHandle::mixerFrequency()
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->mixerFrequency():static_cast<Arts::WaveDataHandle_base*>(_method_call())->mixerFrequency();
}

inline float Arts::WaveDataHandle::oscillatorFrequency()
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->oscillatorFrequency():static_cast<Arts::WaveDataHandle_base*>(_method_call())->oscillatorFrequency();
}

inline bool Arts::WaveDataHandle::isLoaded()
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->isLoaded():static_cast<Arts::WaveDataHandle_base*>(_method_call())->isLoaded();
}

inline bool Arts::WaveDataHandle::load(const std::string& filename)
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->load(filename):static_cast<Arts::WaveDataHandle_base*>(_method_call())->load(filename);
}

inline bool Arts::WaveDataHandle::load(const std::string& filename, long waveIndex, long chunkIndex)
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->load(filename, waveIndex, chunkIndex):static_cast<Arts::WaveDataHandle_base*>(_method_call())->load(filename, waveIndex, chunkIndex);
}

inline Arts::DataHandlePlay Arts::WaveDataHandle::createPlayer()
{
	return _cache?static_cast<Arts::WaveDataHandle_base*>(_cache)->createPlayer():static_cast<Arts::WaveDataHandle_base*>(_method_call())->createPlayer();
}

#endif /* ARTSFLOW_H */
