/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1256;
import sun.io.CharToByteCp1256;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1256
extends Charset
implements HistoricallyNamedCharset {
    public String historicalName() {
        return "Cp1256";
    }

    public MS1256() {
        super("windows-1256", StandardCharsets.aliasesFor((String)"windows-1256"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1256;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1256 c2b = new CharToByteCp1256();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1256 b2c = new ByteToCharCp1256();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }
}

