/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

final class DGCImpl
implements DGC {
    static int logLevel = LogStream.parseLevel(DGCImpl.getLogLevel());
    static final Log dgcLog = Log.getLog("sun.rmi.dgc", "dgc", logLevel);
    static final Timer timer;
    private static final long leaseValue;
    private static final long leaseCheckInterval;
    private static DGCImpl dgc;
    private Hashtable leaseTable = new Hashtable();
    private Thread checker = null;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.dgc.logLevel"));
    }

    static DGCImpl getDGCImpl() {
        return dgc;
    }

    private DGCImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease dirty(ObjID[] objIDArray, long l2, Lease lease) {
        Object object;
        VMID vMID = lease.getVMID();
        long l3 = leaseValue;
        if (dgcLog.isLoggable(Log.VERBOSE)) {
            dgcLog.log(Log.VERBOSE, "vmid = " + vMID);
        }
        if (vMID == null) {
            vMID = new VMID();
            if (dgcLog.isLoggable(Log.BRIEF)) {
                try {
                    object = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    object = "<unknown host>";
                }
                dgcLog.log(Log.BRIEF, " assigning vmid " + vMID + " to client " + (String)object);
            }
        }
        lease = new Lease(vMID, l3);
        object = this.leaseTable;
        synchronized (object) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                this.leaseTable.put(vMID, new LeaseInfo(vMID, l3));
                if (this.checker == null) {
                    this.checker = (Thread)AccessController.doPrivileged(new NewThreadAction(new LeaseChecker(), "LeaseChecker", true));
                    this.checker.start();
                }
            } else {
                leaseInfo.renew(l3);
            }
        }
        int n2 = 0;
        while (n2 < objIDArray.length) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + objIDArray[n2] + ", vmid = " + vMID + ", duration = " + l3);
            }
            ObjectTable.referenced(objIDArray[n2], l2, vMID);
            ++n2;
        }
        return lease;
    }

    public void clean(ObjID[] objIDArray, long l2, VMID vMID, boolean bl2) {
        int n2 = 0;
        while (n2 < objIDArray.length) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + objIDArray[n2] + ", vmid = " + vMID + ", strong = " + bl2);
            }
            ObjectTable.unreferenced(objIDArray[n2], l2, vMID, bl2);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                target.vmidDead(vMID);
            } else {
                leaseInfo.notifySet.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo != null) {
                leaseInfo.notifySet.remove(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLeases() {
        long l2 = System.currentTimeMillis();
        Enumeration enumeration = null;
        LeaseInfo leaseInfo = null;
        boolean bl2 = false;
        Vector vector = new Vector(5);
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            enumeration = this.leaseTable.elements();
            while (enumeration.hasMoreElements()) {
                leaseInfo = (LeaseInfo)enumeration.nextElement();
                if (!leaseInfo.expired(l2)) continue;
                vector.add(leaseInfo);
                this.leaseTable.remove(leaseInfo.vmid);
            }
            if (this.leaseTable.isEmpty()) {
                this.checker = null;
                bl2 = false;
            } else {
                bl2 = true;
            }
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            leaseInfo = (LeaseInfo)enumeration2.nextElement();
            Iterator iterator = leaseInfo.notifySet.iterator();
            while (iterator.hasNext()) {
                Target target = (Target)iterator.next();
                target.vmidDead(leaseInfo.vmid);
            }
        }
        return bl2;
    }

    static {
        leaseValue = (Long)AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
        leaseCheckInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.checkInterval", leaseValue / 2L));
        timer = (Timer)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Timer timer;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    timer = new Timer(true);
                    try {
                        dgc = new DGCImpl();
                        ObjID objID = new ObjID(2);
                        LiveRef liveRef = new LiveRef(objID, 0);
                        UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
                        RemoteStub remoteStub = unicastServerRef.setSkeleton(dgc);
                        Target target = new Target(dgc, unicastServerRef, remoteStub, objID, true);
                        ObjectTable.putTarget(target);
                    }
                    catch (RemoteException remoteException) {
                        throw new Error("exception initializing server-side DGC", remoteException);
                    }
                    Object var9_9 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                    throw throwable;
                }
                return timer;
            }
        });
    }

    private static class LeaseInfo {
        VMID vmid;
        long expiration;
        HashSet notifySet = new HashSet();

        LeaseInfo(VMID vMID, long l2) {
            this.vmid = vMID;
            this.expiration = System.currentTimeMillis() + l2;
        }

        synchronized void renew(long l2) {
            long l3 = System.currentTimeMillis() + l2;
            if (l3 > this.expiration) {
                this.expiration = l3;
            }
        }

        boolean expired(long l2) {
            if (this.expiration < l2) {
                if (dgcLog.isLoggable(Log.BRIEF)) {
                    dgcLog.log(Log.BRIEF, this.vmid.toString());
                }
                return true;
            }
            return false;
        }
    }

    private class LeaseChecker
    implements Runnable {
        private LeaseChecker() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(leaseCheckInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (DGCImpl.this.checkLeases());
        }
    }
}

