/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

public class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);

    public static String encodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == File.separatorChar) {
                stringBuffer.append('/');
            } else if (c2 <= '\u007f') {
                if (encodedInPath.get(c2)) {
                    ParseUtil.escape(stringBuffer, c2);
                } else {
                    stringBuffer.append(c2);
                }
            } else if (c2 > '\u07ff') {
                ParseUtil.escape(stringBuffer, (char)(0xE0 | c2 >> 12 & 0xF));
                ParseUtil.escape(stringBuffer, (char)(0x80 | c2 >> 6 & 0x3F));
                ParseUtil.escape(stringBuffer, (char)(0x80 | c2 >> 0 & 0x3F));
            } else {
                ParseUtil.escape(stringBuffer, (char)(0xC0 | c2 >> 6 & 0x1F));
                ParseUtil.escape(stringBuffer, (char)(0x80 | c2 >> 0 & 0x3F));
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c2) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c2 >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c2 & 0xF, 16));
    }

    private static char unescape(String string, int n2) {
        return (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '%') {
                ++n2;
            } else {
                try {
                    c2 = ParseUtil.unescape(string, n2);
                    n2 += 3;
                    if ((c2 & 0x80) != 0) {
                        switch (c2 >> 4) {
                            case 12: 
                            case 13: {
                                char c3 = ParseUtil.unescape(string, n2);
                                n2 += 3;
                                c2 = (char)((c2 & 0x1F) << 6 | c3 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c3 = ParseUtil.unescape(string, n2);
                                char c4 = ParseUtil.unescape(string, n2 += 3);
                                n2 += 3;
                                c2 = (char)((c2 & 0xF) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String canonizeString(String string) {
        int n2 = 0;
        int n3 = string.length();
        while ((n2 = string.indexOf("/../")) >= 0) {
            n3 = string.lastIndexOf(47, n2 - 1);
            string = n3 >= 0 ? string.substring(0, n3) + string.substring(n2 + 3) : string.substring(n2 + 3);
        }
        while ((n2 = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 2);
        }
        while (string.endsWith("/..")) {
            n2 = string.indexOf("/..");
            n3 = string.lastIndexOf(47, n2 - 1);
            string = n3 >= 0 ? string.substring(0, n3 + 1) : string.substring(0, n2);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (!(string = ParseUtil.encodePath(string)).startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        int n2 = 0;
        while (n2 < 32) {
            encodedInPath.set(n2);
            ++n2;
        }
        encodedInPath.set(127);
    }
}

