/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xml.utils.StringToStringTable;

public class StringToStringTableVector {
    private int m_blocksize;
    private StringToStringTable[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToStringTableVector() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new StringToStringTable[this.m_blocksize];
    }

    public StringToStringTableVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new StringToStringTable[n2];
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(StringToStringTable stringToStringTable) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            StringToStringTable[] stringToStringTableArray = new StringToStringTable[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringToStringTableArray, 0, this.m_firstFree + 1);
            this.m_map = stringToStringTableArray;
        }
        this.m_map[this.m_firstFree] = stringToStringTable;
        ++this.m_firstFree;
    }

    public final String get(String string) {
        int n2 = this.m_firstFree - 1;
        while (n2 >= 0) {
            String string2 = this.m_map[n2].get(string);
            if (string2 != null) {
                return string2;
            }
            --n2;
        }
        return null;
    }

    public final boolean containsKey(String string) {
        int n2 = this.m_firstFree - 1;
        while (n2 >= 0) {
            if (this.m_map[n2].get(string) != null) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public final void removeLastElem() {
        if (this.m_firstFree > 0) {
            this.m_map[this.m_firstFree] = null;
            --this.m_firstFree;
        }
    }

    public final StringToStringTable elementAt(int n2) {
        return this.m_map[n2];
    }

    public final boolean contains(StringToStringTable stringToStringTable) {
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            if (this.m_map[n2].equals(stringToStringTable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

