/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;
import sun.awt.AppContext;
import sun.misc.Service;

public abstract class PrintServiceLookup {
    static /* synthetic */ Class class$javax$print$PrintServiceLookup$Services;
    static /* synthetic */ Class class$javax$print$PrintServiceLookup;

    private static Services getServicesForContext() {
        Services services = (Services)AppContext.getAppContext().get(class$javax$print$PrintServiceLookup$Services == null ? (class$javax$print$PrintServiceLookup$Services = PrintServiceLookup.class$("javax.print.PrintServiceLookup$Services")) : class$javax$print$PrintServiceLookup$Services);
        if (services == null) {
            services = new Services();
            AppContext.getAppContext().put(class$javax$print$PrintServiceLookup$Services == null ? (class$javax$print$PrintServiceLookup$Services = PrintServiceLookup.class$("javax.print.PrintServiceLookup$Services")) : class$javax$print$PrintServiceLookup$Services, services);
        }
        return services;
    }

    private static ArrayList getListOfLookupServices() {
        return PrintServiceLookup.getServicesForContext().listOfLookupServices;
    }

    private static ArrayList initListOfLookupServices() {
        ArrayList arrayList = new ArrayList();
        PrintServiceLookup.getServicesForContext().listOfLookupServices = arrayList;
        return arrayList;
    }

    private static ArrayList getRegisteredServices() {
        return PrintServiceLookup.getServicesForContext().registeredServices;
    }

    private static ArrayList initRegisteredServices() {
        ArrayList arrayList = new ArrayList();
        PrintServiceLookup.getServicesForContext().registeredServices = arrayList;
        return arrayList;
    }

    public static final PrintService[] lookupPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        ArrayList arrayList = PrintServiceLookup.getServices(docFlavor, attributeSet);
        return (PrintService[])arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        ArrayList arrayList = PrintServiceLookup.getMultiDocServices(docFlavorArray, attributeSet);
        return (MultiDocPrintService[])arrayList.toArray(new MultiDocPrintService[arrayList.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                PrintServiceLookup printServiceLookup = (PrintServiceLookup)iterator.next();
                PrintService printService = printServiceLookup.getDefaultPrintService();
                if (printService == null) continue;
                return printService;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerServiceProvider(PrintServiceLookup printServiceLookup) {
        Class clazz = class$javax$print$PrintServiceLookup == null ? (class$javax$print$PrintServiceLookup = PrintServiceLookup.class$("javax.print.PrintServiceLookup")) : class$javax$print$PrintServiceLookup;
        synchronized (clazz) {
            Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
            while (iterator.hasNext()) {
                try {
                    Object object = iterator.next();
                    if (object.getClass() != printServiceLookup.getClass()) continue;
                    return false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PrintServiceLookup.getListOfLookupServices().add(printServiceLookup);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerService(PrintService printService) {
        Class clazz = class$javax$print$PrintServiceLookup == null ? (class$javax$print$PrintServiceLookup = PrintServiceLookup.class$("javax.print.PrintServiceLookup")) : class$javax$print$PrintServiceLookup;
        synchronized (clazz) {
            if (printService instanceof StreamPrintService) {
                return false;
            }
            ArrayList arrayList = PrintServiceLookup.getRegisteredServices();
            if (arrayList == null) {
                arrayList = PrintServiceLookup.initRegisteredServices();
            } else if (arrayList.contains(printService)) {
                return false;
            }
            arrayList.add(printService);
            return true;
        }
    }

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService getDefaultPrintService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getAllLookupServices() {
        Class clazz = class$javax$print$PrintServiceLookup == null ? (class$javax$print$PrintServiceLookup = PrintServiceLookup.class$("javax.print.PrintServiceLookup")) : class$javax$print$PrintServiceLookup;
        synchronized (clazz) {
            ArrayList arrayList = PrintServiceLookup.getListOfLookupServices();
            if (arrayList != null) {
                return arrayList;
            }
            arrayList = PrintServiceLookup.initListOfLookupServices();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.providers(class$javax$print$PrintServiceLookup == null ? (class$javax$print$PrintServiceLookup = PrintServiceLookup.class$("javax.print.PrintServiceLookup")) : class$javax$print$PrintServiceLookup);
                        ArrayList arrayList = PrintServiceLookup.getListOfLookupServices();
                        while (iterator.hasNext()) {
                            try {
                                PrintServiceLookup printServiceLookup = (PrintServiceLookup)iterator.next();
                                arrayList.add(printServiceLookup);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            return arrayList;
        }
    }

    private static ArrayList getServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        PrintService[] printServiceArray;
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                object = (PrintServiceLookup)iterator.next();
                printServiceArray = null;
                if (docFlavor == null && attributeSet == null) {
                    try {
                        printServiceArray = ((PrintServiceLookup)object).getPrintServices();
                    }
                    catch (Throwable throwable) {}
                } else {
                    printServiceArray = ((PrintServiceLookup)object).getPrintServices(docFlavor, attributeSet);
                }
                if (printServiceArray == null) continue;
                int n2 = 0;
                while (n2 < printServiceArray.length) {
                    arrayList.add(printServiceArray[n2]);
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        try {
            printServiceArray = System.getSecurityManager();
            if (printServiceArray != null) {
                printServiceArray.checkPrintJobAccess();
            }
            object = PrintServiceLookup.getRegisteredServices();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (object != null) {
            printServiceArray = (PrintService[])((ArrayList)object).toArray(new PrintService[((ArrayList)object).size()]);
            int n3 = 0;
            while (n3 < printServiceArray.length) {
                if (!arrayList.contains(printServiceArray[n3])) {
                    if (docFlavor == null && attributeSet == null) {
                        arrayList.add(printServiceArray[n3]);
                    } else if ((docFlavor != null && printServiceArray[n3].isDocFlavorSupported(docFlavor) || docFlavor == null) && null == printServiceArray[n3].getUnsupportedAttributes(docFlavor, attributeSet)) {
                        arrayList.add(printServiceArray[n3]);
                    }
                }
                ++n3;
            }
        }
        return arrayList;
    }

    private static ArrayList getMultiDocServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        int n2;
        PrintService[] printServiceArray;
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = PrintServiceLookup.getAllLookupServices().iterator();
        while (iterator.hasNext()) {
            try {
                object = (PrintServiceLookup)iterator.next();
                printServiceArray = ((PrintServiceLookup)object).getMultiDocPrintServices(docFlavorArray, attributeSet);
                if (printServiceArray == null) continue;
                n2 = 0;
                while (n2 < printServiceArray.length) {
                    arrayList.add(printServiceArray[n2]);
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        try {
            printServiceArray = System.getSecurityManager();
            if (printServiceArray != null) {
                printServiceArray.checkPrintJobAccess();
            }
            object = PrintServiceLookup.getRegisteredServices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            printServiceArray = (PrintService[])((ArrayList)object).toArray(new PrintService[((ArrayList)object).size()]);
            n2 = 0;
            while (n2 < printServiceArray.length) {
                if (printServiceArray[n2] instanceof MultiDocPrintService && !arrayList.contains(printServiceArray[n2])) {
                    if (docFlavorArray == null || docFlavorArray.length == 0) {
                        arrayList.add(printServiceArray[n2]);
                    } else {
                        boolean bl2 = true;
                        int n3 = 0;
                        while (n3 < docFlavorArray.length) {
                            if (printServiceArray[n2].isDocFlavorSupported(docFlavorArray[n3])) {
                                if (printServiceArray[n2].getUnsupportedAttributes(docFlavorArray[n3], attributeSet) != null) {
                                    bl2 = false;
                                    break;
                                }
                            } else {
                                bl2 = false;
                                break;
                            }
                            ++n3;
                        }
                        if (bl2) {
                            arrayList.add(printServiceArray[n2]);
                        }
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Services {
        private ArrayList listOfLookupServices = null;
        private ArrayList registeredServices = null;

        Services() {
        }
    }
}

