/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;

public final class VMID
implements Serializable {
    private static byte[] localAddr = VMID.computeAddressHash();
    private byte[] addr = localAddr;
    private UID uid = new UID();
    private static final long serialVersionUID = -538642295484486218L;

    public static boolean isUnique() {
        return true;
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof VMID) {
            VMID vMID = (VMID)object;
            if (!this.uid.equals(vMID.uid)) {
                return false;
            }
            if (this.addr == null ^ vMID.addr == null) {
                return false;
            }
            if (this.addr != null) {
                if (this.addr.length != vMID.addr.length) {
                    return false;
                }
                int n2 = 0;
                while (n2 < this.addr.length) {
                    if (this.addr[n2] != vMID.addr[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addr != null) {
            int n2 = 0;
            while (n2 < this.addr.length) {
                int n3 = this.addr[n2] & 0xFF;
                stringBuffer.append((n3 < 16 ? "0" : "") + Integer.toString(n3, 16));
                ++n2;
            }
        }
        stringBuffer.append(':');
        stringBuffer.append(this.uid.toString());
        return stringBuffer.toString();
    }

    private static byte[] computeAddressHash() {
        byte[] byArray;
        byte[] byArray2 = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return InetAddress.getLocalHost().getAddress();
                }
                catch (Exception exception) {
                    return new byte[]{0, 0, 0, 0};
                }
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            dataOutputStream.write(byArray2, 0, byArray2.length);
            dataOutputStream.flush();
            byte[] byArray3 = messageDigest.digest();
            int n2 = Math.min(8, byArray3.length);
            byArray = new byte[n2];
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        }
        catch (IOException iOException) {
            byArray = new byte[]{};
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        return byArray;
    }
}

