/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.Interruptible;

public abstract class AbstractSelector
extends Selector {
    private boolean open = true;
    private final SelectorProvider provider;
    private final Set cancelledKeys = new HashSet();
    private Interruptible interruptor = null;

    protected AbstractSelector(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(SelectionKey selectionKey) {
        Set set = this.cancelledKeys;
        synchronized (set) {
            this.cancelledKeys.add(selectionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        AbstractSelector abstractSelector = this;
        synchronized (abstractSelector) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseSelector();
        }
    }

    protected abstract void implCloseSelector() throws IOException;

    public final boolean isOpen() {
        return this.open;
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set cancelledKeys() {
        return this.cancelledKeys;
    }

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey abstractSelectionKey) {
        ((AbstractSelectableChannel)abstractSelectionKey.channel()).removeKey(abstractSelectionKey);
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                public void interrupt() {
                    AbstractSelector.this.wakeup();
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (Thread.currentThread().isInterrupted()) {
            this.interruptor.interrupt();
        }
    }

    protected final void end() {
        AbstractInterruptibleChannel.blockedOn(null);
    }
}

