/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue;
    private static Finalizer unfinalized;
    private static Object lock;
    private Finalizer next = null;
    private Finalizer prev = null;

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            Object object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                Thread thread = new Thread(threadGroup, runnable, "Secondary finalizer");
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                Finalizer finalizer;
                while ((finalizer = (Finalizer)queue.poll()) != null) {
                    finalizer.runFinalizer();
                }
            }
        });
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Finalizer finalizer;
                    Object object = lock;
                    synchronized (object) {
                        finalizer = unfinalized;
                        if (finalizer == null) {
                            break;
                        }
                        unfinalized = finalizer.next;
                    }
                    finalizer.runFinalizer();
                }
            }
        });
    }

    static {
        ThreadGroup threadGroup;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        FinalizerThread finalizerThread = new FinalizerThread(threadGroup);
        finalizerThread.setPriority(8);
        finalizerThread.setDaemon(true);
        finalizerThread.start();
    }

    private static class FinalizerThread
    extends Thread {
        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)queue.remove();
                        finalizer.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

