/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = 0;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, cArray.length);
        this.markedPos = n2;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n3 > this.count) {
                n3 = this.count - this.pos;
            }
            if (n3 <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, cArray, n2, n3);
            this.pos += n3;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if ((long)this.pos + l2 > (long)this.count) {
                l2 = this.count - this.pos;
            }
            if (l2 < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.count - this.pos > 0;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
        }
    }

    public void close() {
        this.buf = null;
    }
}

