/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$EventDispatchThread == null ? (class$java$awt$EventDispatchThread = EventDispatchThread.class$("java.awt.EventDispatchThread")) : class$java$awt$EventDispatchThread);
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final int ANY_EVENT = -1;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();
    static /* synthetic */ Class class$java$awt$EventDispatchThread;
    static /* synthetic */ Class class$java$lang$Throwable;

    EventDispatchThread(ThreadGroup threadGroup, String string, EventQueue eventQueue) {
        super(threadGroup, string);
        this.theQueue = eventQueue;
    }

    void stopDispatchingImpl(boolean bl2) {
        block3: {
            this.doDispatch = false;
            if (Thread.currentThread() == this) break block3;
            this.theQueue.postEventPrivate(new EmptyEvent());
            if (bl2) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stopDispatching() {
        this.stopDispatchingImpl(true);
    }

    public void stopDispatchingLater() {
        this.stopDispatchingImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pumpEvents(new Conditional(){

                public boolean evaluate() {
                    return true;
                }
            });
        }
        finally {
            EventQueue eventQueue = this.theQueue;
            synchronized (eventQueue) {
                this.theQueue.detachDispatchThread();
                if (this.theQueue.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    this.theQueue.initDispatchThread();
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this);
            }
        }
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEvents(-1, conditional);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.pumpEventsForHierarchy(-1, conditional, component);
    }

    void pumpEvents(int n2, Conditional conditional) {
        this.pumpEventsForHierarchy(n2, conditional, null);
    }

    void pumpEventsForHierarchy(int n2, Conditional conditional, Component component) {
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForHierarchy(n2, component)) continue;
            this.doDispatch = false;
        }
    }

    boolean pumpOneEventForHierarchy(int n2, Component component) {
        try {
            AWTEvent aWTEvent;
            boolean bl2;
            do {
                Object object;
                int n3;
                aWTEvent = n2 == -1 ? this.theQueue.getNextEvent() : this.theQueue.getNextEvent(n2);
                bl2 = true;
                if (component == null || ((n3 = aWTEvent.getID()) < 500 || n3 > 507) && (n3 < 1001 || n3 > 1001) || !((object = aWTEvent.getSource()) instanceof Component)) continue;
                Component component2 = (Component)object;
                if (component instanceof Container) {
                    while (component2 != component && component2 != null) {
                        component2 = component2.getParent();
                    }
                }
                if (component2 == component) continue;
                bl2 = false;
                aWTEvent.consume();
            } while (!bl2);
            this.theQueue.dispatchEvent(aWTEvent);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            this.processException(runtimeException, component != null);
        }
        catch (Error error) {
            this.processException(error, component != null);
        }
        return true;
    }

    private void processException(Throwable throwable, boolean bl2) {
        if (!this.handleException(throwable)) {
            if (bl2) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            } else {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object object;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = (String)AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = EventDispatchThread.class$("java.lang.Throwable")) : class$java$lang$Throwable});
                object = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(object, new Object[]{throwable});
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

