/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import sun.awt.DebugHelper;

public class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[0];
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private Dimension maxSize;
    private transient FocusTraversalPolicy focusTraversalPolicy;
    private boolean focusCycleRoot = false;
    private transient Set printingThreads;
    private transient boolean printing = false;
    transient ContainerListener containerListener;
    transient int listeningChildren;
    transient int listeningBoundsChildren;
    transient int descendantsCount;
    private static final long serialVersionUID = 4613797578919906343L;
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$Container == null ? (class$java$awt$Container = Container.class$("java.awt.Container")) : class$java$awt$Container);
    static final boolean INCLUDE_SELF = true;
    static final boolean SEARCH_HEAVYWEIGHTS = true;
    private int containerSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$event$ContainerListener;

    private static native void initIDs();

    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[4];
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n2 < 0 || n2 >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("No such child: " + n2);
            }
            return this.component[n2];
        }
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Component[] getComponents_NoClientCode() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            return componentArray;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer != null && this.peer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            return (Insets)containerPeer.insets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n2) {
        this.addImpl(component, null, n2);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setZOrder(Component component, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            Container container;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n2 > this.ncomponents || n2 < 0 && n2 != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                container = this;
                while (container != null) {
                    if (container == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    container = container.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (!(component.peer instanceof LightweightPeer)) {
                throw new IllegalArgumentException("should be lightweight component");
            }
            Container container2 = container = this.peer instanceof LightweightPeer ? this.getNativeContainer() : this;
            if (container != component.getNativeContainer()) {
                throw new IllegalArgumentException("component should be in the same heavyweight container");
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                int n3;
                object2 = component.parent;
                Component[] componentArray = ((Container)object2).component;
                int n4 = n3 = ((Container)object2).ncomponents;
                while (--n4 >= 0) {
                    if (componentArray[n4] != component) continue;
                    if (((Container)object2).layoutMgr != null) {
                        ((Container)object2).layoutMgr.removeLayoutComponent(component);
                    }
                    ((Container)object2).adjustListeningChildren(32768L, -component.numListening(32768L));
                    ((Container)object2).adjustListeningChildren(65536L, -component.numListening(65536L));
                    ((Container)object2).adjustDescendants(-component.countHierarchyMembers());
                    component.parent = null;
                    System.arraycopy(((Container)object2).component, n4 + 1, ((Container)object2).component, n4, ((Container)object2).ncomponents - n4 - 1);
                    componentArray[--((Container)object2).ncomponents] = null;
                    if (((Container)object2).valid) {
                        ((Container)object2).invalidate();
                    }
                    if (((Container)object2).containerListener != null || (((Container)object2).eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                        ContainerEvent containerEvent = new ContainerEvent((Component)object2, 301, component);
                        ((Component)object2).dispatchEvent(containerEvent);
                    }
                    component.createHierarchyEvents(1400, component, (Container)object2, 1L, Toolkit.enabledOnToolkit(32768L));
                    if (((Container)object2).peer == null || ((Container)object2).layoutMgr != null || !((Component)object2).isVisible()) continue;
                    ((Component)object2).updateCursorImmediately();
                }
                if (n2 > n3) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (this.ncomponents == this.component.length) {
                object2 = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object2, 0, this.ncomponents);
                this.component = object2;
            }
            if (n2 == -1 || n2 == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n2, this.component, n2 + 1, this.ncomponents - n2);
                this.component[n2] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
                ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, null);
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object2 = new ContainerEvent(this, 300, component);
                this.dispatchEvent((AWTEvent)object2);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n2) {
        this.addImpl(component, object, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n2) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n2 > this.ncomponents || n2 < 0 && n2 != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                object3 = this;
                while (object3 != null) {
                    if (object3 == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    object3 = object3.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                component.parent.remove(component);
                if (n2 > this.ncomponents) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (this.ncomponents == this.component.length) {
                object3 = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object3, 0, this.ncomponents);
                this.component = object3;
            }
            if (n2 == -1 || n2 == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n2, this.component, n2 + 1, this.ncomponents - n2);
                this.component[n2] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object3 = new ContainerEvent((Component)this, 300, component);
                this.dispatchEvent((AWTEvent)object3);
            }
            component.createHierarchyEvents(1400, component, (Container)this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    void checkGD(String string) {
        int n2 = 0;
        while (n2 < this.component.length) {
            Component component = this.component[n2];
            if (component != null) {
                component.checkGD(string);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.component[n2];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            System.arraycopy(this.component, n2 + 1, this.component, n2, this.ncomponents - n2 - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent == this) {
                Component[] componentArray = this.component;
                int n2 = this.ncomponents;
                while (--n2 >= 0) {
                    if (componentArray[n2] != component) continue;
                    this.remove(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.adjustListeningChildren(32768L, -this.listeningChildren);
            this.adjustListeningChildren(65536L, -this.listeningBoundsChildren);
            this.adjustDescendants(-this.descendantsCount);
            while (this.ncomponents > 0) {
                Component component = this.component[--this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            }
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    int numListening(long l2) {
        int n2 = super.numListening(l2);
        if (l2 == 32768L) {
            return this.listeningChildren + n2;
        }
        if (l2 == 65536L) {
            return this.listeningBoundsChildren + n2;
        }
        return n2;
    }

    void adjustListeningChildren(long l2, int n2) {
        if (n2 == 0) {
            return;
        }
        if ((l2 & 0x8000L) != 0L) {
            this.listeningChildren += n2;
        }
        if ((l2 & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n2;
        }
        this.adjustListeningChildrenOnParent(l2, n2);
    }

    void adjustDescendants(int n2) {
        if (n2 == 0) {
            return;
        }
        this.descendantsCount += n2;
        this.adjustDecendantsOnParent(n2);
    }

    void adjustDecendantsOnParent(int n2) {
        if (this.parent != null) {
            this.parent.adjustDescendants(n2);
        }
    }

    int countHierarchyMembers() {
        return this.descendantsCount;
    }

    int createHierarchyEvents(int n2, Component component, Container container, long l2, boolean bl2) {
        int n3 = 0;
        switch (n2) {
            case 1400: {
                n3 = this.listeningChildren;
                break;
            }
            case 1401: 
            case 1402: {
                n3 = this.listeningBoundsChildren;
                break;
            }
        }
        if (bl2) {
            n3 = this.descendantsCount;
        }
        int n4 = n3;
        int n5 = 0;
        while (n4 > 0) {
            n4 -= this.component[n5].createHierarchyEvents(n2, component, container, l2, bl2);
            ++n5;
        }
        return n3 + super.createHierarchyEvents(n2, component, container, l2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createChildHierarchyEvents(int n2, long l2, boolean bl2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            switch (n2) {
                case 1400: {
                    n3 = this.listeningChildren;
                    break;
                }
                case 1401: 
                case 1402: {
                    n3 = this.listeningBoundsChildren;
                    break;
                }
            }
            if (bl2) {
                n3 = this.descendantsCount;
            }
            int n4 = n3;
            int n5 = 0;
            while (n4 > 0) {
                n4 -= this.component[n5].createHierarchyEvents(n2, this, this.parent, l2, bl2);
                ++n5;
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    public void invalidate() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            boolean bl2 = false;
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.valid && this.peer != null) {
                    ContainerPeer containerPeer = null;
                    if (this.peer instanceof ContainerPeer) {
                        containerPeer = (ContainerPeer)this.peer;
                    }
                    if (containerPeer != null) {
                        containerPeer.beginValidate();
                    }
                    this.validateTree();
                    this.valid = true;
                    if (containerPeer != null) {
                        containerPeer.endValidate();
                        bl2 = this.isVisible();
                    }
                }
            }
            if (bl2) {
                this.updateCursorImmediately();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).beginLayout();
            }
            this.doLayout();
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < this.ncomponents) {
                Component component = componentArray[n2];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                } else {
                    component.validate();
                }
                ++n2;
            }
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).endLayout();
            }
        }
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.ncomponents) {
                Component component = this.component[n2];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                } else if (component.valid) {
                    component.invalidate();
                }
                ++n2;
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public void setFont(Font font) {
        boolean bl2 = false;
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            return this.prefSize;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            return this.minSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                this.maxSize = layoutManager2.maximumLayoutSize(this);
            }
        } else {
            this.maxSize = super.getMaximumSize();
        }
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentX() {
        float f2;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f2 = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f2 = super.getAlignmentX();
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentY() {
        float f2;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f2 = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f2 = super.getAlignmentY();
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            if (this.printing) {
                Container container = this;
                synchronized (container) {
                    if (this.printing && this.printingThreads.contains(Thread.currentThread())) {
                        return;
                    }
                }
            }
            GraphicsCallback.PaintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        if (this.isShowing()) {
            Container container;
            Thread thread = Thread.currentThread();
            try {
                container = this;
                synchronized (container) {
                    if (this.printingThreads == null) {
                        this.printingThreads = new HashSet();
                    }
                    this.printingThreads.add(thread);
                    this.printing = true;
                }
                super.print(graphics);
                container = this;
            }
            catch (Throwable throwable) {
                Container container2 = this;
                synchronized (container2) {
                    this.printingThreads.remove(thread);
                    this.printing = !this.printingThreads.isEmpty();
                }
                throw throwable;
            }
            synchronized (container) {
                this.printingThreads.remove(thread);
                this.printing = !this.printingThreads.isEmpty();
            }
            GraphicsCallback.PrintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPaint(Graphics graphics) {
        super.lightweightPaint(graphics);
        this.paintHeavyweightComponents(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printHeavyweightComponents(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])this.getListeners(class$java$awt$event$ContainerListener == null ? (class$java$awt$event$ContainerListener = Container.class$("java.awt.event.ContainerListener")) : class$java$awt$event$ContainerListener);
    }

    public EventListener[] getListeners(Class clazz) {
        ContainerListener containerListener = null;
        if (clazz != (class$java$awt$event$ContainerListener == null ? (class$java$awt$event$ContainerListener = Container.class$("java.awt.event.ContainerListener")) : class$java$awt$event$ContainerListener)) {
            return super.getListeners(clazz);
        }
        containerListener = this.containerListener;
        return AWTEventMulticaster.getListeners(containerListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        if (n2 == 300 || n2 == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    this.containerListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
        switch (aWTEvent.getID()) {
            case 101: {
                this.createChildHierarchyEvents(1402, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
            case 100: {
                this.createChildHierarchyEvents(1401, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
        }
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    Component getMouseEventTarget(int n2, int n3, boolean bl2) {
        return this.getMouseEventTarget(n2, n3, bl2, MouseEventTargetFilter.FILTER, false);
    }

    Component getDropTargetEventTarget(int n2, int n3, boolean bl2) {
        return this.getMouseEventTarget(n2, n3, bl2, DropTargetEventTargetFilter.FILTER, true);
    }

    private Component getMouseEventTarget(int n2, int n3, boolean bl2, EventTargetFilter eventTargetFilter, boolean bl3) {
        Component component = null;
        if (bl3) {
            component = this.getMouseEventTargetImpl(n2, n3, bl2, eventTargetFilter, true, bl3);
        }
        if (component == null || component == this) {
            component = this.getMouseEventTargetImpl(n2, n3, bl2, eventTargetFilter, false, bl3);
        }
        return component;
    }

    private Component getMouseEventTargetImpl(int n2, int n3, boolean bl2, EventTargetFilter eventTargetFilter, boolean bl3, boolean bl4) {
        int n4 = this.ncomponents;
        Component[] componentArray = this.component;
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component != null && component.visible && (!bl3 && component.peer instanceof LightweightPeer || bl3 && !(component.peer instanceof LightweightPeer)) && component.contains(n2 - component.x, n3 - component.y)) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    Component component2 = container.getMouseEventTarget(n2 - container.x, n3 - container.y, bl2, eventTargetFilter, bl4);
                    if (component2 != null) {
                        return component2;
                    }
                } else if (eventTargetFilter.accept(component)) {
                    return component;
                }
            }
            ++n5;
        }
        boolean bl5 = this.peer instanceof LightweightPeer || bl2;
        boolean bl6 = this.contains(n2, n3);
        if (bl6 && bl5 && eventTargetFilter.accept(this)) {
            return this;
        }
        return null;
    }

    void proxyEnableEvents(long l2) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyEnableEvents(l2);
            }
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l2);
        }
    }

    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    public Component getComponentAt(int n2, int n3) {
        return this.locate(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component locate(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int n4 = 0;
            while (n4 < this.ncomponents) {
                Component component = this.component[n4];
                if (component != null && !(component.peer instanceof LightweightPeer) && component.contains(n2 - component.x, n3 - component.y)) {
                    return component;
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.ncomponents) {
                Component component = this.component[n5];
                if (component != null && component.peer instanceof LightweightPeer && component.contains(n2 - component.x, n3 - component.y)) {
                    return component;
                }
                ++n5;
            }
        }
        return this;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component findComponentAt(int n2, int n3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.findComponentAt(n2, n3, true);
        }
    }

    final Component findComponentAt(int n2, int n3, boolean bl2) {
        if (!this.contains(n2, n3) || !this.visible || !bl2 && !this.enabled) {
            return null;
        }
        int n4 = this.ncomponents;
        Component[] componentArray = this.component;
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component != null && !(component.peer instanceof LightweightPeer) && (component = component instanceof Container ? ((Container)component).findComponentAt(n2 - component.x, n3 - component.y, bl2) : component.locate(n2 - component.x, n3 - component.y)) != null && component.visible && (bl2 || component.enabled)) {
                return component;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            Component component = componentArray[n6];
            if (component != null && component.peer instanceof LightweightPeer && (component = component instanceof Container ? ((Container)component).findComponentAt(n2 - component.x, n3 - component.y, bl2) : component.locate(n2 - component.x, n3 - component.y)) != null && component.visible && (bl2 || component.enabled)) {
                return component;
            }
            ++n6;
        }
        return this;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            int n2 = this.ncomponents;
            Component[] componentArray = this.component;
            int n3 = 0;
            while (n3 < n2) {
                componentArray[n3].addNotify();
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.ncomponents;
            Component[] componentArray = this.component;
            int n3 = 0;
            while (n3 < n2) {
                componentArray[n3].removeNotify();
                ++n3;
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
            }
            super.removeNotify();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAncestorOf(Component var1_1) {
        if (var1_1 != null && (var2_2 = var1_1.getParent()) != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (var2_2 == this) {
                return true;
            }
            var2_2 = var2_2.getParent();
lbl6:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = string + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    public void list(PrintStream printStream, int n2) {
        super.list(printStream, n2);
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null) {
                component.list(printStream, n2 + 1);
            }
            ++n4;
        }
    }

    public void list(PrintWriter printWriter, int n2) {
        super.list(printWriter, n2);
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null) {
                component.list(printWriter, n2 + 1);
            }
            ++n4;
        }
    }

    public void setFocusTraversalKeys(int n2, Set set) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n2, set);
    }

    public Set getFocusTraversalKeys(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n2);
    }

    public boolean areFocusTraversalKeysSet(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n2] != null;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this.isFocusCycleRoot() && container == this) {
            return true;
        }
        return super.isFocusCycleRoot(container);
    }

    private Container findTraversalRoot() {
        Container container;
        Container container2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (container2 == this) {
            container = this;
        } else {
            container = this.getFocusCycleRootAncestor();
            if (container == null) {
                container = this;
            }
        }
        if (container != container2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean containsFocus() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            while (component != null && !(component instanceof Window) && component != this) {
                component = component.getParent();
            }
            return component == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMostRecentFocusOwnerOnHide() {
        Component component = null;
        Container container = this;
        Object object = this.getTreeLock();
        synchronized (object) {
            while (container != null && !(container instanceof Window)) {
                container = container.getParent();
            }
            if (container != null) {
                component = KeyboardFocusManager.getMostRecentFocusOwner((Window)container);
                while (component != null && component != this && !(component instanceof Window)) {
                    component = component.getParent();
                }
            }
        }
        if (component == this) {
            KeyboardFocusManager.setMostRecentFocusOwner((Window)container, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCurrentFocusCycleRootOnHide() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this != container && !(container instanceof Window) && container != null) {
                container = container.getParent();
            }
        }
        if (container == this) {
            keyboardFocusManager.setGlobalCurrentFocusCycleRoot(null);
        }
    }

    boolean nextFocusHelper() {
        if (this.isFocusCycleRoot()) {
            Container container;
            Container container2 = this.findTraversalRoot();
            Container container3 = this;
            while (!(container2 == null || (container = container2.getFocusCycleRootAncestor()) == null || container2.isShowing() && container2.isFocusable() && container2.isEnabled())) {
                container3 = container2;
                container2 = container;
            }
            if (container2 != null) {
                FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(container2, container3);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container2);
                }
                if (component != null) {
                    return component.requestFocus(false);
                }
            }
            return false;
        }
        return super.nextFocusHelper();
    }

    public void transferFocusBackward() {
        if (this.isFocusCycleRoot()) {
            Container container = this.findTraversalRoot();
            Container container2 = this;
            while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
                container2 = container;
                container = container2.getFocusCycleRootAncestor();
            }
            if (container != null) {
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(container, container2);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container);
                }
                if (component != null) {
                    component.requestFocus();
                }
            }
        } else {
            super.transferFocusBackward();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        Container container = this;
        synchronized (container) {
            focusTraversalPolicy2 = this.focusTraversalPolicy;
            this.focusTraversalPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("focusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.focusTraversalPolicy;
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy;
        }
        Container container = this.getFocusCycleRootAncestor();
        if (container != null) {
            return container.getFocusTraversalPolicy();
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusCycleRoot(boolean bl2) {
        boolean bl3;
        Container container = this;
        synchronized (container) {
            bl3 = this.focusCycleRoot;
            this.focusCycleRoot = bl2;
        }
        this.firePropertyChange("focusCycleRoot", bl3, bl2);
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
            Component component = this.getFocusTraversalPolicy().getDefaultComponent(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    boolean postsOldMouseEvents() {
        return true;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        int n2 = 0;
        while (n2 < this.ncomponents) {
            this.component[n2].applyComponentOrientation(componentOrientation);
            ++n2;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block6: {
            Object object;
            Object object2;
            objectInputStream.defaultReadObject();
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < this.ncomponents) {
                componentArray[n2].parent = this;
                this.adjustListeningChildren(32768L, componentArray[n2].numListening(32768L));
                this.adjustListeningChildren(65536L, componentArray[n2].numListening(65536L));
                this.adjustDescendants(componentArray[n2].countHierarchyMembers());
                ++n2;
            }
            while (null != (object2 = objectInputStream.readObject())) {
                object = ((String)object2).intern();
                if ("containerL" == object) {
                    this.addContainerListener((ContainerListener)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            try {
                object = objectInputStream.readObject();
                if (object instanceof FocusTraversalPolicy) {
                    this.focusTraversalPolicy = (FocusTraversalPolicy)object;
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block6;
                throw optionalDataException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleAt(Point point) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)this);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    int n2 = accessibleContext.getAccessibleChildrenCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        AccessibleComponent accessibleComponent;
                        accessible = accessibleContext.getAccessibleChild(n3);
                        if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null && accessibleComponent.isShowing()) {
                            Point point2 = accessibleComponent.getLocation();
                            Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                            if (accessibleComponent.contains(point3)) {
                                return accessible;
                            }
                        }
                        ++n3;
                    }
                }
                return (Accessible)((Object)this);
            }
            Component component = this;
            if (!this.contains(point.x, point.y)) {
                component = null;
            } else {
                int n4 = this.getComponentCount();
                int n5 = 0;
                while (n5 < n4) {
                    Component component2 = this.getComponent(n5);
                    if (component2 != null && component2.isShowing()) {
                        Point point4 = component2.getLocation();
                        if (component2.contains(point.x - point4.x, point.y - point4.y)) {
                            component = component2;
                        }
                    }
                    ++n5;
                }
            }
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessibleChildrenCount() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            Component[] componentArray = this.getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleChild(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n3 = 0;
            int n4 = 0;
            while (n4 < componentArray.length) {
                if (componentArray[n4] instanceof Accessible) {
                    if (n3 == n2) {
                        return (Accessible)((Object)componentArray[n4]);
                    }
                    ++n3;
                }
                ++n4;
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Container.initIDs();
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        protected ContainerListener accessibleContainerHandler = null;

        protected AccessibleAWTContainer() {
        }

        public int getAccessibleChildrenCount() {
            return Container.this.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n2) {
            return Container.this.getAccessibleChild(n2);
        }

        public Accessible getAccessibleAt(Point point) {
            return Container.this.getAccessibleAt(point);
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    static class DropTargetEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new DropTargetEventTargetFilter();

        private DropTargetEventTargetFilter() {
        }

        public boolean accept(Component component) {
            DropTarget dropTarget = component.getDropTarget();
            return dropTarget != null && dropTarget.isActive();
        }
    }

    static class MouseEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new MouseEventTargetFilter();

        private MouseEventTargetFilter() {
        }

        public boolean accept(Component component) {
            return (component.eventMask & 0x20L) != 0L || (component.eventMask & 0x10L) != 0L || (component.eventMask & 0x20000L) != 0L || component.mouseListener != null || component.mouseMotionListener != null || component.mouseWheelListener != null;
        }
    }

    static interface EventTargetFilter {
        public boolean accept(Component var1);
    }
}

