/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class MotifScrollBarButton
extends BasicArrowButton {
    private Color darkShadow = UIManager.getColor("controlShadow");
    private Color lightShadow = UIManager.getColor("controlLtHighlight");

    public MotifScrollBarButton(int n2) {
        super(n2);
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                this.direction = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        this.setRequestFocusEnabled(false);
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("ScrollBar.background"));
        this.setForeground(UIManager.getColor("ScrollBar.foreground"));
    }

    public Dimension getPreferredSize() {
        switch (this.direction) {
            case 1: 
            case 5: {
                return new Dimension(11, 12);
            }
        }
        return new Dimension(12, 11);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        boolean bl2;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n2, n3);
        }
        Color color = (bl2 = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
        Color color2 = bl2 ? this.lightShadow : this.darkShadow;
        Color color3 = this.getBackground();
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        int n6 = Math.min(n2, n3);
        switch (this.direction) {
            case 1: {
                graphics.setColor(color);
                graphics.drawLine(n4, 0, n4, 0);
                int n7 = n4 - 1;
                int n8 = 1;
                int n9 = 1;
                while (n8 <= n6 - 2) {
                    graphics.setColor(color);
                    graphics.drawLine(n7, n8, n7, n8);
                    if (n8 >= n6 - 2) {
                        graphics.drawLine(n7, n8 + 1, n7, n8 + 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n7 + 1, n8, n7 + n9, n8);
                    if (n8 < n6 - 2) {
                        graphics.drawLine(n7, n8 + 1, n7 + n9 + 1, n8 + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n7 + n9 + 1, n8, n7 + n9 + 1, n8);
                    if (n8 >= n6 - 2) {
                        graphics.drawLine(n7 + 1, n8 + 1, n7 + n9 + 1, n8 + 1);
                    }
                    n9 += 2;
                    --n7;
                    n8 += 2;
                }
                break;
            }
            case 5: {
                graphics.setColor(color2);
                graphics.drawLine(n4, n6, n4, n6);
                int n10 = n4 - 1;
                int n11 = n6 - 1;
                int n12 = 1;
                while (n11 >= 1) {
                    graphics.setColor(color);
                    graphics.drawLine(n10, n11, n10, n11);
                    if (n11 <= 2) {
                        graphics.drawLine(n10, n11 - 1, n10 + n12 + 1, n11 - 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n10 + 1, n11, n10 + n12, n11);
                    if (n11 > 2) {
                        graphics.drawLine(n10, n11 - 1, n10 + n12 + 1, n11 - 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n10 + n12 + 1, n11, n10 + n12 + 1, n11);
                    n12 += 2;
                    --n10;
                    n11 -= 2;
                }
                break;
            }
            case 3: {
                graphics.setColor(color);
                graphics.drawLine(n6, n5, n6, n5);
                int n13 = n5 - 1;
                int n14 = n6 - 1;
                int n15 = 1;
                while (n14 >= 1) {
                    graphics.setColor(color);
                    graphics.drawLine(n14, n13, n14, n13);
                    if (n14 <= 2) {
                        graphics.drawLine(n14 - 1, n13, n14 - 1, n13 + n15 + 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n14, n13 + 1, n14, n13 + n15);
                    if (n14 > 2) {
                        graphics.drawLine(n14 - 1, n13, n14 - 1, n13 + n15 + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n14, n13 + n15 + 1, n14, n13 + n15 + 1);
                    n15 += 2;
                    --n13;
                    n14 -= 2;
                }
                break;
            }
            case 7: {
                graphics.setColor(color2);
                graphics.drawLine(0, n5, 0, n5);
                int n16 = n5 - 1;
                int n17 = 1;
                int n18 = 1;
                while (n17 <= n6 - 2) {
                    graphics.setColor(color);
                    graphics.drawLine(n17, n16, n17, n16);
                    if (n17 >= n6 - 2) {
                        graphics.drawLine(n17 + 1, n16, n17 + 1, n16);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n17, n16 + 1, n17, n16 + n18);
                    if (n17 < n6 - 2) {
                        graphics.drawLine(n17 + 1, n16, n17 + 1, n16 + n18 + 1);
                    }
                    graphics.setColor(color2);
                    graphics.drawLine(n17, n16 + n18 + 1, n17, n16 + n18 + 1);
                    if (n17 >= n6 - 2) {
                        graphics.drawLine(n17 + 1, n16 + 1, n17 + 1, n16 + n18 + 1);
                    }
                    n18 += 2;
                    --n16;
                    n17 += 2;
                }
                break;
            }
        }
    }
}

