#ifndef __bug_h__
#define __bug_h__

#include "person.h"

#include <qvaluelist.h>

#include <ksharedptr.h>

class BugImpl;

class Bug
{
public:
    typedef QValueList<Bug> List;

    enum Severity { Critical, Grave, Crash, Normal, WishList };
    enum Status { Closed, Open };

    Bug();
    Bug( BugImpl *impl );
    Bug( const Bug &other );
    Bug &operator=( const Bug &rhs );
    ~Bug();

    static QString severityToString( Severity s );
    static Severity stringToSeverity( const QString &s, bool *ok = 0 );

    static QValueList<Severity> severities();

    QString title() const;
    Person submitter() const;
    QString number() const;
    uint age() const;
    Severity severity() const;
    QString severityAsString() const;

    /**
     * Status of a bug. Currently open or closed.
     * TODO: Should we add a status 'deleted' here ?
     */
    Status status() const;
    void setStatus( Status newStatus );
    
    static QString statusToString( Status s );
    static Status stringToStatus( const QString &s, bool *ok = 0 );

    bool operator==( const Bug &rhs );
    bool operator<( const Bug &rhs ) const;

    bool isNull() const { return m_impl == 0; }

    static Bug fromNumber( const QString &bugNumber );

private:
    BugImpl *impl() const { return m_impl; }

    KSharedPtr<BugImpl> m_impl;
};

#endif

/* vim: set sw=4 ts=4 et softtabstop=4: */

