/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
                2001      by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "prefwidgets.h"
#include "resources.h"
#include "cmdedit.h"

#include <kcombobox.h>
#include <klocale.h>
#include <kdialog.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klineedit.h> 
#include <kurlcompletion.h>
#include <kfontdialog.h>
#include <kcolorbutton.h>
#include <ksconfig.h>
#include <kurldrag.h>
#include <kurlrequester.h>

#include <qlayout.h>
#include <qobjectlist.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qhbuttongroup.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtextcodec.h>
#include <qwhatsthis.h>


static QSize sizeHintForWidget(const QWidget* widget)
{
  //
  // The size is computed by adding the sizeHint().height() of all
  // widget children and taking the width of the widest child and adding
  // layout()->margin() and layout()->spacing()
  //

  QSize size;

  int numChild = 0;
  QObjectList *l = (QObjectList*)(widget->children());

  for( uint i=0; i < l->count(); i++ )
  {
    QObject *o = l->at(i);
    if( o->isWidgetType() )
    {
      numChild += 1;
      QWidget *w=((QWidget*)o);

      QSize s = w->sizeHint();
      if( s.isEmpty() == true )
      {
          s = QSize( 50, 100 ); // Default size
      }
      size.setHeight( size.height() + s.height() );
      if( s.width() > size.width() ) { size.setWidth( s.width() ); }
    }
  }

  if( numChild > 0 )
  {
    size.setHeight( size.height() + widget->layout()->spacing()*(numChild-1) );
    size += QSize( widget->layout()->margin()*2, widget->layout()->margin()*2 + 1 );
  }
  else
  {
    size = QSize( 1, 1 );
  }

  return( size );
}


CatManPreferences::CatManPreferences(QWidget* parent)
         : KTabCtl(parent)
{
    QWidget* page = new QWidget(this);

    QVBoxLayout* layout=new QVBoxLayout(page);
    layout->setSpacing(KDialog::spacingHint());
    layout->setMargin(KDialog::marginHint());

    QGroupBox* box=new QGroupBox(1,Qt::Horizontal,page);
    box->setMargin(KDialog::marginHint());
    layout->addWidget(box);

    QLabel* label=new QLabel(i18n("&Base directory of PO-Files:"),box);
    QHBox* hbox = new QHBox(box);
    hbox->setSpacing(KDialog::spacingHint());

    KFile::Mode mode = static_cast<KFile::Mode>( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );
	
												
    _poDirEdit = new KURLRequester(hbox);
    _poDirEdit->setMode( mode );
    _poDirEdit->setMinimumSize(250,_poDirEdit->sizeHint().height());
    label->setBuddy(_poDirEdit);


    label=new QLabel(i18n("Ba&se directory of POT-Files:"),box);
    hbox = new QHBox(box);
    hbox->setSpacing(KDialog::spacingHint());

    _potDirEdit = new KURLRequester(hbox);
    _potDirEdit->setMode( mode );
    _potDirEdit->setMinimumSize(250,_potDirEdit->sizeHint().height());
    label->setBuddy(_potDirEdit);



    QWhatsThis::add(box,i18n("<qt><p><b>Base directories</b></p>\n"
     "<p>Type in the directories which contain all your PO- and POT-files.\n"
     "The files and the directories in these directories will then be merged into one\n"
     "tree.</p></qt>"));


    box=new QGroupBox(1,Qt::Horizontal,page);
    box->setMargin(KDialog::marginHint());
    layout->addWidget(box);

    _openWindowButton = new QCheckBox(i18n("O&pen files in new window"),box);


    QWhatsThis::add(_openWindowButton,i18n("<qt><p><b>Open files in new window</b></p>\n"
"<p>If this is activated all files that are opened from the Catalog Manager are opened\n"
"in a new window.</p></qt>"));

    _killButton = new QCheckBox( i18n("&Kill processes on exit") , box );

    QWhatsThis::add( _killButton , i18n("<qt><p><b>Kill processes on exit</b></p>\n"
"<p>If you check this, KBabel tries to kill the processes, that have not exited already when KBabel exits,\n"
"by sending a kill signal to them.</p>\n"
"<p>NOTE: It's not guaranteed that the processes will be killed.</p></qt>") );


    _indexButton = new QCheckBox( i18n("Create inde&x for file contents"), box );
    
    QWhatsThis::add( _indexButton , i18n("<qt><p><b>Create index for file contents</b></p>\n"
"<p>If you check this, KBabel will create an index for each PO-file to speedup the find/replace functions.</p>\n"
"<p>NOTE: This will slow down updating the file information considerably.</p></qt>") );


    layout->addStretch(1);

    page->setMinimumSize(sizeHintForWidget(page));

    addTab( page , i18n("&General") );



    page = new QWidget( this );
    layout = new QVBoxLayout( page );
    layout->setSpacing( KDialog::spacingHint() );
    layout->setMargin( KDialog::marginHint() );

    box = new QGroupBox( 1 , Qt::Horizontal , i18n("Commands for directories") , page );
    box->setMargin( KDialog::marginHint() );
    layout->addWidget( box );

    _dirCmdEdit = new CmdEdit( box );
    label = new QLabel( i18n("Replaceables:\n@PACKAGE@, @PODIR@, @POTDIR@"), box);

    QWhatsThis::add( box , i18n("<qt><p><b>Commands for directories</b></p>"
"<p>Insert here the commands you want to execute in directories from "
"the Catalog Manager. The commands are then shown in the submenu "
"<b>Commands</b> in the Catalog Manager's context menu.</p>"
"<p>The following strings will be replaced in a command:<ul>"
"<li>@PACKAGE@: The name of the directory without path</li>"
"<li>@PODIR@: The name of the PO-directory with path</li>"
"<li>@POTDIR@: The name of the template directory with path</li></ul></p>"
"</qt>") );



    layout->addStretch(1);
    page->setMinimumSize(sizeHintForWidget(page));
    addTab( page , i18n("D&irectory Commands") );


    page = new QWidget( this );
    layout = new QVBoxLayout( page );
    layout->setSpacing( KDialog::spacingHint() );
    layout->setMargin( KDialog::marginHint() );

    box=new QGroupBox( 1 , Qt::Horizontal , i18n("Commands for files") , page );
    box->setMargin( KDialog::marginHint() );
    layout->addWidget( box );

    _fileCmdEdit = new CmdEdit( box );
    label = new QLabel( i18n("Replaceables:\n"
"@PACKAGE@, @POFILE@,@POTFILE@,\n@PODIR@, @POTDIR@"), box);



    QWhatsThis::add( box , i18n("<qt><p><b>Commands for files</b></p>"
"<p>Insert here the commands you want to execute on files from "
"the Catalog Manager. The commands are then shown in the submenu "
"<b>Commands</b> in the Catalog Manager's context menu.</p>"
"<p>The following strings will be replaced in a command:<ul>"
"<li>@PACKAGE@: The name of the file without path and extension</li>"
"<li>@POFILE@: The name of the PO-file with path and extension</li>"
"<li>@POTFILE@: The name of the corresponding template file with path "
"and extension</li>"
"<li>@PODIR@: The name of the directory, the PO-file is in, with path</li>"
"<li>@POTDIR@: The name of the directory, the template file is in, with "
"path</li></ul></p></qt>") );



    layout->addStretch(1);
    page->setMinimumSize(sizeHintForWidget(page));
    addTab( page , i18n("&File Commands") );



    defaults();

    setMinimumSize(sizeHint());
}


CatManPreferences::~CatManPreferences()
{
}


void CatManPreferences::setSettings(const CatManSettings& settings)
{
   _poDirEdit->setURL(settings.poBaseDir);
   _potDirEdit->setURL(settings.potBaseDir);

   _openWindowButton->setChecked(settings.openWindow);

   _dirCmdEdit->setCommands( settings.dirCommands , settings.dirCommandNames );
   _fileCmdEdit->setCommands( settings.fileCommands , settings.fileCommandNames );

   _killButton->setChecked( settings.killCmdOnExit );
   _indexButton->setChecked( settings.indexWords );
}


void CatManPreferences::mergeSettings(CatManSettings& settings) const
{
    settings.poBaseDir=_poDirEdit->url();
    settings.potBaseDir=_potDirEdit->url();
    settings.openWindow=_openWindowButton->isChecked();

    _dirCmdEdit->commands( settings.dirCommands , settings.dirCommandNames );
    _fileCmdEdit->commands( settings.fileCommands , settings.fileCommandNames );

    settings.killCmdOnExit = _killButton->isChecked() ;
    settings.indexWords = _indexButton->isChecked() ;
}

void CatManPreferences::defaults()
{
   _poDirEdit->setURL(Defaults::CatalogManager::poBaseDir());
   _potDirEdit->setURL(Defaults::CatalogManager::potBaseDir());

   _openWindowButton->setChecked(Defaults::CatalogManager::openWindow);

   _dirCmdEdit->setCommands( Defaults::CatalogManager::dirCommands()
                            , Defaults::CatalogManager::dirCommandNames() );
   _fileCmdEdit->setCommands( Defaults::CatalogManager::fileCommands()
                            , Defaults::CatalogManager::fileCommandNames() );

   _killButton->setChecked( Defaults::CatalogManager::killCmdOnExit );
   _indexButton->setChecked( Defaults::CatalogManager::indexWords );
}



#include "prefwidgets.moc"
